/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.agent;

import java.lang.instrument.ClassDefinition;
import javassist.ClassPool;
import javassist.CtClass;
import org.powermock.core.transformers.TransformStrategy;
import org.powermock.core.transformers.impl.MainMockTransformer;
import org.powermock.modules.agent.PowerMockAgent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerMockClassRedefiner {
    private static final MainMockTransformer mainMockTransformer = new MainMockTransformer(TransformStrategy.INST_REDEFINE);

    public static void redefine(Class<?> cls) {
        if (cls == null) {
            throw new IllegalArgumentException("Class to redefine cannot be null");
        }
        try {
            CtClass ctClass = ClassPool.getDefault().get(cls.getName());
            ctClass = mainMockTransformer.transform(ctClass);
            ClassDefinition classDefinition = new ClassDefinition(cls, ctClass.toBytecode());
            PowerMockAgent.instrumentation().redefineClasses(classDefinition);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to redefine class " + cls.getName(), e);
        }
    }

    public static void redefine(String className) {
        if (className == null) {
            throw new IllegalArgumentException("Class name to redefine cannot be null");
        }
        try {
            PowerMockClassRedefiner.redefine(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

