/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.transformers.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.powermock.core.transformers.ClassWrapper;
import org.powermock.core.transformers.MockTransformer;
import org.powermock.core.transformers.MockTransformerChain;

public class DefaultMockTransformerChain
implements MockTransformerChain {
    private final List<MockTransformer> transformers;

    private DefaultMockTransformerChain(List<MockTransformer> transformers) {
        this.transformers = Collections.unmodifiableList(transformers);
    }

    @Override
    public <T> ClassWrapper<T> transform(ClassWrapper<T> clazz) throws Exception {
        ClassWrapper<T> classWrapper = clazz;
        for (MockTransformer transformer : this.transformers) {
            classWrapper = transformer.transform(classWrapper);
        }
        return classWrapper;
    }

    @Override
    public Collection<MockTransformer> filter(MockTransformerChain.FilterPredicate predicate) {
        ArrayList<MockTransformer> filtered = new ArrayList<MockTransformer>();
        for (MockTransformer transformer : this.transformers) {
            if (!predicate.test(transformer)) continue;
            filtered.add(transformer);
        }
        return filtered;
    }

    public String toString() {
        return "MockTransformerChain{transformers=" + this.transformers + '}';
    }

    public static MockTransformerChainBuilder newBuilder() {
        return new MockTransformerChainBuilder();
    }

    public static class MockTransformerChainBuilder {
        private final List<MockTransformer> transformers = new ArrayList<MockTransformer>();

        private MockTransformerChainBuilder() {
        }

        public MockTransformerChainBuilder append(MockTransformer transformer) {
            this.transformers.add(transformer);
            return this;
        }

        public MockTransformerChainBuilder append(List<MockTransformer> mockTransformerChain) {
            this.transformers.addAll(mockTransformerChain);
            return this;
        }

        public MockTransformerChain build() {
            return new DefaultMockTransformerChain(this.transformers);
        }
    }
}

