/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.bytebuddy;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.jar.asm.MethodVisitor;
import org.powermock.core.bytebuddy.Variable;
import org.powermock.reflect.internal.WhiteboxImpl;

public class MockGetawayCall {
    private final Method getawayMethod;

    public MockGetawayCall(Class mockGetawayClass) {
        this.getawayMethod = WhiteboxImpl.getMethod((Class)mockGetawayClass, (String)"suppressConstructorCall", (Class[])new Class[]{Class.class, Object[].class, Class[].class});
    }

    public ForType forType(TypeDescription targetType) {
        return new ForType(this, targetType);
    }

    private static class ConstructorMockGetawayCall
    implements StackManipulation {
        private final Method getawayMethod;
        private final TypeDescription targetType;
        private final List<Variable> arguments;
        private final ParameterList<ParameterDescription.InDefinedShape> targetParameters;

        private ConstructorMockGetawayCall(Method getawayMethod, TypeDescription targetType, List<Variable> arguments, ParameterList<ParameterDescription.InDefinedShape> targetParameters) {
            this.getawayMethod = getawayMethod;
            this.targetType = targetType;
            this.arguments = arguments;
            this.targetParameters = targetParameters;
        }

        private List<StackManipulation> loadSignatureParametersClasess() {
            ArrayList<StackManipulation> constructorSignature = new ArrayList<StackManipulation>();
            for (ParameterDescription.InDefinedShape targetParameter : this.targetParameters) {
                constructorSignature.add(ClassConstant.of((TypeDescription)targetParameter.getType().asErasure()));
            }
            return constructorSignature;
        }

        private List<StackManipulation> loadArgumentsFromVariable() {
            ArrayList<StackManipulation> loadTargetParameters = new ArrayList<StackManipulation>();
            for (Variable argument : this.arguments) {
                loadTargetParameters.add(Variable.VariableAccess.load(argument, true));
            }
            return loadTargetParameters;
        }

        public boolean isValid() {
            return true;
        }

        public StackManipulation.Size apply(MethodVisitor mv, Implementation.Context implementationContext) {
            List<StackManipulation> loadTargetParameters = this.loadArgumentsFromVariable();
            List<StackManipulation> constructorSignature = this.loadSignatureParametersClasess();
            return new StackManipulation.Compound(new StackManipulation[]{ClassConstant.of((TypeDescription)this.targetType), ArrayFactory.forType((TypeDescription.Generic)TypeDescription.OBJECT.asGenericType()).withValues(loadTargetParameters), ArrayFactory.forType((TypeDescription.Generic)TypeDescription.CLASS.asGenericType()).withValues(constructorSignature), MethodInvocation.invoke((MethodDescription.InDefinedShape)new MethodDescription.ForLoadedMethod(this.getawayMethod))}).apply(mv, implementationContext);
        }
    }

    public static class WithArguments {
        private final ForType forType;
        private final List<Variable> arguments;

        private WithArguments(ForType forType, List<Variable> arguments) {
            this.forType = forType;
            this.arguments = arguments;
        }

        public ConstructorMockGetawayCall withParameterTypes(ParameterList<ParameterDescription.InDefinedShape> targetParameters) {
            return new ConstructorMockGetawayCall(this.forType.mockGetawayCall.getawayMethod, this.forType.targetType, this.arguments, targetParameters);
        }
    }

    public static class ForType {
        private final TypeDescription targetType;
        private final MockGetawayCall mockGetawayCall;

        private ForType(MockGetawayCall mockGetawayCall, TypeDescription targetType) {
            this.mockGetawayCall = mockGetawayCall;
            this.targetType = targetType;
        }

        public WithArguments withArguments(List<Variable> parameters) {
            return new WithArguments(this, parameters);
        }
    }
}

