/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.classloading;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.powermock.api.support.DeepCloner;
import org.powermock.api.support.DoNotClone;
import org.powermock.api.support.SafeExceptionRethrower;
import org.powermock.reflect.Whitebox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassloaderExecutor {
    @DoNotClone
    private final ClassLoader classloader;

    public ClassloaderExecutor(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public <T> T execute(Callable<T> callable) {
        this.assertArgumentNotNull(callable, "callable");
        return (T)this.execute(callable, Whitebox.getMethod(callable.getClass(), (String)"call", (Class[])new Class[0]), new Object[0]);
    }

    public void execute(Runnable runnable) {
        this.assertArgumentNotNull(runnable, "runnable");
        this.execute(runnable, Whitebox.getMethod(runnable.getClass(), (String)"run", (Class[])new Class[0]), new Object[0]);
    }

    private void assertArgumentNotNull(Object object, String argumentName) {
        if (object == null) {
            throw new IllegalArgumentException(argumentName + " cannot be null.");
        }
    }

    private Object execute(Object instance, Method method, Object ... arguments) {
        DeepCloner deepCloner = new DeepCloner(this.classloader);
        Object objectLoadedWithClassloader = deepCloner.clone(instance);
        Object[] argumentsLoadedByClassLoader = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Object argument = arguments[i];
            argumentsLoadedByClassLoader[i] = deepCloner.clone(argument);
        }
        Object result = null;
        try {
            result = Whitebox.invokeMethod((Object)objectLoadedWithClassloader, (String)method.getName(), (Object[])argumentsLoadedByClassLoader);
        }
        catch (Exception e) {
            SafeExceptionRethrower.safeRethrow((Throwable)e);
        }
        return result == null ? null : new DeepCloner().clone(result);
    }
}

