/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.expectation;

import java.lang.reflect.Constructor;
import org.mockito.stubbing.OngoingStubbing;
import org.powermock.api.mockito.expectation.DefaultConstructorExpectationSetup;
import org.powermock.api.mockito.expectation.WithOrWithoutExpectedArguments;

public class ConstructorAwareExpectationSetup<T>
implements WithOrWithoutExpectedArguments<T> {
    private final Constructor<T> ctor;
    private final DefaultConstructorExpectationSetup<T> expectationSetup;

    public ConstructorAwareExpectationSetup(Constructor<T> ctor) {
        if (ctor == null) {
            throw new IllegalArgumentException("Constructor to expect cannot be null");
        }
        this.ctor = ctor;
        this.expectationSetup = this.setupExpectation();
    }

    @Override
    public OngoingStubbing<T> withArguments(Object firstArgument, Object ... additionalArguments) throws Exception {
        return this.expectationSetup.withArguments(firstArgument, additionalArguments);
    }

    @Override
    public OngoingStubbing<T> withNoArguments() throws Exception {
        return this.expectationSetup.withNoArguments();
    }

    private DefaultConstructorExpectationSetup<T> setupExpectation() {
        DefaultConstructorExpectationSetup<T> setup = new DefaultConstructorExpectationSetup<T>(this.ctor.getDeclaringClass());
        setup.setParameterTypes(this.ctor.getParameterTypes());
        return setup;
    }
}

