/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.mockmaker;

import org.mockito.plugins.MockMaker;
import org.powermock.configuration.MockitoConfiguration;

public class MockMakerLoader {
    public MockMaker load(MockitoConfiguration mockitoConfiguration) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        String mockMakerClassName = mockitoConfiguration.getMockMakerClass();
        try {
            Class<?> mockMakerClass = loader.loadClass(mockMakerClassName);
            Object mockMaker = mockMakerClass.newInstance();
            return (MockMaker)MockMaker.class.cast(mockMaker);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load MockMaker implementation: " + mockMakerClassName, e);
        }
    }
}

