/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.repackaged;

import java.lang.reflect.Modifier;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.creation.instance.DefaultInstantiatorProvider;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.plugins.MockMaker;
import org.powermock.api.mockito.repackaged.AcrossJVMSerializationFeature;
import org.powermock.api.mockito.repackaged.ClassImposterizer;
import org.powermock.api.mockito.repackaged.MethodInterceptorFilter;
import org.powermock.api.mockito.repackaged.cglib.proxy.Callback;
import org.powermock.api.mockito.repackaged.cglib.proxy.Factory;
import org.powermock.api.mockito.repackaged.cglib.proxy.MethodInterceptor;

public class CglibMockMaker
implements MockMaker {
    public <T> T createMock(MockCreationSettings<T> settings, MockHandler handler) {
        InternalMockHandler mockitoHandler = this.cast(handler);
        new AcrossJVMSerializationFeature().enableSerializationAcrossJVM(settings);
        return new ClassImposterizer(new DefaultInstantiatorProvider().getInstantiator(settings)).imposterise((MethodInterceptor)new MethodInterceptorFilter(mockitoHandler, settings), settings.getTypeToMock(), settings.getExtraInterfaces());
    }

    private InternalMockHandler cast(MockHandler handler) {
        if (!(handler instanceof InternalMockHandler)) {
            throw new MockitoException("At the moment you cannot provide own implementations of MockHandler.\nPlease see the javadocs for the MockMaker interface.");
        }
        return (InternalMockHandler)handler;
    }

    public void resetMock(Object mock, MockHandler newHandler, MockCreationSettings settings) {
        ((Factory)mock).setCallback(0, new MethodInterceptorFilter(this.cast(newHandler), settings));
    }

    public MockHandler getHandler(Object mock) {
        if (!(mock instanceof Factory)) {
            return null;
        }
        Factory factory = (Factory)mock;
        Callback callback = factory.getCallback(0);
        if (!(callback instanceof MethodInterceptorFilter)) {
            return null;
        }
        return ((MethodInterceptorFilter)callback).getHandler();
    }

    public MockMaker.TypeMockability isTypeMockable(final Class<?> type) {
        return new MockMaker.TypeMockability(){

            public boolean mockable() {
                return !type.isPrimitive() && !Modifier.isFinal(type.getModifiers());
            }

            public String nonMockableReason() {
                if (type.isPrimitive()) {
                    return "primitive type";
                }
                if (Modifier.isFinal(type.getModifiers())) {
                    return "final or anonymous class";
                }
                return "";
            }
        };
    }
}

