/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.invocation;

import java.util.ArrayList;
import java.util.List;
import org.mockito.ArgumentMatcher;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.invocation.MatchersBinder;
import org.mockito.internal.matchers.LocalizedMatcher;
import org.mockito.internal.progress.ArgumentMatcherStorage;
import org.mockito.invocation.Invocation;

public class PowerMockMatchersBinder
extends MatchersBinder {
    public InvocationMatcher bindMatchers(ArgumentMatcherStorage argumentMatcherStorage, final Invocation invocation) {
        List lastMatchers = argumentMatcherStorage.pullLocalizedMatchers();
        this.validateMatchers(invocation, lastMatchers);
        List<ArgumentMatcher> argumentMatchers = this.extractArgumentMatchers(lastMatchers);
        InvocationMatcher invocationWithMatchers = new InvocationMatcher(invocation, argumentMatchers){

            public String toString() {
                return invocation.toString();
            }
        };
        return invocationWithMatchers;
    }

    private List<ArgumentMatcher> extractArgumentMatchers(List<LocalizedMatcher> lastMatchers) {
        ArrayList<ArgumentMatcher> argumentMatchers = new ArrayList<ArgumentMatcher>(lastMatchers.size());
        for (LocalizedMatcher localizedMatcher : lastMatchers) {
            argumentMatchers.add(localizedMatcher.getMatcher());
        }
        return argumentMatchers;
    }

    private void validateMatchers(Invocation invocation, List<LocalizedMatcher> lastMatchers) {
        if (!lastMatchers.isEmpty()) {
            int recordedMatchersSize = lastMatchers.size();
            int expectedMatchersSize = invocation.getArguments().length;
            if (expectedMatchersSize != recordedMatchersSize) {
                Reporter.invalidUseOfMatchers((int)expectedMatchersSize, lastMatchers);
            }
        }
    }
}

