/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.extension.listener;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.powermock.api.extension.InjectFieldSearcher;
import org.powermock.api.extension.listener.MockMetadata;
import org.powermock.reflect.Whitebox;

class DefaultInjectFieldSearcher
implements InjectFieldSearcher {
    DefaultInjectFieldSearcher() {
    }

    @Override
    public Field findField(Object instance, MockMetadata mockMetadata) {
        Set<Field> candidates = Whitebox.getFieldsAnnotatedWith((Object)instance, mockMetadata.getAnnotation(), (Class[])new Class[0]);
        if (candidates.size() == 1) {
            return (Field)candidates.iterator().next();
        }
        if ((candidates = this.filterByQualifier(candidates, mockMetadata.getQualifier())).size() == 1) {
            return candidates.iterator().next();
        }
        if ((candidates = this.filterByType(candidates, mockMetadata.getType())).size() == 1) {
            return candidates.iterator().next();
        }
        if ((candidates = this.filterByFieldName(candidates, mockMetadata.getFieldName())).size() == 1) {
            return candidates.iterator().next();
        }
        return null;
    }

    private Set<Field> filterByFieldName(Set<Field> candidates, String fieldName) {
        if (fieldName == null || fieldName.length() == 0) {
            return candidates;
        }
        return this.doFilterByQualifier(candidates, fieldName);
    }

    private Set<Field> filterByType(Set<Field> candidates, Class<?> type) {
        if (type == null) {
            return candidates;
        }
        return this.doFilterByType(candidates, type);
    }

    private Set<Field> doFilterByType(Set<Field> candidates, Class<?> type) {
        HashSet<Field> fields = new HashSet<Field>();
        for (Field candidate : candidates) {
            if (!candidate.getType().isAssignableFrom(type)) continue;
            fields.add(candidate);
        }
        return fields;
    }

    private Set<Field> filterByQualifier(Set<Field> candidates, String qualifier) {
        if (qualifier == null || qualifier.length() == 0) {
            return candidates;
        }
        return this.doFilterByQualifier(candidates, qualifier);
    }

    private Set<Field> doFilterByQualifier(Set<Field> candidates, String qualifier) {
        HashSet<Field> fields = new HashSet<Field>();
        for (Field candidate : candidates) {
            if (!candidate.getName().equals(qualifier)) continue;
            fields.add(candidate);
        }
        return fields;
    }
}

