/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.easymock;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.sf.cglib.proxy.Enhancer;
import org.easymock.ConstructorArgs;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.easymock.IMocksControl;
import org.easymock.internal.LastControl;
import org.easymock.internal.MockInvocationHandler;
import org.easymock.internal.MocksControl;
import org.powermock.api.easymock.internal.invocationcontrol.EasyMockMethodInvocationControl;
import org.powermock.api.easymock.internal.invocationcontrol.NewInvocationControlAssertionError;
import org.powermock.api.easymock.internal.invocationcontrol.NewInvocationControlImpl;
import org.powermock.api.easymock.internal.mockstrategy.MockStrategy;
import org.powermock.api.easymock.internal.mockstrategy.impl.DefaultMockStrategy;
import org.powermock.api.easymock.internal.mockstrategy.impl.NiceMockStrategy;
import org.powermock.api.easymock.internal.mockstrategy.impl.StrictMockStrategy;
import org.powermock.api.support.SuppressCode;
import org.powermock.api.support.membermodification.MemberModifier;
import org.powermock.core.ClassReplicaCreator;
import org.powermock.core.DefaultFieldValueGenerator;
import org.powermock.core.MockGateway;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.MethodInvocationControl;
import org.powermock.core.spi.NewInvocationControl;
import org.powermock.core.spi.support.InvocationSubstitute;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.internal.WhiteboxImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerMock
extends MemberModifier {
    private static final String NICE_REPLAY_AND_VERIFY_KEY = "PowerMock.niceReplayAndVerify";

    public static synchronized <T> T createMock(Class<T> type, Method ... methods) {
        return PowerMock.doMock(type, false, new DefaultMockStrategy(), null, methods);
    }

    public static synchronized <T> T createMock(Class<T> type) {
        return PowerMock.doMock(type, false, new DefaultMockStrategy(), null, null);
    }

    public static <T> T createMock(Class<T> type, ConstructorArgs constructorArgs, Method ... methods) {
        return PowerMock.doMock(type, false, new DefaultMockStrategy(), constructorArgs, methods);
    }

    public static <T> T createMock(Class<T> type, Object ... constructorArguments) {
        Constructor constructor = WhiteboxImpl.findUniqueConstructorOrThrowException(type, (Object[])constructorArguments);
        ConstructorArgs constructorArgs = new ConstructorArgs(constructor, constructorArguments);
        return PowerMock.doMock(type, false, new DefaultMockStrategy(), constructorArgs, null);
    }

    public static synchronized <T> T createStrictMock(Class<T> type, Method ... methods) {
        return PowerMock.doMock(type, false, new StrictMockStrategy(), null, methods);
    }

    public static synchronized <T> T createStrictMock(Class<T> type) {
        return PowerMock.doMock(type, false, new StrictMockStrategy(), null, null);
    }

    public static synchronized <T> T createNiceMock(Class<T> type, Method ... methods) {
        return PowerMock.doMock(type, false, new NiceMockStrategy(), null, methods);
    }

    public static synchronized <T> T createNiceMock(Class<T> type) {
        return PowerMock.doMock(type, false, new NiceMockStrategy(), null, null);
    }

    public static <T> T createStrictMock(Class<T> type, ConstructorArgs constructorArgs, Method ... methods) {
        return PowerMock.doMock(type, false, new StrictMockStrategy(), constructorArgs, methods);
    }

    public static <T> T createNiceMock(Class<T> type, ConstructorArgs constructorArgs, Method ... methods) {
        return PowerMock.doMock(type, false, new NiceMockStrategy(), constructorArgs, methods);
    }

    public static <T> T createStrictMock(Class<T> type, Object ... constructorArguments) {
        Constructor constructor = WhiteboxImpl.findUniqueConstructorOrThrowException(type, (Object[])constructorArguments);
        ConstructorArgs constructorArgs = new ConstructorArgs(constructor, constructorArguments);
        return PowerMock.doMock(type, false, new StrictMockStrategy(), constructorArgs, null);
    }

    public static <T> T createNiceMock(Class<T> type, Object ... constructorArguments) {
        Constructor constructor = WhiteboxImpl.findUniqueConstructorOrThrowException(type, (Object[])constructorArguments);
        ConstructorArgs constructorArgs = new ConstructorArgs(constructor, constructorArguments);
        return PowerMock.doMock(type, false, new NiceMockStrategy(), constructorArgs, null);
    }

    public static synchronized void mockStatic(Class<?> type, Method ... methods) {
        PowerMock.doMock(type, true, new DefaultMockStrategy(), null, methods);
    }

    public static synchronized void mockStatic(Class<?> type) {
        PowerMock.doMock(type, true, new DefaultMockStrategy(), null, null);
    }

    public static synchronized void mockStaticStrict(Class<?> type, Method ... methods) {
        PowerMock.doMock(type, true, new StrictMockStrategy(), null, methods);
    }

    public static synchronized void mockStaticStrict(Class<?> type) {
        PowerMock.doMock(type, true, new StrictMockStrategy(), null, null);
    }

    public static synchronized void mockStaticNice(Class<?> type, Method ... methods) {
        PowerMock.doMock(type, true, new NiceMockStrategy(), null, methods);
    }

    public static synchronized void mockStaticNice(Class<?> type) {
        PowerMock.doMock(type, true, new NiceMockStrategy(), null, null);
    }

    public static synchronized <T> T createPartialMockForAllMethodsExcept(Class<T> type, String ... methodNames) {
        if (methodNames != null && methodNames.length == 0) {
            return PowerMock.createMock(type);
        }
        return PowerMock.createMock(type, WhiteboxImpl.getAllMethodExcept(type, (String[])methodNames));
    }

    public static synchronized <T> T createNicePartialMockForAllMethodsExcept(Class<T> type, String ... methodNames) {
        if (methodNames != null && methodNames.length == 0) {
            return PowerMock.createNiceMock(type);
        }
        return PowerMock.createNiceMock(type, WhiteboxImpl.getAllMethodExcept(type, (String[])methodNames));
    }

    public static synchronized <T> T createStrictPartialMockForAllMethodsExcept(Class<T> type, String ... methodNames) {
        if (methodNames != null && methodNames.length == 0) {
            return PowerMock.createStrictMock(type);
        }
        return PowerMock.createStrictMock(type, WhiteboxImpl.getAllMethodExcept(type, (String[])methodNames));
    }

    public static synchronized <T> T createPartialMockForAllMethodsExcept(Class<T> type, String methodNameToExclude, Class<?> firstArgumentType, Class<?> ... moreTypes) {
        Class[] argumentTypes = PowerMock.mergeArgumentTypes(firstArgumentType, moreTypes);
        return PowerMock.createMock(type, WhiteboxImpl.getAllMetodsExcept(type, (String)methodNameToExclude, (Class[])argumentTypes));
    }

    public static synchronized <T> T createNicePartialMockForAllMethodsExcept(Class<T> type, String methodNameToExclude, Class<?> firstArgumentType, Class<?> ... moreTypes) {
        Class[] argumentTypes = PowerMock.mergeArgumentTypes(firstArgumentType, moreTypes);
        return PowerMock.createNiceMock(type, WhiteboxImpl.getAllMetodsExcept(type, (String)methodNameToExclude, (Class[])argumentTypes));
    }

    public static synchronized <T> T createStrictPartialMockForAllMethodsExcept(Class<T> type, String methodNameToExclude, Class<?> firstArgumentType, Class<?> ... moreTypes) {
        Class[] argumentTypes = PowerMock.mergeArgumentTypes(firstArgumentType, moreTypes);
        return PowerMock.createStrictMock(type, WhiteboxImpl.getAllMetodsExcept(type, (String)methodNameToExclude, (Class[])argumentTypes));
    }

    public static synchronized <T> T createPartialMock(Class<T> type, String methodNameToMock, Class<?> firstArgumentType, Class<?> ... additionalArgumentTypes) {
        return PowerMock.doMockSpecific(type, new DefaultMockStrategy(), new String[]{methodNameToMock}, null, PowerMock.mergeArgumentTypes(firstArgumentType, additionalArgumentTypes));
    }

    public static synchronized <T> T createStrictPartialMock(Class<T> type, String methodNameToMock, Class<?> firstArgumentType, Class<?> ... additionalArgumentTypes) {
        return PowerMock.doMockSpecific(type, new StrictMockStrategy(), new String[]{methodNameToMock}, null, PowerMock.mergeArgumentTypes(firstArgumentType, additionalArgumentTypes));
    }

    public static synchronized <T> T createNicePartialMock(Class<T> type, String methodNameToMock, Class<?> firstArgumentType, Class<?> ... additionalArgumentTypes) {
        return PowerMock.doMockSpecific(type, new NiceMockStrategy(), new String[]{methodNameToMock}, null, PowerMock.mergeArgumentTypes(firstArgumentType, additionalArgumentTypes));
    }

    public static synchronized void mockStaticPartial(Class<?> clazz, String methodNameToMock, Class<?> firstArgumentType, Class<?> ... additionalArgumentTypes) {
        PowerMock.doMockSpecific(clazz, new DefaultMockStrategy(), new String[]{methodNameToMock}, null, PowerMock.mergeArgumentTypes(firstArgumentType, additionalArgumentTypes));
    }

    public static synchronized void mockStaticPartialStrict(Class<?> clazz, String methodNameToMock, Class<?> firstArgumentType, Class<?> ... additionalArgumentTypes) {
        PowerMock.doMockSpecific(clazz, new StrictMockStrategy(), new String[]{methodNameToMock}, null, PowerMock.mergeArgumentTypes(firstArgumentType, additionalArgumentTypes));
    }

    public static synchronized void mockStaticPartialNice(Class<?> clazz, String methodNameToMock, Class<?> firstArgumentType, Class<?> ... additionalArgumentTypes) {
        PowerMock.doMockSpecific(clazz, new NiceMockStrategy(), new String[]{methodNameToMock}, null, PowerMock.mergeArgumentTypes(firstArgumentType, additionalArgumentTypes));
    }

    public static synchronized void mockStaticPartial(Class<?> clazz, String ... methodNames) {
        PowerMock.mockStatic(clazz, Whitebox.getMethods(clazz, (String[])methodNames));
    }

    public static synchronized void mockStaticPartialStrict(Class<?> clazz, String ... methodNames) {
        PowerMock.mockStaticStrict(clazz, Whitebox.getMethods(clazz, (String[])methodNames));
    }

    public static synchronized void mockStaticPartialNice(Class<?> clazz, String ... methodNames) {
        PowerMock.mockStaticNice(clazz, Whitebox.getMethods(clazz, (String[])methodNames));
    }

    static <T> T doMockSpecific(Class<T> type, MockStrategy mockStrategy, String[] methodNamesToMock, ConstructorArgs constructorArgs, Class<?> ... argumentTypes) {
        LinkedList<Method> methods = new LinkedList<Method>();
        for (String methodName : methodNamesToMock) {
            methods.add(WhiteboxImpl.findMethodOrThrowException(type, (String)methodName, (Class[])argumentTypes));
        }
        Method[] methodArray = methods.toArray(new Method[0]);
        if (WhiteboxImpl.areAllMethodsStatic((Method[])methodArray)) {
            if (mockStrategy instanceof DefaultMockStrategy) {
                PowerMock.mockStatic(type, methodArray);
            } else if (mockStrategy instanceof StrictMockStrategy) {
                PowerMock.mockStaticStrict(type, methodArray);
            } else {
                PowerMock.mockStaticNice(type, methodArray);
            }
            return null;
        }
        T mock = null;
        mock = mockStrategy instanceof DefaultMockStrategy ? (T)PowerMock.createMock(type, constructorArgs, methodArray) : (mockStrategy instanceof StrictMockStrategy ? (T)PowerMock.createStrictMock(type, constructorArgs, methodArray) : (T)PowerMock.createNiceMock(type, constructorArgs, methodArray));
        return mock;
    }

    public static synchronized <T> T createPartialMock(Class<T> type, String ... methodNames) {
        return PowerMock.createMock(type, Whitebox.getMethods(type, (String[])methodNames));
    }

    public static synchronized <T> T createPartialMock(Class<T> type, Class<? super T> where, String ... methodNames) {
        return PowerMock.createMock(type, Whitebox.getMethods(where, (String[])methodNames));
    }

    public static synchronized <T> T createStrictPartialMock(Class<T> type, String ... methodNames) {
        return PowerMock.createStrictMock(type, Whitebox.getMethods(type, (String[])methodNames));
    }

    public static synchronized <T> T createStrictPartialMock(Class<T> type, Class<? super T> where, String ... methodNames) {
        return PowerMock.createStrictMock(type, Whitebox.getMethods(where, (String[])methodNames));
    }

    public static synchronized <T> T createNicePartialMock(Class<T> type, String ... methodNames) {
        return PowerMock.createNiceMock(type, Whitebox.getMethods(type, (String[])methodNames));
    }

    public static synchronized <T> T createNicePartialMock(Class<T> type, Class<? super T> where, String ... methodNames) {
        return PowerMock.createNiceMock(type, Whitebox.getMethods(where, (String[])methodNames));
    }

    public static <T> T createPartialMockAndInvokeDefaultConstructor(Class<T> type, String ... methodNames) throws Exception {
        return PowerMock.createMock(type, new ConstructorArgs(Whitebox.getConstructor(type, (Class[])new Class[0]), new Object[0]), Whitebox.getMethods(type, (String[])methodNames));
    }

    public static <T> T createNicePartialMockAndInvokeDefaultConstructor(Class<T> type, String ... methodNames) throws Exception {
        return PowerMock.createNiceMock(type, new ConstructorArgs(Whitebox.getConstructor(type, (Class[])new Class[0]), new Object[0]), Whitebox.getMethods(type, (String[])methodNames));
    }

    public static <T> T createStrictPartialMockAndInvokeDefaultConstructor(Class<T> type, String ... methodNames) throws Exception {
        return PowerMock.createStrictMock(type, new ConstructorArgs(Whitebox.getConstructor(type, (Class[])new Class[0]), new Object[0]), Whitebox.getMethods(type, (String[])methodNames));
    }

    public static <T> T createPartialMock(Class<T> type, String[] methodNames, Object ... constructorArguments) {
        Constructor constructor = WhiteboxImpl.findUniqueConstructorOrThrowException(type, (Object[])constructorArguments);
        ConstructorArgs constructorArgs = new ConstructorArgs(constructor, constructorArguments);
        return PowerMock.doMock(type, false, new DefaultMockStrategy(), constructorArgs, Whitebox.getMethods(type, (String[])methodNames));
    }

    public static <T> T createStrictPartialMock(Class<T> type, String[] methodNames, Object ... constructorArguments) {
        Constructor constructor = WhiteboxImpl.findUniqueConstructorOrThrowException(type, (Object[])constructorArguments);
        ConstructorArgs constructorArgs = new ConstructorArgs(constructor, constructorArguments);
        return PowerMock.doMock(type, false, new StrictMockStrategy(), constructorArgs, Whitebox.getMethods(type, (String[])methodNames));
    }

    public static <T> T createNicePartialMock(Class<T> type, String[] methodNames, Object ... constructorArguments) {
        Constructor constructor = WhiteboxImpl.findUniqueConstructorOrThrowException(type, (Object[])constructorArguments);
        ConstructorArgs constructorArgs = new ConstructorArgs(constructor, constructorArguments);
        return PowerMock.doMock(type, false, new NiceMockStrategy(), constructorArgs, Whitebox.getMethods(type, (String[])methodNames));
    }

    public static <T> T createPartialMock(Class<T> type, String methodName, Class<?>[] methodParameterTypes, Object ... constructorArguments) {
        Constructor constructor = WhiteboxImpl.findUniqueConstructorOrThrowException(type, (Object[])constructorArguments);
        ConstructorArgs constructorArgs = new ConstructorArgs(constructor, constructorArguments);
        return PowerMock.doMockSpecific(type, new DefaultMockStrategy(), new String[]{methodName}, constructorArgs, methodParameterTypes);
    }

    public static <T> T createStrictPartialMock(Class<T> type, String methodName, Class<?>[] methodParameterTypes, Object ... constructorArguments) {
        Constructor constructor = WhiteboxImpl.findUniqueConstructorOrThrowException(type, (Object[])constructorArguments);
        ConstructorArgs constructorArgs = new ConstructorArgs(constructor, constructorArguments);
        return PowerMock.doMockSpecific(type, new StrictMockStrategy(), new String[]{methodName}, constructorArgs, methodParameterTypes);
    }

    public static <T> T createNicePartialMock(Class<T> type, String methodName, Class<?>[] methodParameterTypes, Object ... constructorArguments) {
        Constructor constructor = WhiteboxImpl.findUniqueConstructorOrThrowException(type, (Object[])constructorArguments);
        ConstructorArgs constructorArgs = new ConstructorArgs(constructor, constructorArguments);
        return PowerMock.doMockSpecific(type, new NiceMockStrategy(), new String[]{methodName}, constructorArgs, methodParameterTypes);
    }

    public static <T> T createPartialMock(Class<T> type, String methodName, Class<?>[] methodParameterTypes, Object[] constructorArguments, Class<?>[] constructorParameterTypes) {
        ConstructorArgs constructorArgs = new ConstructorArgs(Whitebox.getConstructor(type, (Class[])constructorParameterTypes), constructorArguments);
        return PowerMock.doMockSpecific(type, new DefaultMockStrategy(), new String[]{methodName}, constructorArgs, methodParameterTypes);
    }

    public static <T> T createStrictPartialMock(Class<T> type, String methodName, Class<?>[] methodParameterTypes, Object[] constructorArguments, Class<?>[] constructorParameterTypes) {
        ConstructorArgs constructorArgs = new ConstructorArgs(Whitebox.getConstructor(type, (Class[])constructorParameterTypes), constructorArguments);
        return PowerMock.doMockSpecific(type, new StrictMockStrategy(), new String[]{methodName}, constructorArgs, methodParameterTypes);
    }

    public static <T> T createNicePartialMock(Class<T> type, String methodName, Class<?>[] methodParameterTypes, Object[] constructorArguments, Class<?>[] constructorParameterTypes) {
        ConstructorArgs constructorArgs = new ConstructorArgs(Whitebox.getConstructor(type, (Class[])constructorParameterTypes), constructorArguments);
        return PowerMock.doMockSpecific(type, new NiceMockStrategy(), new String[]{methodName}, constructorArgs, methodParameterTypes);
    }

    public static synchronized <T> IExpectationSetters<T> expectPrivate(Class<?> clazz, Method method, Object ... arguments) throws Exception {
        return PowerMock.doExpectPrivate(clazz, method, arguments);
    }

    public static synchronized <T> IExpectationSetters<T> expectPrivate(Object instance, Method method, Object ... arguments) throws Exception {
        return PowerMock.doExpectPrivate(instance, method, arguments);
    }

    public static synchronized <T> IExpectationSetters<T> expectPrivate(Object instance, String methodName, Class<?>[] parameterTypes, Object ... arguments) throws Exception {
        if (arguments == null) {
            arguments = new Object[]{};
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance cannot be null.");
        }
        if (arguments.length != parameterTypes.length) {
            throw new IllegalArgumentException("The length of the arguments must be equal to the number of parameter types.");
        }
        Method foundMethod = Whitebox.getMethod(instance.getClass(), (String)methodName, (Class[])parameterTypes);
        WhiteboxImpl.throwExceptionIfMethodWasNotFound(instance.getClass(), (String)methodName, (Method)foundMethod, (Object[])parameterTypes);
        return PowerMock.doExpectPrivate(instance, foundMethod, arguments);
    }

    public static synchronized <T> IExpectationSetters<T> expectPrivate(Object instance, String methodName, Object ... arguments) throws Exception {
        if (instance == null) {
            throw new IllegalArgumentException("Instance or class cannot be null.");
        }
        return PowerMock.expectPrivate(instance, methodName, Whitebox.getType((Object)instance), arguments);
    }

    public static synchronized <T> IExpectationSetters<T> expectPrivate(Object instance, Object ... arguments) throws Exception {
        return PowerMock.expectPrivate(instance, null, Whitebox.getType((Object)instance), arguments);
    }

    public static synchronized <T> IExpectationSetters<T> expectPrivate(Object instance, String methodName, Class<?> where, Class<?>[] parameterTypes, Object ... arguments) throws Exception {
        if (instance == null) {
            throw new IllegalArgumentException("Instance or class to expect cannot be null.");
        }
        Method[] methods = null;
        if (methodName != null) {
            methods = parameterTypes == null ? Whitebox.getMethods(where, (String[])new String[]{methodName}) : new Method[]{Whitebox.getMethod(where, (String)methodName, (Class[])parameterTypes)};
        }
        Object methodToExpect = methods != null && methods.length == 1 ? methods[0] : WhiteboxImpl.findMethodOrThrowException((Object)instance, null, (String)methodName, (Object[])arguments);
        return PowerMock.doExpectPrivate(instance, methodToExpect, arguments);
    }

    public static synchronized <T> IExpectationSetters<T> expectPrivate(Object instance, String methodName, Class<?> where, Object ... arguments) throws Exception {
        return PowerMock.expectPrivate(instance, methodName, where, null, arguments);
    }

    public static synchronized IExpectationSetters<Object> expectLastCall() {
        return EasyMock.expectLastCall();
    }

    public static synchronized void niceReplayAndVerify() {
        MockRepository.putAdditionalState((String)NICE_REPLAY_AND_VERIFY_KEY, (Object)true);
    }

    private static boolean isEasyMocked(Object mock) {
        return Enhancer.isEnhanced(mock.getClass()) || Proxy.isProxyClass(mock.getClass());
    }

    public static synchronized void replayAll(Object ... additionalMocks) {
        MockRepository.addObjectsToAutomaticallyReplayAndVerify((Object[])additionalMocks);
        for (Object classToReplayOrVerify : MockRepository.getObjectsToAutomaticallyReplayAndVerify()) {
            PowerMock.replay(classToReplayOrVerify);
        }
    }

    public static synchronized void resetAll(Object ... additionalMocks) {
        MockRepository.addObjectsToAutomaticallyReplayAndVerify((Object[])additionalMocks);
        for (Object classToReplayOrVerify : MockRepository.getObjectsToAutomaticallyReplayAndVerify()) {
            PowerMock.reset(classToReplayOrVerify);
        }
    }

    public static synchronized void reset(Class<?> ... classMocks) {
        for (Class<?> type : classMocks) {
            NewInvocationControl newInvocationControl;
            MethodInvocationControl invocationHandler = MockRepository.getStaticMethodInvocationControl(type);
            if (invocationHandler != null) {
                invocationHandler.reset(new Object[0]);
            }
            if ((newInvocationControl = MockRepository.getNewInstanceControl(type)) == null) continue;
            try {
                newInvocationControl.reset(new Object[0]);
            }
            catch (AssertionError e) {
                NewInvocationControlAssertionError.throwAssertionErrorForNewSubstitutionFailure(e, type);
            }
        }
    }

    public static synchronized void reset(Object ... mocks) {
        try {
            for (Object mock : mocks) {
                if (mock instanceof Class) {
                    PowerMock.reset((Class)mock);
                    continue;
                }
                MethodInvocationControl invocationControl = MockRepository.getInstanceMethodInvocationControl((Object)mock);
                if (invocationControl != null) {
                    invocationControl.reset(new Object[0]);
                    continue;
                }
                if (PowerMock.isNiceReplayAndVerifyMode() && !PowerMock.isEasyMocked(mock)) continue;
                try {
                    EasyMock.reset((Object[])new Object[]{mock});
                }
                catch (RuntimeException e) {
                    throw new RuntimeException(mock + " is not a mock object", e);
                }
            }
        }
        catch (Throwable t) {
            MockRepository.putAdditionalState((String)NICE_REPLAY_AND_VERIFY_KEY, (Object)false);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
    }

    public static synchronized void verifyAll() {
        for (Object classToReplayOrVerify : MockRepository.getObjectsToAutomaticallyReplayAndVerify()) {
            PowerMock.verify(classToReplayOrVerify);
        }
    }

    public static synchronized void replay(Object ... mocks) {
        try {
            for (Object mock : mocks) {
                if (mock instanceof Class) {
                    PowerMock.replay((Class)mock);
                    continue;
                }
                MethodInvocationControl invocationControl = MockRepository.getInstanceMethodInvocationControl((Object)mock);
                if (invocationControl != null) {
                    invocationControl.replay(new Object[0]);
                    continue;
                }
                if (PowerMock.isNiceReplayAndVerifyMode() && !PowerMock.isEasyMocked(mock)) continue;
                try {
                    EasyMock.replay((Object[])new Object[]{mock});
                }
                catch (RuntimeException e) {
                    throw new RuntimeException(mock + " is not a mock object", e);
                }
            }
        }
        catch (Throwable t) {
            MockRepository.putAdditionalState((String)NICE_REPLAY_AND_VERIFY_KEY, (Object)false);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
    }

    public static synchronized void verify(Object ... objects) {
        for (Object mock : objects) {
            if (mock instanceof Class) {
                PowerMock.verifyClass((Class)mock);
                continue;
            }
            MethodInvocationControl invocationControl = MockRepository.getInstanceMethodInvocationControl((Object)mock);
            if (invocationControl != null) {
                invocationControl.verify(new Object[0]);
                continue;
            }
            if (PowerMock.isNiceReplayAndVerifyMode() && !PowerMock.isEasyMocked(mock)) continue;
            try {
                EasyMock.verify((Object[])new Object[]{mock});
            }
            catch (RuntimeException e) {
                throw new RuntimeException(mock + " is not a mock object", e);
            }
        }
    }

    public static synchronized <T> T createMockAndExpectNew(Class<T> type, Object ... arguments) throws Exception {
        T mock = PowerMock.createMock(type);
        PowerMock.expectNew(type, arguments).andReturn(mock);
        return mock;
    }

    public static synchronized <T> T createMockAndExpectNew(Class<T> type, Class<?>[] parameterTypes, Object ... arguments) throws Exception {
        T mock = PowerMock.createMock(type);
        PowerMock.expectNew(type, parameterTypes, arguments).andReturn(mock);
        return mock;
    }

    public static synchronized <T> T createNiceMockAndExpectNew(Class<T> type, Object ... arguments) throws Exception {
        T mock = PowerMock.createNiceMock(type);
        IExpectationSetters<T> expectationSetters = PowerMock.expectNiceNew(type, arguments);
        if (expectationSetters != null) {
            expectationSetters.andReturn(mock);
        }
        return mock;
    }

    public static synchronized <T> T createNiceMockAndExpectNew(Class<T> type, Class<?>[] parameterTypes, Object ... arguments) throws Exception {
        T mock = PowerMock.createNiceMock(type);
        IExpectationSetters<T> expectationSetters = PowerMock.expectNiceNew(type, parameterTypes, arguments);
        if (expectationSetters != null) {
            expectationSetters.andReturn(mock);
        }
        return mock;
    }

    public static synchronized <T> T createStrictMockAndExpectNew(Class<T> type, Object ... arguments) throws Exception {
        T mock = PowerMock.createStrictMock(type);
        PowerMock.expectStrictNew(type, arguments).andReturn(mock);
        return mock;
    }

    public static synchronized <T> T createStrictMockAndExpectNew(Class<T> type, Class<?>[] parameterTypes, Object ... arguments) throws Exception {
        T mock = PowerMock.createStrictMock(type);
        PowerMock.expectStrictNew(type, parameterTypes, arguments).andReturn(mock);
        return mock;
    }

    public static synchronized <T> IExpectationSetters<T> expectNew(Class<T> type, Class<?>[] parameterTypes, Object ... arguments) throws Exception {
        return PowerMock.doExpectNew(type, new DefaultMockStrategy(), parameterTypes, arguments);
    }

    private static <T> IExpectationSetters<T> doExpectNew(Class<T> type, MockStrategy mockStrategy, Class<?>[] parameterTypes, Object ... arguments) throws Exception {
        NewInvocationControlImpl<T> newInvocationControl;
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (mockStrategy == null) {
            throw new IllegalArgumentException("Internal error: Mock strategy cannot be null");
        }
        boolean isNiceMock = mockStrategy instanceof NiceMockStrategy;
        Class unmockedType = WhiteboxImpl.getUnmockedType(type);
        if (!isNiceMock) {
            if (parameterTypes == null) {
                WhiteboxImpl.findUniqueConstructorOrThrowException(type, (Object[])arguments);
            } else {
                WhiteboxImpl.getConstructor((Class)unmockedType, (Class[])parameterTypes);
            }
        }
        if ((newInvocationControl = MockRepository.getNewInstanceControl((Class)unmockedType)) == null) {
            InvocationSubstitute mock = PowerMock.doMock(InvocationSubstitute.class, false, mockStrategy, null, null);
            newInvocationControl = new NewInvocationControlImpl<T>(mock, type);
            MockRepository.putNewInstanceControl(type, newInvocationControl);
            MockRepository.addObjectsToAutomaticallyReplayAndVerify((Object[])new Object[]{WhiteboxImpl.getUnmockedType(type)});
        }
        if (isNiceMock && (arguments == null || arguments.length == 0)) {
            return null;
        }
        return (IExpectationSetters)newInvocationControl.expectSubstitutionLogic(arguments);
    }

    public static synchronized <T> IExpectationSetters<T> expectNew(Class<T> type, Object ... arguments) throws Exception {
        return PowerMock.doExpectNew(type, new DefaultMockStrategy(), null, arguments);
    }

    public static synchronized <T> IExpectationSetters<T> expectNew(String fullyQualifiedName, Object ... arguments) throws Exception {
        Class<?> forName = Class.forName(fullyQualifiedName);
        return PowerMock.doExpectNew(forName, new DefaultMockStrategy(), null, arguments);
    }

    public static synchronized <T> IExpectationSetters<T> expectStrictNew(Class<T> type, Object ... arguments) throws Exception {
        return PowerMock.doExpectNew(type, new StrictMockStrategy(), null, arguments);
    }

    public static synchronized <T> IExpectationSetters<T> expectStrictNew(Class<T> type, Class<?>[] parameterTypes, Object ... arguments) throws Exception {
        return PowerMock.doExpectNew(type, new StrictMockStrategy(), parameterTypes, arguments);
    }

    public static synchronized <T> IExpectationSetters<T> expectNiceNew(Class<T> type, Object ... arguments) throws Exception {
        return PowerMock.doExpectNew(type, new NiceMockStrategy(), null, arguments);
    }

    public static synchronized <T> IExpectationSetters<T> expectNiceNew(Class<T> type, Class<?>[] parameterTypes, Object ... arguments) throws Exception {
        return PowerMock.doExpectNew(type, new NiceMockStrategy(), parameterTypes, arguments);
    }

    public static synchronized void suppressConstructor(Constructor<?> ... constructors) {
        SuppressCode.suppressConstructor((Constructor[])constructors);
    }

    public static synchronized void suppressSpecificConstructor(Class<?> clazz, Class<?> ... parameterTypes) {
        SuppressCode.suppressSpecificConstructor(clazz, (Class[])parameterTypes);
    }

    public static synchronized void suppressConstructor(Class<?> ... classes) {
        SuppressCode.suppressConstructor((Class[])classes);
    }

    public static synchronized void suppressConstructor(Class<?> clazz, boolean excludePrivateConstructors) {
        SuppressCode.suppressConstructor(clazz, (boolean)excludePrivateConstructors);
    }

    public static synchronized void suppressField(Field ... fields) {
        SuppressCode.suppressField((Field[])fields);
    }

    public static synchronized void suppressField(Class<?>[] classes) {
        SuppressCode.suppressField((Class[])classes);
    }

    public static synchronized void suppressField(Class<?> clazz, String ... fieldNames) {
        SuppressCode.suppressField(clazz, (String[])fieldNames);
    }

    public static synchronized void suppressMethod(Method ... methods) {
        SuppressCode.suppressMethod((Method[])methods);
    }

    public static synchronized void suppressMethod(Class<?> cls, Class<?> ... additionalClasses) {
        SuppressCode.suppressMethod(cls, (Class[])additionalClasses);
    }

    public static synchronized void suppressMethod(Class<?>[] classes) {
        SuppressCode.suppressMethod((Class[])classes);
    }

    public static synchronized void suppressMethod(Class<?> clazz, String methodName, String ... additionalMethodNames) {
        SuppressCode.suppressMethod(clazz, (String)methodName, (String[])additionalMethodNames);
    }

    public static synchronized void suppressMethod(Class<?> clazz, String[] methodNames) {
        SuppressCode.suppressMethod(clazz, (String[])methodNames);
    }

    public static synchronized void suppressMethod(Class<?> clazz, boolean excludePrivateMethods) {
        SuppressCode.suppressMethod(clazz, (boolean)excludePrivateMethods);
    }

    public static synchronized void suppressMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        SuppressCode.suppressMethod(clazz, (String)methodName, (Class[])parameterTypes);
    }

    private static <T> T doMock(Class<T> type, boolean isStatic, MockStrategy mockStrategy, ConstructorArgs constructorArgs, Method ... methods) {
        if (type == null) {
            throw new IllegalArgumentException("The class to mock cannot be null");
        }
        MockRepository.addAfterMethodRunner((Runnable)new Runnable(){

            public void run() {
                LastControl.reportLastControl(null);
            }
        });
        IMocksControl control = mockStrategy.createMockControl(type);
        MockRepository.addAfterMethodRunner((Runnable)new EasyMockStateCleaner());
        Object mock = null;
        if (type.isInterface()) {
            mock = control.createMock(type);
        } else {
            if (type.getName().startsWith("java.") && Modifier.isFinal(type.getModifiers())) {
                Object newInstance;
                Class<?> replicaType = PowerMock.createReplicaType(type, isStatic, constructorArgs);
                Object replica = PowerMock.doCreateMock(replicaType, constructorArgs, control, methods);
                control = mockStrategy.createMockControl(replicaType);
                MockInvocationHandler h = new MockInvocationHandler((MocksControl)control);
                Set<Method> methodsToMock = PowerMock.toSet(methods);
                if (isStatic) {
                    MockRepository.putStaticMethodInvocationControl(type, new EasyMockMethodInvocationControl(h, methodsToMock, replica));
                    MockRepository.addObjectsToAutomaticallyReplayAndVerify((Object[])new Object[]{type});
                    return null;
                }
                if (constructorArgs == null) {
                    newInstance = Whitebox.newInstance(type);
                    DefaultFieldValueGenerator.fillWithDefaultValues((Object)newInstance);
                } else {
                    try {
                        newInstance = constructorArgs.getConstructor().newInstance(constructorArgs.getInitArgs());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Internal error", e);
                    }
                }
                MockRepository.putInstanceMethodInvocationControl((Object)newInstance, new EasyMockMethodInvocationControl(h, methodsToMock, replica));
                if (!(newInstance instanceof InvocationSubstitute)) {
                    MockRepository.addObjectsToAutomaticallyReplayAndVerify((Object[])new Object[]{newInstance});
                }
                return (T)newInstance;
            }
            mock = PowerMock.doCreateMock(type, constructorArgs, control, methods);
        }
        MockInvocationHandler h = new MockInvocationHandler((MocksControl)control);
        Set<Method> methodsToMock = PowerMock.toSet(methods);
        if (isStatic) {
            MockRepository.putStaticMethodInvocationControl(type, new EasyMockMethodInvocationControl<Object>(h, methodsToMock, mock));
            MockRepository.addObjectsToAutomaticallyReplayAndVerify((Object[])new Object[]{type});
        } else {
            MockRepository.putInstanceMethodInvocationControl((Object)mock, new EasyMockMethodInvocationControl(h, methodsToMock));
            if (!(mock instanceof InvocationSubstitute)) {
                MockRepository.addObjectsToAutomaticallyReplayAndVerify((Object[])new Object[]{mock});
            }
        }
        return (T)mock;
    }

    private static <T> Class<?> createReplicaType(Class<T> type, boolean isStatic, ConstructorArgs constructorArgs) {
        ClassReplicaCreator classReplicaCreator = new ClassReplicaCreator();
        Class replicaType = null;
        if (isStatic || constructorArgs == null) {
            replicaType = classReplicaCreator.createClassReplica(type);
        } else {
            try {
                replicaType = classReplicaCreator.createInstanceReplica(constructorArgs.getConstructor().newInstance(constructorArgs.getInitArgs()));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof RuntimeException) {
                    throw (RuntimeException)targetException;
                }
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return replicaType;
    }

    private static <T> T doCreateMock(Class<T> type, ConstructorArgs constructorArgs, IMocksControl control, Method ... methods) {
        MocksControl mocksControl = (MocksControl)control;
        Object mock = constructorArgs == null ? (methods == null ? mocksControl.createMock(type) : mocksControl.createMock(type, methods)) : (methods == null ? mocksControl.createMock(type, constructorArgs, new Method[0]) : mocksControl.createMock(type, constructorArgs, methods));
        return (T)mock;
    }

    private static Set<Method> toSet(Method[] methods) {
        return methods == null ? null : new HashSet<Method>(Arrays.asList(methods));
    }

    private static Class<?>[] mergeArgumentTypes(Class<?> firstArgumentType, Class<?> ... additionalArgumentTypes) {
        if (firstArgumentType == null) {
            return additionalArgumentTypes == null ? new Class[]{} : additionalArgumentTypes;
        }
        if (additionalArgumentTypes == null) {
            additionalArgumentTypes = new Class[]{};
        }
        Class[] argumentTypes = new Class[additionalArgumentTypes.length + 1];
        argumentTypes[0] = firstArgumentType;
        if (additionalArgumentTypes.length != 0) {
            System.arraycopy(additionalArgumentTypes, 0, argumentTypes, 1, additionalArgumentTypes.length);
        }
        return argumentTypes;
    }

    private static <T> IExpectationSetters<T> doExpectPrivate(Object instance, Method methodToExpect, Object ... arguments) throws Exception {
        WhiteboxImpl.performMethodInvocation((Object)instance, (Method)methodToExpect, (Object[])arguments);
        return EasyMock.expectLastCall();
    }

    private static synchronized void replay(Class<?> ... types) {
        for (Class<?> type : types) {
            NewInvocationControl newInvocationControl;
            MethodInvocationControl invocationHandler = MockRepository.getStaticMethodInvocationControl(type);
            if (invocationHandler != null) {
                invocationHandler.replay(new Object[0]);
            }
            if ((newInvocationControl = MockRepository.getNewInstanceControl(type)) == null) continue;
            newInvocationControl.replay(new Object[0]);
        }
    }

    private static synchronized void verifyClass(Class<?> ... types) {
        for (Class<?> type : types) {
            NewInvocationControl newInvocationControl;
            MethodInvocationControl invocationHandler = MockRepository.getStaticMethodInvocationControl(type);
            if (invocationHandler != null) {
                invocationHandler.verify(new Object[0]);
            }
            if ((newInvocationControl = MockRepository.getNewInstanceControl(type)) == null) continue;
            try {
                newInvocationControl.verify(new Object[0]);
            }
            catch (AssertionError e) {
                NewInvocationControlAssertionError.throwAssertionErrorForNewSubstitutionFailure(e, type);
            }
        }
    }

    private static boolean isNiceReplayAndVerifyMode() {
        Boolean mode = (Boolean)MockRepository.getAdditionalState((String)NICE_REPLAY_AND_VERIFY_KEY);
        return mode != null && mode != false;
    }

    static {
        MockGateway.MOCK_STANDARD_METHODS = false;
        MockGateway.MOCK_GET_CLASS_METHOD = false;
    }

    private static class EasyMockStateCleaner
    implements Runnable {
        private EasyMockStateCleaner() {
        }

        public void run() {
            LastControl.reportLastControl(null);
            this.invokeReportLastControlFromSystemCL();
        }

        private void invokeReportLastControlFromSystemCL() {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            try {
                Class<?> lastControlClassBySystemCL = Class.forName(LastControl.class.getName(), false, classLoader);
                Class<?> mocksControlClassBySystemCL = Class.forName(MocksControl.class.getName(), false, classLoader);
                Method reportLastControl = lastControlClassBySystemCL.getMethod("reportLastControl", mocksControlClassBySystemCL);
                reportLastControl.invoke(lastControlClassBySystemCL, new Object[]{null});
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to clean up state", e);
            }
        }
    }
}

