/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.modules.junit4.internal.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.junit.internal.runners.ClassRoadie;
import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.MethodRoadie;
import org.junit.internal.runners.TestClass;
import org.junit.internal.runners.TestMethod;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.powermock.core.classloader.annotations.MockPolicy;
import org.powermock.core.classloader.annotations.PrepareEverythingForTest;
import org.powermock.core.spi.PowerMockTestListener;
import org.powermock.modules.junit4.common.internal.PowerMockJUnitRunnerDelegate;
import org.powermock.modules.junit4.internal.impl.testcaseworkaround.PowerMockJUnit4MethodValidator;
import org.powermock.reflect.Whitebox;
import org.powermock.tests.utils.PowerMockTestNotifier;
import org.powermock.tests.utils.impl.MockPolicyInitializerImpl;
import org.powermock.tests.utils.impl.PowerMockTestNotifierImpl;
import org.powermock.tests.utils.impl.PrepareForTestExtractorImpl;
import org.powermock.tests.utils.impl.StaticConstructorSuppressExtractorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerMockJUnit44RunnerDelegateImpl
extends Runner
implements Filterable,
Sortable,
PowerMockJUnitRunnerDelegate {
    private final List<Method> testMethods;
    private final TestClass testClass;
    private final PowerMockTestNotifier powerMockTestNotifier;

    public PowerMockJUnit44RunnerDelegateImpl(Class<?> klass, String[] methodsToRun, PowerMockTestListener[] listeners) throws InitializationError {
        this.powerMockTestNotifier = new PowerMockTestNotifierImpl(listeners == null ? new PowerMockTestListener[]{} : listeners);
        this.testClass = new TestClass(klass);
        this.testMethods = this.getTestMethods(klass, methodsToRun);
        this.validate();
    }

    public PowerMockJUnit44RunnerDelegateImpl(Class<?> klass, String[] methodsToRun) throws InitializationError {
        this(klass, methodsToRun, null);
    }

    public PowerMockJUnit44RunnerDelegateImpl(Class<?> klass) throws InitializationError {
        this(klass, null);
    }

    protected List<Method> getTestMethods(Class<?> klass, String[] methodsToRun) {
        Method[] methods;
        if (methodsToRun == null || methodsToRun.length == 0) {
            try {
                return (List)Whitebox.invokeMethod((Object)this.testClass, (String)"getTestMethods", (Object[])new Object[0]);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        LinkedList<Method> foundMethods = new LinkedList<Method>();
        for (Method method : methods = klass.getMethods()) {
            for (String methodName : methodsToRun) {
                if (!method.getName().equals(methodName)) continue;
                foundMethods.add(method);
            }
        }
        return foundMethods;
    }

    protected void validate() throws InitializationError {
        if (!TestCase.class.isAssignableFrom(this.testClass.getJavaClass())) {
            PowerMockJUnit4MethodValidator methodValidator = new PowerMockJUnit4MethodValidator(this.testClass);
            methodValidator.validateMethodsForDefaultRunner();
            methodValidator.assertValid();
        }
    }

    public void run(final RunNotifier notifier) {
        new ClassRoadie(notifier, this.testClass, this.getDescription(), new Runnable(){

            public void run() {
                PowerMockJUnit44RunnerDelegateImpl.this.runMethods(notifier);
            }
        }).runProtected();
    }

    protected void runMethods(RunNotifier notifier) {
        StaticConstructorSuppressExtractorImpl staticConstructorSuppressExtractorImpl = new StaticConstructorSuppressExtractorImpl();
        Class<?> testType = this.getTestClass();
        ClassLoader thisClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        if (!thisClassLoader.equals(testType.getClassLoader())) {
            try {
                testType = thisClassLoader.loadClass(testType.getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Internal error in PowerMock", e);
            }
        }
        for (Method method : this.testMethods) {
            if (staticConstructorSuppressExtractorImpl.getTestClasses((AnnotatedElement)method) == null) {
                staticConstructorSuppressExtractorImpl.getTestClasses(testType);
            }
            this.invokeTestMethod(method, notifier);
        }
    }

    public Description getDescription() {
        Description spec = Description.createSuiteDescription((String)this.getName(), (Annotation[])this.classAnnotations());
        List<Method> testMethods = this.testMethods;
        for (Method method : testMethods) {
            spec.addChild(this.methodDescription(method));
        }
        return spec;
    }

    protected Annotation[] classAnnotations() {
        return this.getTestClass().getAnnotations();
    }

    protected String getName() {
        return this.getTestWrappedClass().getName();
    }

    protected Object createTest() throws Exception {
        return this.createTestInstance();
    }

    private Object createTestInstance() throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        TestClass testWrappedClass = this.getTestWrappedClass();
        Constructor constructor = null;
        Class javaClass = testWrappedClass.getJavaClass();
        if (TestCase.class.isAssignableFrom(javaClass)) {
            constructor = TestSuite.getTestConstructor(javaClass.asSubclass(TestCase.class));
            if (constructor.getParameterTypes().length == 1) {
                return constructor.newInstance(javaClass.getSimpleName());
            }
        } else {
            constructor = testWrappedClass.getConstructor();
        }
        return constructor.newInstance(new Object[0]);
    }

    protected void invokeTestMethod(Method method, RunNotifier notifier) {
        Object testInstance;
        Description description = this.methodDescription(method);
        try {
            testInstance = this.createTest();
        }
        catch (InvocationTargetException e) {
            this.testAborted(notifier, description, e.getTargetException());
            return;
        }
        catch (Exception e) {
            this.testAborted(notifier, description, e);
            return;
        }
        boolean extendsFromTestCase = TestCase.class.isAssignableFrom(this.testClass.getJavaClass());
        TestMethod testMethod = this.wrapMethod(method);
        this.createPowerMockRunner(testInstance, testMethod, notifier, description, extendsFromTestCase).run();
    }

    protected PowerMockJUnit44MethodRunner createPowerMockRunner(Object testInstance, TestMethod testMethod, RunNotifier notifier, Description description, boolean extendsFromTestCase) {
        return new PowerMockJUnit44MethodRunner(testInstance, testMethod, notifier, description, extendsFromTestCase);
    }

    private void testAborted(RunNotifier notifier, Description description, Throwable e) {
        notifier.fireTestStarted(description);
        notifier.fireTestFailure(new Failure(description, e));
        notifier.fireTestFinished(description);
    }

    protected TestMethod wrapMethod(Method method) {
        return new TestMethod(method, this.testClass);
    }

    protected String testName(Method method) {
        return method.getName();
    }

    protected Description methodDescription(Method method) {
        return Description.createTestDescription((Class)this.getTestWrappedClass().getJavaClass(), (String)this.testName(method), (Annotation[])this.testAnnotations(method));
    }

    protected Annotation[] testAnnotations(Method method) {
        return method.getAnnotations();
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        Iterator<Method> iter = this.testMethods.iterator();
        while (iter.hasNext()) {
            Method method = iter.next();
            if (filter.shouldRun(this.methodDescription(method))) continue;
            iter.remove();
        }
        if (this.testMethods.isEmpty()) {
            throw new NoTestsRemainException();
        }
    }

    public void sort(final Sorter sorter) {
        Collections.sort(this.testMethods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return sorter.compare(PowerMockJUnit44RunnerDelegateImpl.this.methodDescription(o1), PowerMockJUnit44RunnerDelegateImpl.this.methodDescription(o2));
            }
        });
    }

    protected TestClass getTestWrappedClass() {
        return this.testClass;
    }

    public int getTestCount() {
        return this.testMethods.size();
    }

    public Class<?> getTestClass() {
        return this.testClass.getJavaClass();
    }

    protected class PowerMockJUnit44MethodRunner
    extends MethodRoadie {
        private final Object testInstance;
        private final boolean extendsFromTestCase;
        protected final TestMethod testMethod;

        protected PowerMockJUnit44MethodRunner(Object testInstance, TestMethod method, RunNotifier notifier, Description description, boolean extendsFromTestCase) {
            super(testInstance, method, notifier, description);
            this.testInstance = testInstance;
            this.extendsFromTestCase = extendsFromTestCase;
            this.testMethod = method;
        }

        public void runBeforesThenTestThenAfters(Runnable test) {
            this.executeTest((Method)Whitebox.getInternalState((Object)this.testMethod, Method.class), this.testInstance, test);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeTest(Method method, Object testInstance, Runnable test) {
            ClassLoader classloader = ((Object)((Object)this)).getClass().getClassLoader();
            Thread currentThread = Thread.currentThread();
            ClassLoader originalClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(classloader);
            new MockPolicyInitializerImpl(PowerMockJUnit44RunnerDelegateImpl.this.testClass.getJavaClass()).initialize(classloader);
            PowerMockJUnit44RunnerDelegateImpl.this.powerMockTestNotifier.notifyBeforeTestMethod(testInstance, method, new Object[0]);
            try {
                super.runBeforesThenTestThenAfters(test);
            }
            finally {
                currentThread.setContextClassLoader(originalClassLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void runTestMethod() {
            try {
                try {
                    if (this.extendsFromTestCase) {
                        Whitebox.invokeMethod((Object)this.testInstance, (String)"setUp", (Object[])new Object[0]);
                    }
                    this.testMethod.invoke(this.testInstance);
                    if (((Boolean)Whitebox.invokeMethod((Object)this.testMethod, (String)"expectsException", (Object[])new Object[0])).booleanValue()) {
                        this.addFailure((Throwable)((Object)new AssertionError((Object)("Expected exception: " + this.getExpectedExceptionName(this.testMethod)))));
                    }
                }
                catch (InvocationTargetException e) {
                    this.handleInvocationTargetException(this.testMethod, e);
                }
                catch (Throwable e) {
                    this.addFailure(e);
                }
                finally {
                    if (this.extendsFromTestCase) {
                        try {
                            Whitebox.invokeMethod((Object)this.testInstance, (String)"tearDown", (Object[])new Object[0]);
                        }
                        catch (Throwable tearingDown) {
                            this.addFailure(tearingDown);
                        }
                    }
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("Internal error in PowerMock.", e);
            }
        }

        private void handleInvocationTargetException(TestMethod testMethod, InvocationTargetException e) throws Exception {
            Throwable actual = e.getTargetException();
            while (actual instanceof InvocationTargetException) {
                actual = ((InvocationTargetException)actual).getTargetException();
            }
            this.handleException(testMethod, actual);
        }

        protected void handleException(TestMethod testMethod, Throwable actualFailure) {
            try {
                if (!((Boolean)Whitebox.invokeMethod((Object)testMethod, (String)"expectsException", (Object[])new Object[0])).booleanValue()) {
                    String className = actualFailure.getStackTrace()[0].getClassName();
                    Class testClassAsJavaClass = PowerMockJUnit44RunnerDelegateImpl.this.testClass.getJavaClass();
                    if (!(!(actualFailure instanceof NullPointerException) || testClassAsJavaClass.getName().equals(className) || className.startsWith("java.lang") || className.startsWith("org.powermock") || className.startsWith("org.junit") || new PrepareForTestExtractorImpl().isPrepared((AnnotatedElement)testClassAsJavaClass, className) || testClassAsJavaClass.isAnnotationPresent(PrepareEverythingForTest.class) || new MockPolicyInitializerImpl(testClassAsJavaClass.isAnnotationPresent(MockPolicy.class) ? testClassAsJavaClass.getAnnotation(MockPolicy.class).value() : null).isPrepared(className))) {
                        Whitebox.setInternalState((Object)actualFailure, (String)"detailMessage", (Object)("Perhaps the class " + className + " must be prepared for test?"), Throwable.class);
                    }
                    this.addFailure(actualFailure);
                } else if (((Boolean)Whitebox.invokeMethod((Object)testMethod, (String)"isUnexpected", (Object[])new Object[]{actualFailure})).booleanValue()) {
                    String message = "Unexpected exception, expected<" + this.getExpectedExceptionName(testMethod) + "> but was<" + actualFailure.getClass().getName() + ">";
                    this.addFailure(new Exception(message, actualFailure));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("PowerMock internal error: Should never throw exception at this level", e);
            }
        }

        private String getExpectedExceptionName(TestMethod fTestMethod) throws Exception {
            return ((Class)Whitebox.invokeMethod((Object)fTestMethod, (String)"getExpectedException", (Object[])new Object[0])).getName();
        }
    }
}

