/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.easymock.internal.invocationcontrol;

import java.lang.reflect.Constructor;
import org.easymock.IExpectationSetters;
import org.easymock.classextension.EasyMock;
import org.easymock.internal.MocksControl;
import org.powermock.api.easymock.internal.invocationcontrol.EasyMockMethodInvocationControl;
import org.powermock.api.easymock.internal.invocationcontrol.NewInvocationControlAssertionError;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.NewInvocationControl;
import org.powermock.core.spi.support.InvocationSubstitute;
import org.powermock.reflect.internal.WhiteboxImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewInvocationControlImpl<T>
implements NewInvocationControl<IExpectationSetters<T>> {
    private final InvocationSubstitute<T> substitute;
    private final Class<T> subsitutionType;
    private boolean hasReplayed;
    private boolean hasVerified;

    public NewInvocationControlImpl(InvocationSubstitute<T> substitute, Class<T> type) {
        if (substitute == null) {
            throw new IllegalArgumentException("Internal error: substitute cannot be null.");
        }
        this.subsitutionType = type;
        this.substitute = substitute;
    }

    public Object invoke(Class<?> type, Object[] args, Class<?>[] sig) throws Exception {
        Constructor constructor = WhiteboxImpl.getConstructor(type, (Class[])sig);
        if (constructor.isVarArgs()) {
            args = (Object[])args[0];
        }
        try {
            MocksControl.MockType mockType = ((EasyMockMethodInvocationControl)MockRepository.getInstanceMethodInvocationControl(this.substitute)).getMockType();
            Object result = this.substitute.performSubstitutionLogic(args);
            if (result == null) {
                if (mockType == MocksControl.MockType.NICE) {
                    result = EasyMock.createNiceMock(this.subsitutionType);
                } else {
                    throw new IllegalStateException("Must replay class " + type.getName() + " to get configured expectation.");
                }
            }
            return result;
        }
        catch (AssertionError e) {
            NewInvocationControlAssertionError.throwAssertionErrorForNewSubstitutionFailure(e, type);
            return null;
        }
    }

    public IExpectationSetters<T> expectSubstitutionLogic(Object ... arguments) throws Exception {
        return EasyMock.expect((Object)this.substitute.performSubstitutionLogic(arguments));
    }

    public synchronized Object replay(Object ... mocks) {
        if (!this.hasReplayed) {
            EasyMock.replay((Object[])new Object[]{this.substitute});
            this.hasReplayed = true;
        }
        return null;
    }

    public synchronized Object verify(Object ... mocks) {
        if (!this.hasVerified) {
            EasyMock.verify((Object[])new Object[]{this.substitute});
            this.hasVerified = true;
        }
        return null;
    }

    public synchronized Object reset(Object ... mocks) {
        EasyMock.reset((Object[])new Object[]{this.substitute});
        this.hasReplayed = false;
        this.hasVerified = false;
        return null;
    }
}

