/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import java.util.Arrays;

public enum SSLNegotiation {
    POSTGRES("postgres"),
    DIRECT("direct"),
    TUNNEL("tunnel");

    private final String value;

    private SSLNegotiation(String value) {
        this.value = value;
    }

    public static SSLNegotiation fromValue(String sslNegotiationString) {
        for (SSLNegotiation sslMode : SSLNegotiation.values()) {
            if (!sslMode.value.equalsIgnoreCase(sslNegotiationString) && !sslMode.name().equalsIgnoreCase(sslNegotiationString)) continue;
            return sslMode;
        }
        throw new IllegalArgumentException("Invalid ssl negotiation value: " + sslNegotiationString + ". Supported values are: " + Arrays.toString((Object[])SSLNegotiation.values()));
    }

    public String value() {
        return this.value;
    }
}

