/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.api.PostgresqlConnection;
import io.r2dbc.postgresql.api.PostgresqlStatement;
import io.r2dbc.postgresql.codec.Codec;
import io.r2dbc.postgresql.codec.CodecRegistry;
import io.r2dbc.postgresql.codec.HStoreCodec;
import io.r2dbc.postgresql.codec.PostgisGeometryCodec;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.codec.VectorCodec;
import io.r2dbc.postgresql.codec.VectorFloatCodec;
import io.r2dbc.postgresql.extension.CodecRegistrar;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.util.annotation.Nullable;

public class BuiltinDynamicCodecs
implements CodecRegistrar {
    private static final Object EMPTY = new Object();

    @Override
    public Publisher<Void> register(PostgresqlConnection connection, ByteBufAllocator byteBufAllocator, CodecRegistry registry) {
        PostgresqlStatement statement = this.createQuery(connection);
        return statement.execute().flatMap(it -> it.map((row, rowMetadata) -> {
            int oid = PostgresqlObjectId.toInt((Long)row.get("oid", Long.class));
            int typarray = PostgresqlObjectId.toInt((Long)row.get("typarray", Long.class));
            String typname = (String)row.get("typname", String.class);
            BuiltinCodec lookup = BuiltinCodec.lookup(typname);
            if (lookup.isSupported()) {
                lookup.createCodec(byteBufAllocator, oid, typarray).forEach(registry::addLast);
            }
            return EMPTY;
        })).then();
    }

    private PostgresqlStatement createQuery(PostgresqlConnection connection) {
        return connection.createStatement(String.format("SELECT oid, typname, typarray FROM pg_catalog.pg_type WHERE typname IN (%s)", BuiltinDynamicCodecs.getPlaceholders()));
    }

    private static String getPlaceholders() {
        return Arrays.stream(BuiltinCodec.values()).map(s -> "'" + s.getName() + "'").collect(Collectors.joining(","));
    }

    private static boolean isPresent(ClassLoader classLoader, String name) {
        try {
            Class.forName(name, false, classLoader);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static /* synthetic */ boolean access$100(ClassLoader x0, String x1) {
        return BuiltinDynamicCodecs.isPresent(x0, x1);
    }

    static enum BuiltinCodec {
        HSTORE("hstore"),
        POSTGIS_GEOMETRY("geometry"){
            private final boolean jtsPresent = BuiltinDynamicCodecs.access$100(BuiltinDynamicCodecs.class.getClassLoader(), "org.locationtech.jts.geom.Geometry");

            @Override
            public boolean isSupported() {
                return this.jtsPresent;
            }
        }
        ,
        VECTOR("vector");

        private final String name;

        private BuiltinCodec(String name) {
            this.name = name;
        }

        public Iterable<Codec<?>> createCodec(ByteBufAllocator byteBufAllocator, int oid, int typarray) {
            switch (this) {
                case HSTORE: {
                    return Collections.singletonList(new HStoreCodec(byteBufAllocator, oid));
                }
                case POSTGIS_GEOMETRY: {
                    return Collections.singletonList(new PostgisGeometryCodec(oid));
                }
                case VECTOR: {
                    VectorCodec vectorCodec = new VectorCodec(byteBufAllocator, oid, typarray);
                    return Arrays.asList(vectorCodec, new VectorCodec.VectorArrayCodec(byteBufAllocator, vectorCodec), new VectorFloatCodec(byteBufAllocator, oid));
                }
            }
            throw new UnsupportedOperationException(String.format("Codec %s for OID %d not supported", this.name(), oid));
        }

        public String getName() {
            return this.name;
        }

        boolean isSupported() {
            return true;
        }

        static BuiltinCodec lookup(@Nullable String name) {
            for (BuiltinCodec codec : BuiltinCodec.values()) {
                if (!codec.getName().equalsIgnoreCase(name)) continue;
                return codec;
            }
            throw new IllegalArgumentException(String.format("Cannot determine codec for %s", name));
        }
    }
}

