/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.ArrayCodec;
import io.r2dbc.postgresql.codec.ArrayCodecDelegate;
import io.r2dbc.postgresql.codec.Codec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresTypes;
import io.r2dbc.postgresql.extension.CodecRegistrar;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public class EnumCodec<T extends Enum<T>>
implements Codec<T> {
    private static final Logger logger = Loggers.getLogger(EnumCodec.class);
    private final ByteBufAllocator byteBufAllocator;
    private final Class<T> type;
    private final int oid;

    public EnumCodec(ByteBufAllocator byteBufAllocator, Class<T> type, int oid) {
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        this.type = Assert.requireNonNull(type, "type must not be null");
        this.oid = oid;
    }

    @Override
    public boolean canDecode(int dataType, Format format, Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        return type.isAssignableFrom(this.type) && dataType == this.oid;
    }

    @Override
    public boolean canEncode(Object value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.type.isInstance(value);
    }

    @Override
    public boolean canEncodeNull(Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        return this.type.equals(type);
    }

    @Override
    public T decode(@Nullable ByteBuf buffer, int dataType, Format format, Class<? extends T> type) {
        if (buffer == null) {
            return null;
        }
        return Enum.valueOf(this.type, ByteBufUtils.decode(buffer));
    }

    @Override
    public EncodedParameter encode(Object value) {
        return this.encode(value, this.oid);
    }

    @Override
    public EncodedParameter encode(Object value, int dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return new EncodedParameter(Format.FORMAT_TEXT, dataType, (Publisher<? extends ByteBuf>)Mono.fromSupplier(() -> ByteBufUtils.encode(this.byteBufAllocator, ((Enum)this.type.cast(value)).name())));
    }

    @Override
    public EncodedParameter encodeNull() {
        return this.encodeNull(this.oid);
    }

    private EncodedParameter encodeNull(int dataType) {
        return new EncodedParameter(Format.FORMAT_BINARY, dataType, (Publisher<? extends ByteBuf>)EncodedParameter.NULL_VALUE);
    }

    @Override
    public Class<?> type() {
        return this.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Class<? extends Enum<?>>> mapping = new LinkedHashMap();
        private RegistrationPriority registrationPriority = RegistrationPriority.LAST;

        public Builder withEnum(String name, Class<? extends Enum<?>> enumClass) {
            Assert.requireNotEmpty(name, "Postgres type name must not be null");
            Assert.requireNonNull(enumClass, "Enum class must not be null");
            Assert.isTrue(enumClass.isEnum(), String.format("Enum class %s must be an enum type", enumClass.getName()));
            if (this.mapping.containsKey(name)) {
                throw new IllegalArgumentException(String.format("Builder contains already a mapping for Postgres type %s", name));
            }
            if (this.mapping.containsValue(enumClass)) {
                throw new IllegalArgumentException(String.format("Builder contains already a mapping for Java type %s", enumClass.getName()));
            }
            this.mapping.put(name, enumClass);
            return this;
        }

        public Builder withRegistrationPriority(RegistrationPriority registrationPriority) {
            this.registrationPriority = Assert.requireNonNull(registrationPriority, "registrationPriority must not be null");
            return this;
        }

        public CodecRegistrar build() {
            LinkedHashMap mapping = new LinkedHashMap(this.mapping);
            return (connection, allocator, registry) -> {
                ArrayList missing = new ArrayList(mapping.keySet());
                return PostgresTypes.from(connection).lookupTypes(mapping.keySet()).filter(PostgresTypes.PostgresType::isEnum).doOnNext(it -> {
                    Class enumClass = (Class)mapping.get(it.getName());
                    if (enumClass == null) {
                        logger.warn("Cannot find Java type for enum type '{}' with oid {}. Known types are: {}", new Object[]{it.getName(), it.getOid(), mapping});
                        return;
                    }
                    missing.remove(it.getName());
                    logger.debug("Registering codec for type '{}' with oid {} using Java enum type '{}'", new Object[]{it.getName(), it.getOid(), enumClass.getName()});
                    if (this.registrationPriority == RegistrationPriority.LAST) {
                        if (it.getArrayObjectId() > 0) {
                            registry.addLast(new ArrayCodec(allocator, new EnumArrayCodec(allocator, enumClass, it.getOid(), it.asArrayType()), enumClass));
                        }
                        registry.addLast(new EnumCodec(allocator, enumClass, it.getOid()));
                    } else {
                        if (it.getArrayObjectId() > 0) {
                            registry.addFirst(new ArrayCodec(allocator, new EnumArrayCodec(allocator, enumClass, it.getOid(), it.asArrayType()), enumClass));
                        }
                        registry.addFirst(new EnumCodec(allocator, enumClass, it.getOid()));
                    }
                }).doOnComplete(() -> {
                    if (!missing.isEmpty()) {
                        logger.warn("Could not lookup enum types for: {}", new Object[]{missing});
                    }
                }).then();
            };
        }

        public static enum RegistrationPriority {
            FIRST,
            LAST;

        }
    }

    static class EnumArrayCodec<T extends Enum<T>>
    extends EnumCodec<T>
    implements ArrayCodecDelegate<T> {
        private final PostgresTypeIdentifier arrayType;

        public EnumArrayCodec(ByteBufAllocator byteBufAllocator, Class<T> type, int oid, PostgresTypeIdentifier arrayType) {
            super(byteBufAllocator, type, oid);
            this.arrayType = arrayType;
        }

        @Override
        public String encodeToText(T value) {
            return ((Enum)value).name();
        }

        @Override
        public PostgresTypeIdentifier getArrayDataType() {
            return this.arrayType;
        }

        @Override
        public T decode(ByteBuf buffer, PostgresTypeIdentifier dataType, Format format, Class<? extends T> type) {
            return (T)this.decode(buffer, dataType.getObjectId(), format, (Class)type);
        }
    }
}

