/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.Codec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

abstract class AbstractCodec<T>
implements Codec<T> {
    private final Class<T> type;

    AbstractCodec(Class<T> type) {
        this.type = Assert.requireNonNull(type, "type must not be null");
    }

    @Override
    public boolean canDecode(int dataType, Format format, Class<?> type) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.isValid(dataType) && (type == Object.class || this.isTypeAssignable(type)) && this.doCanDecode(PostgresqlObjectId.valueOf(dataType), format);
    }

    @Override
    public boolean canEncode(Object value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.type.isInstance(value);
    }

    @Override
    public boolean canEncodeNull(Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        return this.type.isAssignableFrom(type);
    }

    @Override
    @Nullable
    public final T decode(@Nullable ByteBuf buffer, int dataType, Format format, Class<? extends T> type) {
        if (buffer == null) {
            return null;
        }
        return this.doDecode(buffer, this.getDataType(dataType), format, type);
    }

    @Override
    public final EncodedParameter encode(Object value) {
        Assert.requireNonNull(value, "value must not be null");
        return this.doEncode(value);
    }

    @Override
    public EncodedParameter encode(Object value, int dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return this.doEncode(value, this.getDataType(dataType));
    }

    PostgresTypeIdentifier getDataType(int dataType) {
        return PostgresqlObjectId.isValid(dataType) ? PostgresqlObjectId.valueOf(dataType) : new SimplePostgresTypeIdentifier(dataType);
    }

    public EncodedParameter encodeNull(int dataType) {
        return new EncodedParameter(Format.FORMAT_BINARY, dataType, (Publisher<? extends ByteBuf>)EncodedParameter.NULL_VALUE);
    }

    @Override
    public Class<?> type() {
        return this.type;
    }

    static EncodedParameter create(Format format, PostgresTypeIdentifier type, Publisher<? extends ByteBuf> value) {
        Assert.requireNonNull(type, "type must not be null");
        return new EncodedParameter(format, type.getObjectId(), value);
    }

    static EncodedParameter create(Format format, PostgresTypeIdentifier type, Supplier<? extends ByteBuf> bufferSupplier) {
        Assert.requireNonNull(type, "type must not be null");
        return AbstractCodec.create(format, type.getObjectId(), bufferSupplier);
    }

    static EncodedParameter create(Format format, int type, Supplier<? extends ByteBuf> bufferSupplier) {
        return new EncodedParameter(format, type, (Publisher<? extends ByteBuf>)Mono.fromSupplier(bufferSupplier));
    }

    static EncodedParameter createNull(Format format, PostgresTypeIdentifier type) {
        return AbstractCodec.create(format, type, EncodedParameter.NULL_VALUE);
    }

    abstract boolean doCanDecode(PostgresqlObjectId var1, Format var2);

    abstract T doDecode(ByteBuf var1, PostgresTypeIdentifier var2, Format var3, Class<? extends T> var4);

    public T decode(ByteBuf buffer, PostgresTypeIdentifier dataType, Format format, Class<? extends T> type) {
        return this.doDecode(buffer, dataType, format, type);
    }

    abstract EncodedParameter doEncode(T var1);

    abstract EncodedParameter doEncode(T var1, PostgresTypeIdentifier var2);

    boolean isTypeAssignable(Class<?> type) {
        Assert.requireNonNull(type, "type must not be null");
        return type.isAssignableFrom(this.type);
    }

    static class SimplePostgresTypeIdentifier
    implements PostgresTypeIdentifier {
        private final int oid;

        public SimplePostgresTypeIdentifier(int oid) {
            this.oid = oid;
        }

        @Override
        public int getObjectId() {
            return this.oid;
        }
    }
}

