/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.EncodedParameter;
import io.r2dbc.postgresql.codec.AbstractCodec;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

abstract class AbstractGeometryCodec<T>
extends AbstractCodec<T> {
    protected final PostgresqlObjectId postgresqlObjectId;
    protected final ByteBufAllocator byteBufAllocator;

    AbstractGeometryCodec(Class<T> type, PostgresqlObjectId postgresqlObjectId, ByteBufAllocator byteBufAllocator) {
        super(type);
        this.postgresqlObjectId = Assert.requireNonNull(postgresqlObjectId, "postgresqlObjectId must not be null");
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(type, "type must not be null");
        Assert.requireNonNull(format, "format must not be null");
        return this.postgresqlObjectId == type;
    }

    @Override
    T doDecode(ByteBuf buffer, PostgresqlObjectId dataType, Format format, Class<? extends T> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        Assert.requireNonNull(type, "type must not be null");
        Assert.requireNonNull(format, "format must not be null");
        if (format == Format.FORMAT_BINARY) {
            return this.doDecodeBinary(buffer);
        }
        return this.doDecodeText(ByteBufUtils.decode(buffer));
    }

    abstract T doDecodeBinary(ByteBuf var1);

    abstract T doDecodeText(String var1);

    @Override
    EncodedParameter doEncode(T value) {
        return this.doEncode(value, this.postgresqlObjectId);
    }

    @Override
    EncodedParameter doEncode(T value, PostgresTypeIdentifier dataType) {
        Assert.requireNonNull(value, "value must not be null");
        return AbstractGeometryCodec.create(Format.FORMAT_BINARY, dataType, () -> this.doEncodeBinary(value));
    }

    abstract ByteBuf doEncodeBinary(T var1);

    @Override
    public EncodedParameter encodeNull() {
        return AbstractGeometryCodec.createNull(Format.FORMAT_BINARY, this.postgresqlObjectId);
    }

    TokenStream getTokenStream(String content) {
        final List<String> tokens = AbstractGeometryCodec.tokenizeTextData(content);
        return new TokenStream(){
            int position = 0;

            @Override
            public boolean hasNext() {
                return tokens.size() > this.position;
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    return (String)tokens.get(this.position++);
                }
                throw new IllegalStateException(String.format("No token available at index %d. Current tokens are: %s", this.position, tokens));
            }

            @Override
            public double nextDouble() {
                return Double.parseDouble(this.next());
            }
        };
    }

    private static List<String> tokenizeTextData(String content) {
        ArrayList<String> tokens = new ArrayList<String>();
        int s = 0;
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c == '(' || c == '[' || c == '<' || c == '{') {
                ++s;
                continue;
            }
            if (c != ',' && c != ')' && c != ']' && c != '>' && c != '}') continue;
            if (s != i) {
                tokens.add(content.substring(s, i));
                s = i + 1;
                continue;
            }
            ++s;
        }
        return tokens;
    }

    static interface TokenStream
    extends Iterator<String> {
        @Override
        public String next();

        public double nextDouble();
    }
}

