/*
 * Decompiled with CFR 0.152.
 */
package play.api.mvc;

import java.io.Serializable;
import java.time.ZonedDateTime;
import play.api.http.HeaderNames$;
import play.api.http.HttpEntity;
import play.api.libs.typedmap.TypedEntry;
import play.api.libs.typedmap.TypedKey;
import play.api.libs.typedmap.TypedMap;
import play.api.mvc.Cookie;
import play.api.mvc.CookieBaker;
import play.api.mvc.CookieHeaderEncoding;
import play.api.mvc.DefaultCookieHeaderEncoding;
import play.api.mvc.DefaultCookieHeaderEncoding$;
import play.api.mvc.DefaultFlashCookieBaker;
import play.api.mvc.DefaultSessionCookieBaker;
import play.api.mvc.DiscardingCookie;
import play.api.mvc.Flash;
import play.api.mvc.Flash$;
import play.api.mvc.RequestHeader;
import play.api.mvc.ResponseHeader;
import play.api.mvc.ResponseHeader$;
import play.api.mvc.Result$;
import play.api.mvc.Session;
import play.api.mvc.Session$;
import play.mvc.Http;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.hashing.MurmurHash3$;

public class Result
implements Product,
Serializable {
    private final ResponseHeader header;
    private final HttpEntity body;
    private final Option newSession;
    private final Option newFlash;
    private final scala.collection.immutable.Seq newCookies;
    private final TypedMap attrs;

    public static Result apply(ResponseHeader responseHeader, HttpEntity httpEntity, Option<Session> option, Option<Flash> option2, scala.collection.immutable.Seq<Cookie> seq, TypedMap typedMap) {
        return Result$.MODULE$.apply(responseHeader, httpEntity, option, option2, seq, typedMap);
    }

    public static Result fromProduct(Product product) {
        return Result$.MODULE$.fromProduct(product);
    }

    public static Result unapply(Result result) {
        return Result$.MODULE$.unapply(result);
    }

    public static void warnFlashingIfNotRedirect(Flash flash, ResponseHeader responseHeader) {
        Result$.MODULE$.warnFlashingIfNotRedirect(flash, responseHeader);
    }

    public static Option<Session> $lessinit$greater$default$3() {
        return Result$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Flash> $lessinit$greater$default$4() {
        return Result$.MODULE$.$lessinit$greater$default$4();
    }

    public static scala.collection.immutable.Seq<Cookie> $lessinit$greater$default$5() {
        return Result$.MODULE$.$lessinit$greater$default$5();
    }

    public static TypedMap $lessinit$greater$default$6() {
        return Result$.MODULE$.$lessinit$greater$default$6();
    }

    public Result(ResponseHeader header, HttpEntity body, Option<Session> newSession, Option<Flash> newFlash, scala.collection.immutable.Seq<Cookie> newCookies, TypedMap attrs) {
        this.header = header;
        this.body = body;
        this.newSession = newSession;
        this.newFlash = newFlash;
        this.newCookies = newCookies;
        this.attrs = attrs;
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, -1995001512, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Result)) return false;
        Result result = (Result)object;
        ResponseHeader responseHeader = this.header();
        ResponseHeader responseHeader2 = result.header();
        if (responseHeader == null) {
            if (responseHeader2 != null) {
                return false;
            }
        } else if (!((Object)responseHeader).equals(responseHeader2)) return false;
        HttpEntity httpEntity = this.body();
        HttpEntity httpEntity2 = result.body();
        if (httpEntity == null) {
            if (httpEntity2 != null) {
                return false;
            }
        } else if (!httpEntity.equals(httpEntity2)) return false;
        Option<Session> option = this.newSession();
        Option<Session> option2 = result.newSession();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Flash> option3 = this.newFlash();
        Option<Flash> option4 = result.newFlash();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        scala.collection.immutable.Seq<Cookie> seq = this.newCookies();
        scala.collection.immutable.Seq<Cookie> seq2 = result.newCookies();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        TypedMap typedMap = this.attrs();
        TypedMap typedMap2 = result.attrs();
        if (typedMap == null) {
            if (typedMap2 != null) {
                return false;
            }
        } else if (!typedMap.equals(typedMap2)) return false;
        if (!result.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof Result;
    }

    public int productArity() {
        return 6;
    }

    public String productPrefix() {
        return "Result";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "header";
            }
            case 1: {
                return "body";
            }
            case 2: {
                return "newSession";
            }
            case 3: {
                return "newFlash";
            }
            case 4: {
                return "newCookies";
            }
            case 5: {
                return "attrs";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ResponseHeader header() {
        return this.header;
    }

    public HttpEntity body() {
        return this.body;
    }

    public Option<Session> newSession() {
        return this.newSession;
    }

    public Option<Flash> newFlash() {
        return this.newFlash;
    }

    public scala.collection.immutable.Seq<Cookie> newCookies() {
        return this.newCookies;
    }

    public TypedMap attrs() {
        return this.attrs;
    }

    public Result withHeaders(scala.collection.immutable.Seq<Tuple2<String, String>> headers) {
        Map map = (Map)this.header().headers().$plus$plus(headers);
        int n = this.header().copy$default$1();
        Option<String> option = this.header().copy$default$3();
        return this.copy(this.header().copy(n, (Map<String, String>)map, option), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public Result withDateHeaders(scala.collection.immutable.Seq<Tuple2<String, ZonedDateTime>> headers) {
        Map map = (Map)this.header().headers().$plus$plus((IterableOnce)headers.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                ZonedDateTime dateTime = (ZonedDateTime)tuple2._2();
                return Tuple2$.MODULE$.apply((Object)name, (Object)dateTime.format(ResponseHeader$.MODULE$.httpDateFormat()));
            }
            throw new MatchError((Object)tuple2);
        }));
        int n = this.header().copy$default$1();
        Option<String> option = this.header().copy$default$3();
        return this.copy(this.header().copy(n, (Map<String, String>)map, option), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public Result discardingHeader(String name) {
        Map map = (Map)this.header().headers().$minus((Object)name);
        int n = this.header().copy$default$1();
        Option<String> option = this.header().copy$default$3();
        return this.copy(this.header().copy(n, (Map<String, String>)map, option), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public Result withCookies(scala.collection.immutable.Seq<Cookie> cookies) {
        scala.collection.immutable.Seq filteredCookies = (scala.collection.immutable.Seq)this.newCookies().filter((Function1 & Serializable)cookie -> !cookies.exists((Function1 & Serializable)_$2 -> {
            String string = _$2.name();
            String string2 = cookie.name();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }));
        if (cookies.isEmpty()) {
            return this;
        }
        scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)filteredCookies.$plus$plus(cookies);
        ResponseHeader responseHeader = this.copy$default$1();
        HttpEntity httpEntity = this.copy$default$2();
        Option<Session> option = this.copy$default$3();
        Option<Flash> option2 = this.copy$default$4();
        TypedMap typedMap = this.copy$default$6();
        return this.copy(responseHeader, httpEntity, option, option2, (scala.collection.immutable.Seq<Cookie>)seq, typedMap);
    }

    public Result discardingCookies(scala.collection.immutable.Seq<DiscardingCookie> cookies) {
        return this.withCookies((scala.collection.immutable.Seq<Cookie>)((scala.collection.immutable.Seq)cookies.map((Function1 & Serializable)_$3 -> _$3.toCookie())));
    }

    public Result withSession(Session session) {
        Some some = Some$.MODULE$.apply((Object)session);
        ResponseHeader responseHeader = this.copy$default$1();
        HttpEntity httpEntity = this.copy$default$2();
        Option<Flash> option = this.copy$default$4();
        scala.collection.immutable.Seq<Cookie> seq = this.copy$default$5();
        TypedMap typedMap = this.copy$default$6();
        return this.copy(responseHeader, httpEntity, (Option<Session>)some, option, seq, typedMap);
    }

    public Result withSession(scala.collection.immutable.Seq<Tuple2<String, String>> session) {
        return this.withSession(Session$.MODULE$.apply((Map<String, String>)session.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    public Result withNewSession() {
        return this.withSession(Session$.MODULE$.apply(Session$.MODULE$.$lessinit$greater$default$1()));
    }

    public Result flashing(Flash flash) {
        Result$.MODULE$.warnFlashingIfNotRedirect(flash, this.header());
        Some some = Some$.MODULE$.apply((Object)flash);
        ResponseHeader responseHeader = this.copy$default$1();
        HttpEntity httpEntity = this.copy$default$2();
        Option<Session> option = this.copy$default$3();
        scala.collection.immutable.Seq<Cookie> seq = this.copy$default$5();
        TypedMap typedMap = this.copy$default$6();
        return this.copy(responseHeader, httpEntity, option, (Option<Flash>)some, seq, typedMap);
    }

    public Result flashing(scala.collection.immutable.Seq<Tuple2<String, String>> values) {
        return this.flashing(Flash$.MODULE$.apply((Map<String, String>)values.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    public Result as(String contentType) {
        HttpEntity httpEntity = this.body().as(contentType);
        ResponseHeader responseHeader = this.copy$default$1();
        Option<Session> option = this.copy$default$3();
        Option<Flash> option2 = this.copy$default$4();
        scala.collection.immutable.Seq<Cookie> seq = this.copy$default$5();
        TypedMap typedMap = this.copy$default$6();
        return this.copy(responseHeader, httpEntity, option, option2, seq, typedMap);
    }

    public Session session(RequestHeader request) {
        return (Session)this.newSession().getOrElse(() -> Result.session$$anonfun$1(request));
    }

    public Result addingToSession(scala.collection.immutable.Seq<Tuple2<String, String>> values, RequestHeader request) {
        return this.withSession(new Session((Map<String, String>)((Map)this.session(request).data().$plus$plus((IterableOnce)values.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())))));
    }

    public Result removingFromSession(scala.collection.immutable.Seq<String> keys, RequestHeader request) {
        return this.withSession(new Session((Map<String, String>)((Map)this.session(request).data().$minus$minus(keys))));
    }

    public String toString() {
        return "Result(" + this.header() + ")";
    }

    public play.mvc.Result asJava() {
        return new play.mvc.Result(this.header().asJava(), this.body().asJava(), (Http.Session)this.newSession().map((Function1 & Serializable)_$4 -> _$4.asJava()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Http.Flash)this.newFlash().map((Function1 & Serializable)_$5 -> _$5.asJava()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.newCookies().map((Function1 & Serializable)_$6 -> _$6.asJava())).asJava(), this.attrs().asJava());
    }

    public Result bakeCookies(CookieHeaderEncoding cookieHeaderEncoding, CookieBaker<Session> sessionBaker, CookieBaker<Flash> flashBaker, boolean requestHasFlash) {
        scala.collection.immutable.Seq<Cookie> setCookieCookies = cookieHeaderEncoding.decodeSetCookieHeader((String)this.header().headers().getOrElse((Object)HeaderNames$.MODULE$.SET_COOKIE(), Result::$anonfun$6));
        Option session = this.newSession().map((Function1 & Serializable)data -> {
            if (data.isEmpty()) {
                return sessionBaker.discard().toCookie();
            }
            return sessionBaker.encodeAsCookie((Session)data);
        });
        Option flash = this.newFlash().map((Function1 & Serializable)data -> {
            if (data.isEmpty()) {
                return flashBaker.discard().toCookie();
            }
            return flashBaker.encodeAsCookie((Flash)data);
        }).orElse(() -> Result.$anonfun$9(requestHasFlash, flashBaker));
        scala.collection.immutable.Seq allCookies = (scala.collection.immutable.Seq)((IterableOps)((IterableOps)setCookieCookies.$plus$plus((IterableOnce)session)).$plus$plus((IterableOnce)flash)).$plus$plus(this.newCookies());
        if (allCookies.isEmpty()) {
            return this;
        }
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.SET_COOKIE());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)cookieHeaderEncoding.encodeSetCookieHeader((scala.collection.immutable.Seq<Cookie>)allCookies));
        return this.withHeaders((scala.collection.immutable.Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public CookieHeaderEncoding bakeCookies$default$1() {
        return new DefaultCookieHeaderEncoding(DefaultCookieHeaderEncoding$.MODULE$.$lessinit$greater$default$1());
    }

    public CookieBaker<Session> bakeCookies$default$2() {
        return new DefaultSessionCookieBaker();
    }

    public CookieBaker<Flash> bakeCookies$default$3() {
        return new DefaultFlashCookieBaker();
    }

    public boolean bakeCookies$default$4() {
        return false;
    }

    public Result withAttrs(TypedMap newAttrs) {
        return new Result(this.header(), this.body(), this.newSession(), this.newFlash(), this.newCookies(), newAttrs);
    }

    public <A> Result addAttr(TypedKey<A> key, A value) {
        return this.withAttrs(this.attrs().updated(key, value));
    }

    public Result addAttrs(TypedEntry<?> e1) {
        return this.withAttrs(this.attrs().updated(e1));
    }

    public Result addAttrs(TypedEntry<?> e1, TypedEntry<?> e2) {
        return this.withAttrs(this.attrs().updated(e1, e2));
    }

    public Result addAttrs(TypedEntry<?> e1, TypedEntry<?> e2, TypedEntry<?> e3) {
        return this.withAttrs(this.attrs().updated(e1, e2, e3));
    }

    public Result addAttrs(scala.collection.immutable.Seq<TypedEntry<?>> entries) {
        return this.withAttrs(this.attrs().updated(entries));
    }

    public Result removeAttr(TypedKey<?> key) {
        return this.withAttrs(this.attrs().removed(key));
    }

    public Result copy(ResponseHeader header, HttpEntity body, Option<Session> newSession, Option<Flash> newFlash, scala.collection.immutable.Seq<Cookie> newCookies, TypedMap attrs) {
        return new Result(header, body, newSession, newFlash, newCookies, attrs);
    }

    public ResponseHeader copy$default$1() {
        return this.header();
    }

    public HttpEntity copy$default$2() {
        return this.body();
    }

    public Option<Session> copy$default$3() {
        return this.newSession();
    }

    public Option<Flash> copy$default$4() {
        return this.newFlash();
    }

    public scala.collection.immutable.Seq<Cookie> copy$default$5() {
        return this.newCookies();
    }

    public TypedMap copy$default$6() {
        return this.attrs();
    }

    public ResponseHeader _1() {
        return this.header();
    }

    public HttpEntity _2() {
        return this.body();
    }

    public Option<Session> _3() {
        return this.newSession();
    }

    public Option<Flash> _4() {
        return this.newFlash();
    }

    public scala.collection.immutable.Seq<Cookie> _5() {
        return this.newCookies();
    }

    public TypedMap _6() {
        return this.attrs();
    }

    private static final Session session$$anonfun$1(RequestHeader request$1) {
        return request$1.session();
    }

    private static final String $anonfun$6() {
        return "";
    }

    private static final Option $anonfun$9(boolean requestHasFlash$1, CookieBaker flashBaker$2) {
        if (requestHasFlash$1) {
            return Some$.MODULE$.apply((Object)flashBaker$2.discard().toCookie());
        }
        return None$.MODULE$;
    }
}

