/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.AssetInfo;
import controllers.AssetsConfiguration;
import controllers.AssetsFinder;
import controllers.AssetsMetadata;
import controllers.DefaultAssetsMetadata$;
import controllers.Execution$;
import controllers.SelfPopulatingMap;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URL;
import play.api.Environment;
import play.api.http.AcceptEncoding;
import play.api.http.AcceptEncoding$;
import play.api.http.FileMimeTypes;
import play.api.mvc.RequestHeader;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.package$;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

@Singleton
public class DefaultAssetsMetadata
implements AssetsMetadata {
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(DefaultAssetsMetadata.class.getDeclaredField("assetInfoCache$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(DefaultAssetsMetadata.class.getDeclaredField("minifiedPathsCache$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DefaultAssetsMetadata.class.getDeclaredField("digestCache$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DefaultAssetsMetadata.class.getDeclaredField("finder$lzy1"));
    public final AssetsConfiguration controllers$DefaultAssetsMetadata$$config;
    private final Function1<String, Option<URL>> resource;
    private final FileMimeTypes fileMimeTypes;
    private volatile Object finder$lzy1;
    private volatile Object digestCache$lzy1;
    private volatile Object minifiedPathsCache$lzy1;
    private volatile Object assetInfoCache$lzy1;

    public DefaultAssetsMetadata(AssetsConfiguration config, Function1<String, Option<URL>> resource, FileMimeTypes fileMimeTypes) {
        this.controllers$DefaultAssetsMetadata$$config = config;
        this.resource = resource;
        this.fileMimeTypes = fileMimeTypes;
    }

    @Inject
    public DefaultAssetsMetadata(Environment env, AssetsConfiguration config, FileMimeTypes fileMimeTypes) {
        this(config, DefaultAssetsMetadata.DefaultAssetsMetadata$superArg$1(env, config, fileMimeTypes), fileMimeTypes);
    }

    @Override
    public AssetsFinder finder() {
        Object object = this.finder$lzy1;
        if (object instanceof AssetsFinder) {
            return (AssetsFinder)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (AssetsFinder)this.finder$lzyINIT1();
    }

    private Object finder$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.finder$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    AssetsFinder assetsFinder = null;
                    try {
                        assetsFinder = new AssetsFinder(this){
                            public static final long OFFSET$0;
                            private volatile Object unprefixed$lzy3;
                            private final String assetsBasePath;
                            private final String assetsUrlPrefix;
                            private final /* synthetic */ DefaultAssetsMetadata $outer;
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                AssetsFinder.$init$(this);
                                this.assetsBasePath = $outer.controllers$DefaultAssetsMetadata$$config.path();
                                this.assetsUrlPrefix = $outer.controllers$DefaultAssetsMetadata$$config.urlPrefix();
                            }

                            static {
                                OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic($anon$4.class.getDeclaredField("unprefixed$lzy3"));
                            }

                            public AssetsFinder unprefixed() {
                                Object object = this.unprefixed$lzy3;
                                if (object instanceof AssetsFinder) {
                                    return (AssetsFinder)object;
                                }
                                if (object == LazyVals.NullValue$.MODULE$) {
                                    return null;
                                }
                                return (AssetsFinder)this.unprefixed$lzyINIT3();
                            }

                            private Object unprefixed$lzyINIT3() {
                                Object object;
                                block8: {
                                    while (true) {
                                        if ((object = this.unprefixed$lzy3) == null) {
                                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                                            Object object2 = null;
                                            AssetsFinder assetsFinder = null;
                                            try {
                                                assetsFinder = AssetsFinder.unprefixed$(this);
                                                object2 = assetsFinder == null ? LazyVals.NullValue$.MODULE$ : assetsFinder;
                                            }
                                            finally {
                                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.unprefixed$lzy3;
                                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                                    waiting.countDown();
                                                }
                                            }
                                            return assetsFinder;
                                        }
                                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                                        if (object == LazyVals.Evaluating$.MODULE$) {
                                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                                            continue;
                                        }
                                        if (!(object instanceof LazyVals.Waiting)) break;
                                        ((LazyVals.Waiting)object).await();
                                    }
                                    return null;
                                }
                                return object;
                            }

                            public String assetsBasePath() {
                                return this.assetsBasePath;
                            }

                            public String assetsUrlPrefix() {
                                return this.assetsUrlPrefix;
                            }

                            public String findAssetPath(String base, String path) {
                                return (String)package$.MODULE$.blocking(() -> this.findAssetPath$$anonfun$1(path, base));
                            }

                            private final String findAssetPath$$anonfun$1(String path$1, String base$1) {
                                String minPath = this.$outer.controllers$DefaultAssetsMetadata$$minifiedPath(path$1);
                                return StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString((String)this.$outer.digest(minPath).fold(() -> DefaultAssetsMetadata.controllers$DefaultAssetsMetadata$$anon$4$$_$findAssetPath$$anonfun$1$$anonfun$1(minPath), arg_0 -> DefaultAssetsMetadata.controllers$DefaultAssetsMetadata$$anon$4$$_$findAssetPath$$anonfun$1$$anonfun$2(minPath, arg_0))), base$1.length() + 1);
                            }

                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{findAssetPath$$anonfun$1(java.lang.String java.lang.String ), controllers$DefaultAssetsMetadata$$anon$4$$_$findAssetPath$$anonfun$1$$anonfun$1(java.lang.String ), controllers$DefaultAssetsMetadata$$anon$4$$_$findAssetPath$$anonfun$1$$anonfun$2(java.lang.String java.lang.String )}, serializedLambda);
                            }
                        };
                        object2 = assetsFinder == null ? LazyVals.NullValue$.MODULE$ : assetsFinder;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.finder$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return assetsFinder;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private TrieMap<String, Option<String>> digestCache() {
        Object object = this.digestCache$lzy1;
        if (object instanceof TrieMap) {
            return (TrieMap)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (TrieMap)this.digestCache$lzyINIT1();
    }

    private Object digestCache$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.digestCache$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    TrieMap trieMap = null;
                    try {
                        trieMap = (TrieMap)TrieMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                        object2 = trieMap == null ? LazyVals.NullValue$.MODULE$ : trieMap;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.digestCache$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return trieMap;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Option<String> digest(String path) {
        return (Option)this.digestCache().getOrElse((Object)path, () -> this.digest$$anonfun$1(path));
    }

    private TrieMap<String, String> minifiedPathsCache() {
        Object object = this.minifiedPathsCache$lzy1;
        if (object instanceof TrieMap) {
            return (TrieMap)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (TrieMap)this.minifiedPathsCache$lzyINIT1();
    }

    private Object minifiedPathsCache$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.minifiedPathsCache$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    TrieMap trieMap = null;
                    try {
                        trieMap = (TrieMap)TrieMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                        object2 = trieMap == null ? LazyVals.NullValue$.MODULE$ : trieMap;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.minifiedPathsCache$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return trieMap;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String controllers$DefaultAssetsMetadata$$minifiedPath(String path) {
        return (String)this.minifiedPathsCache().getOrElse((Object)path, () -> this.minifiedPath$$anonfun$1(path));
    }

    private SelfPopulatingMap<String, AssetInfo> assetInfoCache() {
        Object object = this.assetInfoCache$lzy1;
        if (object instanceof SelfPopulatingMap) {
            return (SelfPopulatingMap)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (SelfPopulatingMap)this.assetInfoCache$lzyINIT1();
    }

    private Object assetInfoCache$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.assetInfoCache$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    SelfPopulatingMap selfPopulatingMap = null;
                    try {
                        selfPopulatingMap = new SelfPopulatingMap();
                        object2 = selfPopulatingMap == null ? LazyVals.NullValue$.MODULE$ : selfPopulatingMap;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.assetInfoCache$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return selfPopulatingMap;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Option<AssetInfo> assetInfoFromResource(String name) {
        return (Option)package$.MODULE$.blocking(() -> this.assetInfoFromResource$$anonfun$1(name));
    }

    private Future<Option<AssetInfo>> assetInfo(String name2) {
        if (this.controllers$DefaultAssetsMetadata$$config.enableCaching()) {
            return this.assetInfoCache().putIfAbsent(name2, (Function1<String, Option<AssetInfo>>)(Function1 & Serializable)name -> this.assetInfoFromResource((String)name), (ExecutionContext)Execution$.MODULE$.trampoline());
        }
        return Future$.MODULE$.successful(this.assetInfoFromResource(name2));
    }

    @Override
    public Future<Option<Tuple2<AssetInfo, AcceptEncoding>>> assetInfoForRequest(RequestHeader request, String name) {
        return this.assetInfo(name).map((Function1 & Serializable)_$5 -> _$5.map((Function1 & Serializable)_$6 -> {
            AssetInfo assetInfo = (AssetInfo)Predef$.MODULE$.ArrowAssoc(_$6);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)assetInfo, (Object)AcceptEncoding$.MODULE$.forRequest(request));
        }), (ExecutionContext)Execution$.MODULE$.trampoline());
    }

    private static Function1<String, Option<URL>> DefaultAssetsMetadata$superArg$1(Environment env, AssetsConfiguration config, FileMimeTypes fileMimeTypes) {
        return (Function1 & Serializable)_$2 -> env.resource(_$2);
    }

    public static final String controllers$DefaultAssetsMetadata$$anon$4$$_$findAssetPath$$anonfun$1$$anonfun$1(String minPath$1) {
        return minPath$1;
    }

    public static final /* synthetic */ String controllers$DefaultAssetsMetadata$$anon$4$$_$findAssetPath$$anonfun$1$$anonfun$2(String minPath$2, String dgst) {
        int lastSep = minPath$2.lastIndexOf("/");
        return StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(minPath$2), lastSep + 1) + dgst + "-" + StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(minPath$2), lastSep + 1);
    }

    private final Option digest$$anonfun$1(String path$2) {
        Option maybeDigestUrl = (Option)this.resource.apply((Object)(path$2 + "." + this.controllers$DefaultAssetsMetadata$$config.digestAlgorithm()));
        Option maybeDigest = maybeDigestUrl.map((Function1 & Serializable)url -> {
            String string;
            try (BufferedSource source = Source$.MODULE$.fromURL(url, Codec$.MODULE$.fallbackSystemCodec());){
                string = source.getLines().mkString().trim();
            }
            return string;
        });
        if (this.controllers$DefaultAssetsMetadata$$config.enableCaching() && maybeDigest.isDefined()) {
            this.digestCache().put((Object)path$2, (Object)maybeDigest);
        }
        return maybeDigest;
    }

    private static final /* synthetic */ boolean $anonfun$5(char _$3) {
        return _$3 != '.';
    }

    private final Option minifiedPathFor$1(String path$4, char delim) {
        String ext = StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(path$4))), (Function1 & Serializable)_$3 -> DefaultAssetsMetadata.$anonfun$5(BoxesRunTime.unboxToChar((Object)_$3)))));
        String noextPath = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(path$4), ext.length() + 1);
        String minPath = noextPath + delim + "min." + ext;
        return ((Option)this.resource.apply((Object)minPath)).map((Function1 & Serializable)_$4 -> minPath);
    }

    private final Option $anonfun$6(String path$9) {
        return this.minifiedPathFor$1(path$9, '-');
    }

    private static final String $anonfun$7(String path$5) {
        return path$5;
    }

    private final String minifiedPath$$anonfun$1(String path$3) {
        String maybeMinifiedPath;
        String string = maybeMinifiedPath = this.controllers$DefaultAssetsMetadata$$config.checkForMinified() ? (String)this.minifiedPathFor$1(path$3, '.').orElse(() -> this.$anonfun$6(path$3)).getOrElse(() -> DefaultAssetsMetadata.$anonfun$7(path$3)) : path$3;
        if (this.controllers$DefaultAssetsMetadata$$config.enableCaching()) {
            this.minifiedPathsCache().put((Object)path$3, (Object)maybeMinifiedPath);
        }
        return maybeMinifiedPath;
    }

    private final Option assetInfoFromResource$$anonfun$1(String name$1) {
        return ((Option)this.resource.apply((Object)name$1)).map((Function1 & Serializable)url -> {
            Seq compressionUrls = (Seq)((IterableOps)this.controllers$DefaultAssetsMetadata$$config.encodings().map((Function1 & Serializable)ae -> Tuple2$.MODULE$.apply((Object)ae.acceptEncoding(), this.resource.apply((Object)ae.forFilename(name$1))))).collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Tuple2 x) {
                    Tuple2 tuple2 = x;
                    if (tuple2 != null) {
                        String string = (String)tuple2._1();
                        Option option = (Option)tuple2._2();
                        if (string != null) {
                            URL uRL;
                            String key = string;
                            if (option instanceof Some && (uRL = (URL)((Some)option).value()) != null) {
                                URL url = uRL;
                                return true;
                            }
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(Tuple2 x, Function1 function1) {
                    Tuple2 tuple2 = x;
                    if (tuple2 != null) {
                        String string = (String)tuple2._1();
                        Option option = (Option)tuple2._2();
                        if (string != null) {
                            URL uRL;
                            String key = string;
                            if (option instanceof Some && (uRL = (URL)((Some)option).value()) != null) {
                                URL url = uRL;
                                return Tuple2$.MODULE$.apply((Object)key, (Object)url);
                            }
                        }
                    }
                    return function1.apply((Object)x);
                }
            });
            return new AssetInfo(name$1, (URL)url, (Seq<Tuple2<String, URL>>)compressionUrls, this.digest(name$1), this.controllers$DefaultAssetsMetadata$$config, this.fileMimeTypes);
        });
    }
}

