/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.crypto;

import jakarta.inject.Inject;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.time.Clock;
import play.api.libs.Codecs$;
import play.api.libs.crypto.CSRFTokenSigner;
import play.api.libs.crypto.CookieSigner;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.runtime.BoxesRunTime;

public class DefaultCSRFTokenSigner
implements CSRFTokenSigner {
    private final CookieSigner signer;
    private final Clock clock;
    private final SecureRandom random;

    @Inject
    public DefaultCSRFTokenSigner(CookieSigner signer, Clock clock) {
        this.signer = signer;
        this.clock = clock;
        this.random = new SecureRandom();
        this.random.nextBytes(new byte[55]);
    }

    @Override
    public String signToken(String token) {
        long nonce = this.clock.millis();
        String joined = nonce + "-" + token;
        return this.signer.sign(joined) + "-" + joined;
    }

    @Override
    public Option<String> extractSignedToken(String token) {
        String string;
        String raw;
        String string2;
        String nonce;
        String string3;
        String signature;
        Object object;
        String[] stringArray = token.split("-", 3);
        if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 3) == 0 && this.isEqual(signature = (string3 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0)), this.signer.sign((nonce = (string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1))) + "-" + (raw = (string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 2)))))) {
            return Some$.MODULE$.apply((Object)raw);
        }
        return None$.MODULE$;
    }

    @Override
    public String generateToken() {
        byte[] bytes = new byte[12];
        this.random.nextBytes(bytes);
        return Codecs$.MODULE$.toHexString(bytes);
    }

    @Override
    public String generateSignedToken() {
        return this.signToken(this.generateToken());
    }

    @Override
    public boolean compareSignedTokens(String tokenA, String tokenB) {
        return BoxesRunTime.unboxToBoolean((Object)this.extractSignedToken(tokenA).flatMap((Function1 & Serializable)rawA -> this.extractSignedToken(tokenB).map((Function1 & Serializable)rawB -> this.isEqual((String)rawA, (String)rawB))).getOrElse(DefaultCSRFTokenSigner::compareSignedTokens$$anonfun$2));
    }

    private boolean isEqual(String a, String b) {
        return MessageDigest.isEqual(a.getBytes(StandardCharsets.UTF_8), b.getBytes(StandardCharsets.UTF_8));
    }

    private static final boolean compareSignedTokens$$anonfun$2() {
        return false;
    }
}

