/*
 * Decompiled with CFR 0.152.
 */
package play.core.j;

import jakarta.inject.Inject;
import play.api.http.HttpConfiguration;
import play.api.inject.Injector;
import play.core.j.JavaContextComponents;
import play.core.j.JavaHandlerComponents;
import play.http.ActionCreator;
import play.mvc.Action;
import play.mvc.BodyParser;
import scala.concurrent.ExecutionContext;

public class DefaultJavaHandlerComponents
implements JavaHandlerComponents {
    private final Injector injector;
    private final ActionCreator actionCreator;
    private final HttpConfiguration httpConfiguration;
    private final ExecutionContext executionContext;
    private final JavaContextComponents contextComponents;

    @Inject
    public DefaultJavaHandlerComponents(Injector injector, ActionCreator actionCreator, HttpConfiguration httpConfiguration, ExecutionContext executionContext, JavaContextComponents contextComponents) {
        this.injector = injector;
        this.actionCreator = actionCreator;
        this.httpConfiguration = httpConfiguration;
        this.executionContext = executionContext;
        this.contextComponents = contextComponents;
    }

    @Override
    public ActionCreator actionCreator() {
        return this.actionCreator;
    }

    @Override
    public HttpConfiguration httpConfiguration() {
        return this.httpConfiguration;
    }

    @Override
    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public JavaContextComponents contextComponents() {
        return this.contextComponents;
    }

    @Override
    public <A extends BodyParser<?>> A getBodyParser(Class<A> parserClass) {
        return (A)((BodyParser)this.injector.instanceOf(parserClass));
    }

    @Override
    public <A extends Action<?>> A getAction(Class<A> actionClass) {
        return (A)((Action)this.injector.instanceOf(actionClass));
    }
}

