/*
 * Decompiled with CFR 0.152.
 */
package play.api.http;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.io.Serializable;
import play.api.Configuration;
import play.api.Environment;
import play.api.http.ActionCompositionConfiguration;
import play.api.http.CookiesConfiguration;
import play.api.http.FileMimeTypesConfiguration;
import play.api.http.FlashConfiguration;
import play.api.http.HttpConfiguration$;
import play.api.http.ParserConfiguration;
import play.api.http.SecretConfiguration;
import play.api.http.SessionConfiguration;
import play.api.mvc.Cookie;
import scala.Option;
import scala.Product;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public class HttpConfiguration
implements Product,
Serializable {
    private final String context;
    private final ParserConfiguration parser;
    private final ActionCompositionConfiguration actionComposition;
    private final CookiesConfiguration cookies;
    private final SessionConfiguration session;
    private final FlashConfiguration flash;
    private final FileMimeTypesConfiguration fileMimeTypes;
    private final SecretConfiguration secret;

    public static HttpConfiguration apply(String string, ParserConfiguration parserConfiguration, ActionCompositionConfiguration actionCompositionConfiguration, CookiesConfiguration cookiesConfiguration, SessionConfiguration sessionConfiguration, FlashConfiguration flashConfiguration, FileMimeTypesConfiguration fileMimeTypesConfiguration, SecretConfiguration secretConfiguration) {
        return HttpConfiguration$.MODULE$.apply(string, parserConfiguration, actionCompositionConfiguration, cookiesConfiguration, sessionConfiguration, flashConfiguration, fileMimeTypesConfiguration, secretConfiguration);
    }

    public static HttpConfiguration createWithDefaults() {
        return HttpConfiguration$.MODULE$.createWithDefaults();
    }

    public static HttpConfiguration current() {
        return HttpConfiguration$.MODULE$.current();
    }

    public static HttpConfiguration fromConfiguration(Configuration configuration, Environment environment) {
        return HttpConfiguration$.MODULE$.fromConfiguration(configuration, environment);
    }

    public static HttpConfiguration fromProduct(Product product) {
        return HttpConfiguration$.MODULE$.fromProduct(product);
    }

    public static Map<String, String> parseFileMimeTypes(Configuration configuration) {
        return HttpConfiguration$.MODULE$.parseFileMimeTypes(configuration);
    }

    public static Option<Cookie.SameSite> parseSameSite(Configuration configuration, String string) {
        return HttpConfiguration$.MODULE$.parseSameSite(configuration, string);
    }

    public static HttpConfiguration unapply(HttpConfiguration httpConfiguration) {
        return HttpConfiguration$.MODULE$.unapply(httpConfiguration);
    }

    public static String $lessinit$greater$default$1() {
        return HttpConfiguration$.MODULE$.$lessinit$greater$default$1();
    }

    public static ParserConfiguration $lessinit$greater$default$2() {
        return HttpConfiguration$.MODULE$.$lessinit$greater$default$2();
    }

    public static ActionCompositionConfiguration $lessinit$greater$default$3() {
        return HttpConfiguration$.MODULE$.$lessinit$greater$default$3();
    }

    public static CookiesConfiguration $lessinit$greater$default$4() {
        return HttpConfiguration$.MODULE$.$lessinit$greater$default$4();
    }

    public static SessionConfiguration $lessinit$greater$default$5() {
        return HttpConfiguration$.MODULE$.$lessinit$greater$default$5();
    }

    public static FlashConfiguration $lessinit$greater$default$6() {
        return HttpConfiguration$.MODULE$.$lessinit$greater$default$6();
    }

    public static FileMimeTypesConfiguration $lessinit$greater$default$7() {
        return HttpConfiguration$.MODULE$.$lessinit$greater$default$7();
    }

    public static SecretConfiguration $lessinit$greater$default$8() {
        return HttpConfiguration$.MODULE$.$lessinit$greater$default$8();
    }

    public HttpConfiguration(String context, ParserConfiguration parser, ActionCompositionConfiguration actionComposition, CookiesConfiguration cookies, SessionConfiguration session, FlashConfiguration flash, FileMimeTypesConfiguration fileMimeTypes, SecretConfiguration secret) {
        this.context = context;
        this.parser = parser;
        this.actionComposition = actionComposition;
        this.cookies = cookies;
        this.session = session;
        this.flash = flash;
        this.fileMimeTypes = fileMimeTypes;
        this.secret = secret;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof HttpConfiguration)) return false;
        HttpConfiguration httpConfiguration = (HttpConfiguration)object;
        String string = this.context();
        String string2 = httpConfiguration.context();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        ParserConfiguration parserConfiguration = this.parser();
        ParserConfiguration parserConfiguration2 = httpConfiguration.parser();
        if (parserConfiguration == null) {
            if (parserConfiguration2 != null) {
                return false;
            }
        } else if (!((Object)parserConfiguration).equals(parserConfiguration2)) return false;
        ActionCompositionConfiguration actionCompositionConfiguration = this.actionComposition();
        ActionCompositionConfiguration actionCompositionConfiguration2 = httpConfiguration.actionComposition();
        if (actionCompositionConfiguration == null) {
            if (actionCompositionConfiguration2 != null) {
                return false;
            }
        } else if (!((Object)actionCompositionConfiguration).equals(actionCompositionConfiguration2)) return false;
        CookiesConfiguration cookiesConfiguration = this.cookies();
        CookiesConfiguration cookiesConfiguration2 = httpConfiguration.cookies();
        if (cookiesConfiguration == null) {
            if (cookiesConfiguration2 != null) {
                return false;
            }
        } else if (!((Object)cookiesConfiguration).equals(cookiesConfiguration2)) return false;
        SessionConfiguration sessionConfiguration = this.session();
        SessionConfiguration sessionConfiguration2 = httpConfiguration.session();
        if (sessionConfiguration == null) {
            if (sessionConfiguration2 != null) {
                return false;
            }
        } else if (!((Object)sessionConfiguration).equals(sessionConfiguration2)) return false;
        FlashConfiguration flashConfiguration = this.flash();
        FlashConfiguration flashConfiguration2 = httpConfiguration.flash();
        if (flashConfiguration == null) {
            if (flashConfiguration2 != null) {
                return false;
            }
        } else if (!((Object)flashConfiguration).equals(flashConfiguration2)) return false;
        FileMimeTypesConfiguration fileMimeTypesConfiguration = this.fileMimeTypes();
        FileMimeTypesConfiguration fileMimeTypesConfiguration2 = httpConfiguration.fileMimeTypes();
        if (fileMimeTypesConfiguration == null) {
            if (fileMimeTypesConfiguration2 != null) {
                return false;
            }
        } else if (!((Object)fileMimeTypesConfiguration).equals(fileMimeTypesConfiguration2)) return false;
        SecretConfiguration secretConfiguration = this.secret();
        SecretConfiguration secretConfiguration2 = httpConfiguration.secret();
        if (secretConfiguration == null) {
            if (secretConfiguration2 != null) {
                return false;
            }
        } else if (!((Object)secretConfiguration).equals(secretConfiguration2)) return false;
        if (!httpConfiguration.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof HttpConfiguration;
    }

    public int productArity() {
        return 8;
    }

    public String productPrefix() {
        return "HttpConfiguration";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return this._7();
            }
            case 7: {
                return this._8();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "context";
            }
            case 1: {
                return "parser";
            }
            case 2: {
                return "actionComposition";
            }
            case 3: {
                return "cookies";
            }
            case 4: {
                return "session";
            }
            case 5: {
                return "flash";
            }
            case 6: {
                return "fileMimeTypes";
            }
            case 7: {
                return "secret";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String context() {
        return this.context;
    }

    public ParserConfiguration parser() {
        return this.parser;
    }

    public ActionCompositionConfiguration actionComposition() {
        return this.actionComposition;
    }

    public CookiesConfiguration cookies() {
        return this.cookies;
    }

    public SessionConfiguration session() {
        return this.session;
    }

    public FlashConfiguration flash() {
        return this.flash;
    }

    public FileMimeTypesConfiguration fileMimeTypes() {
        return this.fileMimeTypes;
    }

    public SecretConfiguration secret() {
        return this.secret;
    }

    public HttpConfiguration copy(String context, ParserConfiguration parser, ActionCompositionConfiguration actionComposition, CookiesConfiguration cookies, SessionConfiguration session, FlashConfiguration flash, FileMimeTypesConfiguration fileMimeTypes, SecretConfiguration secret) {
        return new HttpConfiguration(context, parser, actionComposition, cookies, session, flash, fileMimeTypes, secret);
    }

    public String copy$default$1() {
        return this.context();
    }

    public ParserConfiguration copy$default$2() {
        return this.parser();
    }

    public ActionCompositionConfiguration copy$default$3() {
        return this.actionComposition();
    }

    public CookiesConfiguration copy$default$4() {
        return this.cookies();
    }

    public SessionConfiguration copy$default$5() {
        return this.session();
    }

    public FlashConfiguration copy$default$6() {
        return this.flash();
    }

    public FileMimeTypesConfiguration copy$default$7() {
        return this.fileMimeTypes();
    }

    public SecretConfiguration copy$default$8() {
        return this.secret();
    }

    public String _1() {
        return this.context();
    }

    public ParserConfiguration _2() {
        return this.parser();
    }

    public ActionCompositionConfiguration _3() {
        return this.actionComposition();
    }

    public CookiesConfiguration _4() {
        return this.cookies();
    }

    public SessionConfiguration _5() {
        return this.session();
    }

    public FlashConfiguration _6() {
        return this.flash();
    }

    public FileMimeTypesConfiguration _7() {
        return this.fileMimeTypes();
    }

    public SecretConfiguration _8() {
        return this.secret();
    }

    @Singleton
    public static class ActionCompositionConfigurationProvider
    implements Provider<ActionCompositionConfiguration> {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ActionCompositionConfigurationProvider.class.getDeclaredField("get$lzy6"));
        private HttpConfiguration conf;
        private volatile Object get$lzy6;

        @Inject
        public ActionCompositionConfigurationProvider(HttpConfiguration conf) {
            this.conf = conf;
        }

        public ActionCompositionConfiguration get() {
            Object object = this.get$lzy6;
            if (object instanceof ActionCompositionConfiguration) {
                return (ActionCompositionConfiguration)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (ActionCompositionConfiguration)this.get$lzyINIT6();
        }

        private Object get$lzyINIT6() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.get$lzy6) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        ActionCompositionConfiguration actionCompositionConfiguration = null;
                        try {
                            actionCompositionConfiguration = this.conf.actionComposition();
                            object2 = actionCompositionConfiguration == null ? LazyVals.NullValue$.MODULE$ : actionCompositionConfiguration;
                            this.conf = null;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.get$lzy6;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return actionCompositionConfiguration;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }
    }

    @Singleton
    public static class CookiesConfigurationProvider
    implements Provider<CookiesConfiguration> {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CookiesConfigurationProvider.class.getDeclaredField("get$lzy3"));
        private HttpConfiguration conf;
        private volatile Object get$lzy3;

        @Inject
        public CookiesConfigurationProvider(HttpConfiguration conf) {
            this.conf = conf;
        }

        public CookiesConfiguration get() {
            Object object = this.get$lzy3;
            if (object instanceof CookiesConfiguration) {
                return (CookiesConfiguration)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (CookiesConfiguration)this.get$lzyINIT3();
        }

        private Object get$lzyINIT3() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.get$lzy3) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        CookiesConfiguration cookiesConfiguration = null;
                        try {
                            cookiesConfiguration = this.conf.cookies();
                            object2 = cookiesConfiguration == null ? LazyVals.NullValue$.MODULE$ : cookiesConfiguration;
                            this.conf = null;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.get$lzy3;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return cookiesConfiguration;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }
    }

    @Singleton
    public static class FileMimeTypesConfigurationProvider
    implements Provider<FileMimeTypesConfiguration> {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(FileMimeTypesConfigurationProvider.class.getDeclaredField("get$lzy7"));
        private HttpConfiguration conf;
        private volatile Object get$lzy7;

        @Inject
        public FileMimeTypesConfigurationProvider(HttpConfiguration conf) {
            this.conf = conf;
        }

        public FileMimeTypesConfiguration get() {
            Object object = this.get$lzy7;
            if (object instanceof FileMimeTypesConfiguration) {
                return (FileMimeTypesConfiguration)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (FileMimeTypesConfiguration)this.get$lzyINIT7();
        }

        private Object get$lzyINIT7() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.get$lzy7) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        FileMimeTypesConfiguration fileMimeTypesConfiguration = null;
                        try {
                            fileMimeTypesConfiguration = this.conf.fileMimeTypes();
                            object2 = fileMimeTypesConfiguration == null ? LazyVals.NullValue$.MODULE$ : fileMimeTypesConfiguration;
                            this.conf = null;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.get$lzy7;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return fileMimeTypesConfiguration;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }
    }

    @Singleton
    public static class FlashConfigurationProvider
    implements Provider<FlashConfiguration> {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(FlashConfigurationProvider.class.getDeclaredField("get$lzy5"));
        private HttpConfiguration conf;
        private volatile Object get$lzy5;

        @Inject
        public FlashConfigurationProvider(HttpConfiguration conf) {
            this.conf = conf;
        }

        public FlashConfiguration get() {
            Object object = this.get$lzy5;
            if (object instanceof FlashConfiguration) {
                return (FlashConfiguration)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (FlashConfiguration)this.get$lzyINIT5();
        }

        private Object get$lzyINIT5() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.get$lzy5) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        FlashConfiguration flashConfiguration = null;
                        try {
                            flashConfiguration = this.conf.flash();
                            object2 = flashConfiguration == null ? LazyVals.NullValue$.MODULE$ : flashConfiguration;
                            this.conf = null;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.get$lzy5;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return flashConfiguration;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }
    }

    @Singleton
    public static class HttpConfigurationProvider
    implements Provider<HttpConfiguration> {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(HttpConfigurationProvider.class.getDeclaredField("get$lzy1"));
        private Configuration configuration;
        private Environment environment;
        private volatile Object get$lzy1;

        @Inject
        public HttpConfigurationProvider(Configuration configuration, Environment environment) {
            this.configuration = configuration;
            this.environment = environment;
        }

        public HttpConfiguration get() {
            Object object = this.get$lzy1;
            if (object instanceof HttpConfiguration) {
                return (HttpConfiguration)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (HttpConfiguration)this.get$lzyINIT1();
        }

        private Object get$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.get$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        HttpConfiguration httpConfiguration = null;
                        try {
                            httpConfiguration = HttpConfiguration$.MODULE$.fromConfiguration(this.configuration, this.environment);
                            object2 = httpConfiguration == null ? LazyVals.NullValue$.MODULE$ : httpConfiguration;
                            this.configuration = null;
                            this.environment = null;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.get$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return httpConfiguration;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }
    }

    @Singleton
    public static class ParserConfigurationProvider
    implements Provider<ParserConfiguration> {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ParserConfigurationProvider.class.getDeclaredField("get$lzy2"));
        private HttpConfiguration conf;
        private volatile Object get$lzy2;

        @Inject
        public ParserConfigurationProvider(HttpConfiguration conf) {
            this.conf = conf;
        }

        public ParserConfiguration get() {
            Object object = this.get$lzy2;
            if (object instanceof ParserConfiguration) {
                return (ParserConfiguration)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (ParserConfiguration)this.get$lzyINIT2();
        }

        private Object get$lzyINIT2() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.get$lzy2) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        ParserConfiguration parserConfiguration = null;
                        try {
                            parserConfiguration = this.conf.parser();
                            object2 = parserConfiguration == null ? LazyVals.NullValue$.MODULE$ : parserConfiguration;
                            this.conf = null;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.get$lzy2;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return parserConfiguration;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }
    }

    @Singleton
    public static class SecretConfigurationProvider
    implements Provider<SecretConfiguration> {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SecretConfigurationProvider.class.getDeclaredField("get$lzy8"));
        private HttpConfiguration conf;
        private volatile Object get$lzy8;

        @Inject
        public SecretConfigurationProvider(HttpConfiguration conf) {
            this.conf = conf;
        }

        public SecretConfiguration get() {
            Object object = this.get$lzy8;
            if (object instanceof SecretConfiguration) {
                return (SecretConfiguration)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (SecretConfiguration)this.get$lzyINIT8();
        }

        private Object get$lzyINIT8() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.get$lzy8) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        SecretConfiguration secretConfiguration = null;
                        try {
                            secretConfiguration = this.conf.secret();
                            object2 = secretConfiguration == null ? LazyVals.NullValue$.MODULE$ : secretConfiguration;
                            this.conf = null;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.get$lzy8;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return secretConfiguration;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }
    }

    @Singleton
    public static class SessionConfigurationProvider
    implements Provider<SessionConfiguration> {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SessionConfigurationProvider.class.getDeclaredField("get$lzy4"));
        private HttpConfiguration conf;
        private volatile Object get$lzy4;

        @Inject
        public SessionConfigurationProvider(HttpConfiguration conf) {
            this.conf = conf;
        }

        public SessionConfiguration get() {
            Object object = this.get$lzy4;
            if (object instanceof SessionConfiguration) {
                return (SessionConfiguration)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (SessionConfiguration)this.get$lzyINIT4();
        }

        private Object get$lzyINIT4() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.get$lzy4) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        SessionConfiguration sessionConfiguration = null;
                        try {
                            sessionConfiguration = this.conf.session();
                            object2 = sessionConfiguration == null ? LazyVals.NullValue$.MODULE$ : sessionConfiguration;
                            this.conf = null;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.get$lzy4;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return sessionConfiguration;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }
    }
}

