/*
 * Decompiled with CFR 0.152.
 */
package play.api.mvc.request;

import javax.inject.Inject;
import play.api.http.HeaderNames$;
import play.api.http.HttpConfiguration;
import play.api.libs.crypto.CookieSignerProvider;
import play.api.libs.typedmap.TypedEntry;
import play.api.libs.typedmap.TypedMap;
import play.api.mvc.CookieHeaderEncoding;
import play.api.mvc.Cookies;
import play.api.mvc.DefaultCookieHeaderEncoding;
import play.api.mvc.DefaultFlashCookieBaker;
import play.api.mvc.DefaultSessionCookieBaker;
import play.api.mvc.Flash;
import play.api.mvc.FlashCookieBaker;
import play.api.mvc.Headers;
import play.api.mvc.RequestHeader;
import play.api.mvc.RequestHeaderImpl;
import play.api.mvc.Session;
import play.api.mvc.SessionCookieBaker;
import play.api.mvc.request.Cell;
import play.api.mvc.request.LazyCell;
import play.api.mvc.request.RemoteConnection;
import play.api.mvc.request.RequestAttrKey$;
import play.api.mvc.request.RequestFactory;
import play.api.mvc.request.RequestTarget;
import play.core.system.RequestIdProvider$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class DefaultRequestFactory
implements RequestFactory {
    private final CookieHeaderEncoding cookieHeaderEncoding;
    private final SessionCookieBaker sessionBaker;
    private final FlashCookieBaker flashBaker;

    @Inject
    public DefaultRequestFactory(CookieHeaderEncoding cookieHeaderEncoding, SessionCookieBaker sessionBaker, FlashCookieBaker flashBaker) {
        this.cookieHeaderEncoding = cookieHeaderEncoding;
        this.sessionBaker = sessionBaker;
        this.flashBaker = flashBaker;
    }

    public CookieHeaderEncoding cookieHeaderEncoding() {
        return this.cookieHeaderEncoding;
    }

    public SessionCookieBaker sessionBaker() {
        return this.sessionBaker;
    }

    public FlashCookieBaker flashBaker() {
        return this.flashBaker;
    }

    public DefaultRequestFactory(HttpConfiguration config) {
        this(new DefaultCookieHeaderEncoding(config.cookies()), new DefaultSessionCookieBaker(config.session(), config.secret(), new CookieSignerProvider(config.secret()).get()), new DefaultFlashCookieBaker(config.flash(), config.secret(), new CookieSignerProvider(config.secret()).get()));
    }

    @Override
    public RequestHeader createRequestHeader(RemoteConnection connection, String method, RequestTarget target, String version, Headers headers, TypedMap attrs) {
        long requestId = BoxesRunTime.unboxToLong((Object)attrs.get(RequestAttrKey$.MODULE$.Id()).getOrElse(DefaultRequestFactory::$anonfun$1));
        LazyCell<Cookies> cookieCell = new LazyCell<Cookies>(headers, this){
            private final Headers headers$1;
            private final /* synthetic */ DefaultRequestFactory $outer;
            {
                this.headers$1 = headers$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Cookies emptyMarker() {
                return null;
            }

            public Cookies create() {
                return this.$outer.cookieHeaderEncoding().fromCookieHeader(this.headers$1.get(HeaderNames$.MODULE$.COOKIE()));
            }
        };
        LazyCell<Session> sessionCell = new LazyCell<Session>((LazyCell)cookieCell, this){
            private final LazyCell cookieCell$1;
            private final /* synthetic */ DefaultRequestFactory $outer;
            {
                this.cookieCell$1 = cookieCell$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Session emptyMarker() {
                return null;
            }

            public Session create() {
                return (Session)this.$outer.sessionBaker().decodeFromCookie(((Cookies)this.cookieCell$1.value()).get(this.$outer.sessionBaker().COOKIE_NAME()));
            }
        };
        LazyCell<Flash> flashCell = new LazyCell<Flash>((LazyCell)cookieCell, this){
            private final LazyCell cookieCell$2;
            private final /* synthetic */ DefaultRequestFactory $outer;
            {
                this.cookieCell$2 = cookieCell$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Flash emptyMarker() {
                return null;
            }

            public Flash create() {
                return (Flash)this.$outer.flashBaker().decodeFromCookie(((Cookies)this.cookieCell$2.value()).get(this.$outer.flashBaker().COOKIE_NAME()));
            }
        };
        TypedMap updatedAttrMap = attrs.updated((Seq<TypedEntry<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TypedEntry[]{RequestAttrKey$.MODULE$.Id().$minus$greater(BoxesRunTime.boxToLong((long)requestId)), RequestAttrKey$.MODULE$.Cookies().$minus$greater((Cell<Cookies>)cookieCell), RequestAttrKey$.MODULE$.Session().$minus$greater((Cell<Session>)sessionCell), RequestAttrKey$.MODULE$.Flash().$minus$greater((Cell<Flash>)flashCell)}));
        return new RequestHeaderImpl(connection, method, target, version, headers, updatedAttrMap);
    }

    private static final long $anonfun$1() {
        return RequestIdProvider$.MODULE$.freshId();
    }
}

