/*
 * Decompiled with CFR 0.152.
 */
package play.api.mvc;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import play.api.libs.Files;
import play.api.libs.Files$TemporaryFile$;
import play.api.mvc.RawBuffer$;
import play.utils.PlayIO$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public class RawBuffer
implements Product,
Serializable {
    private final long memoryThreshold;
    private final Files.TemporaryFileCreator temporaryFileCreator;
    private final ByteString initialData;
    private volatile ByteString inMemory;
    private volatile Files.TemporaryFile backedByTemporaryFile;
    private volatile OutputStream outStream;

    public static RawBuffer apply(long l, Files.TemporaryFileCreator temporaryFileCreator, ByteString byteString) {
        return RawBuffer$.MODULE$.apply(l, temporaryFileCreator, byteString);
    }

    public static RawBuffer fromProduct(Product product) {
        return RawBuffer$.MODULE$.fromProduct(product);
    }

    public static RawBuffer unapply(RawBuffer rawBuffer) {
        return RawBuffer$.MODULE$.unapply(rawBuffer);
    }

    public static ByteString $lessinit$greater$default$3() {
        return RawBuffer$.MODULE$.$lessinit$greater$default$3();
    }

    public RawBuffer(long memoryThreshold, Files.TemporaryFileCreator temporaryFileCreator, ByteString initialData) {
        this.memoryThreshold = memoryThreshold;
        this.temporaryFileCreator = temporaryFileCreator;
        this.initialData = initialData;
        this.inMemory = initialData;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)-394028440);
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.memoryThreshold()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.temporaryFileCreator()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.initialData()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof RawBuffer)) return false;
        RawBuffer rawBuffer = (RawBuffer)object;
        if (this.memoryThreshold() != rawBuffer.memoryThreshold()) return false;
        Files.TemporaryFileCreator temporaryFileCreator = this.temporaryFileCreator();
        Files.TemporaryFileCreator temporaryFileCreator2 = rawBuffer.temporaryFileCreator();
        if (temporaryFileCreator == null) {
            if (temporaryFileCreator2 != null) {
                return false;
            }
        } else if (!temporaryFileCreator.equals(temporaryFileCreator2)) return false;
        ByteString byteString = this.initialData();
        ByteString byteString2 = rawBuffer.initialData();
        if (byteString == null) {
            if (byteString2 != null) {
                return false;
            }
        } else if (!byteString.equals(byteString2)) return false;
        if (!rawBuffer.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof RawBuffer;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "RawBuffer";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return BoxesRunTime.boxToLong((long)this._1());
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "memoryThreshold";
            }
            case 1: {
                return "temporaryFileCreator";
            }
            case 2: {
                return "initialData";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public long memoryThreshold() {
        return this.memoryThreshold;
    }

    public Files.TemporaryFileCreator temporaryFileCreator() {
        return this.temporaryFileCreator;
    }

    public ByteString initialData() {
        return this.initialData;
    }

    public void push(ByteString chunk) {
        if (this.inMemory != null) {
            if ((long)(chunk.length() + this.inMemory.size()) > this.memoryThreshold()) {
                this.backToTemporaryFile();
                this.outStream.write((byte[])chunk.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
                return;
            }
            this.inMemory = this.inMemory.$plus$plus(chunk);
            return;
        }
        this.outStream.write((byte[])chunk.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    public void close() {
        if (this.outStream != null) {
            this.outStream.close();
            return;
        }
    }

    public void backToTemporaryFile() {
        this.backedByTemporaryFile = this.temporaryFileCreator().create("requestBody", "asRaw");
        this.outStream = Files.newOutputStream(Files$TemporaryFile$.MODULE$.temporaryFileToPath(this.backedByTemporaryFile), new OpenOption[0]);
        this.outStream.write((byte[])this.inMemory.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
        this.inMemory = null;
    }

    public long size() {
        if (this.inMemory != null) {
            return Int$.MODULE$.int2long(this.inMemory.size());
        }
        return Files.size(Files$TemporaryFile$.MODULE$.temporaryFileToPath(this.backedByTemporaryFile));
    }

    public Option<ByteString> asBytes(long maxLength) {
        if (this.size() <= maxLength) {
            return Some$.MODULE$.apply((Object)(this.inMemory != null ? this.inMemory : ByteString$.MODULE$.apply(PlayIO$.MODULE$.readFile(this.backedByTemporaryFile.path()))));
        }
        return None$.MODULE$;
    }

    public long asBytes$default$1() {
        return this.memoryThreshold();
    }

    public File asFile() {
        if (this.inMemory != null) {
            this.backToTemporaryFile();
            this.close();
        }
        return Files$TemporaryFile$.MODULE$.temporaryFileToFile(this.backedByTemporaryFile);
    }

    public String toString() {
        Object inMemorySize = Option$.MODULE$.apply((Object)this.inMemory).map((Function1 & Serializable)_$5 -> _$5.size()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return "RawBuffer(inMemory=" + inMemorySize + ", backedByTemporaryFile=" + this.backedByTemporaryFile + ")";
    }

    public RawBuffer copy(long memoryThreshold, Files.TemporaryFileCreator temporaryFileCreator, ByteString initialData) {
        return new RawBuffer(memoryThreshold, temporaryFileCreator, initialData);
    }

    public long copy$default$1() {
        return this.memoryThreshold();
    }

    public Files.TemporaryFileCreator copy$default$2() {
        return this.temporaryFileCreator();
    }

    public ByteString copy$default$3() {
        return this.initialData();
    }

    public long _1() {
        return this.memoryThreshold();
    }

    public Files.TemporaryFileCreator _2() {
        return this.temporaryFileCreator();
    }

    public ByteString _3() {
        return this.initialData();
    }
}

