/*
 * Decompiled with CFR 0.152.
 */
package play.api;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.LoggerFactory;
import play.api.Logger;
import play.api.Mode;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class Logger$
implements Serializable {
    private static final org.slf4j.Logger log;
    private static Option<Mode> _mode;
    private static final AtomicInteger _appsRunning;
    public static final Logger$ MODULE$;

    private Logger$() {
    }

    static {
        MODULE$ = new Logger$();
        log = LoggerFactory.getLogger(MODULE$.getClass());
        _mode = None$.MODULE$;
        _appsRunning = new AtomicInteger(0);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Logger$.class);
    }

    public Option<Mode> applicationMode() {
        return _mode;
    }

    public void setApplicationMode(Mode mode) {
        int appsRunning = _appsRunning.incrementAndGet();
        this.applicationMode().foreach((Function1)(JProcedure1 & Serializable)currentMode -> {
            Mode mode = currentMode;
            Mode mode2 = mode;
            if (mode == null ? mode2 != null : !mode.equals(mode2)) {
                log.warn("Setting logging mode to " + mode + " when it was previously set to " + currentMode);
                log.warn("There are currently " + appsRunning + " applications running.");
                return;
            }
        });
        _mode = Some$.MODULE$.apply((Object)mode);
    }

    public void unsetApplicationMode() {
        int appsRunning = _appsRunning.decrementAndGet();
        if (appsRunning == 0) {
            _mode = None$.MODULE$;
            return;
        }
        if (appsRunning < 0) {
            log.warn("Cannot unset application mode because none was previously set");
            _mode = None$.MODULE$;
            _appsRunning.incrementAndGet();
            return;
        }
    }

    public Logger apply(String name) {
        return new Logger(LoggerFactory.getLogger((String)name));
    }

    public Logger apply(Class<?> clazz) {
        return new Logger(LoggerFactory.getLogger((String)StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(clazz.getName()), "$")));
    }
}

