/*
 * Decompiled with CFR 0.152.
 */
package play.libs;

import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import play.api.libs.json.jackson.JacksonJson$;

public class Json {
    public static ObjectMapper mapper() {
        return JacksonJson$.MODULE$.get().mapper();
    }

    private static String generateJson(Object object, boolean bl, boolean bl2) {
        try {
            ObjectWriter objectWriter = Json.mapper().writer();
            if (bl) {
                objectWriter = objectWriter.with(SerializationFeature.INDENT_OUTPUT);
            }
            if (bl2) {
                objectWriter = objectWriter.with((FormatFeature)JsonWriteFeature.ESCAPE_NON_ASCII);
            }
            return objectWriter.writeValueAsString(object);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static JsonNode toJson(Object object) {
        try {
            return Json.mapper().valueToTree(object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static <A> A fromJson(JsonNode jsonNode, Class<A> clazz) {
        try {
            return (A)Json.mapper().treeToValue((TreeNode)jsonNode, clazz);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static ObjectNode newObject() {
        return Json.mapper().createObjectNode();
    }

    public static ArrayNode newArray() {
        return Json.mapper().createArrayNode();
    }

    public static String stringify(JsonNode jsonNode) {
        return Json.generateJson(jsonNode, false, false);
    }

    public static String asciiStringify(JsonNode jsonNode) {
        return Json.generateJson(jsonNode, false, true);
    }

    public static String prettyPrint(JsonNode jsonNode) {
        return Json.generateJson(jsonNode, true, false);
    }

    public static JsonNode parse(String string) {
        try {
            return Json.mapper().readTree(string);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static JsonNode parse(InputStream inputStream) {
        try {
            return Json.mapper().readTree(inputStream);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static JsonNode parse(byte[] byArray) {
        try {
            return Json.mapper().readTree(byArray);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static void setObjectMapper(ObjectMapper objectMapper) {
        JacksonJson$.MODULE$.get().setObjectMapper(objectMapper);
    }
}

