/*
 * Decompiled with CFR 0.152.
 */
package play.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import scala.Function0;
import scala.io.Codec;

public final class PlayIO$ {
    public static final PlayIO$ MODULE$ = new PlayIO$();
    private static final Logger logger = Logger$.MODULE$.apply(MODULE$.getClass());

    private Logger logger() {
        return logger;
    }

    private byte[] readStream(InputStream stream) {
        byte[] byArray;
        try {
            byte[] buffer = new byte[8192];
            int len = stream.read(buffer);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while (len != -1) {
                out.write(buffer, 0, len);
                len = stream.read(buffer);
            }
            byArray = out.toByteArray();
        }
        finally {
            this.closeQuietly(stream);
        }
        return byArray;
    }

    public byte[] readFile(Path file) {
        return this.readStream(Files.newInputStream(file, new OpenOption[0]));
    }

    public String readStreamAsString(InputStream stream, Codec codec) {
        return new String(this.readStream(stream), codec.name());
    }

    public String readUrlAsString(URL url, Codec codec) {
        return this.readStreamAsString(url.openStream(), codec);
    }

    public String readFileAsString(Path file, Codec codec) {
        return this.readStreamAsString(Files.newInputStream(file, new OpenOption[0]), codec);
    }

    public void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            this.logger().warn((Function0<String>)(Function0 & Serializable)() -> "Error closing stream", (Function0<Throwable>)(Function0 & Serializable)() -> e, MarkerContext$.MODULE$.NoMarker());
        }
    }

    private PlayIO$() {
    }
}

