/*
 * Decompiled with CFR 0.152.
 */
package play.http;

import com.typesafe.config.Config;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.Environment;
import play.api.OptionalSourceMapper;
import play.api.UsefulException;
import play.api.http.HttpErrorHandlerExceptions;
import play.api.routing.Router;
import play.http.HttpErrorHandler;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;
import play.twirl.api.Content;
import scala.Option;
import scala.Some;
import views.html.defaultpages.badRequest;
import views.html.defaultpages.devError;
import views.html.defaultpages.devNotFound;
import views.html.defaultpages.error;
import views.html.defaultpages.notFound;
import views.html.defaultpages.unauthorized;

public class DefaultHttpErrorHandler
implements HttpErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHttpErrorHandler.class);
    private final Option<String> playEditor;
    private final Environment environment;
    private final OptionalSourceMapper sourceMapper;
    private final Provider<Router> routes;

    @Inject
    public DefaultHttpErrorHandler(Config config, Environment environment, OptionalSourceMapper optionalSourceMapper, Provider<Router> provider) {
        this.environment = environment;
        this.sourceMapper = optionalSourceMapper;
        this.routes = provider;
        this.playEditor = Option.apply(config.hasPath("play.editor") ? config.getString("play.editor") : null);
    }

    @Override
    public CompletionStage<Result> onClientError(Http.RequestHeader requestHeader, int n, String string) {
        if (n == 400) {
            return this.onBadRequest(requestHeader, string);
        }
        if (n == 403) {
            return this.onForbidden(requestHeader, string);
        }
        if (n == 404) {
            return this.onNotFound(requestHeader, string);
        }
        if (n >= 400 && n < 500) {
            return this.onOtherClientError(requestHeader, n, string);
        }
        throw new IllegalArgumentException("onClientError invoked with non client error status code " + n + ": " + string);
    }

    protected CompletionStage<Result> onBadRequest(Http.RequestHeader requestHeader, String string) {
        return CompletableFuture.completedFuture(Results.badRequest((Content)badRequest.render(requestHeader.method(), requestHeader.uri(), string, requestHeader.asScala())));
    }

    protected CompletionStage<Result> onForbidden(Http.RequestHeader requestHeader, String string) {
        return CompletableFuture.completedFuture(Results.forbidden((Content)unauthorized.render(requestHeader.asScala())));
    }

    protected CompletionStage<Result> onNotFound(Http.RequestHeader requestHeader, String string) {
        if (this.environment.isProd()) {
            return CompletableFuture.completedFuture(Results.notFound((Content)notFound.render(requestHeader.method(), requestHeader.uri(), requestHeader.asScala())));
        }
        return CompletableFuture.completedFuture(Results.notFound((Content)devNotFound.render(requestHeader.method(), requestHeader.uri(), (Option<Router>)Some.apply((Object)((Router)this.routes.get())), requestHeader.asScala())));
    }

    protected CompletionStage<Result> onOtherClientError(Http.RequestHeader requestHeader, int n, String string) {
        return CompletableFuture.completedFuture(Results.status(n, (Content)badRequest.render(requestHeader.method(), requestHeader.uri(), string, requestHeader.asScala())));
    }

    @Override
    public CompletionStage<Result> onServerError(Http.RequestHeader requestHeader, Throwable throwable) {
        try {
            UsefulException usefulException = this.throwableToUsefulException(throwable);
            this.logServerError(requestHeader, usefulException);
            switch (this.environment.mode()) {
                case PROD: {
                    return this.onProdServerError(requestHeader, usefulException);
                }
            }
            return this.onDevServerError(requestHeader, usefulException);
        }
        catch (Exception exception) {
            logger.error("Error while handling error", (Throwable)exception);
            return CompletableFuture.completedFuture(Results.internalServerError(this.fatalErrorMessage(requestHeader, exception)));
        }
    }

    protected String fatalErrorMessage(Http.RequestHeader requestHeader, Throwable throwable) {
        return "";
    }

    protected void logServerError(Http.RequestHeader requestHeader, UsefulException usefulException) {
        logger.error(String.format("\n\n! @%s - Internal server error, for (%s) [%s] ->\n", usefulException.id, requestHeader.method(), requestHeader.uri()), (Throwable)usefulException);
    }

    protected final UsefulException throwableToUsefulException(Throwable throwable) {
        return HttpErrorHandlerExceptions.throwableToUsefulException(this.sourceMapper.sourceMapper(), this.environment.isProd(), throwable);
    }

    protected CompletionStage<Result> onDevServerError(Http.RequestHeader requestHeader, UsefulException usefulException) {
        return CompletableFuture.completedFuture(Results.internalServerError((Content)devError.render(this.playEditor, usefulException, requestHeader.asScala())));
    }

    protected CompletionStage<Result> onProdServerError(Http.RequestHeader requestHeader, UsefulException usefulException) {
        return CompletableFuture.completedFuture(Results.internalServerError((Content)error.render(usefulException, requestHeader.asScala())));
    }
}

