/*
 * Decompiled with CFR 0.152.
 */
package play.api.http;

import jakarta.inject.Inject;
import java.io.Serializable;
import play.api.Environment;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.Mode;
import play.api.OptionalSourceMapper;
import play.api.UsefulException;
import play.api.http.HttpErrorHandler;
import play.api.http.HttpErrorHandlerExceptions$;
import play.api.http.JsonHttpErrorHandler$;
import play.api.http.Status$;
import play.api.http.Writeable$;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsObject$;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import play.core.SourceMapper;
import play.libs.exception.ExceptionUtils;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005e\u0001B\n\u0015\u0001mA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!)Q\u0007\u0001C\u0001m!9!\b\u0001b\u0001\n\u0013Y\u0004BB \u0001A\u0003%A\bC\u00036\u0001\u0011\u0005\u0001\tC\u0003Q\u0001\u00115\u0011\u000bC\u0003a\u0001\u0011\u0005\u0013\rC\u0004\u0002\f\u0001!\t%!\u0004\t\u000f\u0005\u001d\u0002\u0001\"\u0005\u0002*!9\u0011Q\u0007\u0001\u0005\u0012\u0005]\u0002bBA\"\u0001\u0011E\u0011Q\t\u0005\b\u0003\u0013\u0002A\u0011CA&\u0011\u001d\t\t\u0006\u0001C\t\u0003':\u0011\"!\u0019\u0015\u0003\u0003E\t!a\u0019\u0007\u0011M!\u0012\u0011!E\u0001\u0003KBa!\u000e\t\u0005\u0002\u0005\u001d\u0004\"CA5!E\u0005I\u0011AA6\u0005QQ5o\u001c8IiR\u0004XI\u001d:pe\"\u000bg\u000e\u001a7fe*\u0011QCF\u0001\u0005QR$\bO\u0003\u0002\u00181\u0005\u0019\u0011\r]5\u000b\u0003e\tA\u0001\u001d7bs\u000e\u00011c\u0001\u0001\u001dEA\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\u0004\"a\t\u0013\u000e\u0003QI!!\n\u000b\u0003!!#H\u000f]#se>\u0014\b*\u00198eY\u0016\u0014\u0018aC3om&\u0014xN\\7f]R\u0004\"\u0001K\u0015\u000e\u0003YI!A\u000b\f\u0003\u0017\u0015sg/\u001b:p]6,g\u000e^\u0001\rg>,(oY3NCB\u0004XM\u001d\t\u0004;5z\u0013B\u0001\u0018\u001f\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001gM\u0007\u0002c)\u0011!\u0007G\u0001\u0005G>\u0014X-\u0003\u00025c\ta1k\\;sG\u0016l\u0015\r\u001d9fe\u00061A(\u001b8jiz\"2a\u000e\u001d:!\t\u0019\u0003\u0001C\u0003'\u0007\u0001\u0007q\u0005C\u0004,\u0007A\u0005\t\u0019\u0001\u0017\u0002\r1|wmZ3s+\u0005a\u0004C\u0001\u0015>\u0013\tqdC\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!)\r9\u0014I\u0011\u0005\u0006M\u0019\u0001\ra\n\u0005\u0006\u0007\u001a\u0001\r\u0001R\u0001\u0015_B$\u0018n\u001c8bYN{WO]2f\u001b\u0006\u0004\b/\u001a:\u0011\u0005!*\u0015B\u0001$\u0017\u0005Qy\u0005\u000f^5p]\u0006d7k\\;sG\u0016l\u0015\r\u001d9fe\"\u0012a\u0001\u0013\t\u0003\u0013:k\u0011A\u0013\u0006\u0003\u00172\u000ba!\u001b8kK\u000e$(\"A'\u0002\u000f)\f7.\u0019:uC&\u0011qJ\u0013\u0002\u0007\u0013:TWm\u0019;\u0002\u000b\u0015\u0014(o\u001c:\u0015\u0005IS\u0006CA*Y\u001b\u0005!&BA+W\u0003\u0011Q7o\u001c8\u000b\u0005]3\u0012\u0001\u00027jENL!!\u0017+\u0003\u0011)\u001bxJ\u00196fGRDQaW\u0004A\u0002I\u000bqaY8oi\u0016tG\u000f\u000b\u0002\b;B\u0011QDX\u0005\u0003?z\u0011a!\u001b8mS:,\u0017!D8o\u00072LWM\u001c;FeJ|'\u000f\u0006\u0003c]ND\bcA2gQ6\tAM\u0003\u0002f=\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u001d$'A\u0002$viV\u0014X\r\u0005\u0002jY6\t!N\u0003\u0002l-\u0005\u0019QN^2\n\u00055T'A\u0002*fgVdG\u000fC\u0003p\u0011\u0001\u0007\u0001/A\u0004sKF,Xm\u001d;\u0011\u0005%\f\u0018B\u0001:k\u00055\u0011V-];fgRDU-\u00193fe\")A\u000f\u0003a\u0001k\u0006Q1\u000f^1ukN\u001cu\u000eZ3\u0011\u0005u1\u0018BA<\u001f\u0005\rIe\u000e\u001e\u0005\bs\"\u0001\n\u00111\u0001{\u0003\u001diWm]:bO\u0016\u00042a_A\u0003\u001d\ra\u0018\u0011\u0001\t\u0003{zi\u0011A \u0006\u0003\u007fj\ta\u0001\u0010:p_Rt\u0014bAA\u0002=\u00051\u0001K]3eK\u001aLA!a\u0002\u0002\n\t11\u000b\u001e:j]\u001eT1!a\u0001\u001f\u00035ygnU3sm\u0016\u0014XI\u001d:peR)!-a\u0004\u0002\u0012!)q.\u0003a\u0001a\"9\u00111C\u0005A\u0002\u0005U\u0011!C3yG\u0016\u0004H/[8o!\u0011\t9\"!\t\u000f\t\u0005e\u0011Q\u0004\b\u0004{\u0006m\u0011\"A\u0010\n\u0007\u0005}a$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0012Q\u0005\u0002\n)\"\u0014xn^1cY\u0016T1!a\b\u001f\u000391\u0017\r^1m\u000bJ\u0014xN\u001d&t_:$b!a\u000b\u00022\u0005M\u0002cA*\u0002.%\u0019\u0011q\u0006+\u0003\u000f)\u001bh+\u00197vK\")qN\u0003a\u0001a\"9\u00111\u0003\u0006A\u0002\u0005U\u0011A\u00043fmN+'O^3s\u000bJ\u0014xN\u001d\u000b\u0007\u0003W\tI$a\u000f\t\u000b=\\\u0001\u0019\u00019\t\u000f\u0005M1\u00021\u0001\u0002>A\u0019\u0001&a\u0010\n\u0007\u0005\u0005cCA\bVg\u00164W\u000f\\#yG\u0016\u0004H/[8o\u0003u1wN]7bi\u0012+goU3sm\u0016\u0014XI\u001d:pe\u0016C8-\u001a9uS>tG\u0003BA\u0016\u0003\u000fBq!a\u0005\r\u0001\u0004\t)\"A\bqe>$7+\u001a:wKJ,%O]8s)\u0019\tY#!\u0014\u0002P!)q.\u0004a\u0001a\"9\u00111C\u0007A\u0002\u0005u\u0012A\u00047pON+'O^3s\u000bJ\u0014xN\u001d\u000b\u0007\u0003+\nY&!\u0018\u0011\u0007u\t9&C\u0002\u0002Zy\u0011A!\u00168ji\")qN\u0004a\u0001a\"9\u0011q\f\bA\u0002\u0005u\u0012aD;tK\u001a,H.\u0012=dKB$\u0018n\u001c8\u0002))\u001bxN\u001c%uiB,%O]8s\u0011\u0006tG\r\\3s!\t\u0019\u0003c\u0005\u0002\u00119Q\u0011\u00111M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u00055$f\u0001\u0017\u0002p-\u0012\u0011\u0011\u000f\t\u0005\u0003g\ni(\u0004\u0002\u0002v)!\u0011qOA=\u0003%)hn\u00195fG.,GMC\u0002\u0002|y\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty(!\u001e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class JsonHttpErrorHandler
implements HttpErrorHandler {
    private final Environment environment;
    private final Option<SourceMapper> sourceMapper;
    private final Logger logger;

    public static Option<SourceMapper> $lessinit$greater$default$2() {
        return JsonHttpErrorHandler$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String onClientError$default$3() {
        return HttpErrorHandler.onClientError$default$3$(this);
    }

    private Logger logger() {
        return this.logger;
    }

    private final JsObject error(JsObject content) {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)content, (Writes)JsObject$.MODULE$.writes()))}));
    }

    @Override
    public Future<Result> onClientError(RequestHeader request, int statusCode, String message) {
        if (Status$.MODULE$.isClientError(statusCode)) {
            return Future$.MODULE$.successful((Object)Results$.MODULE$.Status(statusCode).apply(this.error(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requestId"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToLong((long)request.id()), (Writes)Writes$.MODULE$.LongWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)message, (Writes)Writes$.MODULE$.StringWrites()))}))), Writeable$.MODULE$.writeableOf_JsValue()));
        }
        throw new IllegalArgumentException("onClientError invoked with non client error status code " + statusCode + ": " + message);
    }

    @Override
    public Future<Result> onServerError(RequestHeader request, Throwable exception) {
        Future future;
        try {
            Mode mode = this.environment.mode();
            Mode.Prod$ prod$ = Mode.Prod$.MODULE$;
            boolean isProd = !(mode != null ? !mode.equals(prod$) : prod$ != null);
            UsefulException usefulException = HttpErrorHandlerExceptions$.MODULE$.throwableToUsefulException(this.sourceMapper, isProd, exception);
            this.logServerError(request, usefulException);
            future = Future$.MODULE$.successful((Object)Results$.MODULE$.InternalServerError().apply(isProd ? this.prodServerError(request, usefulException) : this.devServerError(request, usefulException), Writeable$.MODULE$.writeableOf_JsValue()));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logger().error((Function0<String>)(Function0 & Serializable)() -> "Error while handling error", (Function0<Throwable>)(Function0 & Serializable)() -> throwable2, MarkerContext$.MODULE$.NoMarker());
                future = Future$.MODULE$.successful((Object)Results$.MODULE$.InternalServerError().apply(this.fatalErrorJson(request, throwable2), Writeable$.MODULE$.writeableOf_JsValue()));
            }
            throw throwable;
        }
        return future;
    }

    public JsValue fatalErrorJson(RequestHeader request, Throwable exception) {
        return Json$.MODULE$.obj((Seq)Nil$.MODULE$);
    }

    public JsValue devServerError(RequestHeader request, UsefulException exception) {
        return this.error(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)exception.id, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requestId"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToLong((long)request.id()), (Writes)Writes$.MODULE$.LongWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"title"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)exception.title, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"description"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)exception.description, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stacktrace"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)this.formatDevServerErrorException(exception.cause), Writes$.MODULE$.jsValueWrites()))})), (Writes)JsObject$.MODULE$.writes()))})));
    }

    public JsValue formatDevServerErrorException(Throwable exception) {
        return new JsArray((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ExceptionUtils.getStackFrames(exception)), (Function1 & Serializable)s -> new JsString(s.trim()), ClassTag$.MODULE$.apply(JsString.class))));
    }

    public JsValue prodServerError(RequestHeader request, UsefulException exception) {
        return this.error(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)exception.id, (Writes)Writes$.MODULE$.StringWrites()))})));
    }

    public void logServerError(RequestHeader request, UsefulException usefulException) {
        this.logger().error((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |\n        |! @%s - Internal server error, for (%s) [%s] ->\n        | "))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{usefulException$2.id, request.method(), request.uri()})), (Function0<Throwable>)(Function0 & Serializable)() -> usefulException, MarkerContext$.MODULE$.NoMarker());
    }

    public JsonHttpErrorHandler(Environment environment, Option<SourceMapper> sourceMapper) {
        this.environment = environment;
        this.sourceMapper = sourceMapper;
        this.logger = Logger$.MODULE$.apply(this.getClass());
    }

    @Inject
    public JsonHttpErrorHandler(Environment environment, OptionalSourceMapper optionalSourceMapper) {
        this(environment, optionalSourceMapper.sourceMapper());
    }
}

