/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.inject.Inject;
import java.io.File;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.pekko.japi.function.Creator;
import org.apache.pekko.japi.function.Function2;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.javadsl.Flow;
import org.apache.pekko.stream.javadsl.Sink;
import org.apache.pekko.stream.javadsl.StreamConverters;
import org.apache.pekko.util.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import play.api.http.HttpConfiguration;
import play.api.http.JavaHttpErrorHandlerDelegate;
import play.api.libs.Files;
import play.api.mvc.BodyParserUtils;
import play.api.mvc.BodyParsers$;
import play.api.mvc.MaxSizeNotExceeded$;
import play.api.mvc.MultipartFormData;
import play.api.mvc.PlayBodyParsers;
import play.api.mvc.RawBuffer;
import play.core.j.JavaHttpErrorHandlerAdapter;
import play.core.j.JavaParsers;
import play.core.parsers.FormUrlEncodedParser;
import play.core.parsers.Multipart;
import play.http.HttpErrorHandler;
import play.libs.F;
import play.libs.Files;
import play.libs.Scala;
import play.libs.XML;
import play.libs.streams.Accumulator;
import play.mvc.BodyParsers;
import play.mvc.Http;
import play.mvc.Result;
import scala.Function1;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.jdk.javaapi.CollectionConverters;
import scala.jdk.javaapi.FutureConverters;
import scala.runtime.AbstractFunction1;

public interface BodyParser<A> {
    public Accumulator<ByteString, F.Either<Result, A>> apply(Http.RequestHeader var1);

    public static <A extends B, B> BodyParser<B> widen(BodyParser<A> bodyParser) {
        return bodyParser;
    }

    public static abstract class DelegatingMultipartFormDataBodyParser<A>
    extends MaxLengthBodyParser<Http.MultipartFormData<A>> {
        private final Materializer materializer;
        private final long maxMemoryBufferSize;
        private final play.api.mvc.BodyParser<play.api.mvc.MultipartFormData<A>> delegate;
        private final play.api.http.HttpErrorHandler errorHandler;

        @Deprecated
        public DelegatingMultipartFormDataBodyParser(Materializer materializer, long l, play.api.http.HttpErrorHandler httpErrorHandler) {
            super(l, new JavaHttpErrorHandlerDelegate(httpErrorHandler));
            this.materializer = materializer;
            this.errorHandler = httpErrorHandler;
            this.maxMemoryBufferSize = 102400L;
            this.delegate = this.multipartParser(false);
        }

        @Deprecated
        public DelegatingMultipartFormDataBodyParser(Materializer materializer, long l, long l2, HttpErrorHandler httpErrorHandler) {
            this(materializer, l, l2, false, httpErrorHandler);
        }

        public DelegatingMultipartFormDataBodyParser(Materializer materializer, long l, long l2, boolean bl, HttpErrorHandler httpErrorHandler) {
            super(l2, httpErrorHandler);
            this.materializer = materializer;
            this.maxMemoryBufferSize = l;
            this.errorHandler = new JavaHttpErrorHandlerAdapter(httpErrorHandler);
            this.delegate = this.multipartParser(bl);
        }

        public abstract Function<Multipart.FileInfo, Accumulator<ByteString, Http.MultipartFormData.FilePart<A>>> createFilePartHandler();

        private play.api.mvc.BodyParser<play.api.mvc.MultipartFormData<A>> multipartParser(boolean bl) {
            ScalaFilePartHandler scalaFilePartHandler = new ScalaFilePartHandler();
            return Multipart.multipartParser(this.maxMemoryBufferSize, bl, scalaFilePartHandler, this.errorHandler, this.materializer);
        }

        @Override
        public Accumulator<ByteString, F.Either<Result, Http.MultipartFormData<A>>> apply1(Http.RequestHeader requestHeader) {
            return ((play.api.libs.streams.Accumulator)this.delegate.apply(requestHeader.asScala())).asJava().map(either -> {
                if (either.isLeft()) {
                    return F.Either.Left(((play.api.mvc.Result)either.swap().toOption().get()).asJava());
                }
                play.api.mvc.MultipartFormData multipartFormData = (play.api.mvc.MultipartFormData)either.toOption().get();
                return F.Either.Right(new DelegatingMultipartFormData(multipartFormData));
            }, JavaParsers.trampoline());
        }

        private class ScalaFilePartHandler
        extends AbstractFunction1<Multipart.FileInfo, play.api.libs.streams.Accumulator<ByteString, MultipartFormData.FilePart<A>>> {
            private ScalaFilePartHandler() {
            }

            public play.api.libs.streams.Accumulator<ByteString, MultipartFormData.FilePart<A>> apply(Multipart.FileInfo fileInfo) {
                return DelegatingMultipartFormDataBodyParser.this.createFilePartHandler().apply(fileInfo).asScala().map((Function1)new JavaFilePartToScalaFilePart(), (ExecutionContext)DelegatingMultipartFormDataBodyParser.this.materializer.executionContext());
            }
        }

        private class DelegatingMultipartFormData
        extends Http.MultipartFormData<A> {
            private final play.api.mvc.MultipartFormData<A> scalaFormData;

            DelegatingMultipartFormData(play.api.mvc.MultipartFormData<A> multipartFormData) {
                this.scalaFormData = multipartFormData;
            }

            @Override
            public Map<String, String[]> asFormUrlEncoded() {
                return CollectionConverters.asJava(this.scalaFormData.asFormUrlEncoded()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Scala.asArray(String.class, (Seq)entry.getValue())));
            }

            @Override
            public List<Http.MultipartFormData.FilePart<A>> getFiles() {
                return CollectionConverters.asJava(this.scalaFormData.files()).stream().map(MultipartFormData.FilePart::asJava).collect(Collectors.toList());
            }

            @Override
            public boolean isEmpty() {
                return this.scalaFormData.isEmpty();
            }
        }

        private class JavaFilePartToScalaFilePart
        extends AbstractFunction1<Http.MultipartFormData.FilePart<A>, MultipartFormData.FilePart<A>> {
            private JavaFilePartToScalaFilePart() {
            }

            public MultipartFormData.FilePart<A> apply(Http.MultipartFormData.FilePart<A> filePart) {
                return filePart.asScala();
            }
        }
    }

    public static abstract class CompletableBodyParser<A>
    implements BodyParser<A> {
        private final CompletionStage<BodyParser<A>> underlying;
        private final Materializer materializer;

        public CompletableBodyParser(CompletionStage<BodyParser<A>> completionStage, Materializer materializer) {
            this.underlying = completionStage;
            this.materializer = materializer;
        }

        @Override
        public Accumulator<ByteString, F.Either<Result, A>> apply(Http.RequestHeader requestHeader) {
            CompletionStage<Accumulator> completionStage = this.underlying.thenApply(bodyParser -> bodyParser.apply(requestHeader));
            return Accumulator.flatten(completionStage, (Materializer)this.materializer);
        }
    }

    public static abstract class DelegatingBodyParser<A, B>
    implements BodyParser<A> {
        private final play.api.mvc.BodyParser<B> delegate;
        private final Function<B, A> transform;

        public DelegatingBodyParser(play.api.mvc.BodyParser<B> bodyParser, Function<B, A> function) {
            this.delegate = bodyParser;
            this.transform = function;
        }

        @Override
        public Accumulator<ByteString, F.Either<Result, A>> apply(Http.RequestHeader requestHeader) {
            return BodyParsers.delegate(this.delegate, this.transform, requestHeader);
        }
    }

    public static abstract class BufferingBodyParser<A>
    extends MaxLengthBodyParser<A> {
        private final HttpErrorHandler errorHandler;
        private final String errorMessage;

        protected BufferingBodyParser(long l, HttpErrorHandler httpErrorHandler, String string) {
            super(l, httpErrorHandler);
            this.errorHandler = httpErrorHandler;
            this.errorMessage = string;
        }

        protected BufferingBodyParser(HttpConfiguration httpConfiguration, HttpErrorHandler httpErrorHandler, String string) {
            this(httpConfiguration.parser().maxMemoryBuffer(), httpErrorHandler, string);
        }

        @Override
        protected final Accumulator<ByteString, F.Either<Result, A>> apply1(Http.RequestHeader requestHeader) {
            Accumulator accumulator = Accumulator.strict(optional -> CompletableFuture.completedFuture(optional.orElse(ByteString.emptyByteString())), (Sink)Sink.fold((Object)ByteString.emptyByteString(), ByteString::concat));
            Accumulator accumulator2 = accumulator.mapFuture(byteString -> {
                try {
                    return CompletableFuture.completedFuture(F.Either.Right(this.parse(requestHeader, (ByteString)byteString)));
                }
                catch (Exception exception) {
                    return this.errorHandler.onClientError(requestHeader, 400, this.errorMessage + ": " + exception.getMessage()).thenApply(F.Either::Left);
                }
            }, JavaParsers.trampoline());
            return accumulator2;
        }

        protected abstract A parse(Http.RequestHeader var1, ByteString var2) throws Exception;
    }

    public static abstract class MaxLengthBodyParser<A>
    implements BodyParser<A> {
        private final long maxLength;
        private final HttpErrorHandler errorHandler;

        protected MaxLengthBodyParser(long l, HttpErrorHandler httpErrorHandler) {
            this.maxLength = l;
            this.errorHandler = httpErrorHandler;
        }

        CompletionStage<F.Either<Result, A>> requestEntityTooLarge(Http.RequestHeader requestHeader) {
            return this.errorHandler.onClientError(requestHeader, 413, "Request entity too large").thenApply(F.Either::Left);
        }

        @Override
        public Accumulator<ByteString, F.Either<Result, A>> apply(Http.RequestHeader requestHeader) {
            Flow flow = Flow.fromGraph(BodyParsers$.MODULE$.takeUpTo(this.maxLength));
            if (BodyParserUtils.contentLengthHeaderExceedsMaxLength(requestHeader.asScala(), this.maxLength)) {
                return Accumulator.done(this.requestEntityTooLarge(requestHeader));
            }
            Sink sink = this.apply1(requestHeader).toSink();
            return Accumulator.fromSink((Sink)flow.toMat((Graph)sink, (Function2 & Serializable)(future, completionStage) -> FutureConverters.asJava((Future)future).thenCompose(maxSizeStatus -> {
                if (maxSizeStatus instanceof MaxSizeNotExceeded$) {
                    return completionStage;
                }
                return this.requestEntityTooLarge(requestHeader);
            })));
        }

        protected abstract Accumulator<ByteString, F.Either<Result, A>> apply1(Http.RequestHeader var1);
    }

    public static class Empty
    implements BodyParser<Optional<Void>> {
        @Override
        public Accumulator<ByteString, F.Either<Result, Optional<Void>>> apply(Http.RequestHeader requestHeader) {
            return Accumulator.done(F.Either.Right(Optional.empty()));
        }
    }

    public static class MultipartFormData
    extends DelegatingBodyParser<Http.MultipartFormData<Files.TemporaryFile>, play.api.mvc.MultipartFormData<Files.TemporaryFile>> {
        @Inject
        public MultipartFormData(PlayBodyParsers playBodyParsers) {
            super(playBodyParsers.multipartFormData(), JavaParsers::toJavaMultipartFormData);
        }

        public MultipartFormData(PlayBodyParsers playBodyParsers, boolean bl) {
            super(playBodyParsers.multipartFormData(bl), JavaParsers::toJavaMultipartFormData);
        }

        public MultipartFormData(PlayBodyParsers playBodyParsers, long l) {
            super(playBodyParsers.multipartFormData(l), JavaParsers::toJavaMultipartFormData);
        }

        public MultipartFormData(PlayBodyParsers playBodyParsers, long l, boolean bl) {
            super(playBodyParsers.multipartFormData(l, bl), JavaParsers::toJavaMultipartFormData);
        }
    }

    public static class FormUrlEncoded
    extends BufferingBodyParser<Map<String, String[]>> {
        private final HttpErrorHandler errorHandler;

        public FormUrlEncoded(long l, HttpErrorHandler httpErrorHandler) {
            super(l, httpErrorHandler, "Error parsing form");
            this.errorHandler = httpErrorHandler;
        }

        @Inject
        public FormUrlEncoded(HttpConfiguration httpConfiguration, HttpErrorHandler httpErrorHandler) {
            super(httpConfiguration, httpErrorHandler, "Error parsing form");
            this.errorHandler = httpErrorHandler;
        }

        @Override
        public Accumulator<ByteString, F.Either<Result, Map<String, String[]>>> apply(Http.RequestHeader requestHeader2) {
            return BodyParsers.validateContentType(this.errorHandler, requestHeader2, "Expected application/x-www-form-urlencoded", string -> string.equalsIgnoreCase("application/x-www-form-urlencoded"), requestHeader -> super.apply((Http.RequestHeader)requestHeader));
        }

        @Override
        protected Map<String, String[]> parse(Http.RequestHeader requestHeader, ByteString byteString) throws Exception {
            String string = requestHeader.charset().orElse("UTF-8");
            String string2 = byteString.decodeString("UTF-8");
            return FormUrlEncodedParser.parseAsJavaArrayValues(string2, string);
        }
    }

    public static class TemporaryFile
    extends MaxLengthBodyParser<Files.TemporaryFile> {
        private final Files.TemporaryFileCreator temporaryFileCreator;
        private final Materializer materializer;

        public TemporaryFile(long l, Files.TemporaryFileCreator temporaryFileCreator, HttpErrorHandler httpErrorHandler, Materializer materializer) {
            super(l, httpErrorHandler);
            this.temporaryFileCreator = temporaryFileCreator;
            this.materializer = materializer;
        }

        @Inject
        public TemporaryFile(HttpConfiguration httpConfiguration, Files.TemporaryFileCreator temporaryFileCreator, HttpErrorHandler httpErrorHandler, Materializer materializer) {
            this(httpConfiguration.parser().maxDiskBuffer(), temporaryFileCreator, httpErrorHandler, materializer);
        }

        @Override
        protected Accumulator<ByteString, F.Either<Result, Files.TemporaryFile>> apply1(Http.RequestHeader requestHeader) {
            if (BodyParserUtils.contentLengthHeaderExceedsMaxLength(requestHeader.asScala(), this.maxLength)) {
                return Accumulator.done(this.requestEntityTooLarge(requestHeader));
            }
            Files.TemporaryFile temporaryFile = this.temporaryFileCreator.create("requestBody", "asTemporaryFile");
            return Accumulator.fromSink((Sink)StreamConverters.fromOutputStream((Creator & Serializable)() -> Files.newOutputStream(temporaryFile.path(), new OpenOption[0]))).map(iOResult -> F.Either.Right(temporaryFile), (Executor)this.materializer.executionContext());
        }
    }

    public static class ToFile
    extends MaxLengthBodyParser<File> {
        private final File to;
        private final Materializer materializer;

        public ToFile(File file, long l, HttpErrorHandler httpErrorHandler, Materializer materializer) {
            super(l, httpErrorHandler);
            this.to = file;
            this.materializer = materializer;
        }

        public ToFile(File file, HttpConfiguration httpConfiguration, HttpErrorHandler httpErrorHandler, Materializer materializer) {
            this(file, httpConfiguration.parser().maxDiskBuffer(), httpErrorHandler, materializer);
        }

        @Override
        protected Accumulator<ByteString, F.Either<Result, File>> apply1(Http.RequestHeader requestHeader) {
            return Accumulator.fromSink((Sink)StreamConverters.fromOutputStream((Creator & Serializable)() -> Files.newOutputStream(this.to.toPath(), new OpenOption[0]))).map(iOResult -> F.Either.Right(this.to), (Executor)this.materializer.executionContext());
        }
    }

    public static class Raw
    extends DelegatingBodyParser<Http.RawBuffer, RawBuffer> {
        @Inject
        public Raw(PlayBodyParsers playBodyParsers) {
            super(playBodyParsers.raw(), JavaParsers::toJavaRaw);
        }

        public Raw(PlayBodyParsers playBodyParsers, long l, long l2) {
            super(playBodyParsers.raw(l, l2), JavaParsers::toJavaRaw);
        }
    }

    public static class Bytes
    extends BufferingBodyParser<ByteString> {
        public Bytes(long l, HttpErrorHandler httpErrorHandler) {
            super(l, httpErrorHandler, "Error decoding byte body");
        }

        @Inject
        public Bytes(HttpConfiguration httpConfiguration, HttpErrorHandler httpErrorHandler) {
            super(httpConfiguration, httpErrorHandler, "Error decoding byte body");
        }

        @Override
        protected ByteString parse(Http.RequestHeader requestHeader, ByteString byteString) throws Exception {
            return byteString;
        }
    }

    public static class TolerantText
    extends BufferingBodyParser<String> {
        private static final Logger logger = LoggerFactory.getLogger(TolerantText.class);

        public TolerantText(long l, HttpErrorHandler httpErrorHandler) {
            super(l, httpErrorHandler, "Error decoding text body");
        }

        @Inject
        public TolerantText(HttpConfiguration httpConfiguration, HttpErrorHandler httpErrorHandler) {
            super(httpConfiguration, httpErrorHandler, "Error decoding text body");
        }

        @Override
        protected String parse(Http.RequestHeader requestHeader, ByteString byteString) throws Exception {
            ByteBuffer byteBuffer = byteString.toByteBuffer();
            Function<Charset, F.Either> function = charset -> {
                try {
                    byteBuffer.rewind();
                    CharsetDecoder charsetDecoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT);
                    return F.Either.Right(charsetDecoder.decode(byteBuffer).toString());
                }
                catch (CharacterCodingException characterCodingException) {
                    String string = String.format("Parser tried to parse request %s as text body with charset %s, but it contains invalid characters!", requestHeader.id(), charset);
                    logger.warn(string);
                    return F.Either.Left(characterCodingException);
                }
                catch (Exception exception) {
                    String string = "Unexpected exception!";
                    logger.error(string, (Throwable)exception);
                    return F.Either.Left(exception);
                }
            };
            Charset charset2 = requestHeader.charset().map(Charset::forName).orElse(StandardCharsets.US_ASCII);
            return function.apply((Charset)charset2).right.orElseGet(() -> ((F.Either)function.apply(StandardCharsets.UTF_8)).right.orElseGet(() -> ((F.Either)function.apply(StandardCharsets.ISO_8859_1)).right.orElseGet(() -> byteString.decodeString(charset2))));
        }
    }

    public static class Text
    extends BufferingBodyParser<String> {
        private static final Logger logger = LoggerFactory.getLogger(Text.class);
        private final HttpErrorHandler errorHandler;

        public Text(long l, HttpErrorHandler httpErrorHandler) {
            super(l, httpErrorHandler, "Error decoding text/plain body");
            this.errorHandler = httpErrorHandler;
        }

        @Inject
        public Text(HttpConfiguration httpConfiguration, HttpErrorHandler httpErrorHandler) {
            super(httpConfiguration, httpErrorHandler, "Error decoding text/plain body");
            this.errorHandler = httpErrorHandler;
        }

        @Override
        public Accumulator<ByteString, F.Either<Result, String>> apply(Http.RequestHeader requestHeader2) {
            return BodyParsers.validateContentType(this.errorHandler, requestHeader2, "Expected text/plain", string -> string.equalsIgnoreCase("text/plain"), requestHeader -> super.apply((Http.RequestHeader)requestHeader));
        }

        @Override
        protected String parse(Http.RequestHeader requestHeader, ByteString byteString) throws Exception {
            Charset charset = requestHeader.charset().map(Charset::forName).orElse(StandardCharsets.US_ASCII);
            try {
                CharsetDecoder charsetDecoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT);
                return charsetDecoder.decode(byteString.toByteBuffer()).toString();
            }
            catch (CharacterCodingException characterCodingException) {
                String string = String.format("Parser tried to parse request %s as text body with charset %s, but it contains invalid characters!", requestHeader.id(), charset);
                logger.warn(string);
                return byteString.decodeString(charset);
            }
            catch (Exception exception) {
                String string = "Unexpected exception while parsing text/plain body";
                logger.error(string, (Throwable)exception);
                return byteString.decodeString(charset);
            }
        }
    }

    public static class TolerantXml
    extends BufferingBodyParser<Document> {
        public TolerantXml(long l, HttpErrorHandler httpErrorHandler) {
            super(l, httpErrorHandler, "Error decoding xml body");
        }

        @Inject
        public TolerantXml(HttpConfiguration httpConfiguration, HttpErrorHandler httpErrorHandler) {
            super(httpConfiguration, httpErrorHandler, "Error decoding xml body");
        }

        @Override
        protected Document parse(Http.RequestHeader requestHeader, ByteString byteString) throws Exception {
            return XML.fromInputStream(byteString.iterator().asInputStream(), requestHeader.charset().orElse(null));
        }
    }

    public static class Xml
    extends TolerantXml {
        private final HttpErrorHandler errorHandler;
        private final PlayBodyParsers parsers;

        public Xml(long l, HttpErrorHandler httpErrorHandler, PlayBodyParsers playBodyParsers) {
            super(l, httpErrorHandler);
            this.errorHandler = httpErrorHandler;
            this.parsers = playBodyParsers;
        }

        @Inject
        public Xml(HttpConfiguration httpConfiguration, HttpErrorHandler httpErrorHandler, PlayBodyParsers playBodyParsers) {
            super(httpConfiguration, httpErrorHandler);
            this.errorHandler = httpErrorHandler;
            this.parsers = playBodyParsers;
        }

        @Override
        public Accumulator<ByteString, F.Either<Result, Document>> apply(Http.RequestHeader requestHeader2) {
            return BodyParsers.validateContentType(this.errorHandler, requestHeader2, "Expected XML", string -> string.startsWith("text/xml") || string.startsWith("application/xml") || this.parsers.ApplicationXmlMatcher().pattern().matcher((CharSequence)string).matches(), requestHeader -> super.apply((Http.RequestHeader)requestHeader));
        }
    }

    public static class TolerantJson
    extends BufferingBodyParser<JsonNode> {
        public TolerantJson(long l, HttpErrorHandler httpErrorHandler) {
            super(l, httpErrorHandler, "Error decoding json body");
        }

        @Inject
        public TolerantJson(HttpConfiguration httpConfiguration, HttpErrorHandler httpErrorHandler) {
            super(httpConfiguration, httpErrorHandler, "Error decoding json body");
        }

        @Override
        protected JsonNode parse(Http.RequestHeader requestHeader, ByteString byteString) throws Exception {
            return play.libs.Json.parse(byteString.iterator().asInputStream());
        }
    }

    public static class Json
    extends TolerantJson {
        private final HttpErrorHandler errorHandler;

        public Json(long l, HttpErrorHandler httpErrorHandler) {
            super(l, httpErrorHandler);
            this.errorHandler = httpErrorHandler;
        }

        @Inject
        public Json(HttpConfiguration httpConfiguration, HttpErrorHandler httpErrorHandler) {
            super(httpConfiguration, httpErrorHandler);
            this.errorHandler = httpErrorHandler;
        }

        @Override
        public Accumulator<ByteString, F.Either<Result, JsonNode>> apply(Http.RequestHeader requestHeader2) {
            return BodyParsers.validateContentType(this.errorHandler, requestHeader2, "Expected application/json", string -> string.equalsIgnoreCase("application/json") || string.equalsIgnoreCase("text/json"), requestHeader -> super.apply((Http.RequestHeader)requestHeader));
        }
    }

    public static class AnyContent
    implements BodyParser<Object> {
        private final HttpErrorHandler errorHandler;
        private final HttpConfiguration httpConfiguration;
        private final PlayBodyParsers parsers;

        @Inject
        public AnyContent(HttpErrorHandler httpErrorHandler, HttpConfiguration httpConfiguration, PlayBodyParsers playBodyParsers) {
            this.errorHandler = httpErrorHandler;
            this.httpConfiguration = httpConfiguration;
            this.parsers = playBodyParsers;
        }

        @Override
        public Accumulator<ByteString, F.Either<Result, Object>> apply(Http.RequestHeader requestHeader) {
            String string2 = requestHeader.contentType().map(string -> string.toLowerCase(Locale.ENGLISH)).orElse(null);
            if (string2 != null) {
                if (string2.equals("text/plain")) {
                    return new TolerantText(this.httpConfiguration, this.errorHandler).apply(requestHeader).map(either -> either.right.map(string -> F.Either.Right(string == null || string.isEmpty() ? Optional.empty() : string)).orElseGet(() -> either.left.map(result -> F.Either.Left(result)).get()), JavaParsers.trampoline());
                }
                if (string2.equals("text/xml") || string2.equals("application/xml") || this.parsers.ApplicationXmlMatcher().pattern().matcher(string2).matches()) {
                    return new TolerantXml(this.httpConfiguration, this.errorHandler).apply(requestHeader).map(either -> either.right.map(document -> F.Either.Right(document == null || !document.hasChildNodes() ? Optional.empty() : document)).orElseGet(() -> either.left.map(result -> F.Either.Left(result)).get()), JavaParsers.trampoline());
                }
                if (string2.equals("text/json") || string2.equals("application/json")) {
                    return new TolerantJson(this.httpConfiguration, this.errorHandler).apply(requestHeader).map(either -> either.right.map(jsonNode -> F.Either.Right(jsonNode == null || jsonNode.isEmpty() && jsonNode.isMissingNode() ? Optional.empty() : jsonNode)).orElseGet(() -> either.left.map(result -> F.Either.Left(result)).get()), JavaParsers.trampoline());
                }
                if (string2.equals("application/x-www-form-urlencoded")) {
                    return new FormUrlEncoded(this.httpConfiguration, this.errorHandler).apply(requestHeader).map(either -> either.right.map(map2 -> F.Either.Right(map2 == null || map2.isEmpty() ? Optional.empty() : map2)).orElseGet(() -> either.left.map(result -> F.Either.Left(result)).get()), JavaParsers.trampoline());
                }
                if (string2.equals("multipart/form-data")) {
                    return new MultipartFormData(this.parsers).apply(requestHeader).map(either -> either.right.map(multipartFormData -> F.Either.Right(multipartFormData == null || multipartFormData.isEmpty() ? Optional.empty() : multipartFormData)).orElseGet(() -> either.left.map(result -> F.Either.Left(result)).get()), JavaParsers.trampoline());
                }
            }
            return new Raw(this.parsers).apply(requestHeader).map(either -> either.right.map(rawBuffer -> F.Either.Right(rawBuffer == null || rawBuffer.size() == 0L ? Optional.empty() : rawBuffer)).orElseGet(() -> either.left.map(result -> F.Either.Left(result)).get()), JavaParsers.trampoline());
        }
    }

    public static class Default
    extends AnyContent {
        @Inject
        public Default(HttpErrorHandler httpErrorHandler, HttpConfiguration httpConfiguration, PlayBodyParsers playBodyParsers) {
            super(httpErrorHandler, httpConfiguration, playBodyParsers);
        }

        @Override
        public Accumulator<ByteString, F.Either<Result, Object>> apply(Http.RequestHeader requestHeader) {
            if (requestHeader.hasBody()) {
                return super.apply(requestHeader);
            }
            return BodyParser.widen(new Empty()).apply(requestHeader);
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Of {
        public Class<? extends BodyParser<?>> value();
    }
}

