/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.mvc.ResponseHeader$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;

public final class Assets$ {
    public static final Assets$ MODULE$ = new Assets$();
    private static final Logger logger = Logger$.MODULE$.apply(MODULE$.getClass());
    private static final DateTimeFormatter standardDateParserWithoutTZ = DateTimeFormatter.ofPattern(ResponseHeader$.MODULE$.basicDateFormatPattern()).withLocale(Locale.ENGLISH).withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter alternativeDateFormatWithTZOffset = DateTimeFormatter.ofPattern("EEE MMM dd yyyy HH:mm:ss 'GMT'Z").withLocale(Locale.ENGLISH);
    private static final Pattern dateRecognizer = Pattern.compile("^(((\\w\\w\\w, \\d\\d \\w\\w\\w \\d\\d\\d\\d \\d\\d:\\d\\d:\\d\\d)(( GMT)?))|(\\w\\w\\w \\w\\w\\w \\d\\d \\d\\d\\d\\d \\d\\d:\\d\\d:\\d\\d GMT.\\d\\d\\d\\d))(\\b.*)");

    private Logger logger() {
        return logger;
    }

    public DateTimeFormatter standardDateParserWithoutTZ() {
        return standardDateParserWithoutTZ;
    }

    public DateTimeFormatter alternativeDateFormatWithTZOffset() {
        return alternativeDateFormatWithTZOffset;
    }

    private Pattern dateRecognizer() {
        return dateRecognizer;
    }

    public Option<Date> parseModifiedDate(String date) {
        Matcher matcher = this.dateRecognizer().matcher(date);
        if (matcher.matches()) {
            Some some;
            String standardDate = matcher.group(3);
            try {
                if (standardDate != null) {
                    some = new Some((Object)Date.from(ZonedDateTime.parse(standardDate, this.standardDateParserWithoutTZ()).toInstant()));
                } else {
                    String alternativeDate = matcher.group(6);
                    some = new Some((Object)Date.from(ZonedDateTime.parse(alternativeDate, this.alternativeDateFormatWithTZOffset()).toInstant()));
                }
            }
            catch (IllegalArgumentException e) {
                this.logger().debug((Function0<String>)(Function0 & Serializable)() -> "An invalid date was received: couldn't parse: " + date, (Function0<Throwable>)(Function0 & Serializable)() -> e, MarkerContext$.MODULE$.NoMarker());
                some = None$.MODULE$;
            }
            catch (DateTimeParseException e) {
                this.logger().debug((Function0<String>)(Function0 & Serializable)() -> "An invalid date was received: couldn't parse: " + date, (Function0<Throwable>)(Function0 & Serializable)() -> e, MarkerContext$.MODULE$.NoMarker());
                some = None$.MODULE$;
            }
            return some;
        }
        this.logger().debug((Function0<String>)(Function0 & Serializable)() -> "An invalid date was received: unrecognized format: " + date, MarkerContext$.MODULE$.NoMarker());
        return None$.MODULE$;
    }

    private Assets$() {
    }
}

