/*
 * Decompiled with CFR 0.152.
 */
package play.api.db.slick.evolutions.internal;

import java.io.Serializable;
import java.sql.Connection;
import javax.inject.Inject;
import javax.sql.DataSource;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.db.DBApi;
import play.api.db.Database;
import play.api.db.TransactionIsolationLevel;
import play.api.db.slick.DbName;
import play.api.db.slick.DbName$;
import play.api.db.slick.SlickApi;
import play.api.db.slick.evolutions.internal.DBApiAdapter$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import slick.basic.DatabaseConfig;
import slick.jdbc.DataSourceJdbcDataSource;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcDataSource;
import slick.jdbc.JdbcProfile;
import slick.jdbc.hikaricp.HikariCPJdbcDataSource;

public class DBApiAdapter
implements DBApi {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DBApiAdapter.class.getDeclaredField("databasesByName$lzy1"));
    private SlickApi slickApi;
    private volatile Object databasesByName$lzy1;

    @Inject
    public DBApiAdapter(SlickApi slickApi) {
        this.slickApi = slickApi;
    }

    private Map<DbName, Database> databasesByName() {
        Object object = this.databasesByName$lzy1;
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Map)this.databasesByName$lzyINIT1();
    }

    private Object databasesByName$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.databasesByName$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Map map = null;
                    try {
                        map = ((IterableOnceOps)this.slickApi.dbConfigs().map((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                String name = tuple2._1() == null ? null : ((DbName)tuple2._1()).value();
                                DatabaseConfig dbConfig = (DatabaseConfig)tuple2._2();
                                return Tuple2$.MODULE$.apply((Object)new DbName(name), (Object)new DatabaseAdapter(name, (DatabaseConfig<JdbcProfile>)dbConfig));
                            }
                            throw new MatchError((Object)tuple2);
                        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                        object2 = map == null ? LazyVals.NullValue$.MODULE$ : map;
                        this.slickApi = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.databasesByName$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return map;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Seq<Database> databases() {
        return this.databasesByName().values().toSeq();
    }

    public Database database(String name) {
        return (Database)this.databasesByName().getOrElse((Object)new DbName(DbName$.MODULE$.apply(name)), () -> DBApiAdapter.database$$anonfun$1(name));
    }

    public void shutdown() {
    }

    private static final Database database$$anonfun$1(String name$1) {
        throw new IllegalArgumentException(new StringBuilder(28).append("Could not find database for ").append(name$1).toString());
    }

    public static class DatabaseAdapter
    implements Database {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DatabaseAdapter.class.getDeclaredField("url$lzy1"));
        private final String _name;
        private final DatabaseConfig<JdbcProfile> dbConfig;
        private final Logger logger;
        private volatile Object url$lzy1;

        public DatabaseAdapter(String _name, DatabaseConfig<JdbcProfile> dbConfig) {
            this._name = _name;
            this.dbConfig = dbConfig;
            this.logger = Logger$.MODULE$.apply(DatabaseAdapter.class);
        }

        public String name() {
            return this._name;
        }

        public DataSource dataSource() {
            JdbcDataSource jdbcDataSource = ((JdbcBackend.JdbcDatabaseDef)this.dbConfig.db()).source();
            if (jdbcDataSource instanceof DataSourceJdbcDataSource) {
                DataSourceJdbcDataSource ds = (DataSourceJdbcDataSource)jdbcDataSource;
                return ds.ds();
            }
            if (jdbcDataSource instanceof HikariCPJdbcDataSource) {
                HikariCPJdbcDataSource hds = (HikariCPJdbcDataSource)jdbcDataSource;
                return hds.ds();
            }
            JdbcDataSource other = jdbcDataSource;
            this.logger.error(() -> DBApiAdapter$.play$api$db$slick$evolutions$internal$DBApiAdapter$DatabaseAdapter$$_$dataSource$$anonfun$1(other), MarkerContext$.MODULE$.NoMarker());
            throw new UnsupportedOperationException();
        }

        public String url() {
            Object object = this.url$lzy1;
            if (object instanceof String) {
                return (String)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (String)this.url$lzyINIT1();
        }

        private Object url$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.url$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        String string = null;
                        try {
                            string = (String)this.withConnection(DBApiAdapter$::play$api$db$slick$evolutions$internal$DBApiAdapter$DatabaseAdapter$$_$url$lzyINIT1$$anonfun$1);
                            object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.url$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return string;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public Connection getConnection() {
            return this.getConnection(true);
        }

        public Connection getConnection(boolean autocommit) {
            Connection connection = ((JdbcBackend.JdbcDatabaseDef)this.dbConfig.db()).source().createConnection();
            try {
                connection.setAutoCommit(autocommit);
            }
            catch (Throwable e) {
                connection.close();
                throw e;
            }
            return connection;
        }

        public <A> A withConnection(Function1<Connection, A> block) {
            return this.withConnection(true, block);
        }

        public <A> A withConnection(boolean autocommit, Function1<Connection, A> block) {
            Object object;
            try (Connection connection = this.getConnection(autocommit);){
                object = block.apply((Object)connection);
            }
            return (A)object;
        }

        public <A> A withTransaction(Function1<Connection, A> block) {
            return this.withConnection(false, arg_0 -> DBApiAdapter$.play$api$db$slick$evolutions$internal$DBApiAdapter$DatabaseAdapter$$_$withTransaction$$anonfun$1(block, arg_0));
        }

        public <A> A withTransaction(TransactionIsolationLevel isolationLevel, Function1<Connection, A> block) {
            return this.withConnection(false, arg_0 -> DBApiAdapter$.play$api$db$slick$evolutions$internal$DBApiAdapter$DatabaseAdapter$$_$withTransaction$$anonfun$2(isolationLevel, block, arg_0));
        }

        public void shutdown() {
        }
    }
}

