/*
 * Decompiled with CFR 0.152.
 */
package play.api.db.slick.evolutions.internal;

import java.io.Serializable;
import java.sql.Connection;
import javax.inject.Inject;
import javax.sql.DataSource;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.db.DBApi;
import play.api.db.Database;
import play.api.db.TransactionIsolationLevel;
import play.api.db.slick.DbName;
import play.api.db.slick.SlickApi;
import play.api.db.slick.package$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.util.control.ControlThrowable;
import slick.basic.DatabaseConfig;
import slick.jdbc.DataSourceJdbcDataSource;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcDataSource;
import slick.jdbc.JdbcProfile;
import slick.jdbc.hikaricp.HikariCPJdbcDataSource;

@ScalaSignature(bytes="\u0006\u0005\u0005Ef!\u0002\u000e\u001c\u0001u9\u0003\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u000ba\u0002A\u0011A\u001d\t\u0011\u0019\u0003\u0001R1A\u0005\n\u001dCQ!\u0017\u0001\u0005BiCQ\u0001\u001a\u0001\u0005\u0002\u0015DQa\u001b\u0001\u0005\u00021<a\u0001]\u000e\t\u0002u\thA\u0002\u000e\u001c\u0011\u0003i\"\u000fC\u00039\u0011\u0011\u00051O\u0002\u0003u\u0011\u0011)\b\u0002\u0003<\u000b\u0005\u0003\u0005\u000b\u0011B*\t\u0011]T!\u0011!Q\u0001\naDa\u0001\u000f\u0006\u0005\u0002\u0005-\u0001\"CA\u000b\u0015\t\u0007I\u0011BA\f\u0011!\t\tC\u0003Q\u0001\n\u0005e\u0001BB4\u000b\t\u0003\t\u0019\u0003C\u0004\u0002&)!\t!a\n\t\u0015\u0005U\"\u0002#b\u0001\n\u0003\t\u0019\u0003C\u0004\u00028)!\t%!\u000f\t\u000f\u0005]\"\u0002\"\u0011\u0002J!9\u0011Q\u000b\u0006\u0005\u0002\u0005]\u0003bBA+\u0015\u0011\u0005\u00111\u0010\u0005\b\u0003\u0017SA\u0011AAG\u0011\u001d\tYI\u0003C!\u00033CQa\u001b\u0006\u0005\u00021\u0014A\u0002\u0012\"Ba&\fE-\u00199uKJT!\u0001H\u000f\u0002\u0011%tG/\u001a:oC2T!AH\u0010\u0002\u0015\u00154x\u000e\\;uS>t7O\u0003\u0002!C\u0005)1\u000f\\5dW*\u0011!eI\u0001\u0003I\nT!\u0001J\u0013\u0002\u0007\u0005\u0004\u0018NC\u0001'\u0003\u0011\u0001H.Y=\u0014\u0007\u0001Ac\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VM\u001a\t\u0003_Aj\u0011!I\u0005\u0003c\u0005\u0012Q\u0001\u0012\"Ba&\f\u0001b\u001d7jG.\f\u0005/[\u0002\u0001!\t)d'D\u0001 \u0013\t9tD\u0001\u0005TY&\u001c7.\u00119j\u0003\u0019a\u0014N\\5u}Q\u0011!\b\u0010\t\u0003w\u0001i\u0011a\u0007\u0005\u0006e\t\u0001\r\u0001\u000e\u0015\u0003\u0005y\u0002\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\r%t'.Z2u\u0015\u0005\u0019\u0015!\u00026bm\u0006D\u0018BA#A\u0005\u0019IeN[3di\u0006yA-\u0019;bE\u0006\u001cXm\u001d\"z\u001d\u0006lW-F\u0001I!\u0011I\u0005k\u0015,\u000f\u0005)s\u0005CA&+\u001b\u0005a%BA'4\u0003\u0019a$o\\8u}%\u0011qJK\u0001\u0007!J,G-\u001a4\n\u0005E\u0013&aA'ba*\u0011qJ\u000b\t\u0003kQK!!V\u0010\u0003\r\u0011\u0013g*Y7f!\tys+\u0003\u0002YC\tAA)\u0019;bE\u0006\u001cX-A\u0005eCR\f'-Y:fgR\t1\fE\u0002]CZs!!X0\u000f\u0005-s\u0016\"A\u0016\n\u0005\u0001T\u0013a\u00029bG.\fw-Z\u0005\u0003E\u000e\u00141aU3r\u0015\t\u0001'&\u0001\u0005eCR\f'-Y:f)\t1f\rC\u0003h\u000b\u0001\u0007\u0001.\u0001\u0003oC6,\u0007CA%j\u0013\tQ'K\u0001\u0004TiJLgnZ\u0001\tg\",H\u000fZ8x]R\tQ\u000e\u0005\u0002*]&\u0011qN\u000b\u0002\u0005+:LG/\u0001\u0007E\u0005\u0006\u0003\u0018.\u00113baR,'\u000f\u0005\u0002<\u0011M\u0011\u0001\u0002\u000b\u000b\u0002c\nyA)\u0019;bE\u0006\u001cX-\u00113baR,'oE\u0002\u000bQY\u000bQa\u00188b[\u0016\f\u0001\u0002\u001a2D_:4\u0017n\u001a\t\u0004sv|X\"\u0001>\u000b\u0005md\u0018!\u00022bg&\u001c'\"\u0001\u0011\n\u0005yT(A\u0004#bi\u0006\u0014\u0017m]3D_:4\u0017n\u001a\t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001?\u0002\t)$'mY\u0005\u0005\u0003\u0013\t\u0019AA\u0006KI\n\u001c\u0007K]8gS2,GCBA\u0007\u0003#\t\u0019\u0002E\u0002\u0002\u0010)i\u0011\u0001\u0003\u0005\u0006m6\u0001\ra\u0015\u0005\u0006o6\u0001\r\u0001_\u0001\u0007Y><w-\u001a:\u0016\u0005\u0005e\u0001\u0003BA\u000e\u0003;i\u0011aI\u0005\u0004\u0003?\u0019#A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0016\u0003!\f!\u0002Z1uCN{WO]2f+\t\tI\u0003\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\r\tyCQ\u0001\u0004gFd\u0017\u0002BA\u001a\u0003[\u0011!\u0002R1uCN{WO]2f\u0003\r)(\u000f\\\u0001\u000eO\u0016$8i\u001c8oK\u000e$\u0018n\u001c8\u0015\u0005\u0005m\u0002\u0003BA\u001f\u0003\u000bj!!a\u0010\u000b\t\u0005=\u0012\u0011\t\u0006\u0003\u0003\u0007\nAA[1wC&!\u0011qIA \u0005)\u0019uN\u001c8fGRLwN\u001c\u000b\u0005\u0003w\tY\u0005C\u0004\u0002NQ\u0001\r!a\u0014\u0002\u0015\u0005,Ho\\2p[6LG\u000fE\u0002*\u0003#J1!a\u0015+\u0005\u001d\u0011un\u001c7fC:\fab^5uQ\u000e{gN\\3di&|g.\u0006\u0003\u0002Z\u0005}C\u0003BA.\u0003c\u0002B!!\u0018\u0002`1\u0001AaBA1+\t\u0007\u00111\r\u0002\u0002\u0003F!\u0011QMA6!\rI\u0013qM\u0005\u0004\u0003SR#a\u0002(pi\"Lgn\u001a\t\u0004S\u00055\u0014bAA8U\t\u0019\u0011I\\=\t\u000f\u0005MT\u00031\u0001\u0002v\u0005)!\r\\8dWB9\u0011&a\u001e\u0002<\u0005m\u0013bAA=U\tIa)\u001e8di&|g.M\u000b\u0005\u0003{\n\u0019\t\u0006\u0003\u0002\u0000\u0005%E\u0003BAA\u0003\u000b\u0003B!!\u0018\u0002\u0004\u00129\u0011\u0011\r\fC\u0002\u0005\r\u0004bBA:-\u0001\u0007\u0011q\u0011\t\bS\u0005]\u00141HAA\u0011\u001d\tiE\u0006a\u0001\u0003\u001f\nqb^5uQR\u0013\u0018M\\:bGRLwN\\\u000b\u0005\u0003\u001f\u000b\u0019\n\u0006\u0003\u0002\u0012\u0006U\u0005\u0003BA/\u0003'#q!!\u0019\u0018\u0005\u0004\t\u0019\u0007C\u0004\u0002t]\u0001\r!a&\u0011\u000f%\n9(a\u000f\u0002\u0012V!\u00111TAQ)\u0011\ti*a*\u0015\t\u0005}\u00151\u0015\t\u0005\u0003;\n\t\u000bB\u0004\u0002ba\u0011\r!a\u0019\t\u000f\u0005M\u0004\u00041\u0001\u0002&B9\u0011&a\u001e\u0002<\u0005}\u0005bBAU1\u0001\u0007\u00111V\u0001\u000fSN|G.\u0019;j_:dUM^3m!\ry\u0013QV\u0005\u0004\u0003_\u000b#!\u0007+sC:\u001c\u0018m\u0019;j_:L5o\u001c7bi&|g\u000eT3wK2\u0004")
public class DBApiAdapter
implements DBApi {
    private Map<DbName, Database> databasesByName;
    private SlickApi slickApi;
    private volatile boolean bitmap$0;

    private Map<DbName, Database> databasesByName$lzycompute() {
        DBApiAdapter dBApiAdapter = this;
        synchronized (dBApiAdapter) {
            if (!this.bitmap$0) {
                this.databasesByName = ((IterableOnceOps)this.slickApi.dbConfigs().map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String name = ((DbName)tuple2._1()).value();
                        DatabaseConfig dbConfig = (DatabaseConfig)tuple2._2();
                        return new Tuple2((Object)new DbName(name), (Object)new DatabaseAdapter(name, (DatabaseConfig<JdbcProfile>)dbConfig));
                    }
                    throw new MatchError((Object)tuple2);
                })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                this.bitmap$0 = true;
            }
        }
        this.slickApi = null;
        return this.databasesByName;
    }

    private Map<DbName, Database> databasesByName() {
        if (!this.bitmap$0) {
            return this.databasesByName$lzycompute();
        }
        return this.databasesByName;
    }

    public Seq<Database> databases() {
        return this.databasesByName().values().toSeq();
    }

    public Database database(String name) {
        return (Database)this.databasesByName().getOrElse((Object)new DbName(name), (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(28).append("Could not find database for ").append(name).toString());
        });
    }

    public void shutdown() {
    }

    @Inject
    public DBApiAdapter(SlickApi slickApi) {
        this.slickApi = slickApi;
    }

    private static class DatabaseAdapter
    implements Database {
        private String url;
        private final String _name;
        private final DatabaseConfig<JdbcProfile> dbConfig;
        private final Logger logger;
        private volatile boolean bitmap$0;

        private Logger logger() {
            return this.logger;
        }

        public String name() {
            return this._name;
        }

        public DataSource dataSource() {
            JdbcDataSource jdbcDataSource = ((JdbcBackend.DatabaseDef)this.dbConfig.db()).source();
            if (jdbcDataSource instanceof DataSourceJdbcDataSource) {
                DataSourceJdbcDataSource dataSourceJdbcDataSource = (DataSourceJdbcDataSource)jdbcDataSource;
                return dataSourceJdbcDataSource.ds();
            }
            if (jdbcDataSource instanceof HikariCPJdbcDataSource) {
                HikariCPJdbcDataSource hikariCPJdbcDataSource = (HikariCPJdbcDataSource)jdbcDataSource;
                return hikariCPJdbcDataSource.ds();
            }
            this.logger().error((Function0 & Serializable)() -> new StringBuilder(53).append("Unexpected data source type ").append(jdbcDataSource.getClass()).append(". Please, file a ticket ").append(package$.MODULE$.IssueTracker()).append(".").toString(), MarkerContext$.MODULE$.NoMarker());
            throw new UnsupportedOperationException();
        }

        private String url$lzycompute() {
            DatabaseAdapter databaseAdapter = this;
            synchronized (databaseAdapter) {
                if (!this.bitmap$0) {
                    this.url = (String)this.withConnection((Function1 & Serializable)x$1 -> x$1.getMetaData().getURL());
                    this.bitmap$0 = true;
                }
            }
            return this.url;
        }

        public String url() {
            if (!this.bitmap$0) {
                return this.url$lzycompute();
            }
            return this.url;
        }

        public Connection getConnection() {
            return this.getConnection(true);
        }

        public Connection getConnection(boolean autocommit) {
            Connection connection = ((JdbcBackend.DatabaseDef)this.dbConfig.db()).source().createConnection();
            try {
                connection.setAutoCommit(autocommit);
            }
            catch (Throwable e) {
                connection.close();
                throw e;
            }
            return connection;
        }

        public <A> A withConnection(Function1<Connection, A> block) {
            return this.withConnection(true, block);
        }

        public <A> A withConnection(boolean autocommit, Function1<Connection, A> block) {
            Object object;
            try (Connection connection = this.getConnection(autocommit);){
                object = block.apply((Object)connection);
            }
            return (A)object;
        }

        public <A> A withTransaction(Function1<Connection, A> block) {
            return this.withConnection(false, (Function1 & Serializable)connection -> {
                void v0;
                try {
                    void var2_2;
                    Object r = block.apply(connection);
                    connection.commit();
                    v0 = var2_2;
                }
                catch (ControlThrowable e) {
                    connection.commit();
                    throw e;
                }
                catch (Throwable e) {
                    connection.rollback();
                    throw e;
                }
                return v0;
            });
        }

        public <A> A withTransaction(TransactionIsolationLevel isolationLevel, Function1<Connection, A> block) {
            return this.withConnection(false, (Function1 & Serializable)connection -> {
                Object object;
                int oldIsolationLevel = connection.getTransactionIsolation();
                try {
                    try {
                        connection.setTransactionIsolation(isolationLevel.id());
                        Object r = block.apply(connection);
                        connection.commit();
                        object = r;
                    }
                    catch (ControlThrowable e) {
                        connection.commit();
                        throw e;
                    }
                    catch (Throwable e) {
                        connection.rollback();
                        throw e;
                    }
                }
                finally {
                    connection.setTransactionIsolation(oldIsolationLevel);
                }
                return object;
            });
        }

        public void shutdown() {
        }

        public DatabaseAdapter(String _name, DatabaseConfig<JdbcProfile> dbConfig) {
            this._name = _name;
            this.dbConfig = dbConfig;
            this.logger = Logger$.MODULE$.apply(DatabaseAdapter.class);
        }
    }
}

