/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.ssl;

import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import play.api.MarkerContext$;
import play.core.ApplicationProvider;
import play.core.server.ServerConfig;
import play.core.server.ssl.DefaultSSLEngineProvider$;
import play.core.server.ssl.FakeKeyStore;
import play.core.server.ssl.noCATrustManager$;
import play.server.api.SSLEngineProvider;
import play.utils.PlayIO$;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005y3A!\u0004\b\u0001/!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u001d9\u0004A1A\u0005BaBaA\u0011\u0001!\u0002\u0013I\u0004\"B\"\u0001\t\u0003\"\u0005\"\u0002%\u0001\t\u0013Iu!\u0002'\u000f\u0011\u0003ie!B\u0007\u000f\u0011\u0003q\u0005\"B\u0019\n\t\u0003)\u0006b\u0002,\n\u0005\u0004%Ia\u0016\u0005\u0007;&\u0001\u000b\u0011\u0002-\u00031\u0011+g-Y;miN\u001bF*\u00128hS:,\u0007K]8wS\u0012,'O\u0003\u0002\u0010!\u0005\u00191o\u001d7\u000b\u0005E\u0011\u0012AB:feZ,'O\u0003\u0002\u0014)\u0005!1m\u001c:f\u0015\u0005)\u0012\u0001\u00029mCf\u001c\u0001aE\u0002\u00011\u0001\u0002\"!\u0007\u0010\u000e\u0003iQ!a\u0007\u000f\u0002\t1\fgn\u001a\u0006\u0002;\u0005!!.\u0019<b\u0013\ty\"D\u0001\u0004PE*,7\r\u001e\t\u0003C\u0015j\u0011A\t\u0006\u0003G\u0011\n1!\u00199j\u0015\t\tB#\u0003\u0002'E\t\t2k\u0015'F]\u001eLg.\u001a)s_ZLG-\u001a:\u0002\u0019M,'O^3s\u0007>tg-[4\u0011\u0005%RS\"\u0001\t\n\u0005-\u0002\"\u0001D*feZ,'oQ8oM&<\u0017aC1qaB\u0013xN^5eKJ\u0004\"AL\u0018\u000e\u0003II!\u0001\r\n\u0003'\u0005\u0003\b\u000f\\5dCRLwN\u001c)s_ZLG-\u001a:\u0002\rqJg.\u001b;?)\r\u0019TG\u000e\t\u0003i\u0001i\u0011A\u0004\u0005\u0006O\r\u0001\r\u0001\u000b\u0005\u0006Y\r\u0001\r!L\u0001\u000bgNd7i\u001c8uKb$X#A\u001d\u0011\u0005i\u0002U\"A\u001e\u000b\u0005=a$BA\u001f?\u0003\rqW\r\u001e\u0006\u0002\u007f\u0005)!.\u0019<bq&\u0011\u0011i\u000f\u0002\u000b'Nc5i\u001c8uKb$\u0018aC:tY\u000e{g\u000e^3yi\u0002\nqb\u0019:fCR,7k\u0015'F]\u001eLg.\u001a\u000b\u0002\u000bB\u0011!HR\u0005\u0003\u000fn\u0012\u0011bU*M\u000b:<\u0017N\\3\u0002!\r\u0014X-\u0019;f'Nc5i\u001c8uKb$HCA\u001dK\u0011\u0015Yu\u00011\u0001.\u0003M\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8Qe>4\u0018\u000eZ3s\u0003a!UMZ1vYR\u001c6\u000bT#oO&tW\r\u0015:pm&$WM\u001d\t\u0003i%\u0019\"!C(\u0011\u0005A\u001bV\"A)\u000b\u0003I\u000bQa]2bY\u0006L!\u0001V)\u0003\r\u0005s\u0017PU3g)\u0005i\u0015A\u00027pO\u001e,'/F\u0001Y!\tI6,D\u0001[\u0015\t\u0019C#\u0003\u0002]5\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b\u0005")
public class DefaultSSLEngineProvider
implements SSLEngineProvider {
    private final ServerConfig serverConfig;
    private final SSLContext sslContext;

    public SSLContext sslContext() {
        return this.sslContext;
    }

    public SSLEngine createSSLEngine() {
        return this.sslContext().createSSLEngine();
    }

    private SSLContext createSSLContext(ApplicationProvider applicationProvider) {
        TrustManager[] trustManagerArray;
        KeyManagerFactory keyManagerFactory;
        Config httpsConfig;
        block10: {
            httpsConfig = this.serverConfig.configuration().underlying().getConfig("play.server.https");
            Config keyStoreConfig = httpsConfig.getConfig("keyStore");
            if (keyStoreConfig.hasPath("path")) {
                String path = keyStoreConfig.getString("path");
                KeyStore keyStore = KeyStore.getInstance(keyStoreConfig.getString("type"));
                char[] password = keyStoreConfig.getString("password").toCharArray();
                String algorithm = keyStoreConfig.hasPath("algorithm") ? keyStoreConfig.getString("algorithm") : KeyManagerFactory.getDefaultAlgorithm();
                File file = new File(path);
                if (file.isFile()) {
                    InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
                    try {
                        try {
                            keyStore.load(in, password);
                            DefaultSSLEngineProvider$.MODULE$.play$core$server$ssl$DefaultSSLEngineProvider$$logger().debug((Function0 & Serializable)() -> "Using HTTPS keystore at " + file.getAbsolutePath(), MarkerContext$.MODULE$.NoMarker());
                            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
                            kmf.init(keyStore, password);
                            keyManagerFactory = kmf;
                            break block10;
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            Throwable throwable3 = throwable;
                            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                                throw new Exception("Error loading HTTPS keystore from " + file.getAbsolutePath(), throwable2);
                            }
                            throw throwable;
                        }
                    }
                    finally {
                        PlayIO$.MODULE$.closeQuietly((Closeable)in);
                    }
                }
                throw new Exception("Unable to find HTTPS keystore at \"" + file.getAbsolutePath() + "\"");
            }
            DefaultSSLEngineProvider$.MODULE$.play$core$server$ssl$DefaultSSLEngineProvider$$logger().warn((Function0 & Serializable)() -> "Using generated key with self signed certificate for HTTPS. This should NOT be used in production.", MarkerContext$.MODULE$.NoMarker());
            FakeKeyStore fakeKeyStore = new FakeKeyStore();
            keyManagerFactory = fakeKeyStore.keyManagerFactory(this.serverConfig.rootDir());
        }
        KeyManagerFactory keyManagerFactory2 = keyManagerFactory;
        Config trustStoreConfig = httpsConfig.getConfig("trustStore");
        if (trustStoreConfig.getBoolean("noCaVerification")) {
            DefaultSSLEngineProvider$.MODULE$.play$core$server$ssl$DefaultSSLEngineProvider$$logger().warn((Function0 & Serializable)() -> "HTTPS configured with no client side CA verification. Requires http://webid.info/ for client certificate verification.", MarkerContext$.MODULE$.NoMarker());
            trustManagerArray = (TrustManager[])((Object[])new TrustManager[]{noCATrustManager$.MODULE$});
        } else {
            DefaultSSLEngineProvider$.MODULE$.play$core$server$ssl$DefaultSSLEngineProvider$$logger().debug((Function0 & Serializable)() -> "Using default trust store for client side CA verification", MarkerContext$.MODULE$.NoMarker());
            trustManagerArray = null;
        }
        TrustManager[] tm = trustManagerArray;
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory2.getKeyManagers(), tm, null);
        return sslContext;
    }

    public DefaultSSLEngineProvider(ServerConfig serverConfig, ApplicationProvider appProvider) {
        this.serverConfig = serverConfig;
        this.sslContext = this.createSSLContext(appProvider);
    }
}

