/*
 * Decompiled with CFR 0.152.
 */
package play.core.server;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigMemorySize;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLContext;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.actor.CoordinatedShutdown$;
import org.apache.pekko.http.javadsl.ConnectionContext;
import org.apache.pekko.http.play.WebSocketHandler$;
import org.apache.pekko.http.scaladsl.ConnectionContext$;
import org.apache.pekko.http.scaladsl.Http;
import org.apache.pekko.http.scaladsl.Http$;
import org.apache.pekko.http.scaladsl.HttpConnectionContext$;
import org.apache.pekko.http.scaladsl.HttpExt;
import org.apache.pekko.http.scaladsl.HttpsConnectionContext;
import org.apache.pekko.http.scaladsl.model.EntityStreamSizeException;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.RemoteAddress;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.headers.Expect;
import org.apache.pekko.http.scaladsl.model.headers.Expect$;
import org.apache.pekko.http.scaladsl.model.headers.Host;
import org.apache.pekko.http.scaladsl.model.headers.Remote;
import org.apache.pekko.http.scaladsl.model.headers.Remote$minusAddress$;
import org.apache.pekko.http.scaladsl.model.ws.UpgradeToWebSocket;
import org.apache.pekko.http.scaladsl.settings.ParserSettings;
import org.apache.pekko.http.scaladsl.settings.ParserSettings$;
import org.apache.pekko.http.scaladsl.settings.ServerSettings;
import org.apache.pekko.http.scaladsl.settings.ServerSettings$;
import org.apache.pekko.http.scaladsl.util.FastFuture;
import org.apache.pekko.http.scaladsl.util.FastFuture$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.TLSClientAuth;
import org.apache.pekko.stream.TLSClientAuth$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import play.api.Application;
import play.api.BuiltInComponents;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Configuration$;
import play.api.MarkerContext$;
import play.api.Mode;
import play.api.http.DefaultHttpErrorHandler;
import play.api.http.DefaultHttpErrorHandler$;
import play.api.http.DevHttpErrorHandler$;
import play.api.http.HeaderNames$;
import play.api.http.HttpErrorHandler;
import play.api.http.HttpErrorInfo$;
import play.api.http.HttpProtocol$;
import play.api.http.Status$;
import play.api.http.Writeable$;
import play.api.internal.libs.concurrent.CoordinatedShutdownSupport$;
import play.api.libs.streams.Accumulator;
import play.api.libs.streams.Accumulator$;
import play.api.mvc.Codec$;
import play.api.mvc.EssentialAction;
import play.api.mvc.EssentialAction$;
import play.api.mvc.Handler;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import play.api.mvc.WebSocket;
import play.api.mvc.pekkohttp.PekkoHttpHandler;
import play.api.mvc.request.RequestAttrKey$;
import play.api.mvc.request.RequestTarget;
import play.core.ApplicationProvider;
import play.core.Execution;
import play.core.server.PekkoHttpServer$;
import play.core.server.PekkoHttpServer$Context$;
import play.core.server.PekkoHttpServer$ReloadCacheValues$;
import play.core.server.PekkoHttpServerProvider;
import play.core.server.Server;
import play.core.server.Server$;
import play.core.server.ServerConfig;
import play.core.server.ServerEndpoint;
import play.core.server.ServerEndpoint$;
import play.core.server.ServerEndpoints;
import play.core.server.ServerEndpoints$;
import play.core.server.ServerProvider;
import play.core.server.common.ForwardedHeaderHandler;
import play.core.server.common.ReloadCache;
import play.core.server.common.ServerDebugInfo;
import play.core.server.common.ServerDebugInfo$;
import play.core.server.common.ServerResultUtils;
import play.core.server.pekkohttp.HttpRequestDecoder$;
import play.core.server.pekkohttp.PekkoHeadersWrapper;
import play.core.server.pekkohttp.PekkoModelConversion;
import play.core.server.pekkohttp.PekkoServerConfigReader;
import play.core.server.ssl.ServerSSLEngine$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public class PekkoHttpServer
implements Server {
    public static final long OFFSET$7 = LazyVals$.MODULE$.getOffsetStatic(PekkoHttpServer.class.getDeclaredField("Http2Encrypted$lzy1"));
    public static final long OFFSET$6 = LazyVals$.MODULE$.getOffsetStatic(PekkoHttpServer.class.getDeclaredField("Http2Plain$lzy1"));
    public static final long OFFSET$5 = LazyVals$.MODULE$.getOffsetStatic(PekkoHttpServer.class.getDeclaredField("Http1Encrypted$lzy1"));
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(PekkoHttpServer.class.getDeclaredField("Http1Plain$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(PekkoHttpServer.class.getDeclaredField("mainAddress$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(PekkoHttpServer.class.getDeclaredField("fallbackErrorHandler$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(PekkoHttpServer.class.getDeclaredField("sslContext$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(PekkoHttpServer.class.getDeclaredField("initialSettings$lzy1"));
    private final Context context;
    private final Configuration serverConfig;
    private volatile Object initialSettings$lzy1;
    private final Duration httpIdleTimeout;
    private final Duration httpsIdleTimeout;
    private final Duration requestTimeout;
    private final FiniteDuration bindTimeout;
    private final FiniteDuration terminationDelay;
    private final Option<FiniteDuration> terminationTimeout;
    private final long maxContentLength;
    private final int maxHeaderValueLength;
    private final boolean includeTlsSessionInfoHeader;
    private final Host defaultHostHeader;
    private final boolean transparentHeadRequests;
    private final Option<String> serverHeaderConfig;
    private final int pipeliningLimit;
    private final Option<org.apache.pekko.http.scaladsl.model.headers.Server> serverHeader;
    private final boolean httpsNeedClientAuth;
    private final boolean httpsWantClientAuth;
    public final String play$core$server$PekkoHttpServer$$illegalResponseHeaderValueProcessingMode;
    private final int wsBufferLimit;
    private final String wsKeepAliveMode;
    private final Duration wsKeepAliveMaxIdle;
    private final boolean http2Enabled;
    private final Config pekkoHttpConfig;
    private final ParserSettings parserSettings;
    public final PekkoHttpServer$ReloadCacheValues$ ReloadCacheValues$lzy1;
    private final ReloadCache<ReloadCacheValues> reloadCache;
    private volatile Object sslContext$lzy1;
    private final Option<Http.ServerBinding> httpServerBinding;
    private final Option<Http.ServerBinding> httpsServerBinding;
    private volatile Object fallbackErrorHandler$lzy1;
    private volatile Object mainAddress$lzy1;
    private volatile Object Http1Plain$lzy1;
    private volatile Object Http1Encrypted$lzy1;
    private volatile Object Http2Plain$lzy1;
    private volatile Object Http2Encrypted$lzy1;
    private final ServerEndpoints serverEndpoints;

    public static PekkoHttpServer fromApplication(Application application, ServerConfig serverConfig) {
        return PekkoHttpServer$.MODULE$.fromApplication(application, serverConfig);
    }

    public static Server fromRouter(ServerConfig serverConfig, PartialFunction<RequestHeader, Handler> partialFunction) {
        return PekkoHttpServer$.MODULE$.fromRouter(serverConfig, partialFunction);
    }

    public static Server fromRouterWithComponents(ServerConfig serverConfig, Function1<BuiltInComponents, PartialFunction<RequestHeader, Handler>> function1) {
        return PekkoHttpServer$.MODULE$.fromRouterWithComponents(serverConfig, function1);
    }

    public static PekkoHttpServerProvider provider() {
        return PekkoHttpServer$.MODULE$.provider();
    }

    public static ServerConfig fromRouter$default$1() {
        return PekkoHttpServer$.MODULE$.fromRouter$default$1();
    }

    public static ServerConfig fromRouterWithComponents$default$1() {
        return PekkoHttpServer$.MODULE$.fromRouterWithComponents$default$1();
    }

    public static ServerConfig fromApplication$default$2() {
        return PekkoHttpServer$.MODULE$.fromApplication$default$2();
    }

    public PekkoHttpServer(Context context) {
        Mode mode;
        this.context = context;
        this.ReloadCacheValues$lzy1 = new PekkoHttpServer$ReloadCacheValues$(this);
        if (!context.config().port().isDefined() && !context.config().sslPort().isDefined()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"PekkoHttpServer must be given at least one of an HTTP and an HTTPS port");
        }
        this.serverConfig = (Configuration)context.config().configuration().get("play.server", ConfigLoader$.MODULE$.configurationLoader());
        Configuration pekkoServerConfig = (Configuration)this.serverConfig.get("pekko", ConfigLoader$.MODULE$.configurationLoader());
        PekkoServerConfigReader pekkoServerConfigReader = new PekkoServerConfigReader(pekkoServerConfig);
        this.httpIdleTimeout = (Duration)this.serverConfig.get("http.idleTimeout", ConfigLoader$.MODULE$.durationLoader());
        this.httpsIdleTimeout = (Duration)this.serverConfig.get("https.idleTimeout", ConfigLoader$.MODULE$.durationLoader());
        this.requestTimeout = (Duration)pekkoServerConfig.get("requestTimeout", ConfigLoader$.MODULE$.durationLoader());
        this.bindTimeout = (FiniteDuration)pekkoServerConfig.get("bindTimeout", ConfigLoader$.MODULE$.finiteDurationLoader());
        this.terminationDelay = (FiniteDuration)this.serverConfig.get("waitBeforeTermination", ConfigLoader$.MODULE$.finiteDurationLoader());
        this.terminationTimeout = (Option)this.serverConfig.getDeprecated("terminationTimeout", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pekko.terminationTimeout"}), ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.finiteDurationLoader()));
        this.maxContentLength = Server$.MODULE$.getPossiblyInfiniteBytes(this.serverConfig.underlying(), "max-content-length", "pekko.max-content-length");
        this.maxHeaderValueLength = (int)((ConfigMemorySize)this.serverConfig.getDeprecated("max-header-size", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pekko.max-header-value-length"}), ConfigLoader$.MODULE$.bytesLoader())).toBytes();
        this.includeTlsSessionInfoHeader = BoxesRunTime.unboxToBoolean((Object)pekkoServerConfig.get("tls-session-info-header", ConfigLoader$.MODULE$.booleanLoader()));
        this.defaultHostHeader = (Host)pekkoServerConfigReader.getHostHeader().fold((Function1 & Serializable)_$1 -> {
            throw _$1;
        }, (Function1 & Serializable)x -> (Host)Predef$.MODULE$.identity(x));
        this.transparentHeadRequests = BoxesRunTime.unboxToBoolean((Object)pekkoServerConfig.get("transparent-head-requests", ConfigLoader$.MODULE$.booleanLoader()));
        this.serverHeaderConfig = pekkoServerConfig.getOptional("server-header", ConfigLoader$.MODULE$.stringLoader());
        this.pipeliningLimit = BoxesRunTime.unboxToInt((Object)pekkoServerConfig.get("pipelining-limit", ConfigLoader$.MODULE$.intLoader()));
        this.serverHeader = this.serverHeaderConfig.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(String x) {
                String string = x;
                String s = string;
                return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s));
            }

            public final Object applyOrElse(String x, Function1 function1) {
                String string = x;
                String s = string;
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s))) {
                    return org.apache.pekko.http.scaladsl.model.headers.Server$.MODULE$.apply(s);
                }
                return function1.apply((Object)x);
            }
        });
        this.httpsNeedClientAuth = BoxesRunTime.unboxToBoolean((Object)this.serverConfig.get("https.needClientAuth", ConfigLoader$.MODULE$.booleanLoader()));
        this.httpsWantClientAuth = BoxesRunTime.unboxToBoolean((Object)this.serverConfig.get("https.wantClientAuth", ConfigLoader$.MODULE$.booleanLoader()));
        this.play$core$server$PekkoHttpServer$$illegalResponseHeaderValueProcessingMode = (String)pekkoServerConfig.get("illegal-response-header-value-processing-mode", ConfigLoader$.MODULE$.stringLoader());
        this.wsBufferLimit = (int)((ConfigMemorySize)this.serverConfig.get("websocket.frame.maxLength", ConfigLoader$.MODULE$.bytesLoader())).toBytes();
        this.wsKeepAliveMode = (String)this.serverConfig.get("websocket.periodic-keep-alive-mode", ConfigLoader$.MODULE$.stringLoader());
        this.wsKeepAliveMaxIdle = (Duration)this.serverConfig.get("websocket.periodic-keep-alive-max-idle", ConfigLoader$.MODULE$.durationLoader());
        this.http2Enabled = BoxesRunTime.unboxToBoolean((Object)pekkoServerConfig.getOptional("http2.enabled", ConfigLoader$.MODULE$.booleanLoader()).getOrElse(PekkoHttpServer::$init$$$anonfun$3));
        this.pekkoHttpConfig = this.createPekkoHttpConfig();
        this.parserSettings = this.createParserSettings();
        this.reloadCache = new ReloadCache<ReloadCacheValues>(this){
            private final /* synthetic */ PekkoHttpServer $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public ReloadCacheValues reloadValue(Try tryApp) {
                ServerResultUtils serverResultUtils = this.reloadServerResultUtils(tryApp);
                ForwardedHeaderHandler forwardedHeaderHandler = this.reloadForwardedHeaderHandler(tryApp);
                ParserSettings.IllegalResponseHeaderValueProcessingMode illegalResponseHeaderValue = ParserSettings.IllegalResponseHeaderValueProcessingMode$.MODULE$.apply(this.$outer.play$core$server$PekkoHttpServer$$illegalResponseHeaderValueProcessingMode);
                PekkoModelConversion modelConversion = new PekkoModelConversion(serverResultUtils, forwardedHeaderHandler, illegalResponseHeaderValue);
                return this.$outer.play$core$server$PekkoHttpServer$$ReloadCacheValues().apply(serverResultUtils, modelConversion, (Option<ServerDebugInfo>)this.reloadDebugInfo(tryApp, PekkoHttpServer$.MODULE$.provider()));
            }
        };
        this.httpServerBinding = context.config().port().map((Function1 & Serializable)port -> this.$init$$$anonfun$4(BoxesRunTime.unboxToInt((Object)port)));
        this.httpsServerBinding = context.config().sslPort().map((Function1 & Serializable)port -> this.$init$$$anonfun$5(BoxesRunTime.unboxToInt((Object)port)));
        if (this.http2Enabled) {
            PekkoHttpServer$.play$core$server$PekkoHttpServer$$$logger.info(PekkoHttpServer::$init$$$anonfun$6, MarkerContext$.MODULE$.NoMarker());
            if (this.httpsServerBinding.isEmpty()) {
                String logMessage = "No HTTPS server bound. Only binding HTTP. Many user agents only support HTTP/2 over HTTPS.";
                Mode mode2 = this.mode();
                if (Mode.Dev$.MODULE$.equals(mode2) || Mode.Test$.MODULE$.equals(mode2)) {
                    PekkoHttpServer$.play$core$server$PekkoHttpServer$$$logger.warn(() -> PekkoHttpServer.$init$$$anonfun$7(logMessage), MarkerContext$.MODULE$.NoMarker());
                } else {
                    PekkoHttpServer$.play$core$server$PekkoHttpServer$$$logger.debug(() -> PekkoHttpServer.$init$$$anonfun$8(logMessage), MarkerContext$.MODULE$.NoMarker());
                }
            }
        }
        if (!Mode.Test$.MODULE$.equals(mode = this.mode())) {
            this.httpServerBinding.foreach((Function1)(JProcedure1 & Serializable)http -> PekkoHttpServer$.play$core$server$PekkoHttpServer$$$logger.info(() -> PekkoHttpServer.$init$$$anonfun$9$$anonfun$1(http), MarkerContext$.MODULE$.NoMarker()));
            this.httpsServerBinding.foreach((Function1)(JProcedure1 & Serializable)https -> PekkoHttpServer$.play$core$server$PekkoHttpServer$$$logger.info(() -> PekkoHttpServer.$init$$$anonfun$10$$anonfun$1(https), MarkerContext$.MODULE$.NoMarker()));
        }
        this.registerShutdownTasks();
        Option<ServerEndpoint> httpEndpoint = this.http2Enabled ? this.Http2Plain() : this.Http1Plain();
        Option<ServerEndpoint> httpsEndpoint = this.http2Enabled ? this.Http2Encrypted() : this.Http1Encrypted();
        this.serverEndpoints = ServerEndpoints$.MODULE$.apply((Seq)Option$.MODULE$.option2Iterable(httpEndpoint).toSeq().$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(httpsEndpoint).toSeq()));
    }

    public Mode mode() {
        return this.context.config().mode();
    }

    public ApplicationProvider applicationProvider() {
        return this.context.appProvider();
    }

    private ServerSettings initialSettings() {
        Object object = this.initialSettings$lzy1;
        if (object instanceof ServerSettings) {
            return (ServerSettings)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ServerSettings)this.initialSettings$lzyINIT1();
    }

    private Object initialSettings$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.initialSettings$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ServerSettings serverSettings = null;
                    try {
                        serverSettings = ServerSettings$.MODULE$.apply(this.pekkoHttpConfig());
                        object2 = serverSettings == null ? LazyVals.NullValue$.MODULE$ : serverSettings;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.initialSettings$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return serverSettings;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Config pekkoHttpConfig() {
        return this.pekkoHttpConfig;
    }

    public Config createPekkoHttpConfig() {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"pekko.http.server.preview.enable-http2");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToBoolean((boolean)this.http2Enabled));
        return Configuration$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).withFallback(Configuration$.MODULE$.apply(this.context.actorSystem().settings().config())).underlying();
    }

    public ParserSettings parserSettings() {
        return this.parserSettings;
    }

    public ParserSettings createParserSettings() {
        return ParserSettings$.MODULE$.apply(this.pekkoHttpConfig()).withMaxContentLength(this.maxContentLength).withMaxHeaderValueLength(this.maxHeaderValueLength).withIncludeTlsSessionInfoHeader(this.includeTlsSessionInfoHeader).withUriParsingMode((Uri.ParsingMode)Uri.ParsingMode$.Relaxed$.MODULE$).withModeledHeaderParsing(false);
    }

    public ServerSettings createServerSettings(int port, org.apache.pekko.http.scaladsl.ConnectionContext connectionContext, boolean secure) {
        return this.initialSettings().withTimeouts(this.initialSettings().timeouts().withIdleTimeout(secure ? this.httpsIdleTimeout : this.httpIdleTimeout).withRequestTimeout(this.requestTimeout)).withRawRequestUriHeader(true).withRemoteAddressHeader(true).withTransparentHeadRequests(this.transparentHeadRequests).withServerHeader(this.serverHeader).withDefaultHostHeader(this.defaultHostHeader).withParserSettings(this.parserSettings()).withPipeliningLimit(this.pipeliningLimit);
    }

    public final PekkoHttpServer$ReloadCacheValues$ play$core$server$PekkoHttpServer$$ReloadCacheValues() {
        return this.ReloadCacheValues$lzy1;
    }

    private Http.ServerBinding createServerBinding(int port, org.apache.pekko.http.scaladsl.ConnectionContext connectionContext, boolean secure) {
        Future future;
        try {
            HttpExt httpExt = Http$.MODULE$.apply((ClassicActorSystemProvider)this.context.actorSystem());
            future = httpExt.bindAndHandleAsync((Function1 & Serializable)_$2 -> this.handleRequest((HttpRequest)_$2, ((ConnectionContext)connectionContext).isSecure()), this.context.config().address(), port, connectionContext, this.createServerSettings(port, connectionContext, secure), httpExt.bindAndHandleAsync$default$6(), httpExt.bindAndHandleAsync$default$7(), this.context.materializer());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 != null) {
                Throwable e = throwable2;
                String string = e.getClass().getSimpleName();
                String string2 = "Http2SupportNotPresentException";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    throw new RuntimeException("HTTP/2 enabled but pekko-http2-support not found. Add .enablePlugins(PlayPekkoHttp2Support) in build.sbt", e);
                }
            }
            throw throwable;
        }
        Future bindingFuture = future;
        return (Http.ServerBinding)Await$.MODULE$.result((Awaitable)bindingFuture, (Duration)this.bindTimeout);
    }

    private SSLContext sslContext() {
        Object object = this.sslContext$lzy1;
        if (object instanceof SSLContext) {
            return (SSLContext)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (SSLContext)this.sslContext$lzyINIT1();
    }

    private Object sslContext$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.sslContext$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    SSLContext sSLContext = null;
                    try {
                        sSLContext = ServerSSLEngine$.MODULE$.createSSLEngineProvider(this.context.config(), this.applicationProvider()).sslContext();
                        object2 = sSLContext == null ? LazyVals.NullValue$.MODULE$ : sSLContext;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.sslContext$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return sSLContext;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<TLSClientAuth> createClientAuth() {
        if (this.httpsNeedClientAuth) {
            return Some$.MODULE$.apply((Object)TLSClientAuth$.MODULE$.need());
        }
        if (this.httpsWantClientAuth) {
            return Some$.MODULE$.apply((Object)TLSClientAuth$.MODULE$.want());
        }
        return None$.MODULE$;
    }

    private HttpErrorHandler errorHandler(Try<Application> tryApp) {
        Try<Application> try_ = tryApp;
        if (try_ instanceof Success) {
            Application app = (Application)((Success)try_).value();
            return app.errorHandler();
        }
        if (try_ instanceof Failure) {
            return this.fallbackErrorHandler();
        }
        throw new MatchError(try_);
    }

    private DefaultHttpErrorHandler fallbackErrorHandler() {
        Object object = this.fallbackErrorHandler$lzy1;
        if (object instanceof DefaultHttpErrorHandler) {
            return (DefaultHttpErrorHandler)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DefaultHttpErrorHandler)this.fallbackErrorHandler$lzyINIT1();
    }

    private Object fallbackErrorHandler$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.fallbackErrorHandler$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DefaultHttpErrorHandler$ defaultHttpErrorHandler$ = null;
                    try {
                        Mode mode = this.mode();
                        Object object3 = defaultHttpErrorHandler$ = Mode.Prod$.MODULE$.equals(mode) ? DefaultHttpErrorHandler$.MODULE$ : DevHttpErrorHandler$.MODULE$;
                        object2 = defaultHttpErrorHandler$ == null ? LazyVals.NullValue$.MODULE$ : defaultHttpErrorHandler$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.fallbackErrorHandler$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return defaultHttpErrorHandler$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private ServerResultUtils resultUtils(Try<Application> tryApp) {
        return ((ReloadCacheValues)this.reloadCache.cachedFrom(tryApp)).resultUtils();
    }

    private PekkoModelConversion modelConversion(Try<Application> tryApp) {
        return ((ReloadCacheValues)this.reloadCache.cachedFrom(tryApp)).modelConversion();
    }

    private Future<HttpResponse> handleRequest(HttpRequest request, boolean secure) {
        Tuple2 tuple2;
        Try<RequestHeader> convertedRequestHeader;
        PekkoHttpServer$.play$core$server$PekkoHttpServer$$$logger.trace(() -> PekkoHttpServer.handleRequest$$anonfun$1(request), MarkerContext$.MODULE$.NoMarker());
        HttpRequest decodedRequest = HttpRequestDecoder$.MODULE$.decodeRequest(request);
        Try tryApp = this.applicationProvider().get();
        InetSocketAddress remoteAddress = this.remoteAddressOfRequest(request);
        Try<RequestHeader> try_ = convertedRequestHeader = this.modelConversion((Try<Application>)tryApp).convertRequestHeader(remoteAddress, secure, decodedRequest);
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            tuple2 = this.clientError$1(tryApp, decodedRequest, secure, remoteAddress, request, Status$.MODULE$.BAD_REQUEST(), exception.getMessage());
        } else if (try_ instanceof Success) {
            RequestHeader untagged = (RequestHeader)((Success)try_).value();
            RequestHeader debugHeader = this.attachDebugInfo$1(tryApp, untagged);
            tuple2 = Server$.MODULE$.getHandlerFor(debugHeader, tryApp, (HttpErrorHandler)this.fallbackErrorHandler());
        } else {
            throw new MatchError(try_);
        }
        Tuple2 tuple22 = tuple2;
        if (!(tuple22 instanceof Tuple2)) {
            throw new MatchError((Object)tuple22);
        }
        Tuple2 tuple23 = tuple22;
        RequestHeader taggedRequestHeader = (RequestHeader)tuple23._1();
        Handler handler = (Handler)tuple23._2();
        Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)taggedRequestHeader, (Object)handler);
        RequestHeader taggedRequestHeader2 = (RequestHeader)tuple24._1();
        Handler handler2 = (Handler)tuple24._2();
        Future<HttpResponse> responseFuture = this.executeHandler((Try<Application>)tryApp, decodedRequest, taggedRequestHeader2, handler2);
        return responseFuture;
    }

    public InetSocketAddress remoteAddressOfRequest(HttpRequest req) {
        Remote.minusAddress minusAddress2;
        RemoteAddress remoteAddress;
        Remote.minusAddress minusAddress3;
        Option option = req.header(ClassTag$.MODULE$.apply(Remote.minusAddress.class));
        if (option instanceof Some && (minusAddress3 = (Remote.minusAddress)((Some)option).value()) != null && (remoteAddress = (minusAddress2 = Remote$minusAddress$.MODULE$.unapply(minusAddress3))._1()) instanceof RemoteAddress.IP) {
            RemoteAddress.IP iP = RemoteAddress.IP$.MODULE$.unapply((RemoteAddress.IP)remoteAddress);
            InetAddress inetAddress = iP._1();
            Option option2 = iP._2();
            InetAddress ip = inetAddress;
            if (option2 instanceof Some) {
                int port = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                return new InetSocketAddress(ip, port);
            }
        }
        throw new IllegalStateException("`Remote-Address` header was missing");
    }

    private Future<HttpResponse> executeHandler(Try<Application> tryApp, HttpRequest request, RequestHeader taggedRequestHeader, Handler handler) {
        Materializer materializer;
        ExecutionContextExecutor executionContextExecutor;
        Option upgradeToWebSocket = request.header(ClassTag$.MODULE$.apply(UpgradeToWebSocket.class));
        Try<Application> try_ = tryApp;
        if (try_ instanceof Success) {
            Application app = (Application)((Success)try_).value();
            executionContextExecutor = app.actorSystem().dispatcher();
        } else if (try_ instanceof Failure) {
            executionContextExecutor = this.context.actorSystem().dispatcher();
        } else {
            throw new MatchError(try_);
        }
        ExecutionContextExecutor defaultExecutionContext = executionContextExecutor;
        Try<Application> try_2 = tryApp;
        if (try_2 instanceof Success) {
            Application app = (Application)((Success)try_2).value();
            materializer = app.materializer();
        } else if (try_2 instanceof Failure) {
            materializer = this.context.materializer();
        } else {
            throw new MatchError(try_2);
        }
        Materializer mat = materializer;
        Either<ByteString, Source<ByteString, Object>> requestBodySource = this.modelConversion(tryApp).convertRequestBody(request);
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)handler, (Object)upgradeToWebSocket);
        if (tuple2 != null) {
            Handler handler2 = (Handler)tuple2._1();
            Option option = (Option)tuple2._2();
            if (handler2 instanceof EssentialAction) {
                EssentialAction action = (EssentialAction)handler2;
                return this.runAction(tryApp, request, taggedRequestHeader, requestBodySource, action, this.errorHandler(tryApp), true, (ExecutionContext)defaultExecutionContext, mat);
            }
            if (handler2 instanceof WebSocket) {
                WebSocket webSocket;
                WebSocket websocket = webSocket = (WebSocket)handler2;
                if (option instanceof Some) {
                    UpgradeToWebSocket upgrade = (UpgradeToWebSocket)((Some)option).value();
                    Future future = FastFuture$.MODULE$.EnhancedFuture(websocket.apply(taggedRequestHeader));
                    Future future2 = new FastFuture(FastFuture.EnhancedFuture$.MODULE$.fast$extension(future)).future();
                    return FastFuture$.MODULE$.flatMap$extension(future2, (Function1 & Serializable)x$1 -> {
                        Either either = x$1;
                        if (either instanceof Left) {
                            Result result = (Result)((Left)either).value();
                            return this.modelConversion(tryApp).convertResult(taggedRequestHeader, result, request.protocol(), this.errorHandler(tryApp), mat);
                        }
                        if (either instanceof Right) {
                            Flow flow = (Flow)((Right)either).value();
                            Option selectedSubprotocol = upgrade.requestedProtocols().headOption();
                            return Future$.MODULE$.successful((Object)WebSocketHandler$.MODULE$.handleWebSocket(upgrade, flow, this.wsBufferLimit, (Option<String>)selectedSubprotocol, this.wsKeepAliveMode, this.wsKeepAliveMaxIdle));
                        }
                        throw new MatchError((Object)either);
                    }, (ExecutionContext)defaultExecutionContext);
                }
                WebSocket websocket2 = webSocket;
                if (None$.MODULE$.equals(option)) {
                    PekkoHttpServer$.play$core$server$PekkoHttpServer$$$logger.trace(() -> PekkoHttpServer.executeHandler$$anonfun$2(request), MarkerContext$.MODULE$.NoMarker());
                    EssentialAction action = EssentialAction$.MODULE$.apply((Function1 & Serializable)_$4 -> {
                        Object[] objectArray = new Tuple2[2];
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.UPGRADE());
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"websocket");
                        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.CONNECTION());
                        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)HeaderNames$.MODULE$.UPGRADE());
                        return Accumulator$.MODULE$.done((Object)Results$.MODULE$.Status(Status$.MODULE$.UPGRADE_REQUIRED()).apply((Object)"Upgrade to WebSocket required", Writeable$.MODULE$.wString(Codec$.MODULE$.utf_8())).withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                    });
                    return this.runAction(tryApp, request, taggedRequestHeader, requestBodySource, action, this.errorHandler(tryApp), this.runAction$default$7(), (ExecutionContext)defaultExecutionContext, mat);
                }
            }
            if (handler2 instanceof PekkoHttpHandler) {
                PekkoHttpHandler pekkoHttpHandler = (PekkoHttpHandler)handler2;
                return (Future)pekkoHttpHandler.apply(request);
            }
            Handler unhandled = handler2;
            throw scala.sys.package$.MODULE$.error("PekkoHttpServer doesn't handle Handlers of this type: " + unhandled);
        }
        throw new MatchError((Object)tuple2);
    }

    private Future<HttpResponse> runAction(Try<Application> tryApp, HttpRequest request, RequestHeader taggedRequestHeader, Either<ByteString, Source<ByteString, ?>> requestBodySource, EssentialAction action, HttpErrorHandler errorHandler, boolean deferredBodyParsingAllowed, ExecutionContext ec, Materializer mat) {
        Either source2 = request.header(ClassTag$.MODULE$.apply(Expect.class)).contains((Object)Expect$.MODULE$.100$minuscontinue()) ? requestBodySource.map((Function1 & Serializable)source -> Source$.MODULE$.lazySource((Function0 & Serializable)() -> source)) : requestBodySource;
        boolean deferBodyParsing = deferredBodyParsingAllowed && Server$.MODULE$.routeModifierDefersBodyParsing(this.serverConfig.underlying().getBoolean("deferBodyParsing"), taggedRequestHeader);
        Future futureAcc = Future$.MODULE$.apply(() -> PekkoHttpServer.$anonfun$6(action, deferBodyParsing, taggedRequestHeader, mat, source2, errorHandler), ec);
        Future resultFuture = PekkoHttpServer.invokeAction$1(mat, source2, errorHandler, taggedRequestHeader, futureAcc, deferBodyParsing);
        Future responseFuture = resultFuture.flatMap((Function1 & Serializable)result -> {
            Result cleanedResult = this.resultUtils(tryApp).prepareCookies(taggedRequestHeader, result);
            return this.modelConversion(tryApp).convertResult(taggedRequestHeader, cleanedResult, request.protocol(), errorHandler, mat);
        }, ec);
        return responseFuture;
    }

    private boolean runAction$default$7() {
        return false;
    }

    public void stop() {
        CoordinatedShutdownSupport$.MODULE$.syncShutdown(this.context.actorSystem(), (CoordinatedShutdown.Reason)Server.ServerStoppedReason$.MODULE$);
    }

    private void registerShutdownTasks() {
        ExecutionContextExecutor exCtx = this.context.actorSystem().dispatcher();
        CoordinatedShutdown cs = (CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this.context.actorSystem());
        cs.addTask(CoordinatedShutdown$.MODULE$.PhaseBeforeServiceUnbind(), "trace-server-stop-request", (Function0 & Serializable)() -> {
            Mode mode = this.mode();
            Mode.Test$ test$ = Mode.Test$.MODULE$;
            if (mode == null ? test$ != null : !mode.equals(test$)) {
                PekkoHttpServer$.play$core$server$PekkoHttpServer$$$logger.info(PekkoHttpServer::registerShutdownTasks$$anonfun$1$$anonfun$1, MarkerContext$.MODULE$.NoMarker());
            }
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        });
        FiniteDuration serverTerminateTimeout = Server$.MODULE$.determineServerTerminateTimeout(this.terminationTimeout, this.terminationDelay, this.context.actorSystem());
        cs.addTask(CoordinatedShutdown$.MODULE$.PhaseServiceUnbind(), "pekko-http-server-unbind", () -> this.registerShutdownTasks$$anonfun$2((ExecutionContext)exCtx));
        cs.addTask(CoordinatedShutdown$.MODULE$.PhaseServiceRequestsDone(), "pekko-http-server-terminate", () -> this.registerShutdownTasks$$anonfun$3(serverTerminateTimeout, (ExecutionContext)exCtx));
        cs.addTask(CoordinatedShutdown$.MODULE$.PhaseBeforeActorSystemTerminate(), "user-provided-server-stop-hook", () -> this.registerShutdownTasks$$anonfun$4((ExecutionContext)exCtx));
        cs.addTask(CoordinatedShutdown$.MODULE$.PhaseBeforeActorSystemTerminate(), "shutdown-logger", () -> this.registerShutdownTasks$$anonfun$5((ExecutionContext)exCtx));
    }

    public InetSocketAddress mainAddress() {
        Object object = this.mainAddress$lzy1;
        if (object instanceof InetSocketAddress) {
            return (InetSocketAddress)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (InetSocketAddress)this.mainAddress$lzyINIT1();
    }

    private Object mainAddress$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.mainAddress$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    InetSocketAddress inetSocketAddress = null;
                    try {
                        inetSocketAddress = (InetSocketAddress)this.httpServerBinding.orElse(this::mainAddress$lzyINIT1$$anonfun$1).map((Function1 & Serializable)_$7 -> _$7.localAddress()).get();
                        object2 = inetSocketAddress == null ? LazyVals.NullValue$.MODULE$ : inetSocketAddress;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.mainAddress$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return inetSocketAddress;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Option<ServerEndpoint> Http1Plain() {
        Object object = this.Http1Plain$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.Http1Plain$lzyINIT1();
    }

    private Object Http1Plain$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Http1Plain$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        option = this.httpServerBinding.map((Function1 & Serializable)_$8 -> _$8.localAddress()).map((Function1 & Serializable)address -> ServerEndpoint$.MODULE$.apply("Pekko HTTP HTTP/1.1 (plaintext)", "http", this.context.config().address(), address.getPort(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{HttpProtocol$.MODULE$.HTTP_1_0(), HttpProtocol$.MODULE$.HTTP_1_1()})), this.serverHeaderConfig, (Option)None$.MODULE$));
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Http1Plain$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Option<ServerEndpoint> Http1Encrypted() {
        Object object = this.Http1Encrypted$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.Http1Encrypted$lzyINIT1();
    }

    private Object Http1Encrypted$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Http1Encrypted$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        option = this.httpsServerBinding.map((Function1 & Serializable)_$9 -> _$9.localAddress()).map((Function1 & Serializable)address -> ServerEndpoint$.MODULE$.apply("Pekko HTTP HTTP/1.1 (encrypted)", "https", this.context.config().address(), address.getPort(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{HttpProtocol$.MODULE$.HTTP_1_0(), HttpProtocol$.MODULE$.HTTP_1_1()})), this.serverHeaderConfig, Option$.MODULE$.apply((Object)this.sslContext())));
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Http1Encrypted$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Option<ServerEndpoint> Http2Plain() {
        Object object = this.Http2Plain$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.Http2Plain$lzyINIT1();
    }

    private Object Http2Plain$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Http2Plain$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        option = this.httpServerBinding.map((Function1 & Serializable)_$10 -> _$10.localAddress()).map((Function1 & Serializable)address -> ServerEndpoint$.MODULE$.apply("Pekko HTTP HTTP/2 (plaintext)", "http", this.context.config().address(), address.getPort(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{HttpProtocol$.MODULE$.HTTP_2_0()})), this.serverHeaderConfig, (Option)None$.MODULE$));
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Http2Plain$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Option<ServerEndpoint> Http2Encrypted() {
        Object object = this.Http2Encrypted$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.Http2Encrypted$lzyINIT1();
    }

    private Object Http2Encrypted$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Http2Encrypted$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        option = this.httpsServerBinding.map((Function1 & Serializable)_$11 -> _$11.localAddress()).map((Function1 & Serializable)address -> ServerEndpoint$.MODULE$.apply("Pekko HTTP HTTP/2 (encrypted)", "https", this.context.config().address(), address.getPort(), (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{HttpProtocol$.MODULE$.HTTP_1_0(), HttpProtocol$.MODULE$.HTTP_1_1(), HttpProtocol$.MODULE$.HTTP_2_0()})), this.serverHeaderConfig, Option$.MODULE$.apply((Object)this.sslContext())));
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Http2Encrypted$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ServerEndpoints serverEndpoints() {
        return this.serverEndpoints;
    }

    private static final boolean $init$$$anonfun$3() {
        return false;
    }

    private final /* synthetic */ Http.ServerBinding $init$$$anonfun$4(int port) {
        return this.createServerBinding(port, (org.apache.pekko.http.scaladsl.ConnectionContext)HttpConnectionContext$.MODULE$.apply(), false);
    }

    private static final String $anonfun$1() {
        return "Cannot load SSL context";
    }

    private static final Throwable $anonfun$2(Throwable e$1) {
        return e$1;
    }

    private final /* synthetic */ Http.ServerBinding $init$$$anonfun$5(int port) {
        HttpsConnectionContext httpsConnectionContext;
        try {
            Option<TLSClientAuth> clientAuth = this.createClientAuth();
            SSLContext sSLContext = this.sslContext();
            Option option = ConnectionContext$.MODULE$.https$default$2();
            Option option2 = ConnectionContext$.MODULE$.https$default$3();
            Option option3 = ConnectionContext$.MODULE$.https$default$4();
            Option option4 = ConnectionContext$.MODULE$.https$default$6();
            httpsConnectionContext = ConnectionContext$.MODULE$.https(sSLContext, option, option2, option3, clientAuth, option4);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                PekkoHttpServer$.play$core$server$PekkoHttpServer$$$logger.error(PekkoHttpServer::$anonfun$1, () -> PekkoHttpServer.$anonfun$2(e), MarkerContext$.MODULE$.NoMarker());
                httpsConnectionContext = ConnectionContext$.MODULE$.noEncryption();
            }
            throw throwable;
        }
        HttpsConnectionContext connectionContext = httpsConnectionContext;
        return this.createServerBinding(port, (org.apache.pekko.http.scaladsl.ConnectionContext)connectionContext, true);
    }

    private static final String $init$$$anonfun$6() {
        return "Enabling HTTP/2 on Pekko HTTP server...";
    }

    private static final String $init$$$anonfun$7(String logMessage$1) {
        return logMessage$1;
    }

    private static final String $init$$$anonfun$8(String logMessage$2) {
        return logMessage$2;
    }

    private static final String $init$$$anonfun$9$$anonfun$1(Http.ServerBinding http$1) {
        return "Listening for HTTP on " + http$1.localAddress();
    }

    private static final String $init$$$anonfun$10$$anonfun$1(Http.ServerBinding https$1) {
        return "Listening for HTTPS on " + https$1.localAddress();
    }

    private static final String handleRequest$$anonfun$1(HttpRequest request$1) {
        return "Http request received by pekko-http: " + request$1;
    }

    private final RequestHeader attachDebugInfo$1(Try tryApp$1, RequestHeader rh) {
        Option<ServerDebugInfo> debugInfo = ((ReloadCacheValues)this.reloadCache.cachedFrom(tryApp$1)).serverDebugInfo();
        return ServerDebugInfo$.MODULE$.attachToRequestHeader(rh, debugInfo);
    }

    private final Tuple2 clientError$1(Try tryApp$2, HttpRequest decodedRequest$1, boolean secure$1, InetSocketAddress remoteAddress$1, HttpRequest request$2, int statusCode, String message) {
        PekkoHeadersWrapper headers = this.modelConversion((Try<Application>)tryApp$2).convertRequestHeadersPekko(decodedRequest$1);
        RequestTarget unparsedTarget = Server$.MODULE$.createUnparsedRequestTarget(headers.uri());
        RequestHeader requestHeader = this.modelConversion((Try<Application>)tryApp$2).createRequestHeader(headers, secure$1, remoteAddress$1, unparsedTarget, request$2);
        RequestHeader debugHeader = this.attachDebugInfo$1(tryApp$2, requestHeader);
        Future result = this.errorHandler((Try<Application>)tryApp$2).onClientError(debugHeader.addAttr(HttpErrorHandler.Attrs$.MODULE$.HttpErrorInfo(), (Object)HttpErrorInfo$.MODULE$.apply("server-backend")), statusCode, message == null ? "" : message);
        RequestHeader requestHeader2 = (RequestHeader)Predef$.MODULE$.ArrowAssoc((Object)debugHeader);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)requestHeader2, (Object)Server$.MODULE$.actionForResult(result.map((Function1 & Serializable)_$3 -> {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.CONNECTION());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"close");
            return _$3.withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline())));
    }

    private static final String executeHandler$$anonfun$2(HttpRequest request$4) {
        return "Bad websocket request: " + request$4;
    }

    private static final Future invokeAction$1(Materializer mat$3, Either source$3, HttpErrorHandler errorHandler$1, RequestHeader taggedRequestHeader$2, Future futureAcc, boolean deferBodyParsing) {
        Future future = FastFuture$.MODULE$.EnhancedFuture(futureAcc);
        Future future2 = new FastFuture(FastFuture.EnhancedFuture$.MODULE$.fast$extension(future)).future();
        return FastFuture$.MODULE$.flatMap$extension(future2, (Function1 & Serializable)actionAccumulator -> {
            if (deferBodyParsing) {
                return actionAccumulator.run(mat$3);
            }
            Either either = source$3;
            if (either instanceof Left) {
                ByteString byteString = (ByteString)((Left)either).value();
                ByteString bytes = byteString;
                if (bytes.isEmpty()) {
                    return actionAccumulator.run(mat$3);
                }
                ByteString bytes2 = byteString;
                return actionAccumulator.run((Object)bytes2, mat$3);
            }
            if (either instanceof Right) {
                Source s = (Source)((Right)either).value();
                return actionAccumulator.run(s, mat$3);
            }
            throw new MatchError((Object)either);
        }, (ExecutionContext)mat$3.executionContext()).recoverWith((PartialFunction)new Serializable(errorHandler$1, taggedRequestHeader$2){
            private final HttpErrorHandler errorHandler$2;
            private final RequestHeader taggedRequestHeader$3;
            {
                this.errorHandler$2 = errorHandler$5;
                this.taggedRequestHeader$3 = taggedRequestHeader$6;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof EntityStreamSizeException) {
                    return true;
                }
                if (throwable != null) {
                    Throwable e = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof EntityStreamSizeException) {
                    return this.errorHandler$2.onClientError(this.taggedRequestHeader$3.addAttr(HttpErrorHandler.Attrs$.MODULE$.HttpErrorInfo(), (Object)HttpErrorInfo$.MODULE$.apply("server-backend")), Status$.MODULE$.REQUEST_ENTITY_TOO_LARGE(), "Request Entity Too Large");
                }
                if (throwable != null) {
                    Throwable e = throwable;
                    return this.errorHandler$2.onServerError(this.taggedRequestHeader$3, e);
                }
                return function1.apply((Object)x);
            }
        }, (ExecutionContext)mat$3.executionContext());
    }

    private static final Accumulator $anonfun$6(EssentialAction action$1, boolean deferBodyParsing$2, RequestHeader taggedRequestHeader$4, Materializer mat$4, Either source$4, HttpErrorHandler errorHandler$3) {
        return (Accumulator)action$1.apply((Object)(deferBodyParsing$2 ? taggedRequestHeader$4.addAttr(RequestAttrKey$.MODULE$.DeferredBodyParsing(), (Function2 & Serializable)(futureAcc, deferBodyParsing) -> PekkoHttpServer.invokeAction$1(mat$4, source$4, errorHandler$3, taggedRequestHeader$4, (Future)futureAcc, BoxesRunTime.unboxToBoolean((Object)deferBodyParsing))) : taggedRequestHeader$4));
    }

    private static final String registerShutdownTasks$$anonfun$1$$anonfun$1() {
        return "Stopping Pekko HTTP server...";
    }

    private static final String unbind$1$$anonfun$1$$anonfun$1(Http.ServerBinding binding$1) {
        return "Unbinding " + binding$1.localAddress();
    }

    private static final Future unbind$1$$anonfun$2() {
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    private static final Future unbind$1(Option binding2) {
        return (Future)binding2.map((Function1 & Serializable)binding -> {
            PekkoHttpServer$.play$core$server$PekkoHttpServer$$$logger.info(() -> PekkoHttpServer.unbind$1$$anonfun$1$$anonfun$1(binding), MarkerContext$.MODULE$.NoMarker());
            return binding.unbind();
        }).getOrElse(PekkoHttpServer::unbind$1$$anonfun$2);
    }

    private final /* synthetic */ Future registerShutdownTasks$$anonfun$2(ExecutionContext exCtx$1) {
        return PekkoHttpServer.unbind$1(this.httpServerBinding).flatMap((Function1 & Serializable)x$12 -> {
            Done done = x$12;
            return PekkoHttpServer.unbind$1(this.httpsServerBinding).map((Function1 & Serializable)x$1 -> {
                Done done = x$1;
                return Done$.MODULE$;
            }, exCtx$1);
        }, exCtx$1);
    }

    private static final String terminate$1$$anonfun$1$$anonfun$1$$anonfun$1(Http.ServerBinding binding$3) {
        return "Terminating server binding for " + binding$3.localAddress();
    }

    private static final Future terminate$1$$anonfun$1$$anonfun$1(Http.ServerBinding binding$2, FiniteDuration serverTerminateTimeout$1, ExecutionContext exCtx$3) {
        PekkoHttpServer$.play$core$server$PekkoHttpServer$$$logger.info(() -> PekkoHttpServer.terminate$1$$anonfun$1$$anonfun$1$$anonfun$1(binding$2), MarkerContext$.MODULE$.NoMarker());
        return binding$2.terminate(serverTerminateTimeout$1.$minus(new package.DurationInt(package$.MODULE$.DurationInt(100)).millis())).map((Function1 & Serializable)_$5 -> Done$.MODULE$, exCtx$3);
    }

    private static final Future terminate$1$$anonfun$2() {
        return Future$.MODULE$.successful((Object)Done$.MODULE$);
    }

    private final Future terminate$1(FiniteDuration serverTerminateTimeout$3, ExecutionContext exCtx$5, Option binding2) {
        return (Future)binding2.map((Function1 & Serializable)binding -> org.apache.pekko.pattern.package$.MODULE$.after(this.terminationDelay, () -> PekkoHttpServer.terminate$1$$anonfun$1$$anonfun$1(binding, serverTerminateTimeout$3, exCtx$5), (ClassicActorSystemProvider)this.context.actorSystem())).getOrElse(PekkoHttpServer::terminate$1$$anonfun$2);
    }

    private final /* synthetic */ Future registerShutdownTasks$$anonfun$3(FiniteDuration serverTerminateTimeout$2, ExecutionContext exCtx$4) {
        return this.terminate$1(serverTerminateTimeout$2, exCtx$4, this.httpServerBinding).flatMap((Function1 & Serializable)x$12 -> {
            Done done = x$12;
            return this.terminate$1(serverTerminateTimeout$2, exCtx$4, this.httpsServerBinding).map((Function1 & Serializable)x$1 -> {
                Done done = x$1;
                return Done$.MODULE$;
            }, exCtx$4);
        }, exCtx$4);
    }

    private static final String registerShutdownTasks$$anonfun$4$$anonfun$1() {
        return "Running provided shutdown stop hooks";
    }

    private final /* synthetic */ Future registerShutdownTasks$$anonfun$4(ExecutionContext exCtx$8) {
        PekkoHttpServer$.play$core$server$PekkoHttpServer$$$logger.info(PekkoHttpServer::registerShutdownTasks$$anonfun$4$$anonfun$1, MarkerContext$.MODULE$.NoMarker());
        return ((Future)this.context.stopHook().apply()).map((Function1 & Serializable)_$6 -> Done$.MODULE$, exCtx$8);
    }

    private final Done$ registerShutdownTasks$$anonfun$5$$anonfun$1() {
        Server.stop$((Server)this);
        return Done$.MODULE$;
    }

    private final /* synthetic */ Future registerShutdownTasks$$anonfun$5(ExecutionContext exCtx$9) {
        return Future$.MODULE$.apply(this::registerShutdownTasks$$anonfun$5$$anonfun$1, exCtx$9);
    }

    private final Option mainAddress$lzyINIT1$$anonfun$1() {
        return this.httpsServerBinding;
    }

    public static final class Context
    implements Product,
    Serializable {
        private final ServerConfig config;
        private final ApplicationProvider appProvider;
        private final ActorSystem actorSystem;
        private final Materializer materializer;
        private final Function0 stopHook;

        public static Context apply(ServerConfig serverConfig, ApplicationProvider applicationProvider, ActorSystem actorSystem, Materializer materializer, Function0<Future<?>> function0) {
            return PekkoHttpServer$Context$.MODULE$.apply(serverConfig, applicationProvider, actorSystem, materializer, function0);
        }

        public static Context fromComponents(ServerConfig serverConfig, Application application, Function0<Future<?>> function0) {
            return PekkoHttpServer$Context$.MODULE$.fromComponents(serverConfig, application, function0);
        }

        public static Context fromProduct(Product product) {
            return PekkoHttpServer$Context$.MODULE$.fromProduct(product);
        }

        public static Context fromServerProviderContext(ServerProvider.Context context) {
            return PekkoHttpServer$Context$.MODULE$.fromServerProviderContext(context);
        }

        public static Context unapply(Context context) {
            return PekkoHttpServer$Context$.MODULE$.unapply(context);
        }

        public static Function0<Future<?>> fromComponents$default$3() {
            return PekkoHttpServer$Context$.MODULE$.fromComponents$default$3();
        }

        public Context(ServerConfig config, ApplicationProvider appProvider, ActorSystem actorSystem, Materializer materializer, Function0<Future<?>> stopHook) {
            this.config = config;
            this.appProvider = appProvider;
            this.actorSystem = actorSystem;
            this.materializer = materializer;
            this.stopHook = stopHook;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Context)) return false;
            Context context = (Context)object;
            ServerConfig serverConfig = this.config();
            ServerConfig serverConfig2 = context.config();
            if (serverConfig == null) {
                if (serverConfig2 != null) {
                    return false;
                }
            } else if (!serverConfig.equals(serverConfig2)) return false;
            ApplicationProvider applicationProvider = this.appProvider();
            ApplicationProvider applicationProvider2 = context.appProvider();
            if (applicationProvider == null) {
                if (applicationProvider2 != null) {
                    return false;
                }
            } else if (!applicationProvider.equals(applicationProvider2)) return false;
            ActorSystem actorSystem = this.actorSystem();
            ActorSystem actorSystem2 = context.actorSystem();
            if (actorSystem == null) {
                if (actorSystem2 != null) {
                    return false;
                }
            } else if (!actorSystem.equals(actorSystem2)) return false;
            Materializer materializer = this.materializer();
            Materializer materializer2 = context.materializer();
            if (materializer == null) {
                if (materializer2 != null) {
                    return false;
                }
            } else if (!materializer.equals(materializer2)) return false;
            Function0<Future<?>> function0 = this.stopHook();
            Function0<Future<?>> function02 = context.stopHook();
            if (function0 == null) {
                if (function02 == null) return true;
                return false;
            } else {
                if (!function0.equals(function02)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Context;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Context";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "config";
                }
                case 1: {
                    return "appProvider";
                }
                case 2: {
                    return "actorSystem";
                }
                case 3: {
                    return "materializer";
                }
                case 4: {
                    return "stopHook";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ServerConfig config() {
            return this.config;
        }

        public ApplicationProvider appProvider() {
            return this.appProvider;
        }

        public ActorSystem actorSystem() {
            return this.actorSystem;
        }

        public Materializer materializer() {
            return this.materializer;
        }

        public Function0<Future<?>> stopHook() {
            return this.stopHook;
        }

        public Context copy(ServerConfig config, ApplicationProvider appProvider, ActorSystem actorSystem, Materializer materializer, Function0<Future<?>> stopHook) {
            return new Context(config, appProvider, actorSystem, materializer, stopHook);
        }

        public ServerConfig copy$default$1() {
            return this.config();
        }

        public ApplicationProvider copy$default$2() {
            return this.appProvider();
        }

        public ActorSystem copy$default$3() {
            return this.actorSystem();
        }

        public Materializer copy$default$4() {
            return this.materializer();
        }

        public Function0<Future<?>> copy$default$5() {
            return this.stopHook();
        }

        public ServerConfig _1() {
            return this.config();
        }

        public ApplicationProvider _2() {
            return this.appProvider();
        }

        public ActorSystem _3() {
            return this.actorSystem();
        }

        public Materializer _4() {
            return this.materializer();
        }

        public Function0<Future<?>> _5() {
            return this.stopHook();
        }
    }

    public class ReloadCacheValues
    implements Product,
    Serializable {
        private final ServerResultUtils resultUtils;
        private final PekkoModelConversion modelConversion;
        private final Option serverDebugInfo;
        private final /* synthetic */ PekkoHttpServer $outer;

        public ReloadCacheValues(PekkoHttpServer $outer, ServerResultUtils resultUtils, PekkoModelConversion modelConversion, Option<ServerDebugInfo> serverDebugInfo) {
            this.resultUtils = resultUtils;
            this.modelConversion = modelConversion;
            this.serverDebugInfo = serverDebugInfo;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReloadCacheValues)) return false;
            if (((ReloadCacheValues)object).play$core$server$PekkoHttpServer$ReloadCacheValues$$$outer() != this.$outer) return false;
            ReloadCacheValues reloadCacheValues = (ReloadCacheValues)object;
            ServerResultUtils serverResultUtils = this.resultUtils();
            ServerResultUtils serverResultUtils2 = reloadCacheValues.resultUtils();
            if (serverResultUtils == null) {
                if (serverResultUtils2 != null) {
                    return false;
                }
            } else if (!serverResultUtils.equals(serverResultUtils2)) return false;
            PekkoModelConversion pekkoModelConversion = this.modelConversion();
            PekkoModelConversion pekkoModelConversion2 = reloadCacheValues.modelConversion();
            if (pekkoModelConversion == null) {
                if (pekkoModelConversion2 != null) {
                    return false;
                }
            } else if (!pekkoModelConversion.equals(pekkoModelConversion2)) return false;
            Option<ServerDebugInfo> option = this.serverDebugInfo();
            Option<ServerDebugInfo> option2 = reloadCacheValues.serverDebugInfo();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!reloadCacheValues.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ReloadCacheValues;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ReloadCacheValues";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "resultUtils";
                }
                case 1: {
                    return "modelConversion";
                }
                case 2: {
                    return "serverDebugInfo";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ServerResultUtils resultUtils() {
            return this.resultUtils;
        }

        public PekkoModelConversion modelConversion() {
            return this.modelConversion;
        }

        public Option<ServerDebugInfo> serverDebugInfo() {
            return this.serverDebugInfo;
        }

        public ReloadCacheValues copy(ServerResultUtils resultUtils, PekkoModelConversion modelConversion, Option<ServerDebugInfo> serverDebugInfo) {
            return new ReloadCacheValues(this.$outer, resultUtils, modelConversion, serverDebugInfo);
        }

        public ServerResultUtils copy$default$1() {
            return this.resultUtils();
        }

        public PekkoModelConversion copy$default$2() {
            return this.modelConversion();
        }

        public Option<ServerDebugInfo> copy$default$3() {
            return this.serverDebugInfo();
        }

        public ServerResultUtils _1() {
            return this.resultUtils();
        }

        public PekkoModelConversion _2() {
            return this.modelConversion();
        }

        public Option<ServerDebugInfo> _3() {
            return this.serverDebugInfo();
        }

        public final /* synthetic */ PekkoHttpServer play$core$server$PekkoHttpServer$ReloadCacheValues$$$outer() {
            return this.$outer;
        }
    }
}

