/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.pekkohttp;

import java.io.Serializable;
import java.util.Locale;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader$;
import org.apache.pekko.util.ByteString;
import play.api.mvc.Headers;
import play.core.server.pekkohttp.PekkoHeadersWrapper$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public final class PekkoHeadersWrapper
extends Headers
implements Product,
Serializable {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(PekkoHeadersWrapper.class.getDeclaredField("keys$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(PekkoHeadersWrapper.class.getDeclaredField("headers$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(PekkoHeadersWrapper.class.getDeclaredField("contentType$lzy1"));
    private final HttpRequest request;
    private final Option knownContentLength;
    private final Seq hs;
    private final Option isChunked;
    private final String uri;
    private volatile Object contentType$lzy1;
    private volatile Object headers$lzy1;
    private volatile Object keys$lzy1;

    public static String CONTENT_LENGTH_LOWER_CASE() {
        return PekkoHeadersWrapper$.MODULE$.CONTENT_LENGTH_LOWER_CASE();
    }

    public static String CONTENT_TYPE_LOWER_CASE() {
        return PekkoHeadersWrapper$.MODULE$.CONTENT_TYPE_LOWER_CASE();
    }

    public static String TRANSFER_ENCODING_LOWER_CASE() {
        return PekkoHeadersWrapper$.MODULE$.TRANSFER_ENCODING_LOWER_CASE();
    }

    public static PekkoHeadersWrapper fromProduct(Product product) {
        return PekkoHeadersWrapper$.MODULE$.fromProduct(product);
    }

    public static PekkoHeadersWrapper unapply(PekkoHeadersWrapper pekkoHeadersWrapper) {
        return PekkoHeadersWrapper$.MODULE$.unapply(pekkoHeadersWrapper);
    }

    public PekkoHeadersWrapper(HttpRequest request, Option<String> knownContentLength, Seq<HttpHeader> hs, Option<String> isChunked, String uri) {
        this.request = request;
        this.knownContentLength = knownContentLength;
        this.hs = hs;
        this.isChunked = isChunked;
        this.uri = uri;
        super(null);
    }

    public boolean canEqual(Object that) {
        return that instanceof PekkoHeadersWrapper;
    }

    public int productArity() {
        return 5;
    }

    public String productPrefix() {
        return "PekkoHeadersWrapper";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "request";
            }
            case 1: {
                return "knownContentLength";
            }
            case 2: {
                return "hs";
            }
            case 3: {
                return "isChunked";
            }
            case 4: {
                return "uri";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public HttpRequest request() {
        return this.request;
    }

    public Option<String> knownContentLength() {
        return this.knownContentLength;
    }

    public Seq<HttpHeader> hs() {
        return this.hs;
    }

    public Option<String> isChunked() {
        return this.isChunked;
    }

    public String uri() {
        return this.uri;
    }

    private Option<String> contentType() {
        Object object = this.contentType$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.contentType$lzyINIT1();
    }

    private Object contentType$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.contentType$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    None$ none$ = null;
                    try {
                        ContentType contentType = this.request().entity().contentType();
                        ContentType.Binary binary = ContentTypes$.MODULE$.NoContentType();
                        None$ none$2 = !(contentType != null ? !contentType.equals(binary) : binary != null) ? None$.MODULE$ : (none$ = Some$.MODULE$.apply((Object)this.request().entity().contentType().value()));
                        object2 = none$ == null ? LazyVals.NullValue$.MODULE$ : none$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.contentType$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return none$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Seq<Tuple2<String, String>> headers() {
        Object object = this.headers$lzy1;
        if (object instanceof Seq) {
            return (Seq)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Seq)this.headers$lzyINIT1();
    }

    private Object headers$lzyINIT1() {
        Object object;
        block15: {
            while (true) {
                if ((object = this.headers$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Seq seq = null;
                    try {
                        Seq h2;
                        Seq seq2;
                        Seq seq3;
                        Seq seq4;
                        Seq h3 = (Seq)this.hs().map((Function1 & Serializable)h -> {
                            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)h.name());
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)h.value());
                        });
                        Option<String> option = this.contentType();
                        if (option instanceof Some) {
                            String ct = (String)((Some)option).value();
                            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Content-Type");
                            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)ct);
                            seq4 = (Seq)h3.$plus$colon((Object)tuple2);
                        } else if (None$.MODULE$.equals(option)) {
                            seq4 = h3;
                        } else {
                            throw new MatchError(option);
                        }
                        Seq h0 = seq4;
                        Option<String> option2 = this.knownContentLength();
                        if (option2 instanceof Some) {
                            String cl = (String)((Some)option2).value();
                            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Content-Length");
                            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)cl);
                            seq3 = (Seq)h0.$plus$colon((Object)tuple2);
                        } else {
                            seq3 = h0;
                        }
                        Seq h1 = seq3;
                        Option<String> option3 = this.isChunked();
                        if (option3 instanceof Some) {
                            String ch = (String)((Some)option3).value();
                            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Transfer-Encoding");
                            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)ch);
                            seq2 = (Seq)h1.$plus$colon((Object)tuple2);
                        } else {
                            seq2 = h1;
                        }
                        seq = h2 = seq2;
                        object2 = seq == null ? LazyVals.NullValue$.MODULE$ : seq;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.headers$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.headers$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return seq;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block15;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean hasHeader(String headerName) {
        String string = headerName.toLowerCase(Locale.ROOT);
        String string2 = PekkoHeadersWrapper$.MODULE$.CONTENT_LENGTH_LOWER_CASE();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return this.knownContentLength().isDefined();
        }
        String string4 = PekkoHeadersWrapper$.MODULE$.TRANSFER_ENCODING_LOWER_CASE();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return this.isChunked().isDefined();
        }
        String string6 = PekkoHeadersWrapper$.MODULE$.CONTENT_TYPE_LOWER_CASE();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return this.contentType().isDefined();
        }
        return this.get(headerName).isDefined();
    }

    public boolean hasBody() {
        RequestEntity requestEntity = this.request().entity();
        if (requestEntity instanceof HttpEntity.Strict) {
            HttpEntity.Strict strict = HttpEntity.Strict$.MODULE$.unapply((HttpEntity.Strict)requestEntity);
            ContentType contentType = strict._1();
            ByteString byteString = strict._2();
            ByteString data = byteString;
            return data.length() > 0;
        }
        return true;
    }

    public String apply(String key) {
        return (String)this.get(key).getOrElse(() -> PekkoHeadersWrapper.apply$$anonfun$1(key));
    }

    public Option<String> get(String key) {
        String string = key.toLowerCase(Locale.ROOT);
        String string2 = PekkoHeadersWrapper$.MODULE$.CONTENT_LENGTH_LOWER_CASE();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return this.knownContentLength();
        }
        String string4 = PekkoHeadersWrapper$.MODULE$.TRANSFER_ENCODING_LOWER_CASE();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return this.isChunked();
        }
        String string6 = PekkoHeadersWrapper$.MODULE$.CONTENT_TYPE_LOWER_CASE();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return this.contentType();
        }
        String lowerCased = string;
        return this.hs().collectFirst((PartialFunction)new Serializable(lowerCased){
            private final String lowerCased$1;
            {
                this.lowerCased$1 = lowerCased$3;
            }

            public final boolean isDefinedAt(HttpHeader x) {
                HttpHeader httpHeader = x;
                HttpHeader h = httpHeader;
                return h.is(this.lowerCased$1);
            }

            public final Object applyOrElse(HttpHeader x, Function1 function1) {
                HttpHeader httpHeader = x;
                HttpHeader h = httpHeader;
                if (h.is(this.lowerCased$1)) {
                    return h.value();
                }
                return function1.apply((Object)x);
            }
        });
    }

    public Seq<String> getAll(String key) {
        String string = key.toLowerCase(Locale.ROOT);
        String string2 = PekkoHeadersWrapper$.MODULE$.CONTENT_LENGTH_LOWER_CASE();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return this.knownContentLength().toList();
        }
        String string4 = PekkoHeadersWrapper$.MODULE$.TRANSFER_ENCODING_LOWER_CASE();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return this.isChunked().toList();
        }
        String string6 = PekkoHeadersWrapper$.MODULE$.CONTENT_TYPE_LOWER_CASE();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return this.contentType().toList();
        }
        String lowerCased = string;
        return (Seq)this.hs().collect((PartialFunction)new Serializable(lowerCased){
            private final String lowerCased$2;
            {
                this.lowerCased$2 = lowerCased$4;
            }

            public final boolean isDefinedAt(HttpHeader x) {
                HttpHeader httpHeader = x;
                HttpHeader h = httpHeader;
                return h.is(this.lowerCased$2);
            }

            public final Object applyOrElse(HttpHeader x, Function1 function1) {
                HttpHeader httpHeader = x;
                HttpHeader h = httpHeader;
                if (h.is(this.lowerCased$2)) {
                    return h.value();
                }
                return function1.apply((Object)x);
            }
        });
    }

    public Set<String> keys() {
        Object object = this.keys$lzy1;
        if (object instanceof Set) {
            return (Set)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Set)this.keys$lzyINIT1();
    }

    private Object keys$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.keys$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Set set = null;
                    try {
                        set = (Set)((IterableOnceOps)this.hs().map((Function1 & Serializable)_$5 -> _$5.name())).toSet().$plus$plus((IterableOnce)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{PekkoHeadersWrapper$.MODULE$.CONTENT_LENGTH_LOWER_CASE(), PekkoHeadersWrapper$.MODULE$.TRANSFER_ENCODING_LOWER_CASE(), PekkoHeadersWrapper$.MODULE$.CONTENT_TYPE_LOWER_CASE()}))).filter((Function1 & Serializable)headerName -> this.hasHeader((String)headerName)));
                        object2 = set == null ? LazyVals.NullValue$.MODULE$ : set;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.keys$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.keys$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return set;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public PekkoHeadersWrapper add(Seq<Tuple2<String, String>> headers) {
        Seq seq = (Seq)this.hs().$plus$plus(this.raw(headers));
        HttpRequest httpRequest = this.copy$default$1();
        Option<String> option = this.copy$default$2();
        Option<String> option2 = this.copy$default$4();
        String string = this.copy$default$5();
        return this.copy(httpRequest, option, (Seq<HttpHeader>)seq, option2, string);
    }

    public Headers remove(Seq<String> keys) {
        Seq lowerCasedKeys = (Seq)keys.map((Function1 & Serializable)_$6 -> _$6.toLowerCase(Locale.ROOT));
        Seq seq = (Seq)this.hs().filterNot((Function1 & Serializable)h -> lowerCasedKeys.exists((Function1 & Serializable)nameInLowerCase -> h.is(nameInLowerCase)));
        Option<String> option = lowerCasedKeys.contains((Object)PekkoHeadersWrapper$.MODULE$.CONTENT_LENGTH_LOWER_CASE()) ? None$.MODULE$ : this.knownContentLength();
        HttpRequest httpRequest = lowerCasedKeys.contains((Object)PekkoHeadersWrapper$.MODULE$.CONTENT_TYPE_LOWER_CASE()) ? this.request().mapEntity((Function1 & Serializable)_$7 -> _$7.withContentType((ContentType)ContentTypes$.MODULE$.NoContentType())) : this.request();
        Option<String> option2 = this.copy$default$4();
        String string = this.copy$default$5();
        return this.copy(httpRequest, option, (Seq<HttpHeader>)seq, option2, string);
    }

    public Headers replace(Seq<Tuple2<String, String>> headers) {
        return this.remove((Seq<String>)((Seq)headers.map((Function1 & Serializable)_$8 -> (String)_$8._1()))).add(headers);
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof PekkoHeadersWrapper) {
            PekkoHeadersWrapper that = (PekkoHeadersWrapper)object;
            HttpRequest httpRequest = that.request();
            HttpRequest httpRequest2 = this.request();
            return !(httpRequest != null ? !httpRequest.equals(httpRequest2) : httpRequest2 != null);
        }
        return false;
    }

    private Seq<RawHeader> raw(Seq<Tuple2<String, String>> headers) {
        return (Seq)headers.map((Function1 & Serializable)t -> RawHeader$.MODULE$.apply((String)t._1(), (String)t._2()));
    }

    public int hashCode() {
        return this.request().hashCode();
    }

    public PekkoHeadersWrapper copy(HttpRequest request, Option<String> knownContentLength, Seq<HttpHeader> hs, Option<String> isChunked, String uri) {
        return new PekkoHeadersWrapper(request, knownContentLength, hs, isChunked, uri);
    }

    public HttpRequest copy$default$1() {
        return this.request();
    }

    public Option<String> copy$default$2() {
        return this.knownContentLength();
    }

    public Seq<HttpHeader> copy$default$3() {
        return this.hs();
    }

    public Option<String> copy$default$4() {
        return this.isChunked();
    }

    public String copy$default$5() {
        return this.uri();
    }

    public HttpRequest _1() {
        return this.request();
    }

    public Option<String> _2() {
        return this.knownContentLength();
    }

    public Seq<HttpHeader> _3() {
        return this.hs();
    }

    public Option<String> _4() {
        return this.isChunked();
    }

    public String _5() {
        return this.uri();
    }

    private static final String apply$$anonfun$1(String key$1) {
        throw new RuntimeException("Header with name " + key$1 + " not found!");
    }
}

