/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.openid;

import java.io.Serializable;
import play.api.http.HeaderNames$;
import play.api.libs.openid.Discovery$;
import play.api.libs.openid.OpenIDServer;
import play.api.libs.openid.OpenIDServer$;
import play.api.libs.ws.WSResponse;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;
import scala.xml.Node;

public interface Discovery {
    public Future<OpenIDServer> discoverServer(String var1);

    public String normalizeIdentifier(String var1);

    public static class HtmlResolver
    implements Resolver {
        private final Regex providerRegex = new Regex("<link[^>]+openid2[.]provider[^>]+>", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        private final Regex serverRegex = new Regex("<link[^>]+openid[.]server[^>]+>", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        private final Regex localidRegex = new Regex("<link[^>]+openid2[.]local_id[^>]+>", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        private final Regex delegateRegex = new Regex("<link[^>]+openid[.]delegate[^>]+>", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));

        @Override
        public Option<OpenIDServer> resolve(WSResponse response) {
            Option serverUrl = this.providerRegex.findFirstIn((CharSequence)response.body()).orElse(() -> this.$anonfun$9(response)).flatMap((Function1 & Serializable)_$15 -> this.extractHref((String)_$15));
            return serverUrl.map((Function1 & Serializable)url -> {
                Option delegate = this.localidRegex.findFirstIn((CharSequence)response.body()).orElse(() -> this.$anonfun$11(response)).flatMap((Function1 & Serializable)_$16 -> this.extractHref((String)_$16));
                return OpenIDServer$.MODULE$.apply("http://specs.openid.net/auth/2.0/signon", (String)url, (Option<String>)delegate);
            });
        }

        private Option<String> extractHref(String link) {
            return new Regex("href=\"([^\"]*)\"", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).findFirstMatchIn((CharSequence)link).map(Discovery$::play$api$libs$openid$Discovery$HtmlResolver$$_$extractHref$$anonfun$1).orElse(() -> Discovery$.play$api$libs$openid$Discovery$HtmlResolver$$_$extractHref$$anonfun$2(link));
        }

        private final Option $anonfun$9(WSResponse response$4) {
            return this.serverRegex.findFirstIn((CharSequence)response$4.body());
        }

        private final Option $anonfun$11(WSResponse response$6) {
            return this.delegateRegex.findFirstIn((CharSequence)response$6.body());
        }
    }

    public static interface Resolver {
        public Option<OpenIDServer> resolve(WSResponse var1);
    }

    public static class XrdsResolver
    implements Resolver {
        private final Seq<String> serviceTypeId = (Seq)((SeqOps)new .colon.colon((Object)"http://specs.openid.net/auth/2.0/server", (List)new .colon.colon((Object)"http://specs.openid.net/auth/2.0/signon", (List)new .colon.colon((Object)"http://openid.net/server/1.0", (List)new .colon.colon((Object)"http://openid.net/server/1.1", (List)Nil$.MODULE$)))));

        @Override
        public Option<OpenIDServer> resolve(WSResponse response) {
            return response.header(HeaderNames$.MODULE$.CONTENT_TYPE()).filter(Discovery$::play$api$libs$openid$Discovery$XrdsResolver$$_$resolve$$anonfun$1).map((Function1 & Serializable)x$1 -> {
                String string;
                String $2$ = string = x$1;
                Function1 & Serializable findInXml = (Function1 & Serializable)_$13 -> this.findUriWithType((Node)response.xml(), (String)_$13);
                return Tuple2$.MODULE$.apply((Object)$2$, (Object)findInXml);
            }).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Function1 findInXml = (Function1)tuple2._2();
                    return ((IterableOps)this.serviceTypeId.flatMap(findInXml)).headOption().withFilter(Discovery$::play$api$libs$openid$Discovery$XrdsResolver$$_$resolve$$anonfun$3$$anonfun$1).map(Discovery$::play$api$libs$openid$Discovery$XrdsResolver$$_$resolve$$anonfun$3$$anonfun$2);
                }
                throw new MatchError((Object)tuple2);
            });
        }

        private Option<Tuple2<String, String>> findUriWithType(Node xml, String typeId) {
            return xml.$bslash("XRD").$bslash("Service").find(arg_0 -> Discovery$.play$api$libs$openid$Discovery$XrdsResolver$$_$findUriWithType$$anonfun$1(typeId, arg_0)).map(arg_0 -> Discovery$.play$api$libs$openid$Discovery$XrdsResolver$$_$findUriWithType$$anonfun$2(typeId, arg_0));
        }
    }
}

