/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.openid;

import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.libs.openid.Discovery;
import play.api.libs.openid.Errors$AUTH_CANCEL$;
import play.api.libs.openid.Errors$AUTH_ERROR$;
import play.api.libs.openid.Errors$BAD_RESPONSE$;
import play.api.libs.openid.OpenIDServer;
import play.api.libs.openid.OpenIdClient;
import play.api.libs.openid.UserInfo;
import play.api.libs.openid.UserInfo$;
import play.api.libs.ws.BodyWritable;
import play.api.libs.ws.DefaultBodyWritables;
import play.api.libs.ws.JsonBodyWritables;
import play.api.libs.ws.WSBodyWritables;
import play.api.libs.ws.WSClient;
import play.api.libs.ws.XMLBodyWritables;
import play.api.mvc.RequestHeader;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.Statics;

@Singleton
public class WsOpenIdClient
implements OpenIdClient,
DefaultBodyWritables,
JsonBodyWritables,
XMLBodyWritables,
WSBodyWritables {
    private BodyWritable writableOf_File;
    private BodyWritable writableOf_InputStream;
    private BodyWritable writableOf_Source;
    private BodyWritable writeableOf_String;
    private BodyWritable writeableOf_StringBuilder;
    private BodyWritable writeableOf_ByteArray;
    private BodyWritable writeableOf_ByteBuffer;
    private BodyWritable writeableOf_Bytes;
    private BodyWritable writeableOf_WsBody;
    private BodyWritable writeableOf_urlEncodedForm;
    private BodyWritable writeableOf_urlEncodedSimpleForm;
    private BodyWritable writeableOf_JsValue;
    private BodyWritable writeableOf_NodeBuffer;
    private BodyWritable writeableOf_Document;
    private BodyWritable bodyWritableOf_Multipart;
    private final WSClient ws;
    private final Discovery discovery;
    private final ExecutionContext ec;

    @Inject
    public WsOpenIdClient(WSClient ws, Discovery discovery, ExecutionContext ec) {
        this.ws = ws;
        this.discovery = discovery;
        this.ec = ec;
        DefaultBodyWritables.$init$((DefaultBodyWritables)this);
        JsonBodyWritables.$init$((JsonBodyWritables)this);
        XMLBodyWritables.$init$((XMLBodyWritables)this);
        WSBodyWritables.$init$((WSBodyWritables)this);
        Statics.releaseFence();
    }

    public BodyWritable writableOf_File() {
        return this.writableOf_File;
    }

    public BodyWritable writableOf_InputStream() {
        return this.writableOf_InputStream;
    }

    public BodyWritable writableOf_Source() {
        return this.writableOf_Source;
    }

    public BodyWritable writeableOf_String() {
        return this.writeableOf_String;
    }

    public BodyWritable writeableOf_StringBuilder() {
        return this.writeableOf_StringBuilder;
    }

    public BodyWritable writeableOf_ByteArray() {
        return this.writeableOf_ByteArray;
    }

    public BodyWritable writeableOf_ByteBuffer() {
        return this.writeableOf_ByteBuffer;
    }

    public BodyWritable writeableOf_Bytes() {
        return this.writeableOf_Bytes;
    }

    public BodyWritable writeableOf_WsBody() {
        return this.writeableOf_WsBody;
    }

    public BodyWritable writeableOf_urlEncodedForm() {
        return this.writeableOf_urlEncodedForm;
    }

    public BodyWritable writeableOf_urlEncodedSimpleForm() {
        return this.writeableOf_urlEncodedSimpleForm;
    }

    public void play$api$libs$ws$DefaultBodyWritables$_setter_$writableOf_File_$eq(BodyWritable x$0) {
        this.writableOf_File = x$0;
    }

    public void play$api$libs$ws$DefaultBodyWritables$_setter_$writableOf_InputStream_$eq(BodyWritable x$0) {
        this.writableOf_InputStream = x$0;
    }

    public void play$api$libs$ws$DefaultBodyWritables$_setter_$writableOf_Source_$eq(BodyWritable x$0) {
        this.writableOf_Source = x$0;
    }

    public void play$api$libs$ws$DefaultBodyWritables$_setter_$writeableOf_String_$eq(BodyWritable x$0) {
        this.writeableOf_String = x$0;
    }

    public void play$api$libs$ws$DefaultBodyWritables$_setter_$writeableOf_StringBuilder_$eq(BodyWritable x$0) {
        this.writeableOf_StringBuilder = x$0;
    }

    public void play$api$libs$ws$DefaultBodyWritables$_setter_$writeableOf_ByteArray_$eq(BodyWritable x$0) {
        this.writeableOf_ByteArray = x$0;
    }

    public void play$api$libs$ws$DefaultBodyWritables$_setter_$writeableOf_ByteBuffer_$eq(BodyWritable x$0) {
        this.writeableOf_ByteBuffer = x$0;
    }

    public void play$api$libs$ws$DefaultBodyWritables$_setter_$writeableOf_Bytes_$eq(BodyWritable x$0) {
        this.writeableOf_Bytes = x$0;
    }

    public void play$api$libs$ws$DefaultBodyWritables$_setter_$writeableOf_WsBody_$eq(BodyWritable x$0) {
        this.writeableOf_WsBody = x$0;
    }

    public void play$api$libs$ws$DefaultBodyWritables$_setter_$writeableOf_urlEncodedForm_$eq(BodyWritable x$0) {
        this.writeableOf_urlEncodedForm = x$0;
    }

    public void play$api$libs$ws$DefaultBodyWritables$_setter_$writeableOf_urlEncodedSimpleForm_$eq(BodyWritable x$0) {
        this.writeableOf_urlEncodedSimpleForm = x$0;
    }

    public BodyWritable writeableOf_JsValue() {
        return this.writeableOf_JsValue;
    }

    public void play$api$libs$ws$JsonBodyWritables$_setter_$writeableOf_JsValue_$eq(BodyWritable x$0) {
        this.writeableOf_JsValue = x$0;
    }

    public BodyWritable writeableOf_NodeBuffer() {
        return this.writeableOf_NodeBuffer;
    }

    public BodyWritable writeableOf_Document() {
        return this.writeableOf_Document;
    }

    public void play$api$libs$ws$XMLBodyWritables$_setter_$writeableOf_NodeBuffer_$eq(BodyWritable x$0) {
        this.writeableOf_NodeBuffer = x$0;
    }

    public void play$api$libs$ws$XMLBodyWritables$_setter_$writeableOf_Document_$eq(BodyWritable x$0) {
        this.writeableOf_Document = x$0;
    }

    public BodyWritable bodyWritableOf_Multipart() {
        return this.bodyWritableOf_Multipart;
    }

    public void play$api$libs$ws$WSBodyWritables$_setter_$bodyWritableOf_Multipart_$eq(BodyWritable x$0) {
        this.bodyWritableOf_Multipart = x$0;
    }

    @Override
    public Future<String> redirectURL(String openID, String callbackURL, Seq<Tuple2<String, String>> axRequired, Seq<Tuple2<String, String>> axOptional, Option<String> realm) {
        String claimedIdCandidate = this.discovery.normalizeIdentifier(openID);
        return this.discovery.discoverServer(openID).map((Function1 & Serializable)server -> {
            String string = server.protocolVersion();
            String string2 = "http://specs.openid.net/auth/2.0/server";
            Tuple2 tuple2 = (string == null ? string2 != null : !string.equals(string2)) ? Tuple2$.MODULE$.apply((Object)claimedIdCandidate, server.delegate().getOrElse(() -> WsOpenIdClient.$anonfun$2(claimedIdCandidate))) : Tuple2$.MODULE$.apply((Object)"http://specs.openid.net/auth/2.0/identifier_select", (Object)"http://specs.openid.net/auth/2.0/identifier_select");
            String claimedId = (String)tuple2._1();
            String identity = (String)tuple2._2();
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"openid.ns");
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"openid.mode");
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"openid.claimed_id");
            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"openid.identity");
            String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"openid.return_to");
            Seq parameters = (Seq)((IterableOps)((SeqOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)"http://specs.openid.net/auth/2.0"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)"checkid_setup"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)claimedId), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)identity), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)callbackURL), (List)Nil$.MODULE$)))))).$plus$plus(this.axParameters(axRequired, axOptional))).$plus$plus((IterableOnce)realm.map((Function1 & Serializable)_$6 -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"openid.realm");
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, _$6);
            }).toList());
            String separator = server.url().contains("?") ? "&" : "?";
            return server.url() + separator + ((IterableOnceOps)parameters.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    return URLEncoder.encode(k, "UTF-8") + "=" + URLEncoder.encode(v, "UTF-8");
                }
                throw new MatchError((Object)tuple2);
            })).mkString("&");
        }, this.ec);
    }

    @Override
    public Seq<Tuple2<String, String>> redirectURL$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    @Override
    public Seq<Tuple2<String, String>> redirectURL$default$4() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    @Override
    public Option<String> redirectURL$default$5() {
        return None$.MODULE$;
    }

    @Override
    public Future<UserInfo> verifiedId(RequestHeader request) {
        return this.verifiedId((scala.collection.immutable.Map<String, Seq<String>>)request.queryString());
    }

    @Override
    public Future<UserInfo> verifiedId(Map<String, String[]> queryString) {
        return this.verifiedId((scala.collection.immutable.Map<String, Seq<String>>)CollectionConverters$.MODULE$.MapHasAsScala(queryString).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).view().mapValues((Function1 & Serializable)_$7 -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])_$7);
            return ArrayOps$.MODULE$.toSeq$extension(object);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private Future<UserInfo> verifiedId(scala.collection.immutable.Map<String, Seq<String>> queryString) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)queryString.get((Object)"openid.mode").flatMap((Function1 & Serializable)_$8 -> _$8.headOption()), (Object)queryString.get((Object)"openid.claimed_id").flatMap((Function1 & Serializable)_$9 -> _$9.headOption()));
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                String string = (String)((Some)option).value();
                if ("id_res".equals(string) && option2 instanceof Some) {
                    String id = (String)((Some)option2).value();
                    Future<OpenIDServer> server2 = this.discovery.discoverServer(id);
                    return server2.flatMap((Function1 & Serializable)server -> this.directVerification(queryString, (OpenIDServer)server), this.ec);
                }
                if ("cancel".equals(string)) {
                    return Future$.MODULE$.failed((Throwable)Errors$AUTH_CANCEL$.MODULE$);
                }
            }
        }
        return Future$.MODULE$.failed((Throwable)Errors$BAD_RESPONSE$.MODULE$);
    }

    private Future<UserInfo> directVerification(scala.collection.immutable.Map<String, Seq<String>> queryString, OpenIDServer server) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"openid.mode");
        scala.collection.immutable.Map fields = (scala.collection.immutable.Map)queryString.$minus((Object)"openid.mode").$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)((SeqOps)new .colon.colon((Object)"check_authentication", (List)Nil$.MODULE$))));
        return this.ws.url(server.url()).post((Object)fields, this.writeableOf_urlEncodedForm()).map((Function1 & Serializable)response -> {
            if (response.status() == 200 && response.body().contains("is_valid:true")) {
                return UserInfo$.MODULE$.apply(queryString);
            }
            throw Errors$AUTH_ERROR$.MODULE$;
        }, this.ec);
    }

    private Seq<Tuple2<String, String>> axParameters(Seq<Tuple2<String, String>> axRequired, Seq<Tuple2<String, String>> axOptional) {
        Nil$ nil$;
        Nil$ axRequiredParams;
        Nil$ nil$2;
        if (axRequired.isEmpty() && axOptional.isEmpty()) {
            return package$.MODULE$.Nil();
        }
        if (axRequired.isEmpty()) {
            nil$2 = package$.MODULE$.Nil();
        } else {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"openid.ax.required");
            nil$2 = axRequiredParams = (Seq)((SeqOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)((IterableOnceOps)axRequired.map((Function1 & Serializable)_$10 -> (String)_$10._1())).mkString(",")), (List)Nil$.MODULE$));
        }
        if (axOptional.isEmpty()) {
            nil$ = package$.MODULE$.Nil();
        } else {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"openid.ax.if_available");
            nil$ = (Seq)((SeqOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)((IterableOnceOps)axOptional.map((Function1 & Serializable)_$11 -> (String)_$11._1())).mkString(",")), (List)Nil$.MODULE$));
        }
        Nil$ axOptionalParams = nil$;
        Seq definitions = (Seq)((IterableOps)axRequired.$plus$plus(axOptional)).map((Function1 & Serializable)attribute -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)("openid.ax.type." + attribute._1()));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, attribute._2());
        });
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"openid.ns.ax");
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"openid.ax.mode");
        return (Seq)((IterableOps)((IterableOps)((SeqOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"http://openid.net/srv/ax/1.0"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)"fetch_request"), (List)Nil$.MODULE$))).$plus$plus((IterableOnce)axRequiredParams)).$plus$plus((IterableOnce)axOptionalParams)).$plus$plus((IterableOnce)definitions);
    }

    private static final String $anonfun$2(String claimedIdCandidate$2) {
        return claimedIdCandidate$2;
    }
}

