/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.openid;

import java.io.Serializable;
import play.api.http.HeaderNames$;
import play.api.libs.openid.OpenIDServer;
import play.api.libs.openid.OpenIDServer$;
import play.api.libs.ws.WSResponse;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;
import scala.xml.Elem;
import scala.xml.Node;

public interface Discovery {
    public Future<OpenIDServer> discoverServer(String var1);

    public String normalizeIdentifier(String var1);

    public static class HtmlResolver
    implements Resolver {
        private final Regex providerRegex = new Regex("<link[^>]+openid2[.]provider[^>]+>", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        private final Regex serverRegex = new Regex("<link[^>]+openid[.]server[^>]+>", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        private final Regex localidRegex = new Regex("<link[^>]+openid2[.]local_id[^>]+>", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        private final Regex delegateRegex = new Regex("<link[^>]+openid[.]delegate[^>]+>", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));

        @Override
        public Option<OpenIDServer> resolve(WSResponse response) {
            Option serverUrl = this.providerRegex.findFirstIn((CharSequence)response.body()).orElse(() -> this.$anonfun$9(response)).flatMap((Function1 & Serializable)_$14 -> this.extractHref((String)_$14));
            return serverUrl.map((Function1 & Serializable)url -> {
                Option delegate = this.localidRegex.findFirstIn((CharSequence)response.body()).orElse(() -> this.$anonfun$11(response)).flatMap((Function1 & Serializable)_$15 -> this.extractHref((String)_$15));
                return OpenIDServer$.MODULE$.apply("http://specs.openid.net/auth/2.0/signon", (String)url, (Option<String>)delegate);
            });
        }

        private Option<String> extractHref(String link) {
            return new Regex("href=\"([^\"]*)\"", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).findFirstMatchIn((CharSequence)link).map((Function1 & Serializable)_$16 -> _$16.group(1).trim()).orElse(() -> this.extractHref$$anonfun$2(link));
        }

        private final Option $anonfun$9(WSResponse response$3) {
            return this.serverRegex.findFirstIn((CharSequence)response$3.body());
        }

        private final Option $anonfun$11(WSResponse response$5) {
            return this.delegateRegex.findFirstIn((CharSequence)response$5.body());
        }

        private final Option extractHref$$anonfun$2(String link$1) {
            return new Regex("href='([^']*)'", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).findFirstMatchIn((CharSequence)link$1).map((Function1 & Serializable)_$17 -> _$17.group(1).trim());
        }
    }

    public static interface Resolver {
        public Option<OpenIDServer> resolve(WSResponse var1);
    }

    public static class XrdsResolver
    implements Resolver {
        private final Seq<String> serviceTypeId = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"http://specs.openid.net/auth/2.0/server", "http://specs.openid.net/auth/2.0/signon", "http://openid.net/server/1.0", "http://openid.net/server/1.1"}));

        @Override
        public Option<OpenIDServer> resolve(WSResponse response) {
            return response.header(HeaderNames$.MODULE$.CONTENT_TYPE()).filter((Function1 & Serializable)_$12 -> _$12.contains("application/xrds+xml")).map((Function1 & Serializable)x$1 -> {
                String string;
                String $2$ = string = x$1;
                Elem elem = response.xml();
                Function1 & Serializable findInXml = (Function1 & Serializable)typeId -> this.findUriWithType((Node)elem, (String)typeId);
                return Tuple2$.MODULE$.apply((Object)$2$, (Object)findInXml);
            }).flatMap((Function1 & Serializable)x$12 -> {
                Tuple2 tuple2 = x$12;
                if (tuple2 != null) {
                    Function1 findInXml = (Function1)tuple2._2();
                    return ((IterableOps)this.serviceTypeId.flatMap(findInXml)).headOption().withFilter((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            String typeId = (String)tuple2._1();
                            String uri = (String)tuple2._2();
                            return true;
                        }
                        return false;
                    }).map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            String typeId = (String)tuple2._1();
                            String uri = (String)tuple2._2();
                            return OpenIDServer$.MODULE$.apply(typeId, uri, (Option<String>)None$.MODULE$);
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
                throw new MatchError((Object)tuple2);
            });
        }

        private Option<Tuple2<String, String>> findUriWithType(Node xml, String typeId) {
            return xml.$bslash("XRD").$bslash("Service").find((Function1 & Serializable)node -> node.$bslash("Type").find((Function1 & Serializable)inner -> {
                String string = inner.text();
                String string2 = typeId;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).isDefined()).map((Function1 & Serializable)node -> Tuple2$.MODULE$.apply((Object)typeId, (Object)node.$bslash("URI").text().trim()));
        }
    }
}

