/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.util.ByteString;
import org.playframework.netty.http.DefaultWebSocketHttpResponse;
import org.reactivestreams.Processor;
import play.api.Application;
import play.api.MarkerContext$;
import play.api.Mode;
import play.api.http.DefaultHttpErrorHandler;
import play.api.http.DefaultHttpErrorHandler$;
import play.api.http.DevHttpErrorHandler$;
import play.api.http.HeaderNames$;
import play.api.http.HttpErrorHandler;
import play.api.http.HttpErrorInfo$;
import play.api.http.Status$;
import play.api.http.Writeable$;
import play.api.libs.streams.Accumulator;
import play.api.libs.streams.Accumulator$;
import play.api.mvc.Codec$;
import play.api.mvc.EssentialAction;
import play.api.mvc.EssentialAction$;
import play.api.mvc.Handler;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import play.api.mvc.WebSocket;
import play.api.mvc.request.RequestAttrKey$;
import play.api.mvc.request.RequestTarget;
import play.core.Execution;
import play.core.server.NettyServer;
import play.core.server.NettyServer$;
import play.core.server.Server$;
import play.core.server.common.ForwardedHeaderHandler;
import play.core.server.common.ReloadCache;
import play.core.server.common.ServerDebugInfo;
import play.core.server.common.ServerDebugInfo$;
import play.core.server.common.ServerResultUtils;
import play.core.server.netty.NettyModelConversion;
import play.core.server.netty.PlayRequestHandler$;
import play.core.server.netty.PlayRequestHandler$ReloadCacheValues$;
import play.core.server.netty.WebSocketHandler$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.Exception$;

public class PlayRequestHandler
extends ChannelInboundHandlerAdapter {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(PlayRequestHandler.class.getDeclaredField("fallbackErrorHandler$lzy1"));
    private final NettyServer server;
    private final Option serverHeader;
    private final long maxContentLength;
    private final int wsBufferLimit;
    private final String wsKeepAliveMode;
    private final Duration wsKeepAliveMaxIdle;
    private final boolean deferBodyParsingGlobal;
    private final AtomicLong requestsInFlight;
    private Future<BoxedUnit> lastResponseSent;
    public final PlayRequestHandler$ReloadCacheValues$ ReloadCacheValues$lzy1;
    private final ReloadCache<ReloadCacheValues> reloadCache;
    private volatile Object fallbackErrorHandler$lzy1;

    public PlayRequestHandler(NettyServer server, Option<String> serverHeader, long maxContentLength, int wsBufferLimit, String wsKeepAliveMode, Duration wsKeepAliveMaxIdle, boolean deferBodyParsingGlobal) {
        this.server = server;
        this.serverHeader = serverHeader;
        this.maxContentLength = maxContentLength;
        this.wsBufferLimit = wsBufferLimit;
        this.wsKeepAliveMode = wsKeepAliveMode;
        this.wsKeepAliveMaxIdle = wsKeepAliveMaxIdle;
        this.deferBodyParsingGlobal = deferBodyParsingGlobal;
        this.ReloadCacheValues$lzy1 = new PlayRequestHandler$ReloadCacheValues$(this);
        this.requestsInFlight = new AtomicLong();
        this.lastResponseSent = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        this.reloadCache = new ReloadCache<ReloadCacheValues>(this){
            private final /* synthetic */ PlayRequestHandler $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public ReloadCacheValues reloadValue(Try tryApp) {
                ServerResultUtils serverResultUtils = this.reloadServerResultUtils(tryApp);
                ForwardedHeaderHandler forwardedHeaderHandler = this.reloadForwardedHeaderHandler(tryApp);
                NettyModelConversion modelConversion = new NettyModelConversion(serverResultUtils, forwardedHeaderHandler, this.$outer.serverHeader());
                return this.$outer.play$core$server$netty$PlayRequestHandler$$ReloadCacheValues().apply(serverResultUtils, modelConversion, (Option<ServerDebugInfo>)this.reloadDebugInfo(tryApp, NettyServer$.MODULE$.provider()));
            }
        };
    }

    public NettyServer server() {
        return this.server;
    }

    public Option<String> serverHeader() {
        return this.serverHeader;
    }

    public long maxContentLength() {
        return this.maxContentLength;
    }

    public int wsBufferLimit() {
        return this.wsBufferLimit;
    }

    public String wsKeepAliveMode() {
        return this.wsKeepAliveMode;
    }

    public Duration wsKeepAliveMaxIdle() {
        return this.wsKeepAliveMaxIdle;
    }

    public boolean deferBodyParsingGlobal() {
        return this.deferBodyParsingGlobal;
    }

    public final PlayRequestHandler$ReloadCacheValues$ play$core$server$netty$PlayRequestHandler$$ReloadCacheValues() {
        return this.ReloadCacheValues$lzy1;
    }

    private ServerResultUtils resultUtils(Try<Application> tryApp) {
        return ((ReloadCacheValues)this.reloadCache.cachedFrom(tryApp)).resultUtils();
    }

    private NettyModelConversion modelConversion(Try<Application> tryApp) {
        return ((ReloadCacheValues)this.reloadCache.cachedFrom(tryApp)).modelConversion();
    }

    public Future<HttpResponse> handle(Channel channel, HttpRequest request) {
        Handler handler;
        Tuple2 tuple2;
        Try<RequestHeader> tryRequest;
        PlayRequestHandler$.play$core$server$netty$PlayRequestHandler$$$logger.trace(() -> PlayRequestHandler.handle$$anonfun$1(request), MarkerContext$.MODULE$.NoMarker());
        Try tryApp = this.server().applicationProvider().get();
        ReloadCacheValues cacheValues = (ReloadCacheValues)this.reloadCache.cachedFrom(tryApp);
        Try<RequestHeader> try_ = tryRequest = cacheValues.modelConversion().convertRequest(channel, request);
        if (try_ instanceof Failure) {
            IllegalArgumentException exception;
            Throwable throwable = ((Failure)try_).exception();
            if (throwable instanceof IllegalArgumentException && (exception = (IllegalArgumentException)throwable).getMessage().startsWith("invalid hex byte")) {
                tuple2 = this.clientError$1(channel, request, tryApp, cacheValues, Status$.MODULE$.BAD_REQUEST(), exception.getMessage(), true);
            } else if (throwable instanceof TooLongFrameException) {
                TooLongFrameException exception2 = (TooLongFrameException)throwable;
                tuple2 = this.clientError$1(channel, request, tryApp, cacheValues, Status$.MODULE$.REQUEST_URI_TOO_LONG(), exception2.getMessage(), PlayRequestHandler.clientError$default$3$1());
            } else {
                Throwable exception3 = throwable;
                tuple2 = this.clientError$1(channel, request, tryApp, cacheValues, Status$.MODULE$.BAD_REQUEST(), exception3.getMessage(), PlayRequestHandler.clientError$default$3$1());
            }
        } else if (try_ instanceof Success) {
            RequestHeader untagged = (RequestHeader)((Success)try_).value();
            if (untagged.headers().get(HeaderNames$.MODULE$.CONTENT_LENGTH()).flatMap((Function1 & Serializable)clh -> Exception$.MODULE$.catching((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{NumberFormatException.class})).opt(() -> PlayRequestHandler.$anonfun$1$$anonfun$1(clh))).exists((Function1)(JFunction1.mcZJ.sp & Serializable)_$2 -> _$2 > this.maxContentLength())) {
                tuple2 = this.clientError$1(channel, request, tryApp, cacheValues, Status$.MODULE$.REQUEST_ENTITY_TOO_LARGE(), "Request Entity Too Large", PlayRequestHandler.clientError$default$3$1());
            } else {
                RequestHeader debugHeader = PlayRequestHandler.attachDebugInfo$1(cacheValues, untagged);
                tuple2 = Server$.MODULE$.getHandlerFor(debugHeader, tryApp, (HttpErrorHandler)this.fallbackErrorHandler());
            }
        } else {
            throw new MatchError(try_);
        }
        Tuple2 tuple22 = tuple2;
        if (!(tuple22 instanceof Tuple2)) {
            throw new MatchError((Object)tuple22);
        }
        Tuple2 tuple23 = tuple22;
        RequestHeader requestHeader = (RequestHeader)tuple23._1();
        Handler handler2 = (Handler)tuple23._2();
        Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)requestHeader, (Object)handler2);
        RequestHeader requestHeader2 = (RequestHeader)tuple24._1();
        Handler handler3 = handler = (Handler)tuple24._2();
        if (handler3 instanceof EssentialAction) {
            EssentialAction action = (EssentialAction)handler3;
            return this.play$core$server$netty$PlayRequestHandler$$handleAction(action, requestHeader2, request, (Try<Application>)tryApp, true);
        }
        if (handler3 instanceof WebSocket) {
            WebSocket webSocket;
            WebSocket ws = webSocket = (WebSocket)handler3;
            if (requestHeader2.headers().get(HeaderNames$.MODULE$.UPGRADE()).exists((Function1 & Serializable)_$3 -> _$3.equalsIgnoreCase("websocket"))) {
                PlayRequestHandler$.play$core$server$netty$PlayRequestHandler$$$logger.trace(() -> PlayRequestHandler.handle$$anonfun$3(ws), MarkerContext$.MODULE$.NoMarker());
                Application app = (Application)tryApp.get();
                String wsProtocol = requestHeader2.secure() ? "wss" : "ws";
                String wsUrl = wsProtocol + "://" + requestHeader2.host() + requestHeader2.path();
                WebSocketServerHandshakerFactory factory = new WebSocketServerHandshakerFactory(wsUrl, "*", true, this.wsBufferLimit());
                Future executed = Future$.MODULE$.apply(() -> PlayRequestHandler.$anonfun$3(requestHeader2, ws), (ExecutionContext)app.actorSystem().dispatcher());
                return executed.flatMap((Function1 & Serializable)x -> (Future)Predef$.MODULE$.identity(x), (ExecutionContext)Execution.Implicits$.MODULE$.trampoline()).flatMap((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Left) {
                        Result result = (Result)((Left)either).value();
                        EssentialAction action = EssentialAction$.MODULE$.apply((Function1 & Serializable)_$4 -> Accumulator$.MODULE$.done((Object)result));
                        return this.play$core$server$netty$PlayRequestHandler$$handleAction(action, requestHeader2, request, (Try<Application>)tryApp, this.play$core$server$netty$PlayRequestHandler$$handleAction$default$5());
                    }
                    if (either instanceof Right) {
                        Flow flow = (Flow)((Right)either).value();
                        Processor<WebSocketFrame, WebSocketFrame> processor = WebSocketHandler$.MODULE$.messageFlowToFrameProcessor(flow, this.wsBufferLimit(), this.wsKeepAliveMode(), this.wsKeepAliveMaxIdle(), app.materializer());
                        return Future$.MODULE$.successful((Object)new DefaultWebSocketHttpResponse(request.protocolVersion(), HttpResponseStatus.OK, processor, factory));
                    }
                    throw new MatchError((Object)either);
                }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline()).recoverWith((PartialFunction)new Serializable(request, tryApp, requestHeader2, app, this){
                    private final HttpRequest request$4;
                    private final Try tryApp$3;
                    private final RequestHeader requestHeader$3;
                    private final Application app$2;
                    private final /* synthetic */ PlayRequestHandler $outer;
                    {
                        this.request$4 = request$11;
                        this.tryApp$3 = tryApp$10;
                        this.requestHeader$3 = requestHeader$9;
                        this.app$2 = app$3;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable;
                        Throwable error = throwable = x;
                        return true;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable;
                        Throwable error = throwable = x;
                        return this.app$2.errorHandler().onServerError(this.requestHeader$3, error).flatMap((Function1 & Serializable)result -> {
                            EssentialAction action = EssentialAction$.MODULE$.apply(arg_0 -> PlayRequestHandler.play$core$server$netty$PlayRequestHandler$$anon$2$$_$_$$anonfun$5(result, arg_0));
                            return this.$outer.play$core$server$netty$PlayRequestHandler$$handleAction(action, this.requestHeader$3, this.request$4, (Try<Application>)this.tryApp$3, this.$outer.play$core$server$netty$PlayRequestHandler$$handleAction$default$5());
                        }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(play.api.mvc.Result ), play$core$server$netty$PlayRequestHandler$$anon$2$$_$_$$anonfun$5(play.api.mvc.Result play.api.mvc.RequestHeader )}, serializedLambda);
                    }
                }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
            }
            WebSocket ws2 = webSocket;
            PlayRequestHandler$.play$core$server$netty$PlayRequestHandler$$$logger.trace(() -> PlayRequestHandler.handle$$anonfun$6(request), MarkerContext$.MODULE$.NoMarker());
            EssentialAction action = EssentialAction$.MODULE$.apply((Function1 & Serializable)_$6 -> {
                Object[] objectArray = new Tuple2[2];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.UPGRADE());
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"websocket");
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.CONNECTION());
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)HeaderNames$.MODULE$.UPGRADE());
                return Accumulator$.MODULE$.done((Object)Results$.MODULE$.Status(Status$.MODULE$.UPGRADE_REQUIRED()).apply((Object)"Upgrade to WebSocket required", Writeable$.MODULE$.wString(Codec$.MODULE$.utf_8())).withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            });
            return this.play$core$server$netty$PlayRequestHandler$$handleAction(action, requestHeader2, request, (Try<Application>)tryApp, this.play$core$server$netty$PlayRequestHandler$$handleAction$default$5());
        }
        Handler h = handler3;
        IllegalStateException ex = new IllegalStateException("Netty server doesn't handle Handlers of this type: " + h);
        PlayRequestHandler$.play$core$server$netty$PlayRequestHandler$$$logger.error(() -> PlayRequestHandler.handle$$anonfun$7(ex), () -> PlayRequestHandler.handle$$anonfun$8(ex), MarkerContext$.MODULE$.NoMarker());
        throw ex;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        PlayRequestHandler$.play$core$server$netty$PlayRequestHandler$$$logger.trace(() -> PlayRequestHandler.channelRead$$anonfun$1(ctx, msg), MarkerContext$.MODULE$.NoMarker());
        Object object = msg;
        if (object instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)object;
            this.requestsInFlight.incrementAndGet();
            Future<HttpResponse> future = this.handle(ctx.channel(), req);
            this.lastResponseSent = this.lastResponseSent.flatMap((Function1 & Serializable)_$7 -> {
                Future f = future.map((Function1)(JProcedure1 & Serializable)httpResponse -> {
                    if (this.requestsInFlight.decrementAndGet() == 0L) {
                        ctx.read();
                    }
                    ctx.writeAndFlush(httpResponse);
                }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
                return f.recover((PartialFunction)new Serializable(ctx, this){
                    private final ChannelHandlerContext ctx$4;
                    private final /* synthetic */ PlayRequestHandler $outer;
                    {
                        this.ctx$4 = ctx$6;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        if (throwable instanceof Exception) {
                            Exception error = (Exception)throwable;
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        if (throwable instanceof Exception) {
                            Exception error = (Exception)throwable;
                            PlayRequestHandler$.play$core$server$netty$PlayRequestHandler$$$logger.error(PlayRequestHandler::play$core$server$netty$PlayRequestHandler$$anon$3$$_$applyOrElse$$anonfun$2, () -> PlayRequestHandler.play$core$server$netty$PlayRequestHandler$$anon$3$$_$applyOrElse$$anonfun$3(error), MarkerContext$.MODULE$.NoMarker());
                            this.$outer.play$core$server$netty$PlayRequestHandler$$sendSimpleErrorResponse(this.ctx$4, HttpResponseStatus.SERVICE_UNAVAILABLE);
                            return BoxedUnit.UNIT;
                        }
                        return function1.apply((Object)x);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{play$core$server$netty$PlayRequestHandler$$anon$3$$_$applyOrElse$$anonfun$2(), play$core$server$netty$PlayRequestHandler$$anon$3$$_$applyOrElse$$anonfun$3(java.lang.Exception )}, serializedLambda);
                    }
                }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
            }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
            return;
        }
        throw new MatchError(object);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        PlayRequestHandler$.play$core$server$netty$PlayRequestHandler$$$logger.trace(() -> PlayRequestHandler.channelReadComplete$$anonfun$1(ctx), MarkerContext$.MODULE$.NoMarker());
        if (this.requestsInFlight.get() == 0L) {
            ctx.read();
            return;
        }
        ctx.fireChannelReadComplete();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        IllegalArgumentException e;
        Throwable throwable = cause;
        if (throwable instanceof IOException) {
            IOException e2 = (IOException)throwable;
            PlayRequestHandler$.play$core$server$netty$PlayRequestHandler$$$logger.trace(PlayRequestHandler::exceptionCaught$$anonfun$1, () -> PlayRequestHandler.exceptionCaught$$anonfun$2(e2), MarkerContext$.MODULE$.NoMarker());
            ctx.channel().close();
            return;
        }
        if (throwable instanceof TooLongFrameException) {
            TooLongFrameException e3 = (TooLongFrameException)throwable;
            PlayRequestHandler$.play$core$server$netty$PlayRequestHandler$$$logger.warn(PlayRequestHandler::exceptionCaught$$anonfun$3, () -> PlayRequestHandler.exceptionCaught$$anonfun$4(e3), MarkerContext$.MODULE$.NoMarker());
            this.play$core$server$netty$PlayRequestHandler$$sendSimpleErrorResponse(ctx, HttpResponseStatus.REQUEST_URI_TOO_LONG);
            return;
        }
        if (throwable instanceof IllegalArgumentException && Option$.MODULE$.apply((Object)(e = (IllegalArgumentException)throwable).getMessage()).exists((Function1 & Serializable)_$8 -> _$8.contains("Header value contains a prohibited character"))) {
            PlayRequestHandler$.play$core$server$netty$PlayRequestHandler$$$logger.debug(PlayRequestHandler::exceptionCaught$$anonfun$6, () -> PlayRequestHandler.exceptionCaught$$anonfun$7(e), MarkerContext$.MODULE$.NoMarker());
            this.play$core$server$netty$PlayRequestHandler$$sendSimpleErrorResponse(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        Throwable e4 = throwable;
        PlayRequestHandler$.play$core$server$netty$PlayRequestHandler$$$logger.error(PlayRequestHandler::exceptionCaught$$anonfun$8, () -> PlayRequestHandler.exceptionCaught$$anonfun$9(e4), MarkerContext$.MODULE$.NoMarker());
        ctx.channel().close();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.read();
    }

    public Future<HttpResponse> play$core$server$netty$PlayRequestHandler$$handleAction(EssentialAction action, RequestHeader requestHeader, HttpRequest request, Try<Application> tryApp, boolean deferredBodyParsingAllowed) {
        Materializer materializer;
        Try<Application> try_ = tryApp;
        if (try_ instanceof Success) {
            Application app = (Application)((Success)try_).value();
            materializer = app.materializer();
        } else if (try_ instanceof Failure) {
            materializer = this.server().materializer();
        } else {
            throw new MatchError(try_);
        }
        Materializer mat = materializer;
        boolean deferBodyParsing = deferredBodyParsingAllowed && Server$.MODULE$.routeModifierDefersBodyParsing(this.deferBodyParsingGlobal(), requestHeader);
        Future actionFuture = Future$.MODULE$.apply(() -> this.$anonfun$8(action, requestHeader, request, tryApp, mat, deferBodyParsing), (ExecutionContext)mat.executionContext());
        return this.invokeAction$1(requestHeader, request, tryApp, mat, actionFuture, deferBodyParsing).flatMap((Function1 & Serializable)actionResult -> {
            Result cleanedResult = this.resultUtils(tryApp).prepareCookies(requestHeader, actionResult);
            return this.resultUtils(tryApp).validateResult(requestHeader, cleanedResult, this.play$core$server$netty$PlayRequestHandler$$errorHandler(tryApp), mat).flatMap((Function1 & Serializable)validatedResult -> this.modelConversion(tryApp).convertResult((Result)validatedResult, requestHeader, request.protocolVersion(), this.play$core$server$netty$PlayRequestHandler$$errorHandler(tryApp), mat).map((Function1 & Serializable)convertedResult -> convertedResult, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline()), (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
        }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
    }

    public boolean play$core$server$netty$PlayRequestHandler$$handleAction$default$5() {
        return false;
    }

    public HttpErrorHandler play$core$server$netty$PlayRequestHandler$$errorHandler(Try<Application> tryApp) {
        Try<Application> try_ = tryApp;
        if (try_ instanceof Success) {
            Application app = (Application)((Success)try_).value();
            return app.errorHandler();
        }
        if (try_ instanceof Failure) {
            return this.fallbackErrorHandler();
        }
        throw new MatchError(try_);
    }

    private DefaultHttpErrorHandler fallbackErrorHandler() {
        Object object = this.fallbackErrorHandler$lzy1;
        if (object instanceof DefaultHttpErrorHandler) {
            return (DefaultHttpErrorHandler)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DefaultHttpErrorHandler)this.fallbackErrorHandler$lzyINIT1();
    }

    private Object fallbackErrorHandler$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.fallbackErrorHandler$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DefaultHttpErrorHandler$ defaultHttpErrorHandler$ = null;
                    try {
                        Mode mode = this.server().mode();
                        Object object3 = defaultHttpErrorHandler$ = Mode.Prod$.MODULE$.equals(mode) ? DefaultHttpErrorHandler$.MODULE$ : DevHttpErrorHandler$.MODULE$;
                        object2 = defaultHttpErrorHandler$ == null ? LazyVals.NullValue$.MODULE$ : defaultHttpErrorHandler$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.fallbackErrorHandler$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return defaultHttpErrorHandler$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ChannelFuture play$core$server$netty$PlayRequestHandler$$sendSimpleErrorResponse(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"0");
        ChannelFuture f = ctx.channel().write((Object)response);
        f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        return f;
    }

    private static final String handle$$anonfun$1(HttpRequest request$1) {
        return "Http request received by netty: " + request$1;
    }

    private static final RequestHeader attachDebugInfo$1(ReloadCacheValues cacheValues$1, RequestHeader rh) {
        return ServerDebugInfo$.MODULE$.attachToRequestHeader(rh, cacheValues$1.serverDebugInfo());
    }

    private final Tuple2 clientError$1(Channel channel$1, HttpRequest request$2, Try tryApp$1, ReloadCacheValues cacheValues$2, int statusCode, String message, boolean bypassErrorHandler) {
        RequestTarget unparsedTarget = Server$.MODULE$.createUnparsedRequestTarget(request$2.uri());
        RequestHeader requestHeader = this.modelConversion((Try<Application>)tryApp$1).createRequestHeader(channel$1, request$2, unparsedTarget);
        RequestHeader debugHeader = PlayRequestHandler.attachDebugInfo$1(cacheValues$2, requestHeader);
        String cleanMessage = message == null ? "" : message;
        Future result = bypassErrorHandler ? Future$.MODULE$.successful((Object)Results$.MODULE$.Status(statusCode).apply((Object)cleanMessage, Writeable$.MODULE$.wString(Codec$.MODULE$.utf_8()))) : this.play$core$server$netty$PlayRequestHandler$$errorHandler((Try<Application>)tryApp$1).onClientError(debugHeader.addAttr(HttpErrorHandler.Attrs$.MODULE$.HttpErrorInfo(), (Object)HttpErrorInfo$.MODULE$.apply("server-backend")), statusCode, cleanMessage);
        RequestHeader requestHeader2 = (RequestHeader)Predef$.MODULE$.ArrowAssoc((Object)debugHeader);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)requestHeader2, (Object)Server$.MODULE$.actionForResult(result.map((Function1 & Serializable)_$1 -> {
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.CONNECTION());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"close");
            return _$1.withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline())));
    }

    private static final boolean clientError$default$3$1() {
        return false;
    }

    private static final long $anonfun$1$$anonfun$1(String clh$1) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(clh$1));
    }

    private static final String handle$$anonfun$3(WebSocket ws$1) {
        return "Serving this request with: " + ws$1;
    }

    private static final Future $anonfun$3(RequestHeader requestHeader$1, WebSocket ws$2) {
        return ws$2.apply(requestHeader$1);
    }

    public static final /* synthetic */ Accumulator play$core$server$netty$PlayRequestHandler$$anon$2$$_$_$$anonfun$5(Result result$2, RequestHeader _$5) {
        return Accumulator$.MODULE$.done((Object)result$2);
    }

    private static final String handle$$anonfun$6(HttpRequest request$5) {
        return "Bad websocket request: " + request$5;
    }

    private static final String handle$$anonfun$7(IllegalStateException ex$1) {
        return ex$1.getMessage();
    }

    private static final Throwable handle$$anonfun$8(IllegalStateException ex$2) {
        return ex$2;
    }

    private static final String channelRead$$anonfun$1(ChannelHandlerContext ctx$1, Object msg$1) {
        return "channelRead: ctx = " + ctx$1 + ", msg = " + msg$1;
    }

    public static final String play$core$server$netty$PlayRequestHandler$$anon$3$$_$applyOrElse$$anonfun$2() {
        return "Exception caught in channelRead future";
    }

    public static final Throwable play$core$server$netty$PlayRequestHandler$$anon$3$$_$applyOrElse$$anonfun$3(Exception error$1) {
        return error$1;
    }

    private static final String channelReadComplete$$anonfun$1(ChannelHandlerContext ctx$5) {
        return "channelReadComplete: ctx = " + ctx$5;
    }

    private static final String exceptionCaught$$anonfun$1() {
        return "Benign IO exception caught in Netty";
    }

    private static final Throwable exceptionCaught$$anonfun$2(IOException e$1) {
        return e$1;
    }

    private static final String exceptionCaught$$anonfun$3() {
        return "Handling TooLongFrameException";
    }

    private static final Throwable exceptionCaught$$anonfun$4(TooLongFrameException e$2) {
        return e$2;
    }

    private static final String exceptionCaught$$anonfun$6() {
        return "Handling Header value error";
    }

    private static final Throwable exceptionCaught$$anonfun$7(IllegalArgumentException e$3) {
        return e$3;
    }

    private static final String exceptionCaught$$anonfun$8() {
        return "Exception caught in Netty";
    }

    private static final Throwable exceptionCaught$$anonfun$9(Throwable e$4) {
        return e$4;
    }

    public static final String play$core$server$netty$PlayRequestHandler$$anon$4$$_$applyOrElse$$anonfun$4() {
        return "Cannot invoke the action";
    }

    public static final Throwable play$core$server$netty$PlayRequestHandler$$anon$4$$_$applyOrElse$$anonfun$5(Throwable error$2) {
        return error$2;
    }

    private final Future invokeAction$1(RequestHeader requestHeader$4, HttpRequest request$7, Try tryApp$5, Materializer mat$2, Future actionFuture, boolean deferBodyParsing) {
        return actionFuture.flatMap((Function1 & Serializable)acc -> {
            if (deferBodyParsing) {
                return acc.run(mat$2);
            }
            Option<Source<ByteString, Object>> body = this.modelConversion((Try<Application>)tryApp$5).convertRequestBody(request$7);
            Option<Source<ByteString, Object>> option = body;
            if (None$.MODULE$.equals(option)) {
                return acc.run(mat$2);
            }
            if (option instanceof Some) {
                Source source = (Source)((Some)option).value();
                return acc.run(source, mat$2);
            }
            throw new MatchError(option);
        }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline()).recoverWith((PartialFunction)new Serializable(requestHeader$4, tryApp$5, this){
            private final RequestHeader requestHeader$5;
            private final Try tryApp$6;
            private final /* synthetic */ PlayRequestHandler $outer;
            {
                this.requestHeader$5 = requestHeader$10;
                this.tryApp$6 = tryApp$11;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable error = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable error = throwable = x;
                PlayRequestHandler$.play$core$server$netty$PlayRequestHandler$$$logger.error(PlayRequestHandler::play$core$server$netty$PlayRequestHandler$$anon$4$$_$applyOrElse$$anonfun$4, () -> PlayRequestHandler.play$core$server$netty$PlayRequestHandler$$anon$4$$_$applyOrElse$$anonfun$5(error), MarkerContext$.MODULE$.NoMarker());
                return this.$outer.play$core$server$netty$PlayRequestHandler$$errorHandler((Try<Application>)this.tryApp$6).onServerError(this.requestHeader$5, error);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{play$core$server$netty$PlayRequestHandler$$anon$4$$_$applyOrElse$$anonfun$4(), play$core$server$netty$PlayRequestHandler$$anon$4$$_$applyOrElse$$anonfun$5(java.lang.Throwable )}, serializedLambda);
            }
        }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
    }

    private final /* synthetic */ Future $anonfun$8$$anonfun$1(RequestHeader requestHeader$11, HttpRequest request$12, Try tryApp$12, Materializer mat$6, Future actionFuture, boolean deferBodyParsing) {
        return this.invokeAction$1(requestHeader$11, request$12, tryApp$12, mat$6, actionFuture, deferBodyParsing);
    }

    private final Accumulator $anonfun$8(EssentialAction action$1, RequestHeader requestHeader$6, HttpRequest request$8, Try tryApp$7, Materializer mat$3, boolean deferBodyParsing$2) {
        return (Accumulator)action$1.apply((Object)(deferBodyParsing$2 ? requestHeader$6.addAttr(RequestAttrKey$.MODULE$.DeferredBodyParsing(), (Function2 & Serializable)(actionFuture, deferBodyParsing) -> this.$anonfun$8$$anonfun$1(requestHeader$6, request$8, tryApp$7, mat$3, (Future)actionFuture, BoxesRunTime.unboxToBoolean((Object)deferBodyParsing))) : requestHeader$6));
    }

    public class ReloadCacheValues
    implements Product,
    Serializable {
        private final ServerResultUtils resultUtils;
        private final NettyModelConversion modelConversion;
        private final Option serverDebugInfo;
        private final /* synthetic */ PlayRequestHandler $outer;

        public ReloadCacheValues(PlayRequestHandler $outer, ServerResultUtils resultUtils, NettyModelConversion modelConversion, Option<ServerDebugInfo> serverDebugInfo) {
            this.resultUtils = resultUtils;
            this.modelConversion = modelConversion;
            this.serverDebugInfo = serverDebugInfo;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReloadCacheValues)) return false;
            if (((ReloadCacheValues)object).play$core$server$netty$PlayRequestHandler$ReloadCacheValues$$$outer() != this.$outer) return false;
            ReloadCacheValues reloadCacheValues = (ReloadCacheValues)object;
            ServerResultUtils serverResultUtils = this.resultUtils();
            ServerResultUtils serverResultUtils2 = reloadCacheValues.resultUtils();
            if (serverResultUtils == null) {
                if (serverResultUtils2 != null) {
                    return false;
                }
            } else if (!serverResultUtils.equals(serverResultUtils2)) return false;
            NettyModelConversion nettyModelConversion = this.modelConversion();
            NettyModelConversion nettyModelConversion2 = reloadCacheValues.modelConversion();
            if (nettyModelConversion == null) {
                if (nettyModelConversion2 != null) {
                    return false;
                }
            } else if (!nettyModelConversion.equals(nettyModelConversion2)) return false;
            Option<ServerDebugInfo> option = this.serverDebugInfo();
            Option<ServerDebugInfo> option2 = reloadCacheValues.serverDebugInfo();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!reloadCacheValues.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ReloadCacheValues;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ReloadCacheValues";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "resultUtils";
                }
                case 1: {
                    return "modelConversion";
                }
                case 2: {
                    return "serverDebugInfo";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ServerResultUtils resultUtils() {
            return this.resultUtils;
        }

        public NettyModelConversion modelConversion() {
            return this.modelConversion;
        }

        public Option<ServerDebugInfo> serverDebugInfo() {
            return this.serverDebugInfo;
        }

        public ReloadCacheValues copy(ServerResultUtils resultUtils, NettyModelConversion modelConversion, Option<ServerDebugInfo> serverDebugInfo) {
            return new ReloadCacheValues(this.$outer, resultUtils, modelConversion, serverDebugInfo);
        }

        public ServerResultUtils copy$default$1() {
            return this.resultUtils();
        }

        public NettyModelConversion copy$default$2() {
            return this.modelConversion();
        }

        public Option<ServerDebugInfo> copy$default$3() {
            return this.serverDebugInfo();
        }

        public ServerResultUtils _1() {
            return this.resultUtils();
        }

        public NettyModelConversion _2() {
            return this.modelConversion();
        }

        public Option<ServerDebugInfo> _3() {
            return this.serverDebugInfo();
        }

        public final /* synthetic */ PlayRequestHandler play$core$server$netty$PlayRequestHandler$ReloadCacheValues$$$outer() {
            return this.$outer;
        }
    }
}

