/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ReferenceCountUtil;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Instant;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.ByteStringBuilder;
import org.playframework.netty.http.DefaultStreamedHttpResponse;
import org.playframework.netty.http.StreamedHttpRequest;
import org.reactivestreams.Publisher;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.http.HeaderNames$;
import play.api.http.HttpChunk;
import play.api.http.HttpEntity;
import play.api.http.HttpErrorHandler;
import play.api.libs.typedmap.TypedMap$;
import play.api.mvc.Headers;
import play.api.mvc.RequestHeader;
import play.api.mvc.RequestHeaderImpl;
import play.api.mvc.ResponseHeader$;
import play.api.mvc.Result;
import play.api.mvc.request.RemoteConnection;
import play.api.mvc.request.RequestAttrKey$;
import play.api.mvc.request.RequestTarget;
import play.core.server.common.ForwardedHeaderHandler;
import play.core.server.common.PathAndQueryParser$;
import play.core.server.common.ServerResultUtils;
import play.core.server.netty.NettyHeadersWrapper;
import play.core.server.netty.NettyModelConversion$;
import play.core.server.netty.SynchronousMappedStreams$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t-c!B\f\u0019\u0001i\u0001\u0003\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\t\u0011=\u0002!\u0011!Q\u0001\nAB\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\u0006\u0005\u0002!\ta\u0011\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003K\u0011\u0019\t\u0006\u0001)A\u0005\u0017\")!\u000b\u0001C\u0001'\")a\u000f\u0001C\u0005o\")!\u0010\u0001C\u0005w\"9\u0011q\u0002\u0001\u0005\n\u0005E\u0001bBA\u000e\u0001\u0011\u0005\u0011Q\u0004\u0005\b\u0003O\u0001A\u0011AA\u0015\u0011\u001d\tY\u0006\u0001C\u0005\u0003;Bq!!\u001b\u0001\t\u0003\tY\u0007C\u0004\u00024\u0002!I!!.\t\u000f\u00055\b\u0001\"\u0003\u0002p\"9!Q\u0002\u0001\u0005\n\t=\u0001b\u0002B\u0011\u0001\u0011%!1\u0005\u0005\n\u0005O\u0001\u0001\u0019!C\u0005\u0005SA\u0011Ba\u000e\u0001\u0001\u0004%IA!\u000f\t\u0011\t\u0015\u0003\u0001)Q\u0005\u0005WAqAa\u0012\u0001\t\u0013\u0011IE\u0001\u000bOKR$\u00180T8eK2\u001cuN\u001c<feNLwN\u001c\u0006\u00033i\tQA\\3uifT!a\u0007\u000f\u0002\rM,'O^3s\u0015\tib$\u0001\u0003d_J,'\"A\u0010\u0002\tAd\u0017-_\n\u0003\u0001\u0005\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0017a\u0003:fgVdG/\u0016;jYN\u001c\u0001\u0001\u0005\u0002+[5\t1F\u0003\u0002-5\u000511m\\7n_:L!AL\u0016\u0003#M+'O^3s%\u0016\u001cX\u000f\u001c;Vi&d7/\u0001\fg_J<\u0018M\u001d3fI\"+\u0017\rZ3s\u0011\u0006tG\r\\3s!\tQ\u0013'\u0003\u00023W\t1bi\u001c:xCJ$W\r\u001a%fC\u0012,'\u000fS1oI2,'/\u0001\u0007tKJ4XM\u001d%fC\u0012,'\u000fE\u0002#k]J!AN\u0012\u0003\r=\u0003H/[8o!\tAtH\u0004\u0002:{A\u0011!hI\u0007\u0002w)\u0011A\bK\u0001\u0007yI|w\u000e\u001e \n\u0005y\u001a\u0013A\u0002)sK\u0012,g-\u0003\u0002A\u0003\n11\u000b\u001e:j]\u001eT!AP\u0012\u0002\rqJg.\u001b;?)\u0011!ei\u0012%\u0011\u0005\u0015\u0003Q\"\u0001\r\t\u000b\u001d\"\u0001\u0019A\u0015\t\u000b=\"\u0001\u0019\u0001\u0019\t\u000bM\"\u0001\u0019\u0001\u001b\u0002\r1|wmZ3s+\u0005Y\u0005C\u0001'P\u001b\u0005i%B\u0001(\u001f\u0003\r\t\u0007/[\u0005\u0003!6\u0013a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u000fG>tg/\u001a:u%\u0016\fX/Z:u)\r!\u0006M\u001b\t\u0004+bSV\"\u0001,\u000b\u0005]\u001b\u0013\u0001B;uS2L!!\u0017,\u0003\u0007Q\u0013\u0018\u0010\u0005\u0002\\=6\tAL\u0003\u0002^\u001b\u0006\u0019QN^2\n\u0005}c&!\u0004*fcV,7\u000f\u001e%fC\u0012,'\u000fC\u0003b\u000f\u0001\u0007!-A\u0004dQ\u0006tg.\u001a7\u0011\u0005\rDW\"\u00013\u000b\u0005\u0005,'BA\rg\u0015\u00059\u0017AA5p\u0013\tIGMA\u0004DQ\u0006tg.\u001a7\t\u000b-<\u0001\u0019\u00017\u0002\u000fI,\u0017/^3tiB\u0011Q\u000e^\u0007\u0002]*\u0011q\u000e]\u0001\u0005QR$\bO\u0003\u0002re\u0006)1m\u001c3fG*\u00111/Z\u0001\bQ\u0006tG\r\\3s\u0013\t)hNA\u0006IiR\u0004(+Z9vKN$\u0018A\u0005;ssR{7I]3bi\u0016\u0014V-];fgR$2\u0001\u0016=z\u0011\u0015\t\u0007\u00021\u0001c\u0011\u0015Y\u0007\u00021\u0001m\u0003Y\u0019'/Z1uKJ+Wn\u001c;f\u0007>tg.Z2uS>tG#\u0002?\u0002\u0004\u0005\u0015\u0001CA?\u0000\u001b\u0005q(BA6]\u0013\r\t\tA \u0002\u0011%\u0016lw\u000e^3D_:tWm\u0019;j_:DQ!Y\u0005A\u0002\tDq!a\u0002\n\u0001\u0004\tI!A\u0004iK\u0006$WM]:\u0011\u0007m\u000bY!C\u0002\u0002\u000eq\u0013q\u0001S3bI\u0016\u00148/A\nde\u0016\fG/\u001a*fcV,7\u000f\u001e+be\u001e,G\u000f\u0006\u0003\u0002\u0014\u0005e\u0001cA?\u0002\u0016%\u0019\u0011q\u0003@\u0003\u001bI+\u0017/^3tiR\u000b'oZ3u\u0011\u0015Y'\u00021\u0001m\u0003M\u0019'/Z1uKJ+\u0017/^3ti\"+\u0017\rZ3s)\u001dQ\u0016qDA\u0011\u0003GAQ!Y\u0006A\u0002\tDQa[\u0006A\u00021Dq!!\n\f\u0001\u0004\t\u0019\"\u0001\u0004uCJ<W\r^\u0001\u0013G>tg/\u001a:u%\u0016\fX/Z:u\u0005>$\u0017\u0010\u0006\u0003\u0002,\u0005e\u0003\u0003\u0002\u00126\u0003[\u0001\u0002\"a\f\u0002F\u0005%\u00131K\u0007\u0003\u0003cQA!a\r\u00026\u0005A1oY1mC\u0012\u001cHN\u0003\u0003\u00028\u0005e\u0012AB:ue\u0016\fWN\u0003\u0003\u0002<\u0005u\u0012!\u00029fW.|'\u0002BA \u0003\u0003\na!\u00199bG\",'BAA\"\u0003\ry'oZ\u0005\u0005\u0003\u000f\n\tD\u0001\u0004T_V\u00148-\u001a\t\u0005\u0003\u0017\ny%\u0004\u0002\u0002N)\u0019q+!\u000f\n\t\u0005E\u0013Q\n\u0002\u000b\u0005f$Xm\u0015;sS:<\u0007c\u0001\u0012\u0002V%\u0019\u0011qK\u0012\u0003\u0007\u0005s\u0017\u0010C\u0003l\u0019\u0001\u0007A.A\fiiR\u00048i\u001c8uK:$Hk\u001c\"zi\u0016\u001cFO]5oOR!\u0011\u0011JA0\u0011\u001d\t\t'\u0004a\u0001\u0003G\nqaY8oi\u0016tG\u000fE\u0002n\u0003KJ1!a\u001ao\u0005-AE\u000f\u001e9D_:$XM\u001c;\u0002\u001b\r|gN^3siJ+7/\u001e7u))\ti'!$\u0002\u0018\u0006m\u0015Q\u0015\u000b\u0005\u0003_\n\t\t\u0005\u0004\u0002r\u0005]\u00141P\u0007\u0003\u0003gR1!!\u001e$\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003s\n\u0019H\u0001\u0004GkR,(/\u001a\t\u0004[\u0006u\u0014bAA@]\na\u0001\n\u001e;q%\u0016\u001c\bo\u001c8tK\"9\u00111\u0011\bA\u0004\u0005\u0015\u0015aA7biB!\u0011qQAE\u001b\t\t)$\u0003\u0003\u0002\f\u0006U\"\u0001D'bi\u0016\u0014\u0018.\u00197ju\u0016\u0014\bbBAH\u001d\u0001\u0007\u0011\u0011S\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0011\u0007m\u000b\u0019*C\u0002\u0002\u0016r\u0013aAU3tk2$\bBBAM\u001d\u0001\u0007!,A\u0007sKF,Xm\u001d;IK\u0006$WM\u001d\u0005\b\u0003;s\u0001\u0019AAP\u0003-AG\u000f\u001e9WKJ\u001c\u0018n\u001c8\u0011\u00075\f\t+C\u0002\u0002$:\u00141\u0002\u0013;uaZ+'o]5p]\"9\u0011q\u0015\bA\u0002\u0005%\u0016\u0001D3se>\u0014\b*\u00198eY\u0016\u0014\b\u0003BAV\u0003_k!!!,\u000b\u0005=l\u0015\u0002BAY\u0003[\u0013\u0001\u0003\u0013;ua\u0016\u0013(o\u001c:IC:$G.\u001a:\u0002-\r\u0014X-\u0019;f'R\u0014X-Y7fIJ+7\u000f]8og\u0016$\u0002\"a.\u0002L\u0006\u0005\u00181\u001d\u000b\u0005\u0003s\u000bI\r\u0005\u0003\u0002<\u0006\u0015WBAA_\u0015\ry\u0017q\u0018\u0006\u00043\u0005\u0005'\u0002BAb\u0003\u0003\nQ\u0002\u001d7bs\u001a\u0014\u0018-\\3x_J\\\u0017\u0002BAd\u0003{\u00131\u0004R3gCVdGo\u0015;sK\u0006lW\r\u001a%uiB\u0014Vm\u001d9p]N,\u0007bBAB\u001f\u0001\u000f\u0011Q\u0011\u0005\b\u0003oy\u0001\u0019AAga\u0011\ty-!6\u0011\u0011\u0005=\u0012QIA%\u0003#\u0004B!a5\u0002V2\u0001A\u0001DAl\u0003\u0017\f\t\u0011!A\u0003\u0002\u0005e'\u0001\u0003\u0013r[\u0006\u00148\u000eJ\u0019\u0012\t\u0005m\u00171\u000b\t\u0004E\u0005u\u0017bAApG\t9aj\u001c;iS:<\u0007bBAO\u001f\u0001\u0007\u0011q\u0014\u0005\b\u0003K|\u0001\u0019AAt\u00039\u0011Xm\u001d9p]N,7\u000b^1ukN\u00042!\\Au\u0013\r\tYO\u001c\u0002\u0013\u0011R$\bOU3ta>t7/Z*uCR,8/A\u000bde\u0016\fG/Z\"ik:\\W\r\u001a*fgB|gn]3\u0015\u0011\u0005E\u0018Q\u001fB\u0005\u0005\u0017!B!!/\u0002t\"9\u00111\u0011\tA\u0004\u0005\u0015\u0005bBA|!\u0001\u0007\u0011\u0011`\u0001\u0007G\",hn[:1\t\u0005m(Q\u0001\t\t\u0003_\t)%!@\u0003\u0004A!\u00111VA\u0000\u0013\u0011\u0011\t!!,\u0003\u0013!#H\u000f]\"ik:\\\u0007\u0003BAj\u0005\u000b!ABa\u0002\u0002v\u0006\u0005\t\u0011!B\u0001\u00033\u0014\u0001\u0002J9nCJ\\GE\r\u0005\b\u0003;\u0003\u0002\u0019AAP\u0011\u001d\t)\u000f\u0005a\u0001\u0003O\f1CY=uKN#(/\u001b8h)>\u0014\u0015\u0010^3Ck\u001a$BA!\u0005\u0003\u001eA!!1\u0003B\r\u001b\t\u0011)BC\u0002\u0003\u0018\u0015\faAY;gM\u0016\u0014\u0018\u0002\u0002B\u000e\u0005+\u0011qAQ=uK\n+h\rC\u0004\u0003 E\u0001\r!!\u0013\u0002\u000b\tLH/Z:\u0002/\tLH/Z*ue&tw\rV8IiR\u00048i\u001c8uK:$H\u0003BA2\u0005KAqAa\b\u0013\u0001\u0004\tI%\u0001\tdC\u000eDW\r\u001a#bi\u0016DU-\u00193feV\u0011!1\u0006\t\u0007E\t5\"\u0011G\u001c\n\u0007\t=2E\u0001\u0004UkBdWM\r\t\u0004E\tM\u0012b\u0001B\u001bG\t!Aj\u001c8h\u0003Q\u0019\u0017m\u00195fI\u0012\u000bG/\u001a%fC\u0012,'o\u0018\u0013fcR!!1\bB!!\r\u0011#QH\u0005\u0004\u0005\u007f\u0019#\u0001B+oSRD\u0011Ba\u0011\u0015\u0003\u0003\u0005\rAa\u000b\u0002\u0007a$\u0013'A\tdC\u000eDW\r\u001a#bi\u0016DU-\u00193fe\u0002\n!\u0002Z1uK\"+\u0017\rZ3s+\u00059\u0004")
public class NettyModelConversion {
    private final ServerResultUtils resultUtils;
    private final ForwardedHeaderHandler forwardedHeaderHandler;
    private final Option<String> serverHeader;
    private final Logger play$core$server$netty$NettyModelConversion$$logger;
    private Tuple2<Object, String> cachedDateHeader;

    public Logger play$core$server$netty$NettyModelConversion$$logger() {
        return this.play$core$server$netty$NettyModelConversion$$logger;
    }

    public Try<RequestHeader> convertRequest(Channel channel, HttpRequest request) {
        if (request.decoderResult().isFailure()) {
            return new Failure(request.decoderResult().cause());
        }
        return this.tryToCreateRequest(channel, request);
    }

    private Try<RequestHeader> tryToCreateRequest(Channel channel, HttpRequest request) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            RequestTarget target = this.createRequestTarget(request);
            return this.createRequestHeader(channel, request, target);
        });
    }

    private RemoteConnection createRemoteConnection(Channel channel, Headers headers) {
        RemoteConnection rawConnection = new RemoteConnection(null, channel){
            private InetAddress remoteAddress;
            private Option<Seq<X509Certificate>> clientCertificateChain;
            private final Option<SslHandler> sslHandler;
            private volatile byte bitmap$0;
            private Channel channel$2;

            public String remoteAddressString() {
                return RemoteConnection.remoteAddressString$((RemoteConnection)this);
            }

            public String toString() {
                return RemoteConnection.toString$((RemoteConnection)this);
            }

            public boolean equals(Object obj) {
                return RemoteConnection.equals$((RemoteConnection)this, (Object)obj);
            }

            private InetAddress remoteAddress$lzycompute() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 1) == 0) {
                        this.remoteAddress = ((InetSocketAddress)this.channel$2.remoteAddress()).getAddress();
                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                    }
                }
                this.channel$2 = null;
                return this.remoteAddress;
            }

            public InetAddress remoteAddress() {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    return this.remoteAddress$lzycompute();
                }
                return this.remoteAddress;
            }

            private Option<SslHandler> sslHandler() {
                return this.sslHandler;
            }

            public boolean secure() {
                return this.sslHandler().isDefined();
            }

            private Option<Seq<X509Certificate>> clientCertificateChain$lzycompute() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 2) == 0) {
                        this.clientCertificateChain = this.liftedTree1$1();
                        this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                    }
                }
                return this.clientCertificateChain;
            }

            public Option<Seq<X509Certificate>> clientCertificateChain() {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    return this.clientCertificateChain$lzycompute();
                }
                return this.clientCertificateChain;
            }

            private final /* synthetic */ Option liftedTree1$1() {
                None$ none$;
                try {
                    none$ = this.sslHandler().map((Function1 & Serializable)handler -> (Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])handler.engine().getSession().getPeerCertificates())).collect((PartialFunction)new Serializable(null){
                        private static final long serialVersionUID = 0L;

                        public final <A1 extends Certificate, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            if (A1 instanceof X509Certificate) {
                                X509Certificate x509Certificate = (X509Certificate)A1;
                                return (B1)x509Certificate;
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Certificate x1) {
                            Certificate certificate = x1;
                            return certificate instanceof X509Certificate;
                        }
                    }));
                }
                catch (SSLPeerUnverifiedException e) {
                    none$ = None$.MODULE$;
                }
                return none$;
            }
            {
                this.channel$2 = channel$2;
                RemoteConnection.$init$((RemoteConnection)this);
                this.sslHandler = Option$.MODULE$.apply((Object)channel$2.pipeline().get(SslHandler.class));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$clientCertificateChain$1(io.netty.handler.ssl.SslHandler )}, serializedLambda);
            }
        };
        return this.forwardedHeaderHandler.forwardedConnection(rawConnection, headers);
    }

    private RequestTarget createRequestTarget(HttpRequest request) {
        Tuple2 tuple2 = PathAndQueryParser$.MODULE$.parse(request.uri());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String parsedPath = (String)tuple2._1();
        String parsedQueryString = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)parsedPath, (Object)parsedQueryString);
        String parsedPath2 = (String)tuple22._1();
        String parsedQueryString2 = (String)tuple22._2();
        return new RequestTarget(this, request, parsedPath2, parsedQueryString2){
            private URI uri;
            private final String path;
            private final String queryString;
            private final Map<String, Seq<String>> queryMap;
            private volatile boolean bitmap$0;
            private final /* synthetic */ NettyModelConversion $outer;
            private final HttpRequest request$2;

            public Option<String> getQueryParameter(String key) {
                return RequestTarget.getQueryParameter$((RequestTarget)this, (String)key);
            }

            public RequestTarget withUri(URI newUri) {
                return RequestTarget.withUri$((RequestTarget)this, (URI)newUri);
            }

            public RequestTarget withUriString(String newUriString) {
                return RequestTarget.withUriString$((RequestTarget)this, (String)newUriString);
            }

            public RequestTarget withPath(String newPath) {
                return RequestTarget.withPath$((RequestTarget)this, (String)newPath);
            }

            public RequestTarget withQueryString(Map<String, Seq<String>> newQueryString) {
                return RequestTarget.withQueryString$((RequestTarget)this, newQueryString);
            }

            private URI uri$lzycompute() {
                $anon$2 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.bitmap$0) {
                        this.uri = new URI(this.uriString());
                        this.bitmap$0 = true;
                    }
                }
                return this.uri;
            }

            public URI uri() {
                if (!this.bitmap$0) {
                    return this.uri$lzycompute();
                }
                return this.uri;
            }

            public String uriString() {
                return this.request$2.uri();
            }

            public String path() {
                return this.path;
            }

            public String queryString() {
                return this.queryString;
            }

            public Map<String, Seq<String>> queryMap() {
                return this.queryMap;
            }

            private final /* synthetic */ Map liftedTree2$1(QueryStringDecoder decoder$1) {
                Map map;
                try {
                    map = CollectionConverters$.MODULE$.MapHasAsScala(decoder$1.parameters()).asScala().view().mapValues((Function1 & Serializable)x$2 -> CollectionConverters$.MODULE$.ListHasAsScala(x$2).asScala().toList()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    IllegalArgumentException illegalArgumentException;
                    Throwable throwable3 = throwable;
                    if (throwable3 instanceof IllegalArgumentException && (illegalArgumentException = (IllegalArgumentException)throwable3).getMessage().startsWith("invalid hex byte")) {
                        throw illegalArgumentException;
                    }
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        this.$outer.play$core$server$netty$NettyModelConversion$$logger().warn((Function0 & Serializable)() -> "Failed to parse query string; returning empty map.", (Function0 & Serializable)() -> throwable2, MarkerContext$.MODULE$.NoMarker());
                        map = Predef$.MODULE$.Map().empty();
                    }
                    throw throwable;
                }
                return map;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$2 = request$2;
                RequestTarget.$init$((RequestTarget)this);
                this.path = parsedPath$1;
                this.queryString = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(parsedQueryString$1), "?");
                QueryStringDecoder decoder = new QueryStringDecoder(parsedQueryString$1);
                this.queryMap = this.liftedTree2$1(decoder);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$queryMap$1(java.util.List ), $anonfun$queryMap$2(), $anonfun$queryMap$3(java.lang.Throwable )}, serializedLambda);
            }
        };
    }

    public RequestHeader createRequestHeader(Channel channel, HttpRequest request, RequestTarget target) {
        NettyHeadersWrapper headers = new NettyHeadersWrapper(request.headers());
        return new RequestHeaderImpl(this.createRemoteConnection(channel, headers), request.method().name(), target, request.protocolVersion().text(), (Headers)headers, TypedMap$.MODULE$.apply(RequestAttrKey$.MODULE$.Server().$minus$greater((Object)"netty")));
    }

    public Option<Source<ByteString, Object>> convertRequestBody(HttpRequest request) {
        HttpRequest httpRequest = request;
        if (httpRequest instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)httpRequest;
            ByteString content2 = this.httpContentToByteString((HttpContent)fullHttpRequest);
            if (content2.isEmpty()) {
                return None$.MODULE$;
            }
            return new Some((Object)Source$.MODULE$.single((Object)content2));
        }
        if (httpRequest instanceof StreamedHttpRequest) {
            StreamedHttpRequest streamedHttpRequest = (StreamedHttpRequest)httpRequest;
            return new Some((Object)Source$.MODULE$.fromPublisher(SynchronousMappedStreams$.MODULE$.map(streamedHttpRequest, (Function1 & Serializable)content -> this.httpContentToByteString((HttpContent)content))));
        }
        throw new MatchError((Object)httpRequest);
    }

    private ByteString httpContentToByteString(HttpContent content) {
        ByteStringBuilder builder = ByteString$.MODULE$.newBuilder();
        content.content().readBytes(builder.asOutputStream(), content.content().readableBytes());
        ByteString bytes = builder.result();
        ReferenceCountUtil.release((Object)content);
        return bytes;
    }

    public Future<HttpResponse> convertResult(Result result2, RequestHeader requestHeader, HttpVersion httpVersion, HttpErrorHandler errorHandler, Materializer mat) {
        return this.resultUtils.resultConversionWithErrorHandling(requestHeader, result2, errorHandler, (Function1 & Serializable)result -> {
            DefaultFullHttpResponse response;
            block16: {
                DefaultFullHttpResponse defaultFullHttpResponse;
                HttpResponseStatus httpResponseStatus;
                Option option = result.header().reasonPhrase();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String phrase = (String)some.value();
                    httpResponseStatus = new HttpResponseStatus(result.header().status(), phrase);
                } else if (None$.MODULE$.equals(option)) {
                    httpResponseStatus = HttpResponseStatus.valueOf((int)result.header().status());
                } else {
                    throw new MatchError((Object)option);
                }
                HttpResponseStatus responseStatus = httpResponseStatus;
                ServerResultUtils.ConnectionHeader connectionHeader = $this.resultUtils.determineConnectionHeader(requestHeader, result);
                String string = requestHeader.method();
                String string2 = HttpMethod.HEAD.name();
                boolean skipEntity = !(string != null ? !string.equals(string2) : string2 != null);
                HttpEntity httpEntity = result.body();
                if (skipEntity) {
                    $this.resultUtils.cancelEntity(httpEntity, mat);
                    defaultFullHttpResponse = new DefaultFullHttpResponse(httpVersion, responseStatus, Unpooled.EMPTY_BUFFER);
                } else if (httpEntity instanceof HttpEntity.Strict) {
                    HttpEntity.Strict strict = (HttpEntity.Strict)httpEntity;
                    ByteString data = strict.data();
                    defaultFullHttpResponse = new DefaultFullHttpResponse(httpVersion, responseStatus, this.byteStringToByteBuf(data));
                } else if (httpEntity instanceof HttpEntity.Streamed) {
                    HttpEntity.Streamed streamed = (HttpEntity.Streamed)httpEntity;
                    Source stream = streamed.data();
                    defaultFullHttpResponse = this.createStreamedResponse(stream, httpVersion, responseStatus, mat);
                } else if (httpEntity instanceof HttpEntity.Chunked) {
                    HttpEntity.Chunked chunked = (HttpEntity.Chunked)httpEntity;
                    Source chunks = chunked.chunks();
                    defaultFullHttpResponse = this.createChunkedResponse(chunks, httpVersion, responseStatus, mat);
                } else {
                    throw new MatchError((Object)httpEntity);
                }
                response = defaultFullHttpResponse;
                Iterable headers = $this.resultUtils.splitSetCookieHeaders(result.header().headers());
                headers.foreach(arg_0 -> NettyModelConversion.$anonfun$convertResult$2((HttpResponse)response, arg_0));
                if ($this.resultUtils.mayHaveEntity(result.header().status())) {
                    result.body().contentLength().foreach((Function1)((JFunction1.mcVJ.sp & Serializable)arg_0 -> NettyModelConversion.$anonfun$convertResult$3(this, (HttpResponse)response, arg_0)));
                    v3 = BoxedUnit.UNIT;
                } else if (HttpUtil.isContentLengthSet((HttpMessage)response)) {
                    String manualContentLength = response.headers().get(HeaderNames$.MODULE$.CONTENT_LENGTH());
                    this.play$core$server$netty$NettyModelConversion$$logger().warn((Function0 & Serializable)() -> "Ignoring manual Content-Length (" + manualContentLength + ") since it is not allowed for " + result.header().status() + " responses.", MarkerContext$.MODULE$.NoMarker());
                    v3 = response.headers().remove(HeaderNames$.MODULE$.CONTENT_LENGTH());
                } else {
                    v3 = BoxedUnit.UNIT;
                }
                result.body().contentType().foreach(arg_0 -> NettyModelConversion.$anonfun$convertResult$7(this, (HttpResponse)response, arg_0));
                connectionHeader.header().foreach(arg_0 -> NettyModelConversion.$anonfun$convertResult$9((HttpResponse)response, arg_0));
                Object object = !response.headers().contains(HeaderNames$.MODULE$.DATE()) ? response.headers().add(HeaderNames$.MODULE$.DATE(), (Object)this.dateHeader()) : BoxedUnit.UNIT;
                if (response.headers().contains(HeaderNames$.MODULE$.SERVER())) break block16;
                $this.serverHeader.foreach(arg_0 -> NettyModelConversion.$anonfun$convertResult$10((HttpResponse)response, arg_0));
            }
            return Future$.MODULE$.successful((Object)response);
        }, (Function0 & Serializable)() -> {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(httpVersion, HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.EMPTY_BUFFER);
            HttpUtil.setContentLength((HttpMessage)response, (long)0L);
            response.headers().add(HeaderNames$.MODULE$.DATE(), (Object)this.dateHeader());
            $this.serverHeader.foreach((Function1 & Serializable)x$4 -> response.headers().add(HeaderNames$.MODULE$.SERVER(), x$4));
            response.headers().add(HeaderNames$.MODULE$.CONNECTION(), (Object)"close");
            return response;
        });
    }

    private DefaultStreamedHttpResponse createStreamedResponse(Source<ByteString, ?> stream, HttpVersion httpVersion, HttpResponseStatus responseStatus, Materializer mat) {
        Publisher publisher = SynchronousMappedStreams$.MODULE$.map((Publisher)stream.runWith((Graph)Sink$.MODULE$.asPublisher(false), mat), (Function1 & Serializable)bytes -> this.byteStringToHttpContent((ByteString)bytes));
        return new DefaultStreamedHttpResponse(httpVersion, responseStatus, publisher);
    }

    private DefaultStreamedHttpResponse createChunkedResponse(Source<HttpChunk, ?> chunks, HttpVersion httpVersion, HttpResponseStatus responseStatus, Materializer mat) {
        Publisher publisher = (Publisher)chunks.runWith((Graph)Sink$.MODULE$.asPublisher(false), mat);
        Publisher httpContentPublisher = SynchronousMappedStreams$.MODULE$.map(publisher, (Function1 & Serializable)x0$1 -> {
            HttpChunk httpChunk = x0$1;
            if (httpChunk instanceof HttpChunk.Chunk) {
                HttpChunk.Chunk chunk = (HttpChunk.Chunk)httpChunk;
                ByteString bytes = chunk.data();
                return new DefaultHttpContent(this.byteStringToByteBuf(bytes));
            }
            if (httpChunk instanceof HttpChunk.LastChunk) {
                HttpChunk.LastChunk lastChunk = (HttpChunk.LastChunk)httpChunk;
                Headers trailers = lastChunk.trailers();
                DefaultLastHttpContent lastChunk2 = new DefaultLastHttpContent();
                trailers.headers().foreach((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        return lastChunk2.trailingHeaders().add(name, (Object)value);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return lastChunk2;
            }
            throw new MatchError((Object)httpChunk);
        });
        DefaultStreamedHttpResponse response = new DefaultStreamedHttpResponse(httpVersion, responseStatus, httpContentPublisher);
        HttpUtil.setTransferEncodingChunked((HttpMessage)response, (boolean)true);
        return response;
    }

    private ByteBuf byteStringToByteBuf(ByteString bytes) {
        if (bytes.isEmpty()) {
            return Unpooled.EMPTY_BUFFER;
        }
        return Unpooled.wrappedBuffer((ByteBuffer)bytes.asByteBuffer());
    }

    private HttpContent byteStringToHttpContent(ByteString bytes) {
        return new DefaultHttpContent(this.byteStringToByteBuf(bytes));
    }

    private Tuple2<Object, String> cachedDateHeader() {
        return this.cachedDateHeader;
    }

    private void cachedDateHeader_$eq(Tuple2<Object, String> x$1) {
        this.cachedDateHeader = x$1;
    }

    private String dateHeader() {
        long currentTimeMillis = System.currentTimeMillis();
        long currentTimeSeconds = currentTimeMillis / 1000L;
        Tuple2<Object, String> tuple2 = this.cachedDateHeader();
        if (tuple2 != null) {
            long cachedSeconds = tuple2._1$mcJ$sp();
            String dateHeaderString = (String)tuple2._2();
            if (cachedSeconds == currentTimeSeconds) {
                return dateHeaderString;
            }
        }
        String dateHeaderString = ResponseHeader$.MODULE$.httpDateFormat().format(Instant.ofEpochMilli(currentTimeMillis));
        this.cachedDateHeader_$eq((Tuple2<Object, String>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)currentTimeSeconds)), (Object)dateHeaderString));
        return dateHeaderString;
    }

    public static final /* synthetic */ HttpHeaders $anonfun$convertResult$2(HttpResponse response$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            String value = (String)tuple2._2();
            return response$1.headers().add(name, (Object)value);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$convertResult$3(NettyModelConversion $this, HttpResponse response$1, long contentLength) {
        if (HttpUtil.isContentLengthSet((HttpMessage)response$1)) {
            String manualContentLength;
            String string = manualContentLength = response$1.headers().get(HeaderNames$.MODULE$.CONTENT_LENGTH());
            String string2 = Long.toString(contentLength);
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                $this.play$core$server$netty$NettyModelConversion$$logger().info((Function0 & Serializable)() -> "Manual Content-Length header, ignoring manual header.", MarkerContext$.MODULE$.NoMarker());
            } else {
                $this.play$core$server$netty$NettyModelConversion$$logger().warn((Function0 & Serializable)() -> "Content-Length header was set manually in the header (" + manualContentLength + ") but is not the same as actual content length (" + contentLength + ").", MarkerContext$.MODULE$.NoMarker());
            }
        }
        HttpUtil.setContentLength((HttpMessage)response$1, (long)contentLength);
    }

    public static final /* synthetic */ Object $anonfun$convertResult$7(NettyModelConversion $this, HttpResponse response$1, String contentType) {
        if (response$1.headers().contains(HeaderNames$.MODULE$.CONTENT_TYPE())) {
            $this.play$core$server$netty$NettyModelConversion$$logger().warn((Function0 & Serializable)() -> "Content-Type set both in header (" + response$1.headers().get(HeaderNames$.MODULE$.CONTENT_TYPE()) + ") and attached to entity (" + contentType + "), ignoring content type from entity. To remove this warning, use Result.as(...) to set the content type, rather than setting the header manually.", MarkerContext$.MODULE$.NoMarker());
            return BoxedUnit.UNIT;
        }
        return response$1.headers().add(HeaderNames$.MODULE$.CONTENT_TYPE(), (Object)contentType);
    }

    public static final /* synthetic */ HttpHeaders $anonfun$convertResult$9(HttpResponse response$1, String headerValue) {
        return response$1.headers().set(HeaderNames$.MODULE$.CONNECTION(), (Object)headerValue);
    }

    public static final /* synthetic */ HttpHeaders $anonfun$convertResult$10(HttpResponse response$1, String x$3) {
        return response$1.headers().add(HeaderNames$.MODULE$.SERVER(), (Object)x$3);
    }

    public NettyModelConversion(ServerResultUtils resultUtils, ForwardedHeaderHandler forwardedHeaderHandler, Option<String> serverHeader) {
        this.resultUtils = resultUtils;
        this.forwardedHeaderHandler = forwardedHeaderHandler;
        this.serverHeader = serverHeader;
        this.play$core$server$netty$NettyModelConversion$$logger = Logger$.MODULE$.apply(NettyModelConversion.class);
        this.cachedDateHeader = new Tuple2((Object)BoxesRunTime.boxToLong((long)Long.MIN_VALUE), null);
    }
}

