/*
 * Decompiled with CFR 0.152.
 */
package play.core.server;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigMemorySize;
import com.typesafe.config.ConfigValue;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.ChannelMatchers;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.unix.UnixChannelOption;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.EventExecutor;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.CoordinatedShutdown;
import org.apache.pekko.actor.CoordinatedShutdown$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Sink;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.playframework.netty.HandlerPublisher;
import org.playframework.netty.http.HttpStreamsServerHandler;
import org.reactivestreams.Publisher;
import play.api.Application;
import play.api.BuiltInComponents;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.MarkerContext$;
import play.api.Mode;
import play.api.http.HttpProtocol$;
import play.api.internal.libs.concurrent.CoordinatedShutdownSupport$;
import play.api.mvc.Handler;
import play.api.mvc.RequestHeader;
import play.core.ApplicationProvider;
import play.core.NamedThreadFactory;
import play.core.server.Jdk$;
import play.core.server.Native$;
import play.core.server.NettyServer$;
import play.core.server.NettyServerProvider;
import play.core.server.NettyTransport;
import play.core.server.Server;
import play.core.server.Server$;
import play.core.server.ServerConfig;
import play.core.server.ServerEndpoint;
import play.core.server.ServerEndpoints;
import play.core.server.ServerListenException;
import play.core.server.ServerStartException;
import play.core.server.ServerStartException$;
import play.core.server.netty.NettyIdleHandler;
import play.core.server.netty.PlayRequestHandler;
import play.core.server.ssl.ServerSSLEngine$;
import play.server.SSLEngineProvider;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r]h\u0001B.]\u0001\rD\u0001\u0002\u001d\u0001\u0003\u0002\u0003\u0006I!\u001d\u0005\ti\u0002\u0011)\u0019!C\u0001k\"A!\u0010\u0001B\u0001B\u0003%a\u000f\u0003\u0005|\u0001\t\u0005\t\u0015!\u0003}\u0011)\tI\u0003\u0001BC\u0002\u0013\u0005\u00111\u0006\u0005\u000b\u0003\u000b\u0002!\u0011!Q\u0001\n\u00055\u0002BCA$\u0001\t\u0015\r\u0011b\u0001\u0002J!Q\u0011q\u000b\u0001\u0003\u0002\u0003\u0006I!a\u0013\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\!I\u0011Q\u000f\u0001C\u0002\u0013%\u0011q\u000f\u0005\t\u0003\u000b\u0003\u0001\u0015!\u0003\u0002z!I\u0011q\u0011\u0001C\u0002\u0013%\u0011q\u000f\u0005\t\u0003\u0013\u0003\u0001\u0015!\u0003\u0002z!I\u00111\u0012\u0001C\u0002\u0013%\u0011Q\u0012\u0005\t\u0003W\u0003\u0001\u0015!\u0003\u0002\u0010\"I\u0011Q\u0016\u0001C\u0002\u0013%\u0011q\u0016\u0005\t\u0003o\u0003\u0001\u0015!\u0003\u00022\"I\u0011\u0011\u0018\u0001C\u0002\u0013%\u0011q\u0016\u0005\t\u0003w\u0003\u0001\u0015!\u0003\u00022\"I\u0011Q\u0018\u0001C\u0002\u0013%\u0011q\u0018\u0005\t\u0003\u000f\u0004\u0001\u0015!\u0003\u0002B\"I\u0011\u0011\u001a\u0001C\u0002\u0013%\u0011q\u0016\u0005\t\u0003\u0017\u0004\u0001\u0015!\u0003\u00022\"I\u0011Q\u001a\u0001C\u0002\u0013%\u0011q\u0016\u0005\t\u0003\u001f\u0004\u0001\u0015!\u0003\u00022\"I\u0011\u0011\u001b\u0001C\u0002\u0013%\u00111\u001b\u0005\t\u00037\u0004\u0001\u0015!\u0003\u0002V\"I\u0011Q\u001c\u0001C\u0002\u0013%\u0011q\u001c\u0005\t\u0003g\u0004\u0001\u0015!\u0003\u0002b\"I\u0011Q\u001f\u0001C\u0002\u0013%\u0011q\u001c\u0005\t\u0003o\u0004\u0001\u0015!\u0003\u0002b\"I\u0011\u0011 \u0001C\u0002\u0013%\u00111\u001b\u0005\t\u0003w\u0004\u0001\u0015!\u0003\u0002V\"I\u0011Q \u0001C\u0002\u0013%\u00111\u001b\u0005\t\u0003\u007f\u0004\u0001\u0015!\u0003\u0002V\"I!\u0011\u0001\u0001C\u0002\u0013%!1\u0001\u0005\t\u0005#\u0001\u0001\u0015!\u0003\u0003\u0006!I!1\u0003\u0001C\u0002\u0013%!1\u0001\u0005\t\u0005+\u0001\u0001\u0015!\u0003\u0003\u0006!I!q\u0003\u0001C\u0002\u0013%!\u0011\u0004\u0005\t\u0005C\u0001\u0001\u0015!\u0003\u0003\u001c!I!1\u0005\u0001C\u0002\u0013%!\u0011\u0004\u0005\t\u0005K\u0001\u0001\u0015!\u0003\u0003\u001c!I!q\u0005\u0001C\u0002\u0013%!\u0011\u0006\u0005\t\u0005[\u0001\u0001\u0015!\u0003\u0003,!I!q\u0006\u0001C\u0002\u0013%\u0011q\u0016\u0005\t\u0005c\u0001\u0001\u0015!\u0003\u00022\"I!1\u0007\u0001C\u0002\u0013%!Q\u0007\u0005\t\u0005o\u0001\u0001\u0015!\u0003\u0002\u0016\"I!\u0011\b\u0001C\u0002\u0013%!1\u0001\u0005\t\u0005w\u0001\u0001\u0015!\u0003\u0003\u0006!I!Q\b\u0001C\u0002\u0013%\u00111\u001b\u0005\t\u0005\u007f\u0001\u0001\u0015!\u0003\u0002V\"Q!\u0011\t\u0001\t\u0006\u0004%IAa\u0011\t\u000f\t\r\u0004\u0001\"\u0011\u0003f!I!Q\u000e\u0001C\u0002\u0013%!q\u000e\u0005\t\u0005\u0007\u0003\u0001\u0015!\u0003\u0003r!I!Q\u0011\u0001C\u0002\u0013%!q\u0011\u0005\t\u0005+\u0003\u0001\u0015!\u0003\u0003\n\"Q!q\u0013\u0001\t\u0006\u0004%IA!'\t\u000f\t\u001d\u0006\u0001\"\u0003\u0003*\"I!Q\u001a\u0001\u0012\u0002\u0013%!q\u001a\u0005\b\u0005K\u0004A\u0011\u0002Bt\u0011!\u0019I\u0002\u0001Q\u0005\u0012\rm\u0001bBB\u0012\u0001\u0011%1Q\u0005\u0005\n\u0007\u007f\u0001!\u0019!C\u0005\u0007\u0003B\u0001b!\u0012\u0001A\u0003%11\t\u0005\n\u0007\u000f\u0002!\u0019!C\u0005\u0007\u0003B\u0001b!\u0013\u0001A\u0003%11\t\u0005\b\u0007\u0017\u0002A\u0011BB'\u0011\u001d\u0019\u0019\u0006\u0001C!\u0007+Bqaa\u0016\u0001\t\u0013\u0019)\u0006C\u0004\u0004Z\u0001!Ia!\u0016\t\u0015\rm\u0003\u0001#b\u0001\n\u0003\u001ai\u0006\u0003\u0006\u0004`\u0001A)\u0019!C\u0005\u0007CB!ba\u001b\u0001\u0011\u000b\u0007I\u0011BB1\u0011%\u0019i\u0007\u0001b\u0001\n\u0003\u001ay\u0007\u0003\u0005\u0004x\u0001\u0001\u000b\u0011BB9\u00119\u0019I\b\u0001I\u0001\u0004\u0003\u0005I\u0011BB+\u0007w:qa! ]\u0011\u0003\u0019yH\u0002\u0004\\9\"\u00051\u0011\u0011\u0005\b\u00033\nF\u0011ABE\u0011%\u0019Y)\u0015b\u0001\n\u0013\u0019i\t\u0003\u0005\u0004\u0016F\u0003\u000b\u0011BBH\u0011%\u00199*\u0015b\u0001\n\u0007\u0019I\n\u0003\u0005\u0004\"F\u0003\u000b\u0011BBN\u0011\u001d\u0019\u0019+\u0015C\u0001\u0007KCqa!-R\t\u0003\u0019\u0019\fC\u0005\u0004BF\u000b\n\u0011\"\u0001\u0004D\"91qY)\u0005R\r%'a\u0003(fiRL8+\u001a:wKJT!!\u00180\u0002\rM,'O^3s\u0015\ty\u0006-\u0001\u0003d_J,'\"A1\u0002\tAd\u0017-_\u0002\u0001'\r\u0001A\r\u001c\t\u0003K*l\u0011A\u001a\u0006\u0003O\"\fA\u0001\\1oO*\t\u0011.\u0001\u0003kCZ\f\u0017BA6g\u0005\u0019y%M[3diB\u0011QN\\\u0007\u00029&\u0011q\u000e\u0018\u0002\u0007'\u0016\u0014h/\u001a:\u0002\r\r|gNZ5h!\ti'/\u0003\u0002t9\na1+\u001a:wKJ\u001cuN\u001c4jO\u0006\u0019\u0012\r\u001d9mS\u000e\fG/[8o!J|g/\u001b3feV\ta\u000f\u0005\u0002xq6\ta,\u0003\u0002z=\n\u0019\u0012\t\u001d9mS\u000e\fG/[8o!J|g/\u001b3fe\u0006!\u0012\r\u001d9mS\u000e\fG/[8o!J|g/\u001b3fe\u0002\n\u0001b\u001d;pa\"{wn\u001b\t\u0006{\u0006\u0005\u0011QA\u0007\u0002}*\tq0A\u0003tG\u0006d\u0017-C\u0002\u0002\u0004y\u0014\u0011BR;oGRLwN\u001c\u00191\t\u0005\u001d\u0011q\u0003\t\u0007\u0003\u0013\ty!a\u0005\u000e\u0005\u0005-!bAA\u0007}\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005E\u00111\u0002\u0002\u0007\rV$XO]3\u0011\t\u0005U\u0011q\u0003\u0007\u0001\t-\tI\u0002BA\u0001\u0002\u0003\u0015\t!a\u0007\u0003\u0011\u0011\nX.\u0019:lIE\nB!!\b\u0002$A\u0019Q0a\b\n\u0007\u0005\u0005bPA\u0004O_RD\u0017N\\4\u0011\u0007u\f)#C\u0002\u0002(y\u00141!\u00118z\u0003-\t7\r^8s'f\u001cH/Z7\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003\u0003j!!!\r\u000b\t\u0005M\u0012QG\u0001\u0006C\u000e$xN\u001d\u0006\u0005\u0003o\tI$A\u0003qK.\\wN\u0003\u0003\u0002<\u0005u\u0012AB1qC\u000eDWM\u0003\u0002\u0002@\u0005\u0019qN]4\n\t\u0005\r\u0013\u0011\u0007\u0002\f\u0003\u000e$xN]*zgR,W.\u0001\u0007bGR|'oU=ti\u0016l\u0007%\u0001\u0007nCR,'/[1mSj,'/\u0006\u0002\u0002LA!\u0011QJA*\u001b\t\tyE\u0003\u0003\u0002R\u0005U\u0012AB:ue\u0016\fW.\u0003\u0003\u0002V\u0005=#\u0001D'bi\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018!D7bi\u0016\u0014\u0018.\u00197ju\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u000b\u0003;\n\u0019'!\u001a\u0002h\u0005MD\u0003BA0\u0003C\u0002\"!\u001c\u0001\t\u000f\u0005\u001d\u0013\u0002q\u0001\u0002L!)\u0001/\u0003a\u0001c\")A/\u0003a\u0001m\"110\u0003a\u0001\u0003S\u0002R!`A\u0001\u0003W\u0002D!!\u001c\u0002rA1\u0011\u0011BA\b\u0003_\u0002B!!\u0006\u0002r\u0011a\u0011\u0011DA4\u0003\u0003\u0005\tQ!\u0001\u0002\u001c!9\u0011\u0011F\u0005A\u0002\u00055\u0012\u0001D:feZ,'oQ8oM&<WCAA=!\u0011\tY(!!\u000e\u0005\u0005u$bAA@A\u0006\u0019\u0011\r]5\n\t\u0005\r\u0015Q\u0010\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u001bM,'O^3s\u0007>tg-[4!\u0003-qW\r\u001e;z\u0007>tg-[4\u0002\u00199,G\u000f^=D_:4\u0017n\u001a\u0011\u0002\u0019M,'O^3s\u0011\u0016\fG-\u001a:\u0016\u0005\u0005=\u0005#B?\u0002\u0012\u0006U\u0015bAAJ}\n1q\n\u001d;j_:\u0004B!a&\u0002&:!\u0011\u0011TAQ!\r\tYJ`\u0007\u0003\u0003;S1!a(c\u0003\u0019a$o\\8u}%\u0019\u00111\u0015@\u0002\rA\u0013X\rZ3g\u0013\u0011\t9+!+\u0003\rM#(/\u001b8h\u0015\r\t\u0019K`\u0001\u000eg\u0016\u0014h/\u001a:IK\u0006$WM\u001d\u0011\u0002)5\f\u00070\u00138ji&\fG\u000eT5oK2+gn\u001a;i+\t\t\t\fE\u0002~\u0003gK1!!.\u007f\u0005\rIe\u000e^\u0001\u0016[\u0006D\u0018J\\5uS\u0006dG*\u001b8f\u0019\u0016tw\r\u001e5!\u00035i\u0017\r\u001f%fC\u0012,'oU5{K\u0006qQ.\u0019=IK\u0006$WM]*ju\u0016\u0004\u0013\u0001E7bq\u000e{g\u000e^3oi2+gn\u001a;i+\t\t\t\rE\u0002~\u0003\u0007L1!!2\u007f\u0005\u0011auN\\4\u0002#5\f\u0007pQ8oi\u0016tG\u000fT3oORD\u0007%\u0001\u0007nCb\u001c\u0005.\u001e8l'&TX-A\u0007nCb\u001c\u0005.\u001e8l'&TX\rI\u0001\fi\"\u0014X-\u00193D_VtG/\u0001\u0007uQJ,\u0017\rZ\"pk:$\b%A\u0004m_\u001e<\u0016N]3\u0016\u0005\u0005U\u0007cA?\u0002X&\u0019\u0011\u0011\u001c@\u0003\u000f\t{w\u000e\\3b]\u0006AAn\\4XSJ,\u0007%A\bc_>$8\u000f\u001e:ba>\u0003H/[8o+\t\t\t\u000f\u0005\u0003\u0002d\u0006=XBAAs\u0015\r\u0001\u0018q\u001d\u0006\u0005\u0003S\fY/\u0001\u0005usB,7/\u00194f\u0015\t\ti/A\u0002d_6LA!!=\u0002f\n11i\u001c8gS\u001e\f\u0001CY8piN$(/\u00199PaRLwN\u001c\u0011\u0002\u001b\rD\u0017M\u001c8fY>\u0003H/[8o\u00039\u0019\u0007.\u00198oK2|\u0005\u000f^5p]\u0002\n1\u0003\u001b;uaN<\u0016M\u001c;DY&,g\u000e^!vi\"\fA\u0003\u001b;uaN<\u0016M\u001c;DY&,g\u000e^!vi\"\u0004\u0013a\u00055uiB\u001ch*Z3e\u00072LWM\u001c;BkRD\u0017\u0001\u00065uiB\u001ch*Z3e\u00072LWM\u001c;BkRD\u0007%A\biiR\u0004\u0018\n\u001a7f)&lWm\\;u+\t\u0011)\u0001\u0005\u0003\u0003\b\t5QB\u0001B\u0005\u0015\u0011\u0011Y!a\u0003\u0002\u0011\u0011,(/\u0019;j_:LAAa\u0004\u0003\n\tAA)\u001e:bi&|g.\u0001\tiiR\u0004\u0018\n\u001a7f)&lWm\\;uA\u0005\u0001\u0002\u000e\u001e;qg&#G.\u001a+j[\u0016|W\u000f^\u0001\u0012QR$\bo]%eY\u0016$\u0016.\\3pkR\u0004\u0013aE:ikR$wn\u001e8Rk&,G\u000fU3sS>$WC\u0001B\u000e!\u0011\u00119A!\b\n\t\t}!\u0011\u0002\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0003Q\u0019\b.\u001e;e_^t\u0017+^5fiB+'/[8eA\u0005\u0001B/\u001a:nS:\fG/[8o\t\u0016d\u0017-_\u0001\u0012i\u0016\u0014X.\u001b8bi&|g\u000eR3mCf\u0004\u0013A\u0005;fe6Lg.\u0019;j_:$\u0016.\\3pkR,\"Aa\u000b\u0011\u000bu\f\tJa\u0007\u0002'Q,'/\\5oCRLwN\u001c+j[\u0016|W\u000f\u001e\u0011\u0002\u001b]\u001c()\u001e4gKJd\u0015.\\5u\u0003998OQ;gM\u0016\u0014H*[7ji\u0002\nqb^:LK\u0016\u0004\u0018\t\\5wK6{G-Z\u000b\u0003\u0003+\u000b\u0001c^:LK\u0016\u0004\u0018\t\\5wK6{G-\u001a\u0011\u0002%]\u001c8*Z3q\u00032Lg/Z'bq&#G.Z\u0001\u0014oN\\U-\u001a9BY&4X-T1y\u0013\u0012dW\rI\u0001\u0011I\u00164WM\u001d\"pIf\u0004\u0016M]:j]\u001e\f\u0011\u0003Z3gKJ\u0014u\u000eZ=QCJ\u001c\u0018N\\4!\u0003%!(/\u00198ta>\u0014H/\u0006\u0002\u0003FIA!q\tB&\u0005#\u00129F\u0002\u0004\u0003J\u0001\u0001!Q\t\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0004{\n5\u0013b\u0001B(}\n9\u0001K]8ek\u000e$\bcA7\u0003T%\u0019!Q\u000b/\u0003\u001d9+G\u000f^=Ue\u0006t7\u000f]8siB!!\u0011\fB0\u001b\t\u0011YFC\u0002\u0003^!\f!![8\n\t\t\u0005$1\f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005[>$W-\u0006\u0002\u0003hA!\u00111\u0010B5\u0013\u0011\u0011Y'! \u0003\t5{G-Z\u0001\nKZ,g\u000e\u001e'p_B,\"A!\u001d\u0011\t\tM$qP\u0007\u0003\u0005kRAAa\u001e\u0003z\u000591\r[1o]\u0016d'\u0002\u0002B>\u0005{\nQA\\3uifT!A!\u0018\n\t\t\u0005%Q\u000f\u0002\u001a\u001bVdG/\u001b;ie\u0016\fG-\u0012<f]Rdun\u001c9He>,\b/\u0001\u0006fm\u0016tG\u000fT8pa\u0002\n1\"\u00197m\u0007\"\fgN\\3mgV\u0011!\u0011\u0012\t\u0005\u0005\u0017\u0013\t*\u0004\u0002\u0003\u000e*!!q\u0012B;\u0003\u00159'o\\;q\u0013\u0011\u0011\u0019J!$\u0003'\u0011+g-Y;mi\u000eC\u0017M\u001c8fY\u001e\u0013x.\u001e9\u0002\u0019\u0005dGn\u00115b]:,Gn\u001d\u0011\u0002#M\u001cH.\u00128hS:,\u0007K]8wS\u0012,'/\u0006\u0002\u0003\u001cB)Q0!%\u0003\u001eB!!q\u0014BR\u001b\t\u0011\tK\u0003\u0002^A&!!Q\u0015BQ\u0005E\u00196\u000bT#oO&tW\r\u0015:pm&$WM]\u0001\u000bg\u0016$x\n\u001d;j_:\u001cH\u0003\u0003BV\u0005c\u00139M!3\u0011\u0007u\u0014i+C\u0002\u00030z\u0014A!\u00168ji\"9!1W\u001fA\u0002\tU\u0016!C:fi>\u0003H/[8o!%i(q\u0017B^\u0005\u0003\f\u0019#C\u0002\u0003:z\u0014\u0011BR;oGRLwN\u001c\u001a\u0011\r\tM$Q\u0018Ba\u0013\u0011\u0011yL!\u001e\u0003\u001b\rC\u0017M\u001c8fY>\u0003H/[8o!\ri(1Y\u0005\u0004\u0005\u000bt(AB!osJ+g\r\u0003\u0004q{\u0001\u0007\u0011\u0011\u001d\u0005\n\u0005\u0017l\u0004\u0013!a\u0001\u0003+\fQBY8piN$(/\u00199qS:<\u0017\u0001F:fi>\u0003H/[8og\u0012\"WMZ1vYR$3'\u0006\u0002\u0003R*\"\u0011Q\u001bBjW\t\u0011)\u000e\u0005\u0003\u0003X\n\u0005XB\u0001Bm\u0015\u0011\u0011YN!8\u0002\u0013Ut7\r[3dW\u0016$'b\u0001Bp}\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r(\u0011\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\u00022j]\u0012$BA!;\u0004\nA9QPa;\u0003p\nU\u0018b\u0001Bw}\n1A+\u001e9mKJ\u0002BAa\u001d\u0003r&!!1\u001fB;\u0005\u001d\u0019\u0005.\u00198oK2\u0004DAa>\u0004\u0006AA!\u0011 B\u0000\u0005_\u001c\u0019!\u0004\u0002\u0003|*!!Q`A(\u0003!\u00198-\u00197bINd\u0017\u0002BB\u0001\u0005w\u0014aaU8ve\u000e,\u0007\u0003BA\u000b\u0007\u000b!1ba\u0002@\u0003\u0003\u0005\tQ!\u0001\u0002\u001c\tAA%]7be.$#\u0007C\u0004\u0004\f}\u0002\ra!\u0004\u0002\u000f\u0005$GM]3tgB!1qBB\u000b\u001b\t\u0019\tBC\u0002\u0004\u0014!\f1A\\3u\u0013\u0011\u00199b!\u0005\u0003#%sW\r^*pG.,G/\u00113ee\u0016\u001c8/A\toK^\u0014V-];fgRD\u0015M\u001c3mKJ$\"a!\b\u0011\t\tM4qD\u0005\u0005\u0007C\u0011)HA\u000bDQ\u0006tg.\u001a7J]\n|WO\u001c3IC:$G.\u001a:\u0002\u0017\rD\u0017M\u001c8fYNKgn\u001b\u000b\u0007\u0007O\u00199da\u000f\u0011\u0011\te8\u0011\u0006Bx\u0007[IAaa\u000b\u0003|\n!1+\u001b8l!\u0019\tI!a\u0004\u00040A!1\u0011GB\u001a\u001b\t\t)$\u0003\u0003\u00046\u0005U\"\u0001\u0002#p]\u0016Dqa!\u000fB\u0001\u0004\t\t,\u0001\u0003q_J$\bbBB\u001f\u0003\u0002\u0007\u0011Q[\u0001\u0007g\u0016\u001cWO]3\u0002\u0017!$H\u000f]\"iC:tW\r\\\u000b\u0003\u0007\u0007\u0002R!`AI\u0005_\fA\u0002\u001b;ua\u000eC\u0017M\u001c8fY\u0002\nA\u0002\u001b;uaN\u001c\u0005.\u00198oK2\fQ\u0002\u001b;uaN\u001c\u0005.\u00198oK2\u0004\u0013a\u00032j]\u0012\u001c\u0005.\u00198oK2$bAa<\u0004P\rE\u0003bBB\u001d\r\u0002\u0007\u0011\u0011\u0017\u0005\b\u0007{1\u0005\u0019AAk\u0003\u0011\u0019Ho\u001c9\u0015\u0005\t-\u0016!\u0006:fO&\u001cH/\u001a:TQV$Hm\\<o)\u0006\u001c8n]\u0001&S:LG/[1mSj,7\t[1o]\u0016dw\n\u001d;j_:\u001c8\u000b^1uS\u000elU-\u001c2feN\f1\"\\1j]\u0006#GM]3tgV\u00111QB\u0001\u000b\u0011R$\b/\r)mC&tWCAB2!\u0015i\u0018\u0011SB3!\ri7qM\u0005\u0004\u0007Sb&AD*feZ,'/\u00128ea>Lg\u000e^\u0001\u000f\u0011R$\b/M#oGJL\b\u000f^3e\u0003=\u0019XM\u001d<fe\u0016sG\r]8j]R\u001cXCAB9!\ri71O\u0005\u0004\u0007kb&aD*feZ,'/\u00128ea>Lg\u000e^:\u0002!M,'O^3s\u000b:$\u0007o\\5oiN\u0004\u0013AC:va\u0016\u0014He\u001d;pa&\u001911\u000b8\u0002\u00179+G\u000f^=TKJ4XM\u001d\t\u0003[F\u001bR!\u0015Ba\u0007\u0007\u00032!\\BC\u0013\r\u00199\t\u0018\u0002\u0011'\u0016\u0014h/\u001a:Ge>l'k\\;uKJ$\"aa \u0002\r1|wmZ3s+\t\u0019y\t\u0005\u0003\u0002|\rE\u0015\u0002BBJ\u0003{\u0012a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\taJ|g/\u001b3feV\u001111\u0014\t\u0004[\u000eu\u0015bABP9\n\u0019b*\u001a;usN+'O^3s!J|g/\u001b3fe\u0006I\u0001O]8wS\u0012,'\u000fI\u0001\u0005[\u0006Lg\u000e\u0006\u0003\u0003,\u000e\u001d\u0006bBBU/\u0002\u000711V\u0001\u0005CJ<7\u000fE\u0003~\u0007[\u000b)*C\u0002\u00040z\u0014Q!\u0011:sCf\fqB\u001a:p[\u0006\u0003\b\u000f\\5dCRLwN\u001c\u000b\u0007\u0003?\u001a)la0\t\u000f\r]\u0006\f1\u0001\u0004:\u0006Y\u0011\r\u001d9mS\u000e\fG/[8o!\u0011\tYha/\n\t\ru\u0016Q\u0010\u0002\f\u0003B\u0004H.[2bi&|g\u000eC\u0004q1B\u0005\t\u0019A9\u00023\u0019\u0014x.\\!qa2L7-\u0019;j_:$C-\u001a4bk2$HEM\u000b\u0003\u0007\u000bT3!\u001dBj\u0003Y\u0019'/Z1uKN+'O^3s\rJ|WNU8vi\u0016\u0014H\u0003BBf\u0007g$2\u0001\\Bg\u0011\u001d\u0019yM\u0017a\u0001\u0007#\faA]8vi\u0016\u001c\bcB?\u0004T\u000e]7q]\u0005\u0004\u0007+t(!\u0003$v]\u000e$\u0018n\u001c82%\u0019\u0019Ina7\u0004b\u001a1!\u0011J)\u0001\u0007/\u00042!\\Bo\u0013\r\u0019y\u000e\u0018\u0002\u0011'\u0016\u0014h/\u001a:D_6\u0004xN\\3oiN\u0004B!a\u001f\u0004d&!1Q]A?\u0005E\u0011U/\u001b7u\u0013:\u001cu.\u001c9p]\u0016tGo\u001d\t\u0005\u0007S\u001cy/\u0004\u0002\u0004l*!1Q^A?\u0003\u001d\u0011x.\u001e;j]\u001eLAa!=\u0004l\n1!k\\;uKJD\u0001b!>[!\u0003\u0005\r!]\u0001\u000bg\u0016\u0014h/\u001a:D_:4\u0007")
public class NettyServer
implements Server {
    private Product transport;
    private Option<SSLEngineProvider> sslEngineProvider;
    private InetSocketAddress mainAddress;
    private Option<ServerEndpoint> Http1Plain;
    private Option<ServerEndpoint> Http1Encrypted;
    private final ServerConfig config;
    private final ApplicationProvider applicationProvider;
    private final Function0<Future<?>> stopHook;
    private final ActorSystem actorSystem;
    private final Materializer materializer;
    private final Configuration serverConfig;
    private final Configuration nettyConfig;
    private final Option<String> serverHeader;
    private final int maxInitialLineLength;
    private final int maxHeaderSize;
    private final long maxContentLength;
    private final int maxChunkSize;
    private final int threadCount;
    private final boolean logWire;
    private final Config bootstrapOption;
    private final Config channelOption;
    private final boolean httpsWantClientAuth;
    private final boolean httpsNeedClientAuth;
    private final Duration httpIdleTimeout;
    private final Duration httpsIdleTimeout;
    private final FiniteDuration shutdownQuietPeriod;
    private final FiniteDuration terminationDelay;
    private final Option<FiniteDuration> terminationTimeout;
    private final int wsBufferLimit;
    private final String wsKeepAliveMode;
    private final Duration wsKeepAliveMaxIdle;
    private final boolean deferBodyParsing;
    private final MultithreadEventLoopGroup eventLoop;
    private final DefaultChannelGroup allChannels;
    private final Option<Channel> httpChannel;
    private final Option<Channel> httpsChannel;
    private final ServerEndpoints serverEndpoints;
    private volatile byte bitmap$0;

    public static ServerConfig fromApplication$default$2() {
        return NettyServer$.MODULE$.fromApplication$default$2();
    }

    public static NettyServer fromApplication(Application application, ServerConfig config) {
        return NettyServer$.MODULE$.fromApplication(application, config);
    }

    public static void main(String[] args) {
        NettyServer$.MODULE$.main(args);
    }

    public static NettyServerProvider provider() {
        return NettyServer$.MODULE$.provider();
    }

    public static ServerConfig fromRouterWithComponents$default$1() {
        return NettyServer$.MODULE$.fromRouterWithComponents$default$1();
    }

    public static Server fromRouterWithComponents(ServerConfig config, Function1<BuiltInComponents, PartialFunction<RequestHeader, Handler>> routes) {
        return NettyServer$.MODULE$.fromRouterWithComponents(config, routes);
    }

    public static ServerConfig fromRouter$default$1() {
        return NettyServer$.MODULE$.fromRouter$default$1();
    }

    public static Server fromRouter(ServerConfig config, PartialFunction<RequestHeader, Handler> routes) {
        return NettyServer$.MODULE$.fromRouter(config, routes);
    }

    public void reload() {
        Server.reload$((Server)this);
    }

    public Option<Object> httpPort() {
        return Server.httpPort$((Server)this);
    }

    public Option<Object> httpsPort() {
        return Server.httpsPort$((Server)this);
    }

    private /* synthetic */ void super$stop() {
        Server.stop$((Server)this);
    }

    public ApplicationProvider applicationProvider() {
        return this.applicationProvider;
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public Materializer materializer() {
        return this.materializer;
    }

    private Configuration serverConfig() {
        return this.serverConfig;
    }

    private Configuration nettyConfig() {
        return this.nettyConfig;
    }

    private Option<String> serverHeader() {
        return this.serverHeader;
    }

    private int maxInitialLineLength() {
        return this.maxInitialLineLength;
    }

    private int maxHeaderSize() {
        return this.maxHeaderSize;
    }

    private long maxContentLength() {
        return this.maxContentLength;
    }

    private int maxChunkSize() {
        return this.maxChunkSize;
    }

    private int threadCount() {
        return this.threadCount;
    }

    private boolean logWire() {
        return this.logWire;
    }

    private Config bootstrapOption() {
        return this.bootstrapOption;
    }

    private Config channelOption() {
        return this.channelOption;
    }

    private boolean httpsWantClientAuth() {
        return this.httpsWantClientAuth;
    }

    private boolean httpsNeedClientAuth() {
        return this.httpsNeedClientAuth;
    }

    private Duration httpIdleTimeout() {
        return this.httpIdleTimeout;
    }

    private Duration httpsIdleTimeout() {
        return this.httpsIdleTimeout;
    }

    private FiniteDuration shutdownQuietPeriod() {
        return this.shutdownQuietPeriod;
    }

    private FiniteDuration terminationDelay() {
        return this.terminationDelay;
    }

    private Option<FiniteDuration> terminationTimeout() {
        return this.terminationTimeout;
    }

    private int wsBufferLimit() {
        return this.wsBufferLimit;
    }

    private String wsKeepAliveMode() {
        return this.wsKeepAliveMode;
    }

    private Duration wsKeepAliveMaxIdle() {
        return this.wsKeepAliveMaxIdle;
    }

    private boolean deferBodyParsing() {
        return this.deferBodyParsing;
    }

    private Product transport$lzycompute() {
        block7: {
            NettyServer nettyServer = this;
            synchronized (nettyServer) {
                NettyTransport nettyTransport;
                block8: {
                    if ((byte)(this.bitmap$0 & 1) != 0) break block7;
                    String string = (String)this.nettyConfig().get("transport", ConfigLoader$.MODULE$.stringLoader());
                    switch (string == null ? 0 : string.hashCode()) {
                        case -1052618729: {
                            if (!"native".equals(string)) break;
                            nettyTransport = Native$.MODULE$;
                            break block8;
                        }
                        case 105073: {
                            if (!"jdk".equals(string)) break;
                            nettyTransport = Jdk$.MODULE$;
                            break block8;
                        }
                    }
                    throw new ServerStartException("Netty transport configuration value should be either jdk or native", ServerStartException$.MODULE$.apply$default$2());
                }
                this.transport = nettyTransport;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.transport;
    }

    private Product transport() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.transport$lzycompute();
        }
        return this.transport;
    }

    public Mode mode() {
        return this.config.mode();
    }

    private MultithreadEventLoopGroup eventLoop() {
        return this.eventLoop;
    }

    private DefaultChannelGroup allChannels() {
        return this.allChannels;
    }

    private Option<SSLEngineProvider> sslEngineProvider$lzycompute() {
        NettyServer nettyServer = this;
        synchronized (nettyServer) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sslEngineProvider = this.liftedTree1$1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sslEngineProvider;
    }

    private Option<SSLEngineProvider> sslEngineProvider() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.sslEngineProvider$lzycompute();
        }
        return this.sslEngineProvider;
    }

    private void setOptions(Function2<ChannelOption<Object>, Object, Object> setOption, Config config, boolean bootstrapping) {
        ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(config.entrySet()).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)NettyServer.$anonfun$setOptions$1(x$1)))).foreach((Function1 & Serializable)option -> {
            String cleanKey = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString((String)option.getKey()), "\"")), "\"");
            if (ChannelOption.exists((String)cleanKey)) {
                NettyServer$.MODULE$.play$core$server$NettyServer$$logger().debug((Function0 & Serializable)() -> "Setting Netty channel option " + cleanKey + " to " + NettyServer.unwrap$1((ConfigValue)option.getValue()) + (bootstrapping ? " at bootstrapping" : ""), MarkerContext$.MODULE$.NoMarker());
                return setOption.apply((Object)ChannelOption.valueOf((String)cleanKey), NettyServer.unwrap$1((ConfigValue)option.getValue()));
            }
            NettyServer$.MODULE$.play$core$server$NettyServer$$logger().warn((Function0 & Serializable)() -> "Ignoring unknown Netty channel option: " + cleanKey, MarkerContext$.MODULE$.NoMarker());
            Product product = this.transport();
            if (Native$.MODULE$.equals(product)) {
                NettyServer$.MODULE$.play$core$server$NettyServer$$logger().warn((Function0 & Serializable)() -> "Valid values can be found at http://netty.io/4.1/api/io/netty/channel/ChannelOption.html, https://netty.io/4.1/api/io/netty/channel/unix/UnixChannelOption.html and http://netty.io/4.1/api/io/netty/channel/epoll/EpollChannelOption.html", MarkerContext$.MODULE$.NoMarker());
            } else if (Jdk$.MODULE$.equals(product)) {
                NettyServer$.MODULE$.play$core$server$NettyServer$$logger().warn((Function0 & Serializable)() -> "Valid values can be found at http://netty.io/4.1/api/io/netty/channel/ChannelOption.html", MarkerContext$.MODULE$.NoMarker());
            } else {
                throw new MatchError((Object)product);
            }
            return BoxedUnit.UNIT;
        });
    }

    private boolean setOptions$default$3() {
        return false;
    }

    private Tuple2<Channel, Source<Channel, ?>> bind(InetSocketAddress address) {
        Class<EpollServerSocketChannel> clazz;
        EventLoop serverChannelEventLoop = this.eventLoop().next();
        HandlerPublisher channelPublisher = new HandlerPublisher((EventExecutor)serverChannelEventLoop, Channel.class);
        Product product = this.transport();
        if (Native$.MODULE$.equals(product)) {
            clazz = EpollServerSocketChannel.class;
        } else if (Jdk$.MODULE$.equals(product)) {
            clazz = NioServerSocketChannel.class;
        } else {
            throw new MatchError((Object)product);
        }
        Class<EpollServerSocketChannel> channelClass = clazz;
        Bootstrap bootstrap = (Bootstrap)new Bootstrap().channel(channelClass).group((EventLoopGroup)serverChannelEventLoop).option(ChannelOption.AUTO_READ, (Object)Boolean.FALSE).handler((ChannelHandler)channelPublisher).localAddress((SocketAddress)address);
        this.setOptions((Function2<ChannelOption<Object>, Object, Object>)(Function2 & Serializable)(x$1, x$2) -> (Bootstrap)bootstrap.option(x$1, x$2), this.bootstrapOption(), true);
        Channel channel = bootstrap.bind().await().channel();
        this.allChannels().add(channel);
        return new Tuple2((Object)channel, (Object)Source$.MODULE$.fromPublisher((Publisher)channelPublisher));
    }

    public ChannelInboundHandler newRequestHandler() {
        return new PlayRequestHandler(this, this.serverHeader(), this.maxContentLength(), this.wsBufferLimit(), this.wsKeepAliveMode(), this.wsKeepAliveMaxIdle(), this.deferBodyParsing());
    }

    private Sink<Channel, Future<Done>> channelSink(int port, boolean secure) {
        return Sink$.MODULE$.foreach((Function1 & Serializable)connChannel -> {
            NettyServer.$anonfun$channelSink$1(this, secure, port, connChannel);
            return BoxedUnit.UNIT;
        });
    }

    private Option<Channel> httpChannel() {
        return this.httpChannel;
    }

    private Option<Channel> httpsChannel() {
        return this.httpsChannel;
    }

    private Channel bindChannel(int port, boolean secure) {
        Channel serverChannel;
        block2: {
            String protocolName = secure ? "HTTPS" : "HTTP";
            InetSocketAddress address = new InetSocketAddress(this.config.address(), port);
            Tuple2<Channel, Source<Channel, ?>> tuple2 = this.bind(address);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Channel serverChannel2 = (Channel)tuple2._1();
            Source channelSource = (Source)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)serverChannel2, (Object)channelSource);
            serverChannel = (Channel)tuple22._1();
            Source channelSource2 = (Source)tuple22._2();
            channelSource2.runWith(this.channelSink(port, secure), this.materializer());
            SocketAddress boundAddress = serverChannel.localAddress();
            if (boundAddress == null) {
                ServerListenException e = new ServerListenException(protocolName, (SocketAddress)address);
                NettyServer$.MODULE$.play$core$server$NettyServer$$logger().error((Function0 & Serializable)() -> e.getMessage(), MarkerContext$.MODULE$.NoMarker());
                throw e;
            }
            Mode mode = this.mode();
            Mode.Test$ test$ = Mode.Test$.MODULE$;
            if (!(mode == null ? test$ != null : !mode.equals(test$))) break block2;
            NettyServer$.MODULE$.play$core$server$NettyServer$$logger().info((Function0 & Serializable)() -> "Listening for " + protocolName + " on " + boundAddress, MarkerContext$.MODULE$.NoMarker());
        }
        return serverChannel;
    }

    public void stop() {
        CoordinatedShutdownSupport$.MODULE$.syncShutdown(this.actorSystem(), (CoordinatedShutdown.Reason)Server.ServerStoppedReason$.MODULE$);
    }

    private void registerShutdownTasks() {
        ExecutionContextExecutor ctx = this.actorSystem().dispatcher();
        CoordinatedShutdown cs = (CoordinatedShutdown)CoordinatedShutdown$.MODULE$.apply(this.actorSystem());
        cs.addTask(CoordinatedShutdown$.MODULE$.PhaseBeforeServiceUnbind(), "trace-server-stop-request", (Function0 & Serializable)() -> {
            Mode mode = this.mode();
            if (Mode.Test$.MODULE$.equals(mode)) {
            } else {
                NettyServer$.MODULE$.play$core$server$NettyServer$$logger().info((Function0 & Serializable)() -> "Stopping server...", MarkerContext$.MODULE$.NoMarker());
            }
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        });
        FiniteDuration serverTerminateTimeout = Server$.MODULE$.determineServerTerminateTimeout(this.terminationTimeout(), this.terminationDelay(), this.actorSystem());
        FiniteDuration unbindTimeout = cs.timeout(CoordinatedShutdown$.MODULE$.PhaseServiceUnbind());
        cs.addTask(CoordinatedShutdown$.MODULE$.PhaseServiceUnbind(), "netty-server-unbind", (Function0 & Serializable)() -> {
            ChannelGroupFuture serverChannelGroupFuture = this.allChannels().close(ChannelMatchers.isServerChannel());
            Iterator serverChannelIterator = serverChannelGroupFuture.iterator();
            while (serverChannelIterator.hasNext()) {
                SocketAddress localAddress = ((ChannelFuture)serverChannelIterator.next()).channel().localAddress();
                NettyServer$.MODULE$.play$core$server$NettyServer$$logger().info((Function0 & Serializable)() -> "Closing server channel " + localAddress, MarkerContext$.MODULE$.NoMarker());
            }
            serverChannelGroupFuture.awaitUninterruptibly(unbindTimeout.toMillis() - 100L);
            return Future$.MODULE$.successful((Object)Done$.MODULE$);
        });
        FiniteDuration serviceRequestsDoneTimeout = cs.timeout(CoordinatedShutdown$.MODULE$.PhaseServiceRequestsDone());
        cs.addTask(CoordinatedShutdown$.MODULE$.PhaseServiceRequestsDone(), "netty-server-terminate", () -> NettyServer.$anonfun$registerShutdownTasks$5(this, serviceRequestsDoneTimeout, serverTerminateTimeout, (ExecutionContext)ctx));
        cs.addTask(CoordinatedShutdown$.MODULE$.PhaseBeforeActorSystemTerminate(), "user-provided-server-stop-hook", () -> NettyServer.$anonfun$registerShutdownTasks$11(this, (ExecutionContext)ctx));
        cs.addTask(CoordinatedShutdown$.MODULE$.PhaseBeforeActorSystemTerminate(), "shutdown-logger", () -> NettyServer.$anonfun$registerShutdownTasks$14(this, (ExecutionContext)ctx));
    }

    private void initializeChannelOptionsStaticMembers() {
        new .colon.colon(ChannelOption.class, (List)new .colon.colon(UnixChannelOption.class, (List)new .colon.colon(EpollChannelOption.class, (List)Nil$.MODULE$))).foreach((Function1 & Serializable)clazz -> {
            NettyServer$.MODULE$.play$core$server$NettyServer$$logger().debug((Function0 & Serializable)() -> "Class " + clazz.getName() + " will be initialized (if it hasn't been initialized already)", MarkerContext$.MODULE$.NoMarker());
            return Class.forName(clazz.getName());
        });
    }

    private InetSocketAddress mainAddress$lzycompute() {
        NettyServer nettyServer = this;
        synchronized (nettyServer) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.mainAddress = (InetSocketAddress)((Channel)this.httpChannel().orElse((Function0 & Serializable)() -> this.httpsChannel()).get()).localAddress();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.mainAddress;
    }

    public InetSocketAddress mainAddress() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.mainAddress$lzycompute();
        }
        return this.mainAddress;
    }

    private Option<ServerEndpoint> Http1Plain$lzycompute() {
        NettyServer nettyServer = this;
        synchronized (nettyServer) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.Http1Plain = this.httpChannel().map((Function1 & Serializable)x$7 -> (InetSocketAddress)x$7.localAddress()).map((Function1 & Serializable)address -> new ServerEndpoint("Netty HTTP/1.1 (plaintext)", "http", $this.config.address(), address.getPort(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{HttpProtocol$.MODULE$.HTTP_1_0(), HttpProtocol$.MODULE$.HTTP_1_1()})), this.serverHeader(), (Option)None$.MODULE$));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.Http1Plain;
    }

    private Option<ServerEndpoint> Http1Plain() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.Http1Plain$lzycompute();
        }
        return this.Http1Plain;
    }

    private Option<ServerEndpoint> Http1Encrypted$lzycompute() {
        NettyServer nettyServer = this;
        synchronized (nettyServer) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.Http1Encrypted = this.httpsChannel().map((Function1 & Serializable)x$8 -> (InetSocketAddress)x$8.localAddress()).map((Function1 & Serializable)address -> new ServerEndpoint("Netty HTTP/1.1 (encrypted)", "https", $this.config.address(), address.getPort(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{HttpProtocol$.MODULE$.HTTP_1_0(), HttpProtocol$.MODULE$.HTTP_1_1()})), this.serverHeader(), this.sslEngineProvider().map((Function1 & Serializable)x$9 -> x$9.sslContext())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.Http1Encrypted;
    }

    private Option<ServerEndpoint> Http1Encrypted() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.Http1Encrypted$lzycompute();
        }
        return this.Http1Encrypted;
    }

    public ServerEndpoints serverEndpoints() {
        return this.serverEndpoints;
    }

    private final /* synthetic */ Option liftedTree1$1() {
        Some some;
        try {
            some = new Some((Object)ServerSSLEngine$.MODULE$.createSSLEngineProvider(this.config, this.applicationProvider()));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                NettyServer$.MODULE$.play$core$server$NettyServer$$logger().error((Function0 & Serializable)() -> "cannot load SSL context", (Function0 & Serializable)() -> throwable2, MarkerContext$.MODULE$.NoMarker());
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    private static final Object unwrap$1(ConfigValue value) {
        Object object = value.unwrapped();
        if (object instanceof Number) {
            Number number = (Number)object;
            return BoxesRunTime.boxToInteger((int)number.intValue());
        }
        return object;
    }

    public static final /* synthetic */ boolean $anonfun$setOptions$1(Map.Entry x$1) {
        return ((String)x$1.getKey()).startsWith("child.");
    }

    public static final /* synthetic */ void $anonfun$channelSink$1(NettyServer $this, boolean secure$1, int port$1, Channel connChannel) {
        Option option;
        Duration idleTimeout;
        connChannel.config().setOption(ChannelOption.AUTO_READ, (Object)Boolean.FALSE);
        ChannelConfig channelConfig = connChannel.config();
        $this.setOptions((Function2<ChannelOption<Object>, Object, Object>)(Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToBoolean((boolean)channelConfig.setOption(x$1, x$2)), $this.channelOption(), $this.setOptions$default$3());
        ChannelPipeline pipeline = connChannel.pipeline();
        Object object = secure$1 ? $this.sslEngineProvider().map((Function1 & Serializable)sslEngineProvider -> {
            SSLEngine sslEngine = sslEngineProvider.createSSLEngine();
            sslEngine.setUseClientMode(false);
            if ($this.httpsWantClientAuth()) {
                sslEngine.setWantClientAuth(true);
            }
            if ($this.httpsNeedClientAuth()) {
                sslEngine.setNeedClientAuth(true);
            }
            return pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
        }) : BoxedUnit.UNIT;
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder($this.maxInitialLineLength(), $this.maxHeaderSize(), $this.maxChunkSize()));
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("decompressor", (ChannelHandler)new HttpContentDecompressor());
        Object object2 = $this.logWire() ? pipeline.addLast("logging", (ChannelHandler)new LoggingHandler(LogLevel.DEBUG)) : BoxedUnit.UNIT;
        Duration duration = idleTimeout = secure$1 ? $this.httpsIdleTimeout() : $this.httpIdleTimeout();
        Duration.Infinite infinite = Duration$.MODULE$.Inf();
        Duration duration2 = duration;
        if (!(infinite != null ? !infinite.equals(duration2) : duration2 != null)) {
        } else if (duration != null && !(option = Duration$.MODULE$.unapply(duration)).isEmpty()) {
            long timeout = ((Tuple2)option.get())._1$mcJ$sp();
            TimeUnit timeUnit = (TimeUnit)((Object)((Tuple2)option.get())._2());
            NettyServer$.MODULE$.play$core$server$NettyServer$$logger().trace((Function0 & Serializable)() -> "using idle timeout of " + timeout + " " + timeUnit + " on port " + port$1, MarkerContext$.MODULE$.NoMarker());
            pipeline.addLast("idle-handler", (ChannelHandler)new IdleStateHandler(0L, 0L, timeout, timeUnit));
            pipeline.addLast("idle-handler-play", (ChannelHandler)new NettyIdleHandler());
        } else {
            throw new MatchError((Object)duration);
        }
        ChannelInboundHandler requestHandler = $this.newRequestHandler();
        pipeline.addLast("http-handler", (ChannelHandler)new HttpStreamsServerHandler(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)requestHandler, (List)Nil$.MODULE$)).asJava()));
        pipeline.addLast("request-handler", (ChannelHandler)requestHandler);
        EventLoop childChannelEventLoop = $this.eventLoop().next();
        childChannelEventLoop.register(connChannel);
        $this.allChannels().add(connChannel);
    }

    public static final /* synthetic */ Done$ $anonfun$registerShutdownTasks$10(boolean x$5) {
        return Done$.MODULE$;
    }

    public static final /* synthetic */ Future $anonfun$registerShutdownTasks$5(NettyServer $this, FiniteDuration serviceRequestsDoneTimeout$1, FiniteDuration serverTerminateTimeout$1, ExecutionContext ctx$1) {
        ChannelGroupFuture nonServerChannelGroupFuture = $this.allChannels().close(ChannelMatchers.isNonServerChannel());
        Iterator nonServerChannelIterator = nonServerChannelGroupFuture.iterator();
        while (nonServerChannelIterator.hasNext()) {
            SocketAddress localAddress = ((ChannelFuture)nonServerChannelIterator.next()).channel().localAddress();
            NettyServer$.MODULE$.play$core$server$NettyServer$$logger().info((Function0 & Serializable)() -> "Closing (non server) channel " + localAddress, MarkerContext$.MODULE$.NoMarker());
        }
        long startTime = System.currentTimeMillis();
        nonServerChannelGroupFuture.awaitUninterruptibly(serviceRequestsDoneTimeout$1.toMillis() - 100L);
        long elapsedTime = System.currentTimeMillis() - startTime;
        long remainingServiceRequestsDoneTimeout = serviceRequestsDoneTimeout$1.toMillis() - elapsedTime;
        long remainingServerTerminateTimeout = serverTerminateTimeout$1.toMillis() - elapsedTime;
        return package$.MODULE$.after($this.terminationDelay(), (Function0 & Serializable)() -> Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            NettyServer$.MODULE$.play$core$server$NettyServer$$logger().info((Function0 & Serializable)() -> "Shutting down event loop", MarkerContext$.MODULE$.NoMarker());
            return $this.eventLoop().shutdownGracefully($this.shutdownQuietPeriod().toMillis(), remainingServerTerminateTimeout - 100L, TimeUnit.MILLISECONDS).awaitUninterruptibly(remainingServiceRequestsDoneTimeout - 100L);
        }, ctx$1), (ClassicActorSystemProvider)$this.actorSystem()).map((Function1 & Serializable)x$5 -> NettyServer.$anonfun$registerShutdownTasks$10(BoxesRunTime.unboxToBoolean((Object)x$5)), ctx$1);
    }

    public static final /* synthetic */ Future $anonfun$registerShutdownTasks$11(NettyServer $this, ExecutionContext ctx$1) {
        NettyServer$.MODULE$.play$core$server$NettyServer$$logger().info((Function0 & Serializable)() -> "Running provided shutdown stop hooks", MarkerContext$.MODULE$.NoMarker());
        return ((Future)$this.stopHook.apply()).map((Function1 & Serializable)x$6 -> Done$.MODULE$, ctx$1);
    }

    public static final /* synthetic */ Future $anonfun$registerShutdownTasks$14(NettyServer $this, ExecutionContext ctx$1) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            $this.super$stop();
            return Done$.MODULE$;
        }, ctx$1);
    }

    public NettyServer(ServerConfig config, ApplicationProvider applicationProvider, Function0<Future<?>> stopHook, ActorSystem actorSystem, Materializer materializer) {
        EpollEventLoopGroup epollEventLoopGroup;
        this.config = config;
        this.applicationProvider = applicationProvider;
        this.stopHook = stopHook;
        this.actorSystem = actorSystem;
        this.materializer = materializer;
        Server.$init$((Server)this);
        this.initializeChannelOptionsStaticMembers();
        this.serverConfig = (Configuration)config.configuration().get("play.server", ConfigLoader$.MODULE$.configurationLoader());
        this.nettyConfig = (Configuration)this.serverConfig().get("netty", ConfigLoader$.MODULE$.configurationLoader());
        this.serverHeader = ((Option)this.nettyConfig().get("server-header", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()))).collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(A1))) {
                    return (B1)A1;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(string));
            }
        });
        this.maxInitialLineLength = BoxesRunTime.unboxToInt((Object)this.nettyConfig().get("maxInitialLineLength", ConfigLoader$.MODULE$.intLoader()));
        this.maxHeaderSize = (int)((ConfigMemorySize)this.serverConfig().getDeprecated("max-header-size", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"netty.maxHeaderSize"}), ConfigLoader$.MODULE$.bytesLoader())).toBytes();
        this.maxContentLength = Server$.MODULE$.getPossiblyInfiniteBytes(this.serverConfig().underlying(), "max-content-length", Server$.MODULE$.getPossiblyInfiniteBytes$default$3());
        this.maxChunkSize = BoxesRunTime.unboxToInt((Object)this.nettyConfig().get("maxChunkSize", ConfigLoader$.MODULE$.intLoader()));
        this.threadCount = BoxesRunTime.unboxToInt((Object)this.nettyConfig().get("eventLoopThreads", ConfigLoader$.MODULE$.intLoader()));
        this.logWire = BoxesRunTime.unboxToBoolean((Object)this.nettyConfig().get("log.wire", ConfigLoader$.MODULE$.booleanLoader()));
        this.bootstrapOption = (Config)this.nettyConfig().get("option", ConfigLoader$.MODULE$.configLoader());
        this.channelOption = (Config)this.nettyConfig().get("option.child", ConfigLoader$.MODULE$.configLoader());
        this.httpsWantClientAuth = BoxesRunTime.unboxToBoolean((Object)this.serverConfig().get("https.wantClientAuth", ConfigLoader$.MODULE$.booleanLoader()));
        this.httpsNeedClientAuth = BoxesRunTime.unboxToBoolean((Object)this.serverConfig().get("https.needClientAuth", ConfigLoader$.MODULE$.booleanLoader()));
        this.httpIdleTimeout = (Duration)this.serverConfig().get("http.idleTimeout", ConfigLoader$.MODULE$.durationLoader());
        this.httpsIdleTimeout = (Duration)this.serverConfig().get("https.idleTimeout", ConfigLoader$.MODULE$.durationLoader());
        this.shutdownQuietPeriod = (FiniteDuration)this.nettyConfig().get("shutdownQuietPeriod", ConfigLoader$.MODULE$.finiteDurationLoader());
        this.terminationDelay = (FiniteDuration)this.serverConfig().get("waitBeforeTermination", ConfigLoader$.MODULE$.finiteDurationLoader());
        this.terminationTimeout = this.serverConfig().getOptional("terminationTimeout", ConfigLoader$.MODULE$.finiteDurationLoader());
        this.wsBufferLimit = (int)((ConfigMemorySize)this.serverConfig().get("websocket.frame.maxLength", ConfigLoader$.MODULE$.bytesLoader())).toBytes();
        this.wsKeepAliveMode = (String)this.serverConfig().get("websocket.periodic-keep-alive-mode", ConfigLoader$.MODULE$.stringLoader());
        this.wsKeepAliveMaxIdle = (Duration)this.serverConfig().get("websocket.periodic-keep-alive-max-idle", ConfigLoader$.MODULE$.durationLoader());
        this.deferBodyParsing = this.serverConfig().underlying().getBoolean("deferBodyParsing");
        this.registerShutdownTasks();
        NamedThreadFactory threadFactory = new NamedThreadFactory("netty-event-loop");
        Product product = this.transport();
        if (Native$.MODULE$.equals(product)) {
            epollEventLoopGroup = new EpollEventLoopGroup(this.threadCount(), (ThreadFactory)threadFactory);
        } else if (Jdk$.MODULE$.equals(product)) {
            epollEventLoopGroup = new NioEventLoopGroup(this.threadCount(), (ThreadFactory)threadFactory);
        } else {
            throw new MatchError((Object)product);
        }
        this.eventLoop = epollEventLoopGroup;
        this.allChannels = new DefaultChannelGroup((EventExecutor)this.eventLoop().next());
        this.httpChannel = config.port().map((Function1 & Serializable)x$2 -> this.bindChannel(BoxesRunTime.unboxToInt((Object)x$2), false));
        this.httpsChannel = config.sslPort().map((Function1 & Serializable)x$3 -> this.bindChannel(BoxesRunTime.unboxToInt((Object)x$3), true));
        this.serverEndpoints = new ServerEndpoints((scala.collection.immutable.Seq)Option$.MODULE$.option2Iterable(this.Http1Plain()).toSeq().$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(this.Http1Encrypted()).toSeq()));
    }
}

