/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.mailer;

import com.typesafe.config.ConfigValue;
import java.io.FilterOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.libs.mailer.Attachment;
import play.api.libs.mailer.AttachmentData;
import play.api.libs.mailer.AttachmentDataSource;
import play.api.libs.mailer.AttachmentFile;
import play.api.libs.mailer.AttachmentURL;
import play.api.libs.mailer.Email;
import play.api.libs.mailer.MailerClient;
import play.api.libs.mailer.SMTPConfiguration;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005mb!\u0002\t\u0012\u0003\u0003Q\u0002\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u000b-\u0002A\u0011\u0001\u0017\t\u000f=\u0002!\u0019!C\ta!1\u0011\b\u0001Q\u0001\nEBQA\u000f\u0001\u0007\u0002mBQ!\u0016\u0001\u0007\u0002YCQa\u0016\u0001\u0007\u0002aCQA\u000f\u0001\u0005BqCQA\u0019\u0001\u0005\u0002\rDQA\u0019\u0001\u0005\n\u0015DQ\u0001\u001d\u0001\u0005\nEDQ! \u0001\u0005\nyDq!a\u0003\u0001\t\u0013\ti\u0001C\u0004\u0002\u001c\u0001!I!!\b\t\u000f\u0005-\u0002\u0001\"\u0003\u0002.\ti1i\\7n_:\u001cX*Y5mKJT!AE\n\u0002\r5\f\u0017\u000e\\3s\u0015\t!R#\u0001\u0003mS\n\u001c(B\u0001\f\u0018\u0003\r\t\u0007/\u001b\u0006\u00021\u0005!\u0001\u000f\\1z\u0007\u0001\u00192\u0001A\u000e$!\ta\u0012%D\u0001\u001e\u0015\tqr$\u0001\u0003mC:<'\"\u0001\u0011\u0002\t)\fg/Y\u0005\u0003Eu\u0011aa\u00142kK\u000e$\bC\u0001\u0013&\u001b\u0005\t\u0012B\u0001\u0014\u0012\u00051i\u0015-\u001b7fe\u000ec\u0017.\u001a8u\u0003\u0011\u0019wN\u001c4\u0011\u0005\u0011J\u0013B\u0001\u0016\u0012\u0005E\u0019V\n\u0016)D_:4\u0017nZ;sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00055r\u0003C\u0001\u0013\u0001\u0011\u00159#\u00011\u0001)\u0003\u0019awnZ4feV\t\u0011\u0007\u0005\u00023o5\t1G\u0003\u00025k\u0005)1\u000f\u001c45U*\ta'A\u0002pe\u001eL!\u0001O\u001a\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\nAa]3oIR\u0011A(\u0013\t\u0003{\u0019s!A\u0010#\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005K\u0012A\u0002\u001fs_>$hHC\u0001D\u0003\u0015\u00198-\u00197b\u0013\t)%)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000f\"\u0013aa\u0015;sS:<'BA#C\u0011\u0015QU\u00011\u0001L\u0003\u0015)W.Y5m!\ta5+D\u0001N\u0015\tqu*\u0001\u0003nC&d'B\u0001)R\u0003\u001d\u0019w.\\7p]NT!AU\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t!VJ\u0001\bNk2$\u0018\u000eU1si\u0016k\u0017-\u001b7\u0002)\r\u0014X-\u0019;f\u001bVdG/\u001b)beR,U.Y5m)\u0005Y\u0015aD2sK\u0006$X\r\u0013;nY\u0016k\u0017-\u001b7\u0015\u0003e\u0003\"\u0001\u0014.\n\u0005mk%!\u0003%u[2,U.Y5m)\taT\fC\u0003_\u0011\u0001\u0007q,\u0001\u0003eCR\f\u0007C\u0001\u0013a\u0013\t\t\u0017CA\u0003F[\u0006LG.A\u0006de\u0016\fG/Z#nC&dGCA&e\u0011\u0015q\u0016\u00021\u0001`)\u0011Ye\r\u001c8\t\u000b\u001dT\u0001\u0019\u00015\u0002\u0011\t|G-\u001f+fqR\u00042!\u001b6=\u001b\u0005\u0011\u0015BA6C\u0005\u0019y\u0005\u000f^5p]\")QN\u0003a\u0001Q\u0006A!m\u001c3z\u0011RlG\u000eC\u0003p\u0015\u0001\u0007A(A\u0004dQ\u0006\u00148/\u001a;\u0002\u0015M,G/\u00113ee\u0016\u001c8\u000f\u0006\u0002swR\u00111O\u001e\t\u0003SRL!!\u001e\"\u0003\tUs\u0017\u000e\u001e\u0005\u0006o.\u0001\r\u0001_\u0001\u0007g\u0016$H/\u001a:\u0011\u000b%LH\bP:\n\u0005i\u0014%!\u0003$v]\u000e$\u0018n\u001c83\u0011\u0015a8\u00021\u0001=\u00031)W.Y5m\u0003\u0012$'/Z:t\u0003QA\u0017M\u001c3mK\u0006#H/Y2i[\u0016tG\u000fR1uCR!1o`A\u0001\u0011\u0015QE\u00021\u0001L\u0011\u001d\t\u0019\u0001\u0004a\u0001\u0003\u000b\ta\"\u0019;uC\u000eDW.\u001a8u\t\u0006$\u0018\rE\u0002%\u0003\u000fI1!!\u0003\u0012\u00059\tE\u000f^1dQ6,g\u000e\u001e#bi\u0006\fA\u0003[1oI2,\u0017\t\u001e;bG\"lWM\u001c;GS2,G#B:\u0002\u0010\u0005E\u0001\"\u0002&\u000e\u0001\u0004Y\u0005bBA\n\u001b\u0001\u0007\u0011QC\u0001\u000fCR$\u0018m\u00195nK:$h)\u001b7f!\r!\u0013qC\u0005\u0004\u00033\t\"AD!ui\u0006\u001c\u0007.\\3oi\u001aKG.Z\u0001\u001bQ\u0006tG\r\\3BiR\f7\r[7f]R$\u0015\r^1T_V\u00148-\u001a\u000b\u0006g\u0006}\u0011\u0011\u0005\u0005\u0006\u0015:\u0001\ra\u0013\u0005\b\u0003Gq\u0001\u0019AA\u0013\u0003Q\tG\u000f^1dQ6,g\u000e\u001e#bi\u0006\u001cv.\u001e:dKB\u0019A%a\n\n\u0007\u0005%\u0012C\u0001\u000bBiR\f7\r[7f]R$\u0015\r^1T_V\u00148-Z\u0001\u0014Q\u0006tG\r\\3BiR\f7\r[7f]R,&\u000b\u0014\u000b\u0006g\u0006=\u0012\u0011\u0007\u0005\u0006\u0015>\u0001\ra\u0013\u0005\b\u0003gy\u0001\u0019AA\u001b\u00035\tG\u000f^1dQ6,g\u000e^+S\u0019B\u0019A%a\u000e\n\u0007\u0005e\u0012CA\u0007BiR\f7\r[7f]R,&\u000b\u0014")
public abstract class CommonsMailer
implements MailerClient {
    private final SMTPConfiguration conf;
    private final Logger logger;

    @Override
    public String send(play.libs.mailer.Email data) {
        return MailerClient.send$(this, data);
    }

    @Override
    public Email convert(play.libs.mailer.Email data) {
        return MailerClient.convert$(this, data);
    }

    public Logger logger() {
        return this.logger;
    }

    public abstract String send(MultiPartEmail var1);

    public abstract MultiPartEmail createMultiPartEmail();

    public abstract HtmlEmail createHtmlEmail();

    @Override
    public String send(Email data) {
        return this.send(this.createEmail(data));
    }

    public MultiPartEmail createEmail(Email data) {
        MultiPartEmail email;
        block1: {
            email = this.createEmail(data.bodyText(), data.bodyHtml(), (String)data.charset().getOrElse((Function0 & Serializable)() -> "utf-8"));
            email.setSubject(data.subject());
            this.setAddress(data.from(), (Function2<String, String, BoxedUnit>)(Function2 & Serializable)(address, name) -> {
                email.setFrom(address, name);
                return BoxedUnit.UNIT;
            });
            data.replyTo().foreach((Function1 & Serializable)x$1 -> {
                this.setAddress(x$1, (Function2<String, String, BoxedUnit>)(Function2 & Serializable)(address, name) -> {
                    email$1.addReplyTo(address, name);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            data.bounceAddress().foreach((Function1 & Serializable)x$1 -> email.setBounceAddress(x$1));
            data.to().foreach((Function1 & Serializable)x$2 -> {
                this.setAddress(x$2, (Function2<String, String, BoxedUnit>)(Function2 & Serializable)(address, name) -> {
                    email$1.addTo(address, name);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            data.cc().foreach((Function1 & Serializable)x$3 -> {
                this.setAddress(x$3, (Function2<String, String, BoxedUnit>)(Function2 & Serializable)(address, name) -> {
                    email$1.addCc(address, name);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            data.bcc().foreach((Function1 & Serializable)x$4 -> {
                this.setAddress(x$4, (Function2<String, String, BoxedUnit>)(Function2 & Serializable)(address, name) -> {
                    email$1.addBcc(address, name);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            data.headers().foreach((Function1 & Serializable)header -> {
                email.addHeader((String)header._1(), (String)header._2());
                return BoxedUnit.UNIT;
            });
            this.conf.timeout().foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> email.setSocketTimeout(x$1));
            this.conf.connectionTimeout().foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> email.setSocketConnectionTimeout(x$1));
            data.attachments().foreach((Function1 & Serializable)x0$1 -> {
                CommonsMailer.$anonfun$createEmail$15(this, email, x0$1);
                return BoxedUnit.UNIT;
            });
            email.setHostName(this.conf.host());
            email.setSmtpPort(this.conf.port());
            email.setSSLOnConnect(this.conf.ssl());
            if (this.conf.ssl()) {
                email.setSslSmtpPort(Integer.toString(this.conf.port()));
            }
            email.setStartTLSEnabled(this.conf.tls() || this.conf.tlsRequired());
            email.setStartTLSRequired(this.conf.tlsRequired());
            Option authenticator = this.conf.user().flatMap((Function1 & Serializable)u -> $this.conf.password().map((Function1 & Serializable)p -> new DefaultAuthenticator(u, p)));
            authenticator.foreach((Function1 & Serializable)x$5 -> {
                email.setAuthenticator((Authenticator)x$5);
                return BoxedUnit.UNIT;
            });
            Properties mailProperties = email.getMailSession().getProperties();
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(this.conf.props().entrySet()).asScala()).foreach((Function1 & Serializable)prop -> {
                mailProperties.setProperty("mail.smtp." + prop.getKey(), ((ConfigValue)prop.getValue()).unwrapped().toString());
                return mailProperties.setProperty("mail.smtps." + prop.getKey(), ((ConfigValue)prop.getValue()).unwrapped().toString());
            });
            email.setMailSession(Session.getInstance((Properties)mailProperties, (Authenticator)((Authenticator)authenticator.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
            if (!this.conf.debugMode() || !this.logger().isDebugEnabled()) break block1;
            email.setDebug(this.conf.debugMode());
            email.getMailSession().setDebugOut(new PrintStream(new FilterOutputStream(this){
                private final /* synthetic */ CommonsMailer $outer;

                public void write(byte[] b) {
                    this.$outer.logger().debug(new String(b));
                }

                public void write(byte[] b, int off, int len) {
                    this.$outer.logger().debug(new String(b, off, len));
                }

                public void write(int b) {
                    this.write(new byte[b]);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    super(null);
                }
            }));
        }
        return email;
    }

    private MultiPartEmail createEmail(Option<String> bodyText2, Option<String> bodyHtml, String charset) {
        Tuple2 tuple2 = new Tuple2((Object)bodyHtml.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$6.trim())))), (Object)bodyText2.filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$7.trim())))));
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option bodyTextOpt = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String htmlMsg = (String)some.value();
                HtmlEmail htmlEmail = this.createHtmlEmail();
                htmlEmail.setCharset(charset);
                htmlEmail.setHtmlMsg(htmlMsg);
                bodyTextOpt.foreach((Function1 & Serializable)bodyText -> htmlEmail.setTextMsg(bodyText));
                return htmlEmail;
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && option2 instanceof Some) {
                Some some = (Some)option2;
                String msg = (String)some.value();
                MultiPartEmail multiPartEmail = this.createMultiPartEmail();
                multiPartEmail.setCharset(charset);
                multiPartEmail.setMsg(msg);
                return multiPartEmail;
            }
        }
        return this.createMultiPartEmail();
    }

    private void setAddress(String emailAddress, Function2<String, String, BoxedUnit> setter) {
        if (emailAddress != null) {
            try {
                InternetAddress iAddress = new InternetAddress(emailAddress);
                String address = iAddress.getAddress();
                String name = iAddress.getPersonal();
                setter.apply((Object)address, (Object)name);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)setter.apply((Object)emailAddress, null);
                }
                throw throwable;
            }
            return;
        }
    }

    private void handleAttachmentData(MultiPartEmail email, AttachmentData attachmentData) {
        String description = (String)attachmentData.description().getOrElse((Function0 & Serializable)() -> attachmentData.name());
        String disposition = (String)attachmentData.disposition().getOrElse((Function0 & Serializable)() -> "attachment");
        ByteArrayDataSource dataSource = new ByteArrayDataSource(attachmentData.data(), attachmentData.mimetype());
        Option<String> option = attachmentData.contentId();
        if (option instanceof Some) {
            Some some = (Some)option;
            String cid = (String)some.value();
            MultiPartEmail multiPartEmail = email;
            if (multiPartEmail instanceof HtmlEmail) {
                HtmlEmail htmlEmail = (HtmlEmail)multiPartEmail;
                htmlEmail.embed((DataSource)dataSource, attachmentData.name(), cid);
            } else if (this.conf.debugMode() && this.logger().isDebugEnabled()) {
                this.logger().debug("You need to set an HTML body to embed images with cid");
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            email.attach((DataSource)dataSource, attachmentData.name(), description, disposition);
            return;
        }
        throw new MatchError(option);
    }

    private void handleAttachmentFile(MultiPartEmail email, AttachmentFile attachmentFile) {
        String description = (String)attachmentFile.description().getOrElse((Function0 & Serializable)() -> attachmentFile.name());
        String disposition = (String)attachmentFile.disposition().getOrElse((Function0 & Serializable)() -> "attachment");
        EmailAttachment emailAttachment = new EmailAttachment();
        emailAttachment.setName(attachmentFile.name());
        emailAttachment.setPath(attachmentFile.file().getPath());
        emailAttachment.setDescription(description);
        emailAttachment.setDisposition(disposition);
        Option<String> option = attachmentFile.contentId();
        if (option instanceof Some) {
            Some some = (Some)option;
            String cid = (String)some.value();
            MultiPartEmail multiPartEmail = email;
            if (multiPartEmail instanceof HtmlEmail) {
                HtmlEmail htmlEmail = (HtmlEmail)multiPartEmail;
                htmlEmail.embed(attachmentFile.file(), cid);
            } else if (this.conf.debugMode() && this.logger().isDebugEnabled()) {
                this.logger().debug("You need to set an HTML body to embed images with cid");
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            email.attach(emailAttachment);
            return;
        }
        throw new MatchError(option);
    }

    private void handleAttachmentDataSource(MultiPartEmail email, AttachmentDataSource attachmentDataSource) {
        String description = (String)attachmentDataSource.description().getOrElse((Function0 & Serializable)() -> attachmentDataSource.name());
        String disposition = (String)attachmentDataSource.disposition().getOrElse((Function0 & Serializable)() -> "attachment");
        DataSource dataSource = attachmentDataSource.dataSource();
        Option<String> option = attachmentDataSource.contentId();
        if (option instanceof Some) {
            Some some = (Some)option;
            String cid = (String)some.value();
            MultiPartEmail multiPartEmail = email;
            if (multiPartEmail instanceof HtmlEmail) {
                HtmlEmail htmlEmail = (HtmlEmail)multiPartEmail;
                htmlEmail.embed(dataSource, attachmentDataSource.name(), cid);
            } else if (this.conf.debugMode() && this.logger().isDebugEnabled()) {
                this.logger().debug("You need to set an HTML body to embed images with cid");
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            email.attach(dataSource, attachmentDataSource.name(), description, disposition);
            return;
        }
        throw new MatchError(option);
    }

    private void handleAttachmentURL(MultiPartEmail email, AttachmentURL attachmentURL) {
        String description = (String)attachmentURL.description().getOrElse((Function0 & Serializable)() -> attachmentURL.name());
        String disposition = (String)attachmentURL.disposition().getOrElse((Function0 & Serializable)() -> "attachment");
        URL url = attachmentURL.url();
        Option<String> option = attachmentURL.contentId();
        if (option instanceof Some) {
            Some some = (Some)option;
            String cid = (String)some.value();
            MultiPartEmail multiPartEmail = email;
            if (multiPartEmail instanceof HtmlEmail) {
                HtmlEmail htmlEmail = (HtmlEmail)multiPartEmail;
                htmlEmail.embed((DataSource)new URLDataSource(url), attachmentURL.name(), cid);
            } else if (this.conf.debugMode() && this.logger().isDebugEnabled()) {
                this.logger().debug("You need to set an HTML body to embed images with cid");
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            email.attach(url, attachmentURL.name(), description, disposition);
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$createEmail$15(CommonsMailer $this, MultiPartEmail email$1, Attachment x0$1) {
        Attachment attachment = x0$1;
        if (attachment instanceof AttachmentData) {
            AttachmentData attachmentData = (AttachmentData)attachment;
            $this.handleAttachmentData(email$1, attachmentData);
            return;
        }
        if (attachment instanceof AttachmentFile) {
            AttachmentFile attachmentFile = (AttachmentFile)attachment;
            $this.handleAttachmentFile(email$1, attachmentFile);
            return;
        }
        if (attachment instanceof AttachmentDataSource) {
            AttachmentDataSource attachmentDataSource = (AttachmentDataSource)attachment;
            $this.handleAttachmentDataSource(email$1, attachmentDataSource);
            return;
        }
        if (attachment instanceof AttachmentURL) {
            AttachmentURL attachmentURL = (AttachmentURL)attachment;
            $this.handleAttachmentURL(email$1, attachmentURL);
            return;
        }
        throw new MatchError((Object)attachment);
    }

    public CommonsMailer(SMTPConfiguration conf) {
        this.conf = conf;
        MailerClient.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"play.mailer");
    }
}

