/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.json;

import com.fasterxml.jackson.core.StreamReadConstraints;
import java.io.Serializable;
import java.math.MathContext;
import play.api.libs.json.BigDecimalParseConfig;
import play.api.libs.json.BigDecimalParseConfig$;
import play.api.libs.json.BigDecimalSerializerConfig;
import play.api.libs.json.BigDecimalSerializerConfig$;
import play.api.libs.json.JsonConfig;
import play.api.libs.json.JsonConfigImpl;
import play.api.libs.json.JsonConfigImpl$;
import play.api.libs.json.JsonParserSettings;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.deriving.Mirror;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.control.NonFatal$;

public final class JsonConfig$
implements Mirror.Sum,
Serializable {
    private static final MathContext defaultMathContext;
    private static final int defaultScaleLimit;
    private static final int defaultDigitsLimit;
    private static final boolean defaultPreserveZeroDecimal;
    private static final BigDecimal defaultMaxPlain;
    private static final BigDecimal defaultMinPlain;
    private static final String scaleLimitProperty;
    private static final String digitsLimitProperty;
    private static final String mathContextProperty;
    private static final String minPlainProperty;
    private static final String maxPlainProperty;
    private static final String maxNestingDepth;
    private static final String maxStringLength;
    private static final String preserveZeroDecimalProperty;
    private static final StreamReadConstraints defaultStreamReadConstraints;
    private static final JsonConfig settings;
    public static final JsonConfig$ MODULE$;

    private JsonConfig$() {
    }

    static {
        MODULE$ = new JsonConfig$();
        defaultMathContext = MathContext.DECIMAL128;
        defaultScaleLimit = 6178;
        defaultDigitsLimit = 310;
        defaultPreserveZeroDecimal = false;
        defaultMaxPlain = BigDecimal$.MODULE$.double2bigDecimal(1.0E20);
        defaultMinPlain = BigDecimal$.MODULE$.double2bigDecimal(1.0E-10);
        scaleLimitProperty = "play.json.parser.scaleLimit";
        digitsLimitProperty = "play.json.parser.digitsLimit";
        mathContextProperty = "play.json.parser.mathContext";
        minPlainProperty = "play.json.serializer.minPlain";
        maxPlainProperty = "play.json.serializer.maxPlain";
        maxNestingDepth = "play.json.parser.maxNestingDepth";
        maxStringLength = "play.json.parser.maxStringLength";
        preserveZeroDecimalProperty = "play.json.serializer.preserveZeroDecimal";
        defaultStreamReadConstraints = StreamReadConstraints.builder().maxNestingDepth(MODULE$.loadMaxNestingDepth()).maxStringLength(MODULE$.loadMaxStringLength()).maxNumberLength(Integer.MAX_VALUE).build();
        settings = MODULE$.apply(BigDecimalParseConfig$.MODULE$.apply(MODULE$.loadMathContext(), MODULE$.loadScaleLimit(), MODULE$.loadDigitsLimit()), BigDecimalSerializerConfig$.MODULE$.apply(MODULE$.loadMinPlain(), MODULE$.loadMaxPlain(), MODULE$.loadPreserveZeroDecimal()), MODULE$.defaultStreamReadConstraints());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JsonConfig$.class);
    }

    public MathContext defaultMathContext() {
        return defaultMathContext;
    }

    public int defaultScaleLimit() {
        return defaultScaleLimit;
    }

    public int defaultDigitsLimit() {
        return defaultDigitsLimit;
    }

    public boolean defaultPreserveZeroDecimal() {
        return defaultPreserveZeroDecimal;
    }

    public BigDecimal defaultMaxPlain() {
        return defaultMaxPlain;
    }

    public BigDecimal defaultMinPlain() {
        return defaultMinPlain;
    }

    public String scaleLimitProperty() {
        return scaleLimitProperty;
    }

    public String digitsLimitProperty() {
        return digitsLimitProperty;
    }

    public String mathContextProperty() {
        return mathContextProperty;
    }

    public String minPlainProperty() {
        return minPlainProperty;
    }

    public String maxPlainProperty() {
        return maxPlainProperty;
    }

    public String maxNestingDepth() {
        return maxNestingDepth;
    }

    public String maxStringLength() {
        return maxStringLength;
    }

    public String preserveZeroDecimalProperty() {
        return preserveZeroDecimalProperty;
    }

    public int loadScaleLimit() {
        return BoxesRunTime.unboxToInt((Object)this.prop(this.scaleLimitProperty(), BoxesRunTime.boxToInteger((int)this.defaultScaleLimit()), (Function1 & Serializable)_$1 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$1))));
    }

    public int loadDigitsLimit() {
        return BoxesRunTime.unboxToInt((Object)this.prop(this.digitsLimitProperty(), BoxesRunTime.boxToInteger((int)this.defaultDigitsLimit()), (Function1 & Serializable)_$2 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$2))));
    }

    public MathContext loadMathContext() {
        return this.parseMathContext(this.mathContextProperty());
    }

    public BigDecimal loadMinPlain() {
        return this.prop(this.minPlainProperty(), this.defaultMinPlain(), (Function1 & Serializable)s -> package$.MODULE$.BigDecimal().exact(s));
    }

    public BigDecimal loadMaxPlain() {
        return this.prop(this.maxPlainProperty(), this.defaultMaxPlain(), (Function1 & Serializable)s -> package$.MODULE$.BigDecimal().exact(s));
    }

    public int loadMaxNestingDepth() {
        return BoxesRunTime.unboxToInt((Object)this.prop(this.maxNestingDepth(), BoxesRunTime.boxToInteger((int)1000), (Function1 & Serializable)x$0 -> Integer.parseInt(x$0)));
    }

    public int loadMaxStringLength() {
        return BoxesRunTime.unboxToInt((Object)this.prop(this.maxStringLength(), BoxesRunTime.boxToInteger((int)20000000), (Function1 & Serializable)x$0 -> Integer.parseInt(x$0)));
    }

    public boolean loadPreserveZeroDecimal() {
        return BoxesRunTime.unboxToBoolean((Object)this.prop(this.preserveZeroDecimalProperty(), BoxesRunTime.boxToBoolean((boolean)this.defaultPreserveZeroDecimal()), (Function1 & Serializable)_$3 -> StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(_$3))));
    }

    public StreamReadConstraints defaultStreamReadConstraints() {
        return defaultStreamReadConstraints;
    }

    public JsonConfig settings() {
        return settings;
    }

    public JsonConfig apply() {
        return this.apply(BigDecimalParseConfig$.MODULE$.apply(BigDecimalParseConfig$.MODULE$.apply$default$1(), BigDecimalParseConfig$.MODULE$.apply$default$2(), BigDecimalParseConfig$.MODULE$.apply$default$3()), BigDecimalSerializerConfig$.MODULE$.apply(BigDecimalSerializerConfig$.MODULE$.apply$default$1(), BigDecimalSerializerConfig$.MODULE$.apply$default$2(), BigDecimalSerializerConfig$.MODULE$.apply$default$3()));
    }

    public JsonConfig apply(BigDecimalParseConfig bigDecimalParseConfig, BigDecimalSerializerConfig bigDecimalSerializerConfig) {
        return JsonConfigImpl$.MODULE$.apply(bigDecimalParseConfig, bigDecimalSerializerConfig, this.defaultStreamReadConstraints());
    }

    public JsonConfig apply(BigDecimalParseConfig bigDecimalParseConfig, BigDecimalSerializerConfig bigDecimalSerializerConfig, StreamReadConstraints streamReadConstraints) {
        return JsonConfigImpl$.MODULE$.apply(bigDecimalParseConfig, bigDecimalSerializerConfig, streamReadConstraints);
    }

    public MathContext parseMathContext(String key) {
        Option option = scala.sys.package$.MODULE$.props().get(key).map((Function1 & Serializable)_$4 -> _$4.toLowerCase());
        if (option instanceof Some) {
            String string = (String)((Some)option).value();
            switch (string == null ? 0 : string.hashCode()) {
                case -1984193210: {
                    if (!"decimal128".equals(string)) break;
                    return MathContext.DECIMAL128;
                }
                case 351635824: {
                    if (!"decimal32".equals(string)) break;
                    return MathContext.DECIMAL32;
                }
                case 351635919: {
                    if (!"decimal64".equals(string)) break;
                    return MathContext.DECIMAL64;
                }
            }
            if ("unlimited".equals(string)) {
                return MathContext.UNLIMITED;
            }
        }
        return this.defaultMathContext();
    }

    public <T> T prop(String key, T t, Function1<String, T> f) {
        Object object;
        try {
            object = scala.sys.package$.MODULE$.props().get(key).map(f).getOrElse(() -> this.prop$$anonfun$1(t));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
                object = t;
            }
            throw throwable;
        }
        return (T)object;
    }

    public int ordinal(JsonConfig x$0) {
        JsonConfig jsonConfig = x$0;
        if (jsonConfig instanceof JsonConfigImpl) {
            return 0;
        }
        if (jsonConfig instanceof JsonParserSettings) {
            return 1;
        }
        throw new MatchError((Object)jsonConfig);
    }

    private final Object prop$$anonfun$1(Object default$1) {
        return default$1;
    }
}

