/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.json.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.Serializable;
import java.math.BigDecimal;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsBoolean;
import play.api.libs.json.JsBoolean$;
import play.api.libs.json.JsNull$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsonConfig;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000113Q!\u0002\u0004\u0001\rAA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\u0006K\u0001!\tA\n\u0005\u0006U\u0001!Ia\u000b\u0005\u0006m\u0001!\te\u000e\u0002\u0012\u0015N4\u0016\r\\;f'\u0016\u0014\u0018.\u00197ju\u0016\u0014(BA\u0004\t\u0003\u001dQ\u0017mY6t_:T!!\u0003\u0006\u0002\t)\u001cxN\u001c\u0006\u0003\u00171\tA\u0001\\5cg*\u0011QBD\u0001\u0004CBL'\"A\b\u0002\tAd\u0017-_\n\u0003\u0001E\u00012A\u0005\u000e\u001d\u001b\u0005\u0019\"B\u0001\u000b\u0016\u0003!!\u0017\r^1cS:$'BA\u0004\u0017\u0015\t9\u0002$A\u0005gCN$XM\u001d=nY*\t\u0011$A\u0002d_6L!aG\n\u0003\u001d)\u001bxN\\*fe&\fG.\u001b>feB\u0011QDH\u0007\u0002\u0011%\u0011q\u0004\u0003\u0002\b\u0015N4\u0016\r\\;f\u0003)Q7o\u001c8D_:4\u0017nZ\u0002\u0001!\ti2%\u0003\u0002%\u0011\tQ!j]8o\u0007>tg-[4\u0002\rqJg.\u001b;?)\t9\u0013\u0006\u0005\u0002)\u00015\ta\u0001C\u0003!\u0005\u0001\u0007!%\u0001\ntiJL\u0007\u000f\u0016:bS2Lgn\u001a.fe>\u001cHC\u0001\u00175!\ti#'D\u0001/\u0015\ty\u0003'\u0001\u0003nCRD'\"A\u0019\u0002\t)\fg/Y\u0005\u0003g9\u0012!BQ5h\t\u0016\u001c\u0017.\\1m\u0011\u0015)4\u00011\u0001-\u0003\u0019\u0011\u0017n\u001a#fG\u0006I1/\u001a:jC2L'0\u001a\u000b\u0005qy\u0002u\t\u0005\u0002:y5\t!HC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$H\u0001\u0003V]&$\b\"B \u0005\u0001\u0004a\u0012!\u0002<bYV,\u0007\"B\u0005\u0005\u0001\u0004\t\u0005C\u0001\"F\u001b\u0005\u0019%B\u0001#\u0016\u0003\u0011\u0019wN]3\n\u0005\u0019\u001b%!\u0004&t_:<UM\\3sCR|'\u000fC\u0003I\t\u0001\u0007\u0011*\u0001\u0005qe>4\u0018\u000eZ3s!\t\u0011\"*\u0003\u0002L'\t\u00112+\u001a:jC2L'0\u001a:Qe>4\u0018\u000eZ3s\u0001")
public class JsValueSerializer
extends JsonSerializer<JsValue> {
    private final JsonConfig jsonConfig;

    private BigDecimal stripTrailingZeros(BigDecimal bigDec) {
        BigDecimal stripped = bigDec.stripTrailingZeros();
        if (this.jsonConfig.bigDecimalSerializerConfig().preserveZeroDecimal() && bigDec.scale() > 0 && stripped.scale() <= 0) {
            return stripped.setScale(1);
        }
        return stripped;
    }

    public void serialize(JsValue value, JsonGenerator json, SerializerProvider provider) {
        JsBoolean jsBoolean;
        Some<Object> some;
        JsValue jsValue = value;
        if (jsValue instanceof JsNumber) {
            String raw;
            JsNumber jsNumber = (JsNumber)jsValue;
            scala.math.BigDecimal v = jsNumber.value();
            scala.math.BigDecimal va = v.abs();
            boolean shouldWritePlain = va.$less((Object)this.jsonConfig.bigDecimalSerializerConfig().maxPlain()) && va.$greater((Object)this.jsonConfig.bigDecimalSerializerConfig().minPlain());
            BigDecimal stripped = this.stripTrailingZeros(v.bigDecimal());
            String string = raw = shouldWritePlain ? stripped.toPlainString() : stripped.toString();
            if (new StringOps(Predef$.MODULE$.augmentString(raw)).exists((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)JsValueSerializer.$anonfun$serialize$1(BoxesRunTime.unboxToChar((Object)c))))) {
                json.writeNumber(raw);
                return;
            }
            JsonGenerator jsonGenerator = json;
            if (jsonGenerator instanceof TokenBuffer) {
                TokenBuffer tokenBuffer = (TokenBuffer)jsonGenerator;
                tokenBuffer.writeNumber(raw, true);
            } else {
                json.writeNumber(raw);
            }
            return;
        }
        if (jsValue instanceof JsString) {
            JsString jsString = (JsString)jsValue;
            String v = jsString.value();
            json.writeString(v);
            return;
        }
        if (jsValue instanceof JsBoolean && !(some = JsBoolean$.MODULE$.unapply(jsBoolean = (JsBoolean)jsValue)).isEmpty()) {
            boolean v = BoxesRunTime.unboxToBoolean((Object)some.get());
            json.writeBoolean(v);
            return;
        }
        if (jsValue instanceof JsArray) {
            JsArray jsArray = (JsArray)jsValue;
            IndexedSeq<JsValue> elements = jsArray.value();
            json.writeStartArray();
            elements.foreach((Function1 & Serializable & scala.Serializable)t -> {
                this.serialize(t, json, provider);
                return BoxedUnit.UNIT;
            });
            json.writeEndArray();
            return;
        }
        if (jsValue instanceof JsObject) {
            JsObject jsObject = (JsObject)jsValue;
            Map<String, JsValue> values = jsObject.underlying$access$0();
            json.writeStartObject();
            values.foreach((Function1 & Serializable & scala.Serializable)t -> {
                JsValueSerializer.$anonfun$serialize$3(this, json, provider, t);
                return BoxedUnit.UNIT;
            });
            json.writeEndObject();
            return;
        }
        if (JsNull$.MODULE$.equals(jsValue)) {
            json.writeNull();
            return;
        }
        throw new MatchError((Object)jsValue);
    }

    public static final /* synthetic */ boolean $anonfun$serialize$1(char c) {
        return c == 'E' || c == '.';
    }

    public static final /* synthetic */ void $anonfun$serialize$3(JsValueSerializer $this, JsonGenerator json$1, SerializerProvider provider$1, Tuple2 t) {
        json$1.writeFieldName((String)t._1());
        $this.serialize((JsValue)t._2(), json$1, provider$1);
    }

    public JsValueSerializer(JsonConfig jsonConfig) {
        this.jsonConfig = jsonConfig;
    }
}

