/*
 * Decompiled with CFR 0.152.
 */
package play.api.db;

import com.typesafe.config.Config;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sql.DataSource;
import play.api.Configuration;
import play.api.Configuration$;
import play.api.Environment;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.db.ConnectionPool;
import play.api.db.ConnectionPool$;
import play.api.db.DatabaseConfig;
import play.api.db.HikariCPConfig;
import play.api.libs.JNDI$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some$;
import scala.runtime.function.JProcedure1;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Singleton
public class HikariCPConnectionPool
implements ConnectionPool {
    private final Logger logger = Logger$.MODULE$.apply(this.getClass());

    @Inject
    public HikariCPConnectionPool(Environment environment) {
    }

    @Override
    public DataSource create(String name, DatabaseConfig dbConfig, Config configuration) {
        Configuration config = Configuration$.MODULE$.apply(configuration);
        Try try_ = Try$.MODULE$.apply(() -> this.create$$anonfun$1(name, dbConfig, configuration, config));
        if (try_ instanceof Success) {
            DataSource datasource = (DataSource)((Success)try_).value();
            return datasource;
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            throw config.reportError(name, ex.getMessage(), (Option)Some$.MODULE$.apply((Object)ex));
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public void close(DataSource dataSource) {
        this.logger.info(HikariCPConnectionPool::close$$anonfun$1, MarkerContext$.MODULE$.NoMarker());
        DataSource dataSource2 = ConnectionPool$.MODULE$.unwrap(dataSource);
        if (dataSource2 instanceof HikariDataSource) {
            HikariDataSource ds = (HikariDataSource)dataSource2;
            ds.close();
            return;
        }
        throw package$.MODULE$.error("Unable to close data source: not a HikariDataSource");
    }

    private static final String create$$anonfun$1$$anonfun$1(String name$2) {
        return "Creating Pool for datasource '" + name$2 + "'";
    }

    private static final String create$$anonfun$1$$anonfun$2$$anonfun$1(String name$4, String jndiName$1) {
        return "datasource [" + name$4 + "] bound to JNDI as " + jndiName$1;
    }

    private final DataSource create$$anonfun$1(String name$1, DatabaseConfig dbConfig$1, Config configuration$1, Configuration config$1) {
        this.logger.info(() -> HikariCPConnectionPool.create$$anonfun$1$$anonfun$1(name$1), MarkerContext$.MODULE$.NoMarker());
        HikariConfig hikariConfig = new HikariCPConfig(name$1, dbConfig$1, config$1).toHikariConfig();
        HikariDataSource datasource = new HikariDataSource(hikariConfig);
        DataSource wrappedDataSource = ConnectionPool$.MODULE$.wrapToLogSql((DataSource)datasource, configuration$1);
        dbConfig$1.jndiName().foreach((Function1)(JProcedure1 & Serializable)jndiName -> {
            JNDI$.MODULE$.initialContext().rebind((String)jndiName, (Object)wrappedDataSource);
            this.logger.info(() -> HikariCPConnectionPool.create$$anonfun$1$$anonfun$2$$anonfun$1(name$1, jndiName), MarkerContext$.MODULE$.NoMarker());
        });
        return wrappedDataSource;
    }

    private static final String close$$anonfun$1() {
        return "Shutting down connection pool.";
    }
}

