/*
 * Decompiled with CFR 0.152.
 */
package play.api.db;

import com.typesafe.config.Config;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Serializable;
import javax.sql.DataSource;
import play.api.Configuration;
import play.api.Environment;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.db.ConnectionPool;
import play.api.db.ConnectionPool$;
import play.api.db.DatabaseConfig;
import play.api.db.HikariCPConfig;
import play.api.libs.JNDI$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Singleton
@ScalaSignature(bytes="\u0006\u000594A\u0001D\u0007\u0001)!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005C\u0003%\u0001\u0011\u0005Q\u0005C\u00042\u0001\t\u0007I\u0011\u0002\u001a\t\rY\u0002\u0001\u0015!\u00034\u0011\u00159\u0004\u0001\"\u00119\u0011\u0015y\u0006\u0001\"\u0011a\u000f\u0015QW\u0002#\u0001l\r\u0015aQ\u0002#\u0001m\u0011\u0015!\u0003\u0002\"\u0001n\u0011\u001d\t\u0004B1A\u0005\nIBaA\u000e\u0005!\u0002\u0013\u0019$A\u0006%jW\u0006\u0014\u0018n\u0011)D_:tWm\u0019;j_:\u0004vn\u001c7\u000b\u00059y\u0011A\u00013c\u0015\t\u0001\u0012#A\u0002ba&T\u0011AE\u0001\u0005a2\f\u0017p\u0001\u0001\u0014\u0007\u0001)2\u0004\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VM\u001a\t\u00039ui\u0011!D\u0005\u0003=5\u0011abQ8o]\u0016\u001cG/[8o!>|G.A\u0006f]ZL'o\u001c8nK:$\bCA\u0011#\u001b\u0005y\u0011BA\u0012\u0010\u0005-)eN^5s_:lWM\u001c;\u0002\rqJg.\u001b;?)\t1s\u0005\u0005\u0002\u001d\u0001!)qD\u0001a\u0001A!\u0012!!\u000b\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\na!\u001b8kK\u000e$(\"\u0001\u0018\u0002\u000f)\f7.\u0019:uC&\u0011\u0001g\u000b\u0002\u0007\u0013:TWm\u0019;\u0002\r1|wmZ3s+\u0005\u0019\u0004CA\u00115\u0013\t)tB\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003\u0019\u0019'/Z1uKR!\u0011(\u0011(T!\tQt(D\u0001<\u0015\taT(A\u0002tc2T\u0011AP\u0001\u0006U\u00064\u0018\r_\u0005\u0003\u0001n\u0012!\u0002R1uCN{WO]2f\u0011\u0015\u0011U\u00011\u0001D\u0003\u0011q\u0017-\\3\u0011\u0005\u0011[eBA#J!\t1u#D\u0001H\u0015\tA5#\u0001\u0004=e>|GOP\u0005\u0003\u0015^\ta\u0001\u0015:fI\u00164\u0017B\u0001'N\u0005\u0019\u0019FO]5oO*\u0011!j\u0006\u0005\u0006\u001f\u0016\u0001\r\u0001U\u0001\tI\n\u001cuN\u001c4jOB\u0011A$U\u0005\u0003%6\u0011a\u0002R1uC\n\f7/Z\"p]\u001aLw\rC\u0003U\u000b\u0001\u0007Q+A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003-vk\u0011a\u0016\u0006\u00031f\u000baaY8oM&<'B\u0001.\\\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001/\u0002\u0007\r|W.\u0003\u0002_/\n11i\u001c8gS\u001e\fQa\u00197pg\u0016$\"!\u00193\u0011\u0005Y\u0011\u0017BA2\u0018\u0005\u0011)f.\u001b;\t\u000b\u00154\u0001\u0019A\u001d\u0002\u0015\u0011\fG/Y*pkJ\u001cW\r\u000b\u0002\u0001OB\u0011!\u0006[\u0005\u0003S.\u0012\u0011bU5oO2,Go\u001c8\u0002-!K7.\u0019:j\u0007B\u001buN\u001c8fGRLwN\u001c)p_2\u0004\"\u0001\b\u0005\u0014\u0005!)B#A6")
public class HikariCPConnectionPool
implements ConnectionPool {
    private final Logger logger = Logger$.MODULE$.apply(this.getClass());

    private Logger logger() {
        return this.logger;
    }

    @Override
    public DataSource create(String name, DatabaseConfig dbConfig, Config configuration) {
        Configuration config = new Configuration(configuration);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.logger().info((Function0 & Serializable)() -> "Creating Pool for datasource '" + name + "'", MarkerContext$.MODULE$.NoMarker());
            HikariConfig hikariConfig = new HikariCPConfig(name, dbConfig, config).toHikariConfig();
            HikariDataSource datasource = new HikariDataSource(hikariConfig);
            DataSource wrappedDataSource = ConnectionPool$.MODULE$.wrapToLogSql((DataSource)datasource, configuration);
            dbConfig.jndiName().foreach((Function1 & Serializable)jndiName -> {
                HikariCPConnectionPool.$anonfun$create$3(this, wrappedDataSource, name, jndiName);
                return BoxedUnit.UNIT;
            });
            return wrappedDataSource;
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            DataSource datasource = (DataSource)success.value();
            return datasource;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            throw config.reportError(name, ex.getMessage(), (Option)new Some((Object)ex));
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public void close(DataSource dataSource) {
        this.logger().info((Function0 & Serializable)() -> "Shutting down connection pool.", MarkerContext$.MODULE$.NoMarker());
        DataSource dataSource2 = ConnectionPool$.MODULE$.unwrap(dataSource);
        if (dataSource2 instanceof HikariDataSource) {
            HikariDataSource hikariDataSource = (HikariDataSource)dataSource2;
            hikariDataSource.close();
            return;
        }
        throw package$.MODULE$.error("Unable to close data source: not a HikariDataSource");
    }

    public static final /* synthetic */ void $anonfun$create$3(HikariCPConnectionPool $this, DataSource wrappedDataSource$1, String name$1, String jndiName) {
        JNDI$.MODULE$.initialContext().rebind(jndiName, (Object)wrappedDataSource$1);
        $this.logger().info((Function0 & Serializable)() -> "datasource [" + name$1 + "] bound to JNDI as " + jndiName, MarkerContext$.MODULE$.NoMarker());
    }

    @Inject
    public HikariCPConnectionPool(Environment environment) {
    }
}

