/*
 * Decompiled with CFR 0.152.
 */
package play.api.db;

import com.typesafe.config.Config;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.io.Serializable;
import play.api.Configuration;
import play.api.Environment;
import play.api.Mode;
import play.api.db.ConnectionPool;
import play.api.db.ConnectionPool$;
import play.api.db.DBApi;
import play.api.db.DBApiProvider$;
import play.api.db.DefaultDBApi;
import play.api.inject.ApplicationLifecycle;
import play.api.inject.Injector;
import play.api.inject.NewInstanceInjector$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005M4A!\u0004\b\u0001+!A!\u0006\u0001B\u0001B\u0003%1\u0006\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0011!\u0019\u0004A!A!\u0002\u0013!\u0004\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011u\u0002!\u0011!Q\u0001\nyBQa\u0012\u0001\u0005\u0002!CQa\u0012\u0001\u0005\u0002=C\u0001B\u0017\u0001\t\u0006\u0004%\taW\u0004\bA:\t\t\u0011#\u0001b\r\u001dia\"!A\t\u0002\tDQa\u0012\u0006\u0005\u0002\u0019Dqa\u001a\u0006\u0012\u0002\u0013\u0005\u0001NA\u0007E\u0005\u0006\u0003\u0018\u000e\u0015:pm&$WM\u001d\u0006\u0003\u001fA\t!\u0001\u001a2\u000b\u0005E\u0011\u0012aA1qS*\t1#\u0001\u0003qY\u0006L8\u0001A\n\u0004\u0001Yq\u0002CA\f\u001d\u001b\u0005A\"BA\r\u001b\u0003\u0011a\u0017M\\4\u000b\u0003m\tAA[1wC&\u0011Q\u0004\u0007\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007}!c%D\u0001!\u0015\t\t#%\u0001\u0004j]*,7\r\u001e\u0006\u0002G\u00059!.Y6beR\f\u0017BA\u0013!\u0005!\u0001&o\u001c<jI\u0016\u0014\bCA\u0014)\u001b\u0005q\u0011BA\u0015\u000f\u0005\u0015!%)\u00119j\u0003-)gN^5s_:lWM\u001c;\u0011\u00051jS\"\u0001\t\n\u00059\u0002\"aC#om&\u0014xN\\7f]R\fQbY8oM&<WO]1uS>t\u0007C\u0001\u00172\u0013\t\u0011\u0004CA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0016I\u00164\u0017-\u001e7u\u0007>tg.Z2uS>t\u0007k\\8m!\t9S'\u0003\u00027\u001d\tq1i\u001c8oK\u000e$\u0018n\u001c8Q_>d\u0017!\u00037jM\u0016\u001c\u0017p\u00197f!\tI4(D\u0001;\u0015\t\t\u0003#\u0003\u0002=u\t!\u0012\t\u001d9mS\u000e\fG/[8o\u0019&4WmY=dY\u0016\fQ\"\\1zE\u0016LeN[3di>\u0014\bcA C\t6\t\u0001IC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0005I\u0001\u0004PaRLwN\u001c\t\u0003s\u0015K!A\u0012\u001e\u0003\u0011%s'.Z2u_J\fa\u0001P5oSRtDCB%K\u00172ke\n\u0005\u0002(\u0001!)!F\u0002a\u0001W!)qF\u0002a\u0001a!)1G\u0002a\u0001i!)qG\u0002a\u0001q!)QH\u0002a\u0001}Q1\u0011\nU)S'RCQAK\u0004A\u0002-BQaL\u0004A\u0002ABQaM\u0004A\u0002QBQaN\u0004A\u0002aBq!V\u0004\u0011\u0002\u0003\u0007A)\u0001\u0005j]*,7\r^8sQ\t9q\u000b\u0005\u0002 1&\u0011\u0011\f\t\u0002\u0007\u0013:TWm\u0019;\u0002\u0007\u001d,G/F\u0001'Q\t\u0001Q\f\u0005\u0002 =&\u0011q\f\t\u0002\n'&tw\r\\3u_:\fQ\u0002\u0012\"Ba&\u0004&o\u001c<jI\u0016\u0014\bCA\u0014\u000b'\tQ1\r\u0005\u0002@I&\u0011Q\r\u0011\u0002\u0007\u0003:L(+\u001a4\u0015\u0003\u0005\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*T#A5+\u0005\u0011S7&A6\u0011\u00051\fX\"A7\u000b\u00059|\u0017!C;oG\",7m[3e\u0015\t\u0001\b)\u0001\u0006b]:|G/\u0019;j_:L!A]7\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class DBApiProvider
implements Provider<DBApi> {
    private DBApi get;
    private final Environment environment;
    private final Configuration configuration;
    private final ConnectionPool defaultConnectionPool;
    private ApplicationLifecycle lifecycle;
    private final Option<Injector> maybeInjector;
    private volatile boolean bitmap$0;

    public static Injector $lessinit$greater$default$5() {
        return DBApiProvider$.MODULE$.$lessinit$greater$default$5();
    }

    private DBApi get$lzycompute() {
        DBApiProvider dBApiProvider = this;
        synchronized (dBApiProvider) {
            if (!this.bitmap$0) {
                Config config = this.configuration.underlying();
                String dbKey = config.getString("play.db.config");
                ConnectionPool pool = (ConnectionPool)this.maybeInjector.map((Function1 & Serializable)injector -> ConnectionPool$.MODULE$.fromConfig(config.getString("play.db.pool"), (Injector)injector, $this.environment, $this.defaultConnectionPool)).getOrElse((Function0 & Serializable)() -> ConnectionPool$.MODULE$.fromConfig(config.getString("play.db.pool"), $this.environment, $this.defaultConnectionPool));
                Map configs = config.hasPath(dbKey) ? new Configuration(config).getPrototypedMap(dbKey, "play.db.prototype").view().mapValues((Function1 & Serializable)x$1 -> x$1.underlying()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()) : Predef$.MODULE$.Map().empty();
                DefaultDBApi db = new DefaultDBApi((Map<String, Config>)configs, pool, this.environment, (Injector)this.maybeInjector.getOrElse((Function0 & Serializable)() -> NewInstanceInjector$.MODULE$));
                this.lifecycle.addStopHook((Function0 & Serializable)() -> Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> db.shutdown())));
                Mode mode = this.environment.mode();
                Mode.Test$ test$ = Mode.Test$.MODULE$;
                db.initialize(mode == null ? test$ != null : !mode.equals(test$));
                this.get = db;
                this.bitmap$0 = true;
            }
        }
        this.lifecycle = null;
        return this.get;
    }

    public DBApi get() {
        if (!this.bitmap$0) {
            return this.get$lzycompute();
        }
        return this.get;
    }

    public DBApiProvider(Environment environment, Configuration configuration, ConnectionPool defaultConnectionPool, ApplicationLifecycle lifecycle, Option<Injector> maybeInjector) {
        this.environment = environment;
        this.configuration = configuration;
        this.defaultConnectionPool = defaultConnectionPool;
        this.lifecycle = lifecycle;
        this.maybeInjector = maybeInjector;
    }

    @Inject
    public DBApiProvider(Environment environment, Configuration configuration, ConnectionPool defaultConnectionPool, ApplicationLifecycle lifecycle, Injector injector) {
        this(environment, configuration, defaultConnectionPool, lifecycle, (Option<Injector>)Option$.MODULE$.apply((Object)injector));
    }
}

