/*
 * Decompiled with CFR 0.152.
 */
package play.api.db;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import javax.sql.DataSource;
import play.api.Configuration;
import play.api.Environment;
import play.api.db.Database;
import play.api.db.DatabaseConfig;
import play.api.db.DatabaseConfig$;
import play.api.db.TransactionIsolationLevel;
import play.utils.ProxyDriver;
import play.utils.Reflect$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.ControlThrowable;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005%d!B\f\u0019\u0003\u0003y\u0002\u0002\u0003\u0016\u0001\u0005\u000b\u0007I\u0011A\u0016\t\u0011]\u0002!\u0011!Q\u0001\n1B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\")\u0001\n\u0001C\u0001\u0013\"9A\b\u0001b\u0001\n\u0013q\u0005B\u0002*\u0001A\u0003%q\nC\u0004T\u0001\t\u0007I\u0011\u0001+\t\ra\u0003\u0001\u0015!\u0003V\u0011\u0015I\u0006A\"\u0001[\u0011\u0015\u0019\u0007A\"\u0001e\u0011!Q\u0007\u0001#b\u0001\n\u0003Y\u0007\u0002C5\u0001\u0011\u000b\u0007I\u0011\u0001<\t\u0011]\u0004\u0001R1A\u0005\u0002-BQ\u0001\u001f\u0001\u0005\u0002eDQ\u0001\u001f\u0001\u0005\u0002uDq!a\u0002\u0001\t\u0003\tI\u0001C\u0004\u0002\b\u0001!\t!!\f\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!9\u0011Q\b\u0001\u0005\u0002\u0005-\u0003bBA2\u0001\u0011\u0005\u0011Q\r\u0005\b\u0003O\u0002A\u0011AA3\u0005=!UMZ1vYR$\u0015\r^1cCN,'BA\r\u001b\u0003\t!'M\u0003\u0002\u001c9\u0005\u0019\u0011\r]5\u000b\u0003u\tA\u0001\u001d7bs\u000e\u00011c\u0001\u0001!MA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\u0004\"a\n\u0015\u000e\u0003aI!!\u000b\r\u0003\u0011\u0011\u000bG/\u00192bg\u0016\fAA\\1nKV\tA\u0006\u0005\u0002.i9\u0011aF\r\t\u0003_\tj\u0011\u0001\r\u0006\u0003cy\ta\u0001\u0010:p_Rt\u0014BA\u001a#\u0003\u0019\u0001&/\u001a3fM&\u0011QG\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M\u0012\u0013!\u00028b[\u0016\u0004\u0013!D2p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002;\u00036\t1H\u0003\u0002={\u000511m\u001c8gS\u001eT!AP \u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001Q\u0001\u0004G>l\u0017B\u0001\"<\u0005\u0019\u0019uN\u001c4jO\u0006YQM\u001c<je>tW.\u001a8u!\t)e)D\u0001\u001b\u0013\t9%DA\u0006F]ZL'o\u001c8nK:$\u0018A\u0002\u001fj]&$h\b\u0006\u0003K\u00172k\u0005CA\u0014\u0001\u0011\u0015QS\u00011\u0001-\u0011\u0015AT\u00011\u0001:\u0011\u0015\u0019U\u00011\u0001E+\u0005y\u0005CA#Q\u0013\t\t&DA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\bG>tg-[4!\u00039!\u0017\r^1cCN,7i\u001c8gS\u001e,\u0012!\u0016\t\u0003OYK!a\u0016\r\u0003\u001d\u0011\u000bG/\u00192bg\u0016\u001cuN\u001c4jO\u0006yA-\u0019;bE\u0006\u001cXmQ8oM&<\u0007%\u0001\tde\u0016\fG/\u001a#bi\u0006\u001cv.\u001e:dKR\t1\f\u0005\u0002]C6\tQL\u0003\u0002_?\u0006\u00191/\u001d7\u000b\u0003\u0001\fQA[1wCbL!AY/\u0003\u0015\u0011\u000bG/Y*pkJ\u001cW-A\bdY>\u001cX\rR1uCN{WO]2f)\t)\u0007\u000e\u0005\u0002\"M&\u0011qM\t\u0002\u0005+:LG\u000fC\u0003j\u0017\u0001\u00071,\u0001\u0006eCR\f7k\\;sG\u0016\fa\u0001\u001a:jm\u0016\u0014X#\u00017\u0011\u0007\u0005jw.\u0003\u0002oE\t1q\n\u001d;j_:\u0004\"\u0001\u001d;\u000e\u0003ET!A\u0018:\u000b\u0003M\fAA[1wC&\u0011Q/\u001d\u0002\u0007\tJLg/\u001a:\u0016\u0003m\u000b1!\u001e:m\u000359W\r^\"p]:,7\r^5p]R\t!\u0010\u0005\u0002qw&\u0011A0\u001d\u0002\u000b\u0007>tg.Z2uS>tGC\u0001>\u007f\u0011\u0019y\b\u00031\u0001\u0002\u0002\u0005Q\u0011-\u001e;pG>lW.\u001b;\u0011\u0007\u0005\n\u0019!C\u0002\u0002\u0006\t\u0012qAQ8pY\u0016\fg.\u0001\bxSRD7i\u001c8oK\u000e$\u0018n\u001c8\u0016\t\u0005-\u0011\u0011\u0003\u000b\u0005\u0003\u001b\t\u0019\u0003\u0005\u0003\u0002\u0010\u0005EA\u0002\u0001\u0003\b\u0003'\t\"\u0019AA\u000b\u0005\u0005\t\u0015\u0003BA\f\u0003;\u00012!IA\r\u0013\r\tYB\t\u0002\b\u001d>$\b.\u001b8h!\r\t\u0013qD\u0005\u0004\u0003C\u0011#aA!os\"9\u0011QE\tA\u0002\u0005\u001d\u0012!\u00022m_\u000e\\\u0007CB\u0011\u0002*i\fi!C\u0002\u0002,\t\u0012\u0011BR;oGRLwN\\\u0019\u0016\t\u0005=\u0012Q\u0007\u000b\u0005\u0003c\tY\u0004\u0006\u0003\u00024\u0005]\u0002\u0003BA\b\u0003k!q!a\u0005\u0013\u0005\u0004\t)\u0002C\u0004\u0002&I\u0001\r!!\u000f\u0011\r\u0005\nIC_A\u001a\u0011\u0019y(\u00031\u0001\u0002\u0002\u0005yq/\u001b;i)J\fgn]1di&|g.\u0006\u0003\u0002B\u0005\u0015C\u0003BA\"\u0003\u000f\u0002B!a\u0004\u0002F\u00119\u00111C\nC\u0002\u0005U\u0001bBA\u0013'\u0001\u0007\u0011\u0011\n\t\u0007C\u0005%\"0a\u0011\u0016\t\u00055\u00131\u000b\u000b\u0005\u0003\u001f\nI\u0006\u0006\u0003\u0002R\u0005U\u0003\u0003BA\b\u0003'\"q!a\u0005\u0015\u0005\u0004\t)\u0002C\u0004\u0002&Q\u0001\r!a\u0016\u0011\r\u0005\nIC_A)\u0011\u001d\tY\u0006\u0006a\u0001\u0003;\na\"[:pY\u0006$\u0018n\u001c8MKZ,G\u000eE\u0002(\u0003?J1!!\u0019\u0019\u0005e!&/\u00198tC\u000e$\u0018n\u001c8Jg>d\u0017\r^5p]2+g/\u001a7\u0002\u0011MDW\u000f\u001e3po:$\u0012!Z\u0001\u0011I\u0016\u0014XmZ5ti\u0016\u0014HI]5wKJ\u0004")
public abstract class DefaultDatabase
implements Database {
    private Option<Driver> driver;
    private DataSource dataSource;
    private String url;
    private final String name;
    private final Environment environment;
    private final Configuration config;
    private final DatabaseConfig databaseConfig;
    private volatile byte bitmap$0;

    public String name() {
        return this.name;
    }

    private Configuration config() {
        return this.config;
    }

    public DatabaseConfig databaseConfig() {
        return this.databaseConfig;
    }

    public abstract DataSource createDataSource();

    public abstract void closeDataSource(DataSource var1);

    private Option<Driver> driver$lzycompute() {
        DefaultDatabase defaultDatabase = this;
        synchronized (defaultDatabase) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.driver = this.databaseConfig().driver().map((Function1 & Serializable)driverClassName -> {
                    void v0;
                    try {
                        void var3_2;
                        ProxyDriver proxyDriver = new ProxyDriver((Driver)Reflect$.MODULE$.createInstance(driverClassName, $this.environment.classLoader(), ClassTag$.MODULE$.apply(Driver.class)));
                        DriverManager.registerDriver((Driver)proxyDriver);
                        v0 = var3_2;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable throwable3 = throwable;
                        if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                            throw this.config().reportError("driver", "Driver not found: [" + driverClassName + "}]", (Option)new Some((Object)throwable2));
                        }
                        throw throwable;
                    }
                    return v0;
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.driver;
    }

    public Option<Driver> driver() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.driver$lzycompute();
        }
        return this.driver;
    }

    private DataSource dataSource$lzycompute() {
        DefaultDatabase defaultDatabase = this;
        synchronized (defaultDatabase) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.driver();
                this.dataSource = this.createDataSource();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dataSource;
    }

    public DataSource dataSource() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.dataSource$lzycompute();
        }
        return this.dataSource;
    }

    private String url$lzycompute() {
        DefaultDatabase defaultDatabase = this;
        synchronized (defaultDatabase) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.url = (String)this.databaseConfig().url().getOrElse((Function0 & Serializable)() -> {
                    String string;
                    try (Connection connection = this.dataSource().getConnection();){
                        string = connection.getMetaData().getURL();
                    }
                    return string;
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.url;
    }

    public String url() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.url$lzycompute();
        }
        return this.url;
    }

    public Connection getConnection() {
        return this.getConnection(true);
    }

    public Connection getConnection(boolean autocommit) {
        Connection connection = this.dataSource().getConnection();
        try {
            connection.setAutoCommit(autocommit);
        }
        catch (Throwable e) {
            connection.close();
            throw e;
        }
        return connection;
    }

    public <A> A withConnection(Function1<Connection, A> block) {
        return this.withConnection(true, block);
    }

    public <A> A withConnection(boolean autocommit, Function1<Connection, A> block) {
        Object object;
        try (Connection connection = this.getConnection(autocommit);){
            object = block.apply((Object)connection);
        }
        return (A)object;
    }

    public <A> A withTransaction(Function1<Connection, A> block) {
        return this.withConnection(false, (Function1 & Serializable)connection -> {
            void v0;
            try {
                void var2_2;
                Object r = block.apply(connection);
                connection.commit();
                v0 = var2_2;
            }
            catch (ControlThrowable e) {
                connection.commit();
                throw e;
            }
            catch (Throwable e) {
                connection.rollback();
                throw e;
            }
            return v0;
        });
    }

    public <A> A withTransaction(TransactionIsolationLevel isolationLevel, Function1<Connection, A> block) {
        return this.withConnection(false, (Function1 & Serializable)connection -> {
            Object object;
            int oldIsolationLevel = connection.getTransactionIsolation();
            try {
                try {
                    connection.setTransactionIsolation(isolationLevel.id());
                    Object r = block.apply(connection);
                    connection.commit();
                    object = r;
                }
                catch (ControlThrowable e) {
                    connection.commit();
                    throw e;
                }
                catch (Throwable e) {
                    connection.rollback();
                    throw e;
                }
            }
            finally {
                connection.setTransactionIsolation(oldIsolationLevel);
            }
            return object;
        });
    }

    public void shutdown() {
        this.closeDataSource(this.dataSource());
        this.deregisterDriver();
    }

    public void deregisterDriver() {
        this.driver().foreach((Function1 & Serializable)x$1 -> {
            DefaultDatabase.$anonfun$deregisterDriver$1(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$deregisterDriver$1(Driver x$1) {
        DriverManager.deregisterDriver(x$1);
    }

    public DefaultDatabase(String name, Config configuration, Environment environment) {
        this.name = name;
        this.environment = environment;
        this.config = new Configuration(configuration);
        this.databaseConfig = DatabaseConfig$.MODULE$.fromConfig(this.config(), environment);
    }
}

