/*
 * Decompiled with CFR 0.152.
 */
package play.api.db;

import com.zaxxer.hikari.HikariConfig;
import java.io.Serializable;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.db.DatabaseConfig;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005Q3Q\u0001C\u0005\u0001\u0013=A\u0001B\u0006\u0001\u0003\u0002\u0003\u0006I\u0001\u0007\u0005\tM\u0001\u0011\t\u0011)A\u0005O!A1\u0006\u0001B\u0001B\u0003%A\u0006C\u00031\u0001\u0011%\u0011\u0007C\u00031\u0001\u0011\u0005a\u0007C\u00031\u0001\u0011\u00051\bC\u0003I\u0001\u0011\u0005\u0011J\u0001\bIS.\f'/[\"Q\u0007>tg-[4\u000b\u0005)Y\u0011A\u00013c\u0015\taQ\"A\u0002ba&T\u0011AD\u0001\u0005a2\f\u0017p\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\f\u0011\"\\1zE\u0016t\u0015-\\3\u0004\u0001A\u0019\u0011#G\u000e\n\u0005i\u0011\"AB(qi&|g\u000e\u0005\u0002\u001dG9\u0011Q$\t\t\u0003=Ii\u0011a\b\u0006\u0003A]\ta\u0001\u0010:p_Rt\u0014B\u0001\u0012\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011A%\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\t\u0012\u0012\u0001\u00033c\u0007>tg-[4\u0011\u0005!JS\"A\u0005\n\u0005)J!A\u0004#bi\u0006\u0014\u0017m]3D_:4\u0017nZ\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\u00055rS\"A\u0006\n\u0005=Z!!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0005eM\"T\u0007\u0005\u0002)\u0001!)a\u0003\u0002a\u00011!)a\u0005\u0002a\u0001O!)1\u0006\u0002a\u0001YQ!!gN\u001d;\u0011\u0015AT\u00011\u0001\u001c\u0003\u0011q\u0017-\\3\t\u000b\u0019*\u0001\u0019A\u0014\t\u000b-*\u0001\u0019\u0001\u0017\u0015\u0007IbT\bC\u0003'\r\u0001\u0007q\u0005C\u0003,\r\u0001\u0007A\u0006\u000b\u0004\u0007\u007f\t\u001bUI\u0012\t\u0003#\u0001K!!\u0011\n\u0003\u0015\u0011,\u0007O]3dCR,G-A\u0004nKN\u001c\u0018mZ3\"\u0003\u0011\u000b\u0011$V:fA\r|gn\u001d;sk\u000e$xN\u001d\u0011xSRD\u0007E\\1nK\u0006)1/\u001b8dK\u0006\nq)A\u00033]er\u0003'\u0001\bu_\"K7.\u0019:j\u0007>tg-[4\u0016\u0003)\u0003\"a\u0013*\u000e\u00031S!!\u0014(\u0002\r!L7.\u0019:j\u0015\ty\u0005+\u0001\u0004{CbDXM\u001d\u0006\u0002#\u0006\u00191m\\7\n\u0005Mc%\u0001\u0004%jW\u0006\u0014\u0018nQ8oM&<\u0007")
public class HikariCPConfig {
    private final Option<String> maybeName;
    private final DatabaseConfig dbConfig;
    private final Configuration configuration;

    public HikariConfig toHikariConfig() {
        HikariConfig hikariConfig = new HikariConfig();
        Configuration config = (Configuration)this.configuration.get("hikaricp", ConfigLoader$.MODULE$.configurationLoader());
        ((Option)config.get("dataSourceClassName", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()))).foreach((Function1 & Serializable)x$1 -> {
            hikariConfig.setDataSourceClassName(x$1);
            return BoxedUnit.UNIT;
        });
        this.dbConfig.url().foreach((Function1 & Serializable)x$1 -> {
            hikariConfig.setJdbcUrl(x$1);
            return BoxedUnit.UNIT;
        });
        this.dbConfig.driver().foreach((Function1 & Serializable)x$1 -> {
            hikariConfig.setDriverClassName(x$1);
            return BoxedUnit.UNIT;
        });
        this.dbConfig.username().foreach((Function1 & Serializable)x$1 -> {
            hikariConfig.setUsername(x$1);
            return BoxedUnit.UNIT;
        });
        this.dbConfig.password().foreach((Function1 & Serializable)x$1 -> {
            hikariConfig.setPassword(x$1);
            return BoxedUnit.UNIT;
        });
        Configuration dataSourceConfig = (Configuration)config.get("dataSource", ConfigLoader$.MODULE$.configurationLoader());
        CollectionConverters$.MODULE$.SetHasAsScala(dataSourceConfig.underlying().root().keySet()).asScala().foreach((Function1 & Serializable)key -> {
            hikariConfig.addDataSourceProperty(key, dataSourceConfig.get(key, ConfigLoader$.MODULE$.stringLoader()));
            return BoxedUnit.UNIT;
        });
        hikariConfig.setAutoCommit(BoxesRunTime.unboxToBoolean((Object)config.get("autoCommit", ConfigLoader$.MODULE$.booleanLoader())));
        hikariConfig.setConnectionTimeout(HikariCPConfig.toMillis$1((Duration)config.get("connectionTimeout", ConfigLoader$.MODULE$.durationLoader())));
        hikariConfig.setIdleTimeout(HikariCPConfig.toMillis$1((Duration)config.get("idleTimeout", ConfigLoader$.MODULE$.durationLoader())));
        ((Option)config.get("keepaliveTime", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.durationLoader()))).foreach((Function1 & Serializable)duration -> {
            hikariConfig.setKeepaliveTime(HikariCPConfig.toMillis$1(duration));
            return BoxedUnit.UNIT;
        });
        hikariConfig.setMaxLifetime(HikariCPConfig.toMillis$1((Duration)config.get("maxLifetime", ConfigLoader$.MODULE$.durationLoader())));
        ((Option)config.get("connectionTestQuery", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()))).foreach((Function1 & Serializable)x$1 -> {
            hikariConfig.setConnectionTestQuery(x$1);
            return BoxedUnit.UNIT;
        });
        ((Option)config.get("minimumIdle", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.intLoader()))).foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> hikariConfig.setMinimumIdle(x$1));
        hikariConfig.setMaximumPoolSize(BoxesRunTime.unboxToInt((Object)config.get("maximumPoolSize", ConfigLoader$.MODULE$.intLoader())));
        ((Option)config.get("poolName", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()))).orElse((Function0 & Serializable)() -> $this.maybeName.map((Function1 & Serializable)name -> "HikariPool-" + name)).foreach((Function1 & Serializable)x$1 -> {
            hikariConfig.setPoolName(x$1);
            return BoxedUnit.UNIT;
        });
        hikariConfig.setInitializationFailTimeout(BoxesRunTime.unboxToLong((Object)config.get("initializationFailTimeout", ConfigLoader$.MODULE$.longLoader())));
        hikariConfig.setIsolateInternalQueries(BoxesRunTime.unboxToBoolean((Object)config.get("isolateInternalQueries", ConfigLoader$.MODULE$.booleanLoader())));
        hikariConfig.setAllowPoolSuspension(BoxesRunTime.unboxToBoolean((Object)config.get("allowPoolSuspension", ConfigLoader$.MODULE$.booleanLoader())));
        hikariConfig.setReadOnly(BoxesRunTime.unboxToBoolean((Object)config.get("readOnly", ConfigLoader$.MODULE$.booleanLoader())));
        hikariConfig.setRegisterMbeans(BoxesRunTime.unboxToBoolean((Object)config.get("registerMbeans", ConfigLoader$.MODULE$.booleanLoader())));
        ((Option)config.get("connectionInitSql", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()))).foreach((Function1 & Serializable)x$1 -> {
            hikariConfig.setConnectionInitSql(x$1);
            return BoxedUnit.UNIT;
        });
        ((Option)config.get("catalog", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()))).foreach((Function1 & Serializable)x$1 -> {
            hikariConfig.setCatalog(x$1);
            return BoxedUnit.UNIT;
        });
        ((Option)config.get("transactionIsolation", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()))).foreach((Function1 & Serializable)x$1 -> {
            hikariConfig.setTransactionIsolation(x$1);
            return BoxedUnit.UNIT;
        });
        ((Option)config.get("exceptionOverrideClassName", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()))).foreach((Function1 & Serializable)x$1 -> {
            hikariConfig.setExceptionOverrideClassName(x$1);
            return BoxedUnit.UNIT;
        });
        hikariConfig.setValidationTimeout(((FiniteDuration)config.get("validationTimeout", ConfigLoader$.MODULE$.finiteDurationLoader())).toMillis());
        hikariConfig.setLeakDetectionThreshold(HikariCPConfig.toMillis$1((Duration)config.get("leakDetectionThreshold", ConfigLoader$.MODULE$.durationLoader())));
        hikariConfig.validate();
        return hikariConfig;
    }

    private static final long toMillis$1(Duration duration) {
        if (duration.isFinite()) {
            return duration.toMillis();
        }
        return 0L;
    }

    private HikariCPConfig(Option<String> maybeName, DatabaseConfig dbConfig, Configuration configuration) {
        this.maybeName = maybeName;
        this.dbConfig = dbConfig;
        this.configuration = configuration;
    }

    public HikariCPConfig(String name, DatabaseConfig dbConfig, Configuration configuration) {
        this((Option<String>)new Some((Object)name), dbConfig, configuration);
    }

    public HikariCPConfig(DatabaseConfig dbConfig, Configuration configuration) {
        this((Option<String>)None$.MODULE$, dbConfig, configuration);
    }
}

